/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DropDownButton
extends JButton
implements ChangeListener,
PopupMenuListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private final JButton mainButton;
    private final JButton arrowButton;
    private final JToolBar holder;
    private DropDownButton thisRef = this;
    private boolean popupVisible = false;
    private JPopupMenu popupMenu;
    private JList list;
    private JLabel itemCountLabel = new JLabel("not empty");
    private String doing;
    private Vector<SelectionCompleteListener> selListeners;

    public DropDownButton(Action action, ListModel listModel) {
        super("");
        this.setFocusable(false);
        this.setBorder(null);
        this.selListeners = new Vector(1, 1);
        this.doing = (String)action.getValue("Name");
        this.mainButton = new JButton(action);
        this.mainButton.setText("");
        this.mainButton.setFocusable(false);
        this.mainButton.addPropertyChangeListener("enabled", this);
        this.mainButton.getModel().addChangeListener(this);
        this.arrowButton = new JButton(new ImageIcon(this.getClass().getResource("icons/dropdown.gif")));
        this.arrowButton.setMargin(new Insets(1, 2, 1, 2));
        this.arrowButton.setFocusable(false);
        this.arrowButton.getModel().addChangeListener(this);
        this.arrowButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (DropDownButton.this.arrowButton.isEnabled()) {
                    JPopupMenu popup = DropDownButton.this.getPopupMenu();
                    popup.addPopupMenuListener(DropDownButton.this.thisRef);
                    DropDownButton.this.list.setSelectedIndex(0);
                    DropDownButton.this.list.ensureIndexIsVisible(0);
                    DropDownButton.this.changeItemCountLabel(1);
                    popup.show(DropDownButton.this.mainButton, 0, DropDownButton.this.mainButton.getHeight());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!DropDownButton.this.arrowButton.contains(e.getPoint())) {
                    if (DropDownButton.this.popupVisible) {
                        DropDownButton.this.fireSelectionCompleteEvent(DropDownButton.this.getAmountSelected());
                    }
                    DropDownButton.this.popupMenu.setVisible(false);
                }
            }
        });
        this.arrowButton.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int mouseX;
                Rectangle visRect = DropDownButton.this.list.getVisibleRect();
                int minX = visRect.x;
                int maxX = visRect.x + visRect.width;
                if (DropDownButton.this.list.isShowing()) {
                    int xOffset = ((DropDownButton)DropDownButton.this).arrowButton.getLocationOnScreen().x - ((DropDownButton)DropDownButton.this).list.getLocationOnScreen().x;
                    int yOffset = ((DropDownButton)DropDownButton.this).arrowButton.getLocationOnScreen().y - ((DropDownButton)DropDownButton.this).list.getLocationOnScreen().y;
                    e.translatePoint(xOffset, yOffset);
                }
                if ((mouseX = e.getX()) > minX && mouseX < maxX) {
                    DropDownButton.this.selectItems(DropDownButton.this.list.locationToIndex(e.getPoint()));
                } else {
                    DropDownButton.this.cancelSelection();
                }
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }
        });
        this.holder = new JToolBar();
        this.holder.setBorder(null);
        this.holder.setFocusable(false);
        this.holder.setFloatable(false);
        this.holder.add(this.mainButton);
        this.holder.add(this.arrowButton);
        this.add(this.holder);
        this.popupMenu = new JPopupMenu();
        this.list = new JList(listModel);
        this.list.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Rectangle visRect = DropDownButton.this.list.getVisibleRect();
                int minX = visRect.x;
                int maxX = visRect.x + visRect.width;
                int mouseX = e.getX();
                if (mouseX > minX && mouseX < maxX) {
                    DropDownButton.this.selectItems(DropDownButton.this.list.locationToIndex(e.getPoint()));
                } else {
                    DropDownButton.this.cancelSelection();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                DropDownButton.this.selectItems(DropDownButton.this.list.locationToIndex(e.getPoint()));
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DropDownButton.this.selectItems(DropDownButton.this.list.locationToIndex(e.getPoint()));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (DropDownButton.this.popupVisible) {
                    DropDownButton.this.fireSelectionCompleteEvent(DropDownButton.this.getAmountSelected());
                }
                DropDownButton.this.popupMenu.setVisible(false);
            }
        });
        this.list.setAutoscrolls(true);
        this.list.setVisibleRowCount(5);
        this.list.setPrototypeCellValue("12345678901234567890123456789012345678901234567890");
        this.list.setSelectionMode(1);
        JScrollPane scroll = new JScrollPane(this.list, 20, 31);
        scroll.setBorder(null);
        this.list.setFocusable(false);
        scroll.getVerticalScrollBar().setFocusable(false);
        scroll.getHorizontalScrollBar().setFocusable(false);
        this.popupMenu.setBackground(new Color(220, 220, 220));
        this.popupMenu.add(scroll);
        this.popupMenu.setFocusable(false);
        this.itemCountLabel.setBorder(null);
        this.popupMenu.add(this.itemCountLabel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.arrowButton.setEnabled(this.mainButton.isEnabled());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.mainButton.getModel()) {
            if (this.popupVisible && !this.mainButton.getModel().isRollover()) {
                this.mainButton.getModel().setRollover(true);
                return;
            }
            this.arrowButton.getModel().setRollover(this.mainButton.getModel().isRollover());
            this.arrowButton.setSelected(this.mainButton.getModel().isArmed() && this.mainButton.getModel().isPressed());
        } else {
            if (this.popupVisible && !this.arrowButton.getModel().isSelected()) {
                this.arrowButton.getModel().setSelected(true);
                return;
            }
            this.mainButton.getModel().setRollover(this.arrowButton.getModel().isRollover());
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.popupVisible = true;
        this.mainButton.getModel().setRollover(true);
        this.arrowButton.getModel().setSelected(true);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.popupVisible = false;
        this.mainButton.getModel().setRollover(false);
        this.arrowButton.getModel().setSelected(false);
        ((JPopupMenu)e.getSource()).removePopupMenuListener(this);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.popupVisible = false;
    }

    protected JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    private void selectItems(int last) {
        this.list.setSelectionInterval(0, last);
        this.list.ensureIndexIsVisible(last);
        this.changeItemCountLabel(last + 1);
    }

    private void changeItemCountLabel(int count) {
        this.itemCountLabel.setText(String.valueOf(this.doing) + " " + count + " actions");
    }

    private void cancelSelection() {
        this.list.clearSelection();
        this.itemCountLabel.setText("Cancel");
    }

    private int getAmountSelected() {
        return this.list.getMaxSelectionIndex() + 1;
    }

    public void addSelectionCompleteListener(SelectionCompleteListener scl) {
        this.selListeners.add(scl);
    }

    public void removeSelectionCompleteListener(SelectionCompleteListener scl) {
        this.selListeners.remove(scl);
    }

    public void fireSelectionCompleteEvent(int amountSelected) {
        for (SelectionCompleteListener scl : this.selListeners) {
            scl.selectionComplete(amountSelected);
        }
    }

    public static interface SelectionCompleteListener {
        public void selectionComplete(int var1);
    }
}

