/*
 * Decompiled with CFR 0.152.
 */
package fixvardtags;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Fixer {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final Pattern[] IGNORE_PATTERNS = new Pattern[4];
    private static final Pattern NV = Pattern.compile("<notvariant>([^<]*)</notvariant>");
    private static final Pattern VARIANT = Pattern.compile("<variant>([^<]*)</variant>");
    private static final Pattern NORMALISED = Pattern.compile("<normalised orig=\"([^\"]+)\"([^>]+)>([^<]+)</normalised>");

    static {
        Fixer.IGNORE_PATTERNS[0] = Pattern.compile("(<sc>)(.+?)(</sc>)", 32);
        Fixer.IGNORE_PATTERNS[1] = Pattern.compile("(\\(\\\\)([^\\\\]+)(\\\\\\))");
        Fixer.IGNORE_PATTERNS[2] = Pattern.compile("(\\[\\\\)([^\\\\]+)(\\\\\\])");
        Fixer.IGNORE_PATTERNS[3] = Pattern.compile("(\\[\\^)([^\\^]+)(\\^\\])");
    }

    public static void main(String[] args) {
        File inFolder = new File("/Users/barona/Desktop/helsinki/test");
        File outFolder = new File("/Users/barona/Desktop/helsinki/testfixed");
        outFolder.mkdir();
        try {
            File[] fileArray = inFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                File out = new File(outFolder, f.getName());
                out.createNewFile();
                Fixer.fix(f, out);
                ++n2;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void fix(File in, File out) throws IOException {
        String line;
        String text = "";
        LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(in), "UTF-8"));
        while ((line = reader.readLine()) != null) {
            text = String.valueOf(text) + line + NEW_LINE;
        }
        reader.close();
        StringBuffer sb = new StringBuffer();
        Matcher nvMatcher = NV.matcher(text);
        while (nvMatcher.find()) {
            String word = nvMatcher.group(1);
            if (word.equals("^")) {
                nvMatcher.appendReplacement(sb, "");
                continue;
            }
            boolean tildeStart = word.startsWith("^");
            boolean tildeEnd = word.endsWith("^");
            if (tildeStart) {
                word = word.substring(1);
            }
            if (tildeEnd) {
                word = word.substring(0, word.length() - 1);
            }
            if (word.contains("^")) {
                System.err.println(in + " contains ^ in middle of word (<notvariant>)");
            }
            if (!tildeStart && !tildeEnd) continue;
            String full = String.valueOf(tildeStart ? "^" : "") + "<notvariant>" + word + "</notvariant>" + (tildeEnd ? "^" : "");
            nvMatcher.appendReplacement(sb, full);
        }
        nvMatcher.appendTail(sb);
        text = sb.toString();
        sb = new StringBuffer();
        Matcher vMatcher = VARIANT.matcher(text);
        while (vMatcher.find()) {
            String word = vMatcher.group(1);
            if (word.equals("^")) {
                vMatcher.appendReplacement(sb, "");
                continue;
            }
            boolean tildeStart = word.startsWith("^");
            boolean tildeEnd = word.endsWith("^");
            if (tildeStart) {
                word = word.substring(1);
            }
            if (tildeEnd) {
                word = word.substring(0, word.length() - 1);
            }
            if (word.contains("^")) {
                System.err.println(in + " contains ^ in middle of word (<variant>)");
            }
            if (!tildeStart && !tildeEnd) continue;
            String full = String.valueOf(tildeStart ? "^" : "") + "<variant>" + word + "</variant>" + (tildeEnd ? "^" : "");
            vMatcher.appendReplacement(sb, full);
        }
        vMatcher.appendTail(sb);
        text = sb.toString();
        sb = new StringBuffer();
        Matcher normalisedMatcher = NORMALISED.matcher(text);
        while (normalisedMatcher.find()) {
            String orig = normalisedMatcher.group(1);
            String tagExtra = normalisedMatcher.group(2);
            String rep = normalisedMatcher.group(3);
            boolean tildeStart = orig.startsWith("^");
            boolean tildeEnd = orig.endsWith("^");
            if (tildeStart) {
                orig = orig.substring(1);
            }
            if (tildeEnd) {
                orig = orig.substring(0, orig.length() - 1);
            }
            if (orig.contains("^")) {
                System.err.println(in + " contains ^ in middle of orig (<normalised>)");
            }
            rep = rep.replaceAll("\\^", "");
            if (!tildeStart && !tildeEnd) continue;
            String full = String.valueOf(tildeStart ? "^" : "") + "<normalised orig=\"" + orig + "\"" + tagExtra + ">" + rep + "</normalised>" + (tildeEnd ? "^" : "");
            normalisedMatcher.appendReplacement(sb, full);
        }
        normalisedMatcher.appendTail(sb);
        text = sb.toString();
        Pattern[] patternArray = IGNORE_PATTERNS;
        int n = IGNORE_PATTERNS.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern ip = patternArray[n2];
            sb = new StringBuffer();
            Matcher im = ip.matcher(text);
            while (im.find()) {
                String start = im.group(1);
                String end = im.group(3);
                String ignored = im.group(2);
                String fixed = Fixer.reignoreTags(ignored);
                String full = String.valueOf(start) + fixed + end;
                full = Matcher.quoteReplacement(full);
                im.appendReplacement(sb, full);
            }
            im.appendTail(sb);
            text = sb.toString();
            ++n2;
        }
        PrintWriter pw = new PrintWriter(out, "UTF-8");
        pw.print(text);
        pw.close();
    }

    private static String reignoreTags(String in) {
        String out = in;
        StringBuffer sb = new StringBuffer();
        Matcher nvMatcher = NV.matcher(out);
        while (nvMatcher.find()) {
            String orig = nvMatcher.group(1);
            nvMatcher.appendReplacement(sb, orig);
        }
        nvMatcher.appendTail(sb);
        out = sb.toString();
        sb = new StringBuffer();
        Matcher vMatcher = VARIANT.matcher(out);
        while (vMatcher.find()) {
            String orig = vMatcher.group(1);
            vMatcher.appendReplacement(sb, orig);
        }
        vMatcher.appendTail(sb);
        out = sb.toString();
        sb = new StringBuffer();
        Matcher nMatcher = NORMALISED.matcher(out);
        while (nMatcher.find()) {
            String orig = nMatcher.group(1);
            nMatcher.appendReplacement(sb, orig);
        }
        nMatcher.appendTail(sb);
        out = sb.toString();
        return out;
    }
}

