/*
 * Decompiled with CFR 0.152.
 */
package gui.sidebar;

import gui.sidebar.SetupSideBarPanel;
import gui.sidebar.TextPrompt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import model.Setup;

public class AnnotationsSideBar
extends SetupSideBarPanel {
    private static final long serialVersionUID = 4500736618827481887L;
    private final JTextField annotatorIDAttTF;
    private final JTextField normalisedTagTF;
    private final JTextField normalisedOrigAttTF;
    private final JTextField normalisedAutoAttTF;
    private final JTextField variantTagTF;
    private final JTextField notvariantTagTF;
    private final JTextField foreignTagTF;
    private final JTextField foreignLangAttTF;
    private final JTextField joinTagTF;
    private final JTextField joinOrigAttTF;
    private final JTextField joinLinebreakTF;
    private final JTextField partitionTagTF;
    private final JTextField partitionSeqAttTF;
    private final JTextField partitionCountAttTF;
    private final JTextField partitionStateAttTF;
    private Collection<JTextField> textFields = new ArrayList<JTextField>();
    private static final GridBagConstraints labelGBC = new GridBagConstraints();
    private static final GridBagConstraints textfieldGBC = new GridBagConstraints();

    static {
        AnnotationsSideBar.labelGBC.gridx = 0;
        AnnotationsSideBar.labelGBC.fill = 0;
        AnnotationsSideBar.labelGBC.anchor = 17;
        AnnotationsSideBar.textfieldGBC.gridx = 1;
        AnnotationsSideBar.textfieldGBC.weightx = 1.0;
        AnnotationsSideBar.textfieldGBC.fill = 2;
    }

    public AnnotationsSideBar(Setup setup) {
        JPanel annotatorIDPanel = new JPanel(new GridBagLayout());
        annotatorIDPanel.setBorder(BorderFactory.createTitledBorder("Annotator ID Att."));
        this.annotatorIDAttTF = this.addTextField(annotatorIDPanel, null, setup.getAnnotatorIDAttribute());
        JPanel normalisedPanel = new JPanel(new GridBagLayout());
        normalisedPanel.setBorder(BorderFactory.createTitledBorder("Nomalised"));
        this.normalisedTagTF = this.addTextField(normalisedPanel, "Tag", setup.getNormalisedTag());
        this.normalisedOrigAttTF = this.addTextField(normalisedPanel, "Orig. att.", setup.getNormalisedOriginalAttribute());
        this.normalisedAutoAttTF = new JTextField(setup.getNormalisedAutoAttribute());
        TextPrompt autoTP = new TextPrompt("No auto att.", this.normalisedAutoAttTF);
        autoTP.setShow(TextPrompt.Show.FOCUS_LOST);
        autoTP.changeAlpha(0.5f);
        normalisedPanel.add((Component)new JLabel(" Auto att. "), labelGBC);
        normalisedPanel.add((Component)this.normalisedAutoAttTF, textfieldGBC);
        JPanel variantPanel = new JPanel(new GridBagLayout());
        variantPanel.setBorder(BorderFactory.createTitledBorder("Variants"));
        this.variantTagTF = this.addTextField(variantPanel, "Tag", setup.getVariantTag());
        JPanel notvariantPanel = new JPanel(new GridBagLayout());
        notvariantPanel.setBorder(BorderFactory.createTitledBorder("Not variants"));
        this.notvariantTagTF = this.addTextField(notvariantPanel, "Tag", setup.getNotvariantTag());
        JPanel joinPanel = new JPanel(new GridBagLayout());
        joinPanel.setBorder(BorderFactory.createTitledBorder("Joins"));
        this.joinTagTF = this.addTextField(joinPanel, "Tag", setup.getJoinTag());
        this.joinOrigAttTF = this.addTextField(joinPanel, "Orig. att.", setup.getJoinOriginalAttribute());
        this.joinLinebreakTF = this.addTextField(joinPanel, "Linebreak", setup.getJoinLineBreakMarker());
        JPanel foreignPanel = new JPanel(new GridBagLayout());
        foreignPanel.setBorder(BorderFactory.createTitledBorder("Foreign text"));
        this.foreignTagTF = this.addTextField(foreignPanel, "Tag", setup.getForeignTag());
        this.foreignLangAttTF = this.addTextField(foreignPanel, "Lang. att.", setup.getForeignLanguageAttribute());
        JPanel partitionsPanel = new JPanel(new GridBagLayout());
        partitionsPanel.setBorder(BorderFactory.createTitledBorder("Partitions"));
        this.partitionTagTF = this.addTextField(partitionsPanel, "Tag", setup.getPartitionTag());
        this.partitionSeqAttTF = this.addTextField(partitionsPanel, "Seq. att.", setup.getPartitionSequenceAttribute());
        this.partitionCountAttTF = this.addTextField(partitionsPanel, "Count att.", setup.getPartitionCountAttribute());
        this.partitionStateAttTF = this.addTextField(partitionsPanel, "State att.", setup.getPartitionStateAttribute());
        GridBagConstraints fv = new GridBagConstraints();
        fv.gridx = 0;
        fv.weighty = 1.0;
        fv.weightx = 1.0;
        fv.fill = 1;
        GridBagConstraints nfv = new GridBagConstraints();
        nfv.gridx = 0;
        nfv.weighty = 0.0;
        nfv.weightx = 1.0;
        nfv.fill = 2;
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)annotatorIDPanel, nfv);
        mainPanel.add((Component)normalisedPanel, nfv);
        mainPanel.add((Component)variantPanel, nfv);
        mainPanel.add((Component)notvariantPanel, nfv);
        mainPanel.add((Component)joinPanel, nfv);
        mainPanel.add((Component)foreignPanel, nfv);
        mainPanel.add((Component)partitionsPanel, nfv);
        mainPanel.add(Box.createGlue(), fv);
        JScrollPane scrollPane = new JScrollPane(mainPanel, 20, 31);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
    }

    public JTextField addTextField(JPanel panel, String label, String text) {
        JTextField textField = new JTextField(text);
        TextPrompt textPrompt = new TextPrompt("Required", textField);
        textPrompt.setShow(TextPrompt.Show.FOCUS_LOST);
        textPrompt.changeAlpha(0.5f);
        if (label != null) {
            panel.add((Component)new JLabel(" " + label + " "), labelGBC);
        }
        panel.add((Component)textField, textfieldGBC);
        this.textFields.add(textField);
        return textField;
    }

    @Override
    public void changeSetup(Setup setup) {
        this.annotatorIDAttTF.setText(setup.getAnnotatorIDAttribute());
        this.normalisedTagTF.setText(setup.getNormalisedTag());
        this.normalisedOrigAttTF.setText(setup.getNormalisedOriginalAttribute());
        this.normalisedAutoAttTF.setText(setup.getNormalisedAutoAttribute());
        this.variantTagTF.setText(setup.getVariantTag());
        this.notvariantTagTF.setText(setup.getNotvariantTag());
        this.foreignTagTF.setText(setup.getForeignTag());
        this.foreignLangAttTF.setText(setup.getForeignLanguageAttribute());
        this.joinTagTF.setText(setup.getJoinTag());
        this.joinOrigAttTF.setText(setup.getJoinOriginalAttribute());
        this.joinLinebreakTF.setText(setup.getJoinLineBreakMarker());
        this.partitionTagTF.setText(setup.getPartitionTag());
        this.partitionSeqAttTF.setText(setup.getPartitionSequenceAttribute());
        this.partitionCountAttTF.setText(setup.getPartitionCountAttribute());
        this.partitionStateAttTF.setText(setup.getPartitionStateAttribute());
    }

    @Override
    public void updateSetup(Setup setup) {
        setup.setAnnotatorIDAttribute(this.annotatorIDAttTF.getText());
        setup.setNormalisedTag(this.normalisedTagTF.getText());
        setup.setNormalisedOriginalAttribute(this.normalisedOrigAttTF.getText());
        setup.setNormalisedAutoAttribute(this.normalisedAutoAttTF.getText());
        setup.setVariantTag(this.variantTagTF.getText());
        setup.setNotvariantTag(this.notvariantTagTF.getText());
        setup.setForeignTag(this.foreignTagTF.getText());
        setup.setForeignLanguageAttribute(this.foreignLangAttTF.getText());
        setup.setJoinTag(this.joinTagTF.getText());
        setup.setJoinOriginalAttribute(this.joinOrigAttTF.getText());
        setup.setJoinLineBreakMarker(this.joinLinebreakTF.getText());
        setup.setPartitionTag(this.partitionTagTF.getText());
        setup.setPartitionSequenceAttribute(this.partitionSeqAttTF.getText());
        setup.setPartitionCountAttribute(this.partitionCountAttTF.getText());
        setup.setPartitionStateAttribute(this.partitionStateAttTF.getText());
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (JTextField textfield : this.textFields) {
            textfield.setEnabled(enabled);
        }
        this.normalisedAutoAttTF.setEnabled(enabled);
    }

    @Override
    public String validateForm() {
        for (JTextField textfield : this.textFields) {
            if (!textfield.getText().isEmpty()) continue;
            return "All annotation fields must be present.";
        }
        return null;
    }
}

