/*
 * Decompiled with CFR 0.152.
 */
package gui.sidebar;

import java.awt.event.ActionEvent;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JTextField;
import model.Globals;

public class AddPatternToListAction
extends AbstractAction
implements Action {
    private static final long serialVersionUID = -786571916448709828L;
    protected final JList list;
    protected final Set<Pattern> items;
    protected final JTextField tf;
    private final Globals global;

    public AddPatternToListAction(JList list, Set<Pattern> items, JTextField tf) {
        this.list = list;
        this.items = items;
        this.tf = tf;
        this.global = Globals.getInstance();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String itemToAdd = this.tf.getText();
        if (itemToAdd.isEmpty()) {
            return;
        }
        try {
            Pattern pattern = Pattern.compile(itemToAdd);
            this.items.add(pattern);
            this.list.setListData(this.items.toArray());
            this.tf.setText("");
        }
        catch (PatternSyntaxException ex) {
            this.global.showError("Pattern isn't valid: " + ex.getDescription());
            return;
        }
    }
}

