/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import model.Globals;
import model.doc.CannotExecuteException;
import model.doc.ThreadableEdit;

public class ThreadedProcessEditHolder
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private ThreadableEdit edit;
    private boolean executed = false;
    private boolean undone = false;
    Globals global = Globals.getInstance();

    public ThreadedProcessEditHolder(ThreadableEdit edit) {
        this.edit = edit;
    }

    public void execute() {
        class Worker
        extends SwingWorker<Boolean, Exception> {
            Worker() {
            }

            @Override
            public Boolean doInBackground() {
                try {
                    ThreadedProcessEditHolder.this.edit.execute();
                    return true;
                }
                catch (CannotExecuteException ex) {
                    this.publish(ex);
                    return false;
                }
            }

            @Override
            protected void process(List<Exception> exceptions) {
                for (Exception ex : exceptions) {
                    ThreadedProcessEditHolder.this.global.showException("Error occurred whilst performing operation, please report.", ex);
                }
            }

            @Override
            protected void done() {
                try {
                    ThreadedProcessEditHolder.this.executed = (Boolean)this.get();
                }
                catch (InterruptedException ex) {
                    ThreadedProcessEditHolder.this.global.showException("Error occurred whilst performing operation, please report.", ex);
                    ThreadedProcessEditHolder.this.executed = false;
                }
                catch (ExecutionException ex) {
                    ThreadedProcessEditHolder.this.global.showException("Error occurred whilst performing operation, please report.", ex);
                    ThreadedProcessEditHolder.this.executed = false;
                }
            }
        }
        Worker task = new Worker();
        task.execute();
    }

    @Override
    public void undo() throws CannotUndoException {
        class Worker
        extends SwingWorker<String, Object> {
            Worker() {
            }

            @Override
            public String doInBackground() {
                try {
                    ThreadedProcessEditHolder.this.edit.undo();
                    ThreadedProcessEditHolder.this.undone = true;
                }
                catch (CannotUndoException ex) {
                    ThreadedProcessEditHolder.this.undone = false;
                    ThreadedProcessEditHolder.this.global.showException("Error occurred whilst undoing operation, please report.", ex);
                }
                return null;
            }
        }
        new Worker().execute();
    }

    @Override
    public void redo() throws CannotRedoException {
        class Worker
        extends SwingWorker<String, Object> {
            Worker() {
            }

            @Override
            public String doInBackground() {
                try {
                    ThreadedProcessEditHolder.this.edit.redo();
                    ThreadedProcessEditHolder.this.undone = false;
                }
                catch (CannotRedoException ex) {
                    ThreadedProcessEditHolder.this.undone = true;
                    ThreadedProcessEditHolder.this.global.showException("Error occurred whilst redoing operation, please report.", ex);
                }
                return null;
            }
        }
        new Worker().execute();
    }

    @Override
    public String getPresentationName() {
        return this.edit.getPresentationName();
    }

    @Override
    public boolean canUndo() {
        return this.executed;
    }

    @Override
    public boolean canRedo() {
        return this.undone;
    }
}

