/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.QuestionAsker;
import gui.ThreadedProcessEditHolder;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.undo.UndoableEditSupport;
import model.Globals;
import model.doc.DocumentModel;
import model.doc.Instance;
import model.doc.InvalidInstanceChangeException;
import model.doc.MarkAllFInstancesAsTEdit;
import model.doc.WordHolder;

public class MarkAllFInstancesAsTAction<F extends Instance, T extends Instance>
extends AbstractAction {
    private static final long serialVersionUID = -7964139713034760680L;
    private MarkAllFInstancesAsTEdit<F, T> edit;
    private final WordHolder wh;
    private final DocumentModel docModel;
    private final UndoableEditSupport undoSupport;
    private final QuestionAsker questionAsker;

    public MarkAllFInstancesAsTAction(WordHolder wh, int fromType, int toType, DocumentModel docModel, UndoableEditSupport undoSupport, QuestionAsker questionAsker) {
        this.docModel = docModel;
        this.undoSupport = undoSupport;
        this.questionAsker = questionAsker;
        this.wh = wh;
        try {
            this.edit = new MarkAllFInstancesAsTEdit(wh, fromType, toType);
            this.putValue("Name", this.edit.getActionName());
        }
        catch (InvalidInstanceChangeException ex) {
            Globals.getInstance().showException("Error occurred in marking all instances prep.", ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        QuestionAsker.Answer answer;
        ThreadedProcessEditHolder tEdit = new ThreadedProcessEditHolder(this.edit);
        tEdit.execute();
        this.undoSupport.postEdit(tEdit);
        if (this.edit.getToType() == 103 && !this.wh.isInDictionary()) {
            QuestionAsker.Answer answer2 = this.questionAsker.askYesNoQuestion("Add to dictionary?", "Would you like to add this word to the dictionary?");
            if (answer2 == QuestionAsker.Answer.Yes) {
                DocumentModel.AddWordToDictionaryEdit addEdit = this.docModel.getAddWordToDictionaryEdit(this.wh, this.wh.getWord());
                addEdit.execute();
                this.undoSupport.postEdit(addEdit);
            }
        } else if (this.edit.getToType() == 101 && (answer = this.questionAsker.askYesNoQuestion("Remove from dictionary?", "Would you like to remove this word from the dictionary?\nThis will result in the word being marked as a variant in future.")) == QuestionAsker.Answer.Yes) {
            DocumentModel.RemoveWordFromDictionaryEdit removeEdit = this.docModel.getRemoveWordFromDictionaryEdit(this.wh, this.wh.getWord());
            removeEdit.execute();
            this.undoSupport.postEdit(removeEdit);
        }
    }
}

