/*
 * Decompiled with CFR 0.152.
 */
package gui;

import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import model.ConfidenceWeights;
import model.MethodScores;

public class ConfidenceWeightsTableModel
extends AbstractTableModel
implements TableModel,
ConfidenceWeights.ChangeListener {
    private static final long serialVersionUID = 8100840546622441401L;
    private final ConfidenceWeights confidenceWeights;
    private static final String[] columnNames = new String[]{"Method", "F-Score", "Precision", "Recall"};
    private static final String[] methods = new String[]{"KV", "LR", "PM", "ED"};
    private static final String[] methodFullNames = new String[]{"Known Variants", "Letter Rules", "Phonetic Matching", "Edit Distance"};

    public ConfidenceWeightsTableModel(ConfidenceWeights confidenceWeights) {
        this.confidenceWeights = confidenceWeights;
        this.confidenceWeights.addChangeListener(this);
    }

    @Override
    public void weightsChanged(boolean changed) {
        if (changed) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfidenceWeightsTableModel.this.fireTableDataChanged();
                }
            });
        }
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return methods.length;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return methodFullNames[row];
        }
        MethodScores ms = this.confidenceWeights.getScore(methods[row]);
        switch (col) {
            case 1: {
                return ms.getFScorePercent(this.confidenceWeights.getFWeight());
            }
            case 2: {
                return ms.getPrecisionPercent();
            }
            case 3: {
                return ms.getRecallPercent();
            }
        }
        return "";
    }
}

