import vardwrapper.*;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class Example {
	
	/*
	* javac -cp .:vardwrapper.jar Example.java
	* java -cp .:vardwrapper.jar Example ./setup
	*/
	
	public static void main(String[] args) {
		if(args.length!=1) {
			System.err.println("Must include setup folder as a parameter.");
			System.exit(1);
		}
		File setupFolder = new File(args[0]);
		setupFolder.mkdirs();
		if(!setupFolder.isDirectory()) {
			System.err.println("Setup folder must not be a file.");
			System.exit(1);
		}		

		try {
			VARD vard = new VARD(setupFolder, 50.0, 1.0, true);
			
			String word = "have";
			String variant = "haue";

			System.out.println();
			System.out.println(word + ": is variant? " + vard.isVariant(word));
			System.out.println(variant + ": is variant? " + vard.isVariant(variant));

			System.out.println();
			System.out.println("Suggestions for " + variant + ":");
			List<Suggestion> suggestions = vard.getNormalisationSuggestions(variant,10);
			for(Suggestion s : suggestions) {
				System.out.println(s);
			}

			System.out.println();
			System.out.println(Normalisation.headerString());
			System.out.println(vard.normalise(word));
			System.out.println(vard.normalise(variant));

			System.out.println();
			System.out.println(NormalisationStats.headerString());

			File original = new File("Eca1652.txt");
			File vardedxml = new File("Eca1652-vardedxml.txt");
			File varded = new File("Eca1652-varded.txt");
			
			
			vardedxml.createNewFile();
			varded.createNewFile();
			NormalisationStats stats = vard.normaliseFile(original,vardedxml,varded);
			System.out.println(stats);
		}
		catch(IOException io) {
			io.printStackTrace();
		}
		catch(VARDException ex) {
			ex.printStackTrace();
		}
				
		System.exit(0);
	}
}
