/*
 * Decompiled with CFR 0.152.
 */
package gui.sidebar;

import gui.DisplayUtilities;
import gui.MainScreen;
import gui.NoAction;
import gui.QuestionAsker;
import gui.TBJButton;
import gui.TBJToggleButton;
import gui.sidebar.ClearListAction;
import gui.sidebar.RemoveSelectedFromListAction;
import gui.sidebar.SideBarPanel;
import gui.sidebar.TextPrompt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import model.ConfidenceWeights;
import model.Globals;
import model.Setup;
import model.doc.DocumentModel;
import model.doc.InvalidInstanceChangeException;
import model.lookup.LookUpDictionary;
import model.sample.Partition;
import model.sample.SampleModel;
import model.sample.SampleUtilities;

public class SampleSideBar
extends SideBarPanel
implements SampleModel.ChangeListener {
    private static final long serialVersionUID = -3733938112889329199L;
    private final HashMap<String, Action> actions;
    private final JList fileList;
    private final TreeSet<File> files;
    private final JTextField minSizeTF;
    private final JTextField maxSizeTF;
    private final JTextField outputFolderTF;
    private final JFileChooser fc;
    private final JToggleButton searchSubFoldersTB;
    private final JLabel totalWordsLabel;
    private final JLabel completedLabel;
    private final JLabel inProgressLabel;
    private final JLabel remainingLabel;
    private final JComboBox completedCB;
    private final JComboBox inProgressCB;
    private final Globals global;
    private final ConfidenceWeights confidenceWeights;
    private final LookUpDictionary lud;
    private Setup setup;
    private final SampleModel sampleModel;
    private final JFrame owner;
    private final QuestionAsker questionAsker;
    private boolean enabled;

    public SampleSideBar(SampleModel sampleModel, JFrame owner, ConfidenceWeights confidenceWeights, LookUpDictionary lud, Setup setup, QuestionAsker questionAsker) {
        this.sampleModel = sampleModel;
        sampleModel.addChangeListener(this);
        this.owner = owner;
        this.confidenceWeights = confidenceWeights;
        this.lud = lud;
        this.setup = setup;
        this.questionAsker = questionAsker;
        this.enabled = true;
        this.global = Globals.getInstance();
        this.files = new TreeSet();
        this.fileList = new JList<Object>(this.files.toArray());
        this.fileList.setVisibleRowCount(15);
        this.fileList.setTransferHandler(new AddTransferHandler());
        JScrollPane fileListSP = new JScrollPane(this.fileList, 22, 32);
        this.actions = new HashMap();
        this.actions.put("Add Files", MainScreen.fixAction(new AddFilesAction(), "Add File(s)", "page_white_add", "Add file(s).", -1, null));
        this.actions.put("Add Folders", MainScreen.fixAction(new AddFoldersAction(), "Add Folder(s)", "folder_add", "Add folder(s).", -1, null));
        this.actions.put("Remove Files", MainScreen.fixAction(new RemoveSelectedFromListAction(this.fileList, this.files), "Remove File(s)", "table_row_delete", "Remove selected file(s).", -1, null));
        this.actions.put("Clear List", MainScreen.fixAction(new ClearListAction(this.fileList, this.files), "Clear List", "table_delete", "Clear list.", -1, null));
        this.actions.put("Partition files", MainScreen.fixAction(new PartitionFilesAction(), "(Re-)partition files", "page_add", "Partition all files, any previous partition markup will be removed.", -1, null));
        this.actions.put("Use partitions", MainScreen.fixAction(new UsePartitionedFilesAction(), "Use files for sample", "page_code", "Use partitions in files for normalising a sample.", -1, null));
        this.actions.put("Remove partitions", MainScreen.fixAction(new RemovePartitionsAction(), "Remove partition markup", "page_delete", "Remove partition markup from files.", -1, null));
        this.actions.put("Output Browse", MainScreen.fixAction(new OutputBrowseAction(), "Browse", "folder_explore", "Browse for output folder.", -1, null));
        this.actions.put("Search Subfolders", MainScreen.fixAction(new NoAction(), "Search subfolders", "folder_find", "Search subfolders?", -1, null));
        this.actions.put("Edit started partition", MainScreen.fixAction(new EditStartedPartitionAction(), "Process partition", "page_edit", "Process partition", -1, null));
        this.actions.put("Edit done partition", MainScreen.fixAction(new EditDonePartitionAction(), "Process partition", "page_edit", "Process partition, move to in progress.", -1, null));
        this.actions.put("Next queued partition", MainScreen.fixAction(new NextQueuedPartitionAction(), "Next random partition", "page_go", "Process next random queued partition.", -1, null));
        JToolBar inputButtonsToolBar = new JToolBar(1);
        inputButtonsToolBar.setFloatable(false);
        inputButtonsToolBar.add(new TBJButton(this.actions.get("Add Files")));
        inputButtonsToolBar.add(new TBJButton(this.actions.get("Add Folders")));
        inputButtonsToolBar.add(new TBJButton(this.actions.get("Remove Files")));
        inputButtonsToolBar.add(new TBJButton(this.actions.get("Clear List")));
        this.searchSubFoldersTB = new TBJToggleButton(this.actions.get("Search Subfolders"));
        inputButtonsToolBar.add(this.searchSubFoldersTB);
        JPanel inputPanel = new JPanel(new BorderLayout());
        inputPanel.setBorder(BorderFactory.createTitledBorder("Files"));
        inputPanel.add((Component)fileListSP, "Center");
        inputPanel.add((Component)inputButtonsToolBar, "East");
        GridBagConstraints b = new GridBagConstraints();
        b.fill = 0;
        GridBagConstraints l = new GridBagConstraints();
        l.fill = 2;
        l.weightx = 1.0;
        JPanel sizePanel = new JPanel(new GridBagLayout());
        this.minSizeTF = new JTextField(4);
        this.maxSizeTF = new JTextField(4);
        sizePanel.add((Component)new JLabel(" Min. size:"), b);
        sizePanel.add((Component)this.minSizeTF, b);
        sizePanel.add((Component)new JLabel(" Max. size:"), b);
        sizePanel.add((Component)this.maxSizeTF, b);
        sizePanel.add(Box.createGlue(), l);
        this.fc = new JFileChooser();
        JPanel outputFilePanel = new JPanel(new BorderLayout());
        this.outputFolderTF = new JTextField(15);
        TextPrompt tp = new TextPrompt("Output folder", this.outputFolderTF);
        tp.setShow(TextPrompt.Show.FOCUS_LOST);
        tp.changeAlpha(0.5f);
        this.outputFolderTF.setTransferHandler(new FolderTransferHandler());
        outputFilePanel.add((Component)this.outputFolderTF, "Center");
        outputFilePanel.add((Component)new TBJButton(this.actions.get("Output Browse")), "East");
        JPanel partitionFilesPanel = new JPanel(new BorderLayout());
        partitionFilesPanel.setBorder(BorderFactory.createTitledBorder("Partition files"));
        partitionFilesPanel.add((Component)sizePanel, "North");
        partitionFilesPanel.add((Component)outputFilePanel, "Center");
        partitionFilesPanel.add((Component)new JButton(this.actions.get("Partition files")), "South");
        JPanel existingPartitionsPanel = new JPanel(new GridLayout(2, 1));
        existingPartitionsPanel.setBorder(BorderFactory.createTitledBorder("Existing partitions"));
        existingPartitionsPanel.add(new JButton(this.actions.get("Use partitions")));
        existingPartitionsPanel.add(new JButton(this.actions.get("Remove partitions")));
        GridBagConstraints fv = new GridBagConstraints();
        fv.gridx = 0;
        fv.weighty = 1.0;
        fv.weightx = 1.0;
        fv.fill = 1;
        GridBagConstraints nfv = new GridBagConstraints();
        nfv.gridx = 0;
        nfv.weighty = 0.0;
        nfv.weightx = 1.0;
        nfv.fill = 2;
        JPanel inProgressPanel = new JPanel(new BorderLayout());
        this.inProgressLabel = new JLabel("In progress:");
        this.inProgressCB = new JComboBox();
        inProgressPanel.add((Component)this.inProgressLabel, "North");
        inProgressPanel.add((Component)this.inProgressCB, "Center");
        inProgressPanel.add((Component)new TBJButton(this.actions.get("Edit started partition")), "East");
        JPanel completedPanel = new JPanel(new BorderLayout());
        this.completedLabel = new JLabel("Completed:");
        this.completedCB = new JComboBox();
        completedPanel.add((Component)this.completedLabel, "North");
        completedPanel.add((Component)this.completedCB, "Center");
        completedPanel.add((Component)new TBJButton(this.actions.get("Edit done partition")), "East");
        this.totalWordsLabel = new JLabel(" ");
        this.remainingLabel = new JLabel(" ");
        JPanel samplePanel = new JPanel(new GridBagLayout());
        samplePanel.setBorder(BorderFactory.createTitledBorder("Sample"));
        samplePanel.add((Component)inProgressPanel, nfv);
        samplePanel.add((Component)completedPanel, nfv);
        samplePanel.add((Component)this.totalWordsLabel, nfv);
        samplePanel.add((Component)this.remainingLabel, nfv);
        samplePanel.add((Component)new JButton(this.actions.get("Next queued partition")), nfv);
        this.setLayout(new GridBagLayout());
        this.add((Component)inputPanel, fv);
        this.add((Component)partitionFilesPanel, nfv);
        this.add((Component)existingPartitionsPanel, nfv);
        this.add((Component)samplePanel, nfv);
    }

    private boolean partitionFiles(Collection<File> files, String outputFolderString, int minSize, int maxSize) {
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Preparing to partition files...");
        this.global.lockFinishProgress();
        int totalFiles = files.size();
        int fileCounter = 0;
        String commonFolder = this.getCommonFolderString();
        DocumentModel docModel = new DocumentModel(this.setup, this.confidenceWeights, this.lud);
        boolean overwriteExistingPartitions = false;
        ArrayList<File> newFiles = new ArrayList<File>();
        for (File file : files) {
            String fileString;
            block7: {
                fileString = file.getAbsolutePath().replace(commonFolder, "");
                String fileProgress = "Processing " + fileString + " (" + ++fileCounter + "/" + totalFiles + ")";
                this.global.setProgressMessagePrefix(fileProgress);
                docModel.processNewFile(file);
                if (overwriteExistingPartitions || !docModel.hasPartitions()) break block7;
                QuestionAsker.Answer answer = this.questionAsker.askOkCancelQuestion("Overwrite partitions?", String.valueOf(fileString) + " already contains partitions, overwrite existing partitions in all files?");
                if (answer == QuestionAsker.Answer.OK) {
                    overwriteExistingPartitions = true;
                    break block7;
                }
                return false;
            }
            try {
                docModel.clearPartitions();
                docModel.partitionText(minSize, maxSize);
                File newFile = new File(outputFolderString, fileString);
                newFile.getParentFile().mkdirs();
                newFile.createNewFile();
                docModel.saveWithTags(newFile);
                newFiles.add(newFile);
            }
            catch (BadLocationException ex) {
                this.global.showException("Error occurred partitioning file " + fileString, ex);
                this.global.unlockFinishProgress();
                this.global.finishProgress();
                return false;
            }
            catch (IOException ex) {
                this.global.showException("Error occurred partitioning file " + fileString, ex);
                this.global.unlockFinishProgress();
                this.global.finishProgress();
                return false;
            }
            catch (InvalidInstanceChangeException ex) {
                this.global.showException("Error occurred partitioning file " + fileString, ex);
                this.global.unlockFinishProgress();
                this.global.finishProgress();
                return false;
            }
        }
        files.clear();
        files.addAll(newFiles);
        this.fileList.setListData(files.toArray());
        this.usePartitionedFiles(files);
        this.global.unlockFinishProgress();
        this.global.finishProgress();
        return true;
    }

    private boolean usePartitionedFiles(Collection<File> files) {
        this.sampleModel.clear();
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Preparing to read files...");
        this.global.lockFinishProgress();
        int totalFiles = files.size();
        int fileCounter = 0;
        String commonFolder = this.getCommonFolderString();
        for (File file : files) {
            List<Partition> partitions;
            String fileString;
            block4: {
                fileString = file.getAbsolutePath().replace(commonFolder, "");
                String fileProgress = "Processing " + fileString + " (" + ++fileCounter + "/" + totalFiles + ")";
                this.global.setProgressMessagePrefix(fileProgress);
                partitions = SampleUtilities.findPartitionsInFile(fileString, file, this.setup);
                if (!partitions.isEmpty()) break block4;
                this.global.showError(String.valueOf(fileString) + " does not contain partitions, please partition files.");
                this.global.unlockFinishProgress();
                this.global.finishProgress();
                return false;
            }
            try {
                this.sampleModel.addPartitions(partitions);
            }
            catch (IOException e) {
                this.global.showException("Error occurred reading file: " + fileString, e);
            }
        }
        this.global.unlockFinishProgress();
        this.global.finishProgress();
        return true;
    }

    private boolean removePartitionsMarkup(Collection<File> files) {
        this.sampleModel.clear();
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Preparing to read files...");
        this.global.lockFinishProgress();
        int totalFiles = files.size();
        int fileCounter = 0;
        String commonFolder = this.getCommonFolderString();
        DocumentModel docModel = new DocumentModel(this.setup, this.confidenceWeights, this.lud);
        for (File file : files) {
            String fileString = file.getAbsolutePath().replace(commonFolder, "");
            try {
                String fileProgress = "Processing " + fileString + " (" + ++fileCounter + "/" + totalFiles + ")";
                this.global.setProgressMessagePrefix(fileProgress);
                docModel.processNewFile(file);
                docModel.clearPartitions();
                docModel.saveWithTags(file);
            }
            catch (InvalidInstanceChangeException e) {
                this.global.showException("Error occurred reading file: " + fileString, e);
                this.global.unlockFinishProgress();
                this.global.finishProgress();
                return false;
            }
            catch (BadLocationException e) {
                this.global.showException("Error occurred whilst processing file: " + fileString, e);
                this.global.unlockFinishProgress();
                this.global.finishProgress();
                return false;
            }
            catch (IOException e) {
                this.global.showException("Error occurred whilst saving file: " + fileString, e);
                this.global.unlockFinishProgress();
                this.global.finishProgress();
                return false;
            }
        }
        this.global.unlockFinishProgress();
        this.global.finishProgress();
        return true;
    }

    private String getCommonFolderString() {
        String latest = this.files.first().getAbsolutePath();
        latest = latest.substring(0, latest.lastIndexOf(File.separator));
        for (File file : this.files) {
            String currentFileString = file.getAbsolutePath();
            while (!currentFileString.startsWith(latest)) {
                latest = latest.substring(0, latest.lastIndexOf(File.separator));
            }
        }
        return latest;
    }

    @Override
    public void changeSetup(Setup setup) {
        this.setup = setup;
    }

    @Override
    public void setEnabled(boolean e) {
        this.enabled = e;
        for (Action a : this.actions.values()) {
            a.setEnabled(e);
        }
        this.fileList.setEnabled(e);
        this.minSizeTF.setEditable(e);
        this.maxSizeTF.setEditable(e);
        this.outputFolderTF.setEditable(e);
        boolean donePresent = this.sampleModel.getDonePartitionsSize() > 0;
        boolean startedPresent = this.sampleModel.getStartedPartitionsSize() > 0;
        this.completedCB.setEnabled(e && donePresent);
        this.actions.get("Edit done partition").setEnabled(e && donePresent);
        this.inProgressCB.setEnabled(e && startedPresent);
        this.actions.get("Edit started partition").setEnabled(e && startedPresent);
        this.actions.get("Next queued partition").setEnabled(e && this.sampleModel.getQueuedPartitionsSize() > 0);
    }

    private static void walkFolder(TreeSet<File> toAddTo, File folder) {
        File[] filesFromFolder;
        File[] fileArray = filesFromFolder = folder.listFiles();
        int n = filesFromFolder.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory()) {
                if (!file.isHidden() && !toAddTo.contains(file)) {
                    toAddTo.add(file);
                }
            } else {
                SampleSideBar.walkFolder(toAddTo, file);
            }
            ++n2;
        }
    }

    @Override
    public void currentPartitionChanged(Partition partition) {
        this.inProgressCB.setSelectedItem(partition);
    }

    @Override
    public void partitionDistributionChanged() {
        int totalWords = this.sampleModel.getTotalWords();
        int inProgressWords = this.sampleModel.getStartedWords();
        int completedWords = this.sampleModel.getDoneWords();
        int queuedPartitionsRemaining = this.sampleModel.getQueuedPartitionsSize();
        this.inProgressCB.setModel(new DefaultComboBoxModel<Object>(this.sampleModel.getStartedPartitions().toArray()));
        this.completedCB.setModel(new DefaultComboBoxModel<Object>(this.sampleModel.getDonePartitions().toArray()));
        if (inProgressWords > 0) {
            this.inProgressLabel.setText("In progress: " + DisplayUtilities.getFormattedNumber(inProgressWords) + " words (" + DisplayUtilities.getPercent(inProgressWords, totalWords) + "):");
            this.inProgressCB.setEnabled(this.enabled);
            this.actions.get("Edit started partition").setEnabled(this.enabled);
        } else {
            this.inProgressLabel.setText("In progress:");
            this.inProgressCB.setEnabled(false);
            this.actions.get("Edit started partition").setEnabled(false);
        }
        if (completedWords > 0) {
            this.completedLabel.setText("Completed: " + DisplayUtilities.getFormattedNumber(completedWords) + " words (" + DisplayUtilities.getPercent(completedWords, totalWords) + "):");
            this.completedCB.setEnabled(this.enabled);
            this.actions.get("Edit done partition").setEnabled(this.enabled);
        } else {
            this.completedLabel.setText("Completed:");
            this.completedCB.setEnabled(false);
            this.actions.get("Edit done partition").setEnabled(false);
        }
        if (totalWords > 0) {
            this.totalWordsLabel.setText("Total words: " + DisplayUtilities.getFormattedNumber(totalWords));
        } else {
            this.totalWordsLabel.setText(" ");
        }
        if (queuedPartitionsRemaining > 0) {
            this.remainingLabel.setText("Partitions remaining: " + DisplayUtilities.getFormattedNumber(queuedPartitionsRemaining));
            this.actions.get("Next queued partition").setEnabled(this.enabled);
        } else {
            this.remainingLabel.setText(" ");
            this.actions.get("Next queued partition").setEnabled(false);
        }
    }

    private class AddFilesAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 4326016666260935844L;

        private AddFilesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SampleSideBar.this.fc.setFileSelectionMode(0);
            SampleSideBar.this.fc.setMultiSelectionEnabled(true);
            int returnVal = SampleSideBar.this.fc.showOpenDialog(SampleSideBar.this.owner);
            if (returnVal == 0) {
                new Thread(){

                    @Override
                    public void run() {
                        File[] filesSelected = SampleSideBar.this.fc.getSelectedFiles();
                        SampleSideBar.this.global.startProgress(filesSelected.length);
                        SampleSideBar.this.global.writeProgressMessage("Adding files...");
                        int count = 0;
                        File[] fileArray = filesSelected;
                        int n = filesSelected.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            SampleSideBar.this.files.add(file);
                            SampleSideBar.this.global.setProgressCurrent(++count);
                            ++n2;
                        }
                        SampleSideBar.this.fileList.setListData(SampleSideBar.this.files.toArray());
                        SampleSideBar.this.global.finishProgress();
                    }
                }.start();
            }
        }
    }

    private class AddFoldersAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -7212828610752565633L;

        private AddFoldersAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SampleSideBar.this.fc.setFileSelectionMode(1);
            SampleSideBar.this.fc.setMultiSelectionEnabled(true);
            int returnVal2 = SampleSideBar.this.fc.showOpenDialog(SampleSideBar.this.owner);
            if (returnVal2 == 0) {
                new Thread(){

                    @Override
                    public void run() {
                        SampleSideBar.this.global.startIndeterminateProgress();
                        File[] foldersSelected = SampleSideBar.this.fc.getSelectedFiles();
                        int totalFolders = foldersSelected.length;
                        int folderCount = 0;
                        File[] fileArray = foldersSelected;
                        int n = foldersSelected.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File folder = fileArray[n2];
                            if (SampleSideBar.this.searchSubFoldersTB.isSelected()) {
                                SampleSideBar.walkFolder(SampleSideBar.this.files, folder);
                            } else {
                                File[] filesFromFolder = folder.listFiles();
                                SampleSideBar.this.global.startProgress(filesFromFolder.length);
                                SampleSideBar.this.global.writeProgressMessage("Adding files from " + folder.getName() + "(" + ++folderCount + "/" + totalFolders + ")...");
                                int fileCount = 0;
                                File[] fileArray2 = filesFromFolder;
                                int n3 = filesFromFolder.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    File file = fileArray2[n4];
                                    if (!(file.isDirectory() || file.isHidden() || SampleSideBar.this.files.contains(file))) {
                                        SampleSideBar.this.files.add(file);
                                    }
                                    SampleSideBar.this.global.setProgressCurrent(++fileCount);
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                        SampleSideBar.this.fileList.setListData(SampleSideBar.this.files.toArray());
                        SampleSideBar.this.global.finishProgress();
                    }
                }.start();
            }
        }
    }

    private class AddTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -3375927171804520959L;

        private AddTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            List filesAdded;
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                filesAdded = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            if (filesAdded.isEmpty()) {
                return false;
            }
            new Thread(){

                @Override
                public void run() {
                    SampleSideBar.this.global.startProgress(filesAdded.size());
                    SampleSideBar.this.global.writeProgressMessage("Adding files...");
                    int count = 0;
                    for (File file : filesAdded) {
                        if (file.isDirectory()) {
                            if (SampleSideBar.this.searchSubFoldersTB.isSelected()) {
                                SampleSideBar.walkFolder(SampleSideBar.this.files, file);
                            } else {
                                File[] filesFromFolder = file.listFiles();
                                SampleSideBar.this.global.startProgress(filesFromFolder.length);
                                SampleSideBar.this.global.writeProgressMessage("Adding files from " + file.getName());
                                int fileCount = 0;
                                File[] fileArray = filesFromFolder;
                                int n = filesFromFolder.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    File f = fileArray[n2];
                                    if (!(f.isDirectory() || f.isHidden() || SampleSideBar.this.files.contains(f))) {
                                        SampleSideBar.this.files.add(f);
                                    }
                                    SampleSideBar.this.global.setProgressCurrent(++fileCount);
                                    ++n2;
                                }
                            }
                        } else {
                            SampleSideBar.this.files.add(file);
                        }
                        SampleSideBar.this.global.setProgressCurrent(++count);
                    }
                    SampleSideBar.this.fileList.setListData(SampleSideBar.this.files.toArray());
                    SampleSideBar.this.global.finishProgress();
                }
            }.start();
            return true;
        }
    }

    private class EditDonePartitionAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -8446586664113182319L;

        private EditDonePartitionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Partition selectedPartition = (Partition)SampleSideBar.this.completedCB.getSelectedItem();
            if (selectedPartition != null) {
                SampleSideBar.this.sampleModel.processDonePartition(selectedPartition);
            }
        }
    }

    private class EditStartedPartitionAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -8446586664113182319L;

        private EditStartedPartitionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Partition selectedPartition = (Partition)SampleSideBar.this.inProgressCB.getSelectedItem();
            if (selectedPartition != null) {
                SampleSideBar.this.sampleModel.processStartedPartion(selectedPartition);
            }
        }
    }

    private class FolderTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -260318740428503951L;

        private FolderTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            List files;
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            if (files.isEmpty()) {
                return false;
            }
            File folder = (File)files.get(0);
            if (!folder.isDirectory()) {
                folder = folder.getParentFile();
            }
            SampleSideBar.this.outputFolderTF.setText(folder.getAbsolutePath());
            return true;
        }
    }

    private class NextQueuedPartitionAction
    extends AbstractAction {
        private static final long serialVersionUID = -9026327559685833536L;

        private NextQueuedPartitionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SampleSideBar.this.sampleModel.nextQueuedPartition();
        }
    }

    private class OutputBrowseAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -4484055645720417160L;

        private OutputBrowseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SampleSideBar.this.fc.setFileSelectionMode(1);
            SampleSideBar.this.fc.setMultiSelectionEnabled(false);
            int saveReturnVal = SampleSideBar.this.fc.showSaveDialog(SampleSideBar.this.owner);
            if (saveReturnVal == 0) {
                String ofs = SampleSideBar.this.fc.getSelectedFile().getPath();
                SampleSideBar.this.outputFolderTF.setText(ofs);
            }
        }
    }

    private class PartitionFilesAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 216582840693631371L;

        private PartitionFilesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String outputFolderString = SampleSideBar.this.outputFolderTF.getText();
            if (SampleSideBar.this.files.size() == 0) {
                SampleSideBar.this.global.showError("Please provide atleast one file to partition.");
                return;
            }
            if (outputFolderString.equals("")) {
                SampleSideBar.this.global.showError("Please provide an output folder.");
                return;
            }
            String minSizeString = SampleSideBar.this.minSizeTF.getText();
            if (minSizeString.equals("")) {
                SampleSideBar.this.global.showError("Please provide minimum partition size.");
                return;
            }
            if (!minSizeString.matches("[0-9]+")) {
                SampleSideBar.this.global.showError("Minimum partition size must be number.");
                return;
            }
            String maxSizeString = SampleSideBar.this.maxSizeTF.getText();
            if (maxSizeString.equals("")) {
                SampleSideBar.this.global.showError("Please provide maximum partition size.");
                return;
            }
            if (!maxSizeString.matches("[0-9]+")) {
                SampleSideBar.this.global.showError("Maximum partition size must be number.");
                return;
            }
            File outputFolder = new File(outputFolderString);
            outputFolder.mkdirs();
            int minSize = Integer.parseInt(minSizeString);
            int maxSize = Integer.parseInt(maxSizeString);
            class Worker
            extends SwingWorker<Boolean, Object> {
                private final /* synthetic */ String val$outputFolderString;
                private final /* synthetic */ int val$minSize;
                private final /* synthetic */ int val$maxSize;

                Worker(String string, int n, int n2) {
                    this.val$outputFolderString = string;
                    this.val$minSize = n;
                    this.val$maxSize = n2;
                }

                @Override
                public Boolean doInBackground() {
                    return SampleSideBar.this.partitionFiles(SampleSideBar.this.files, this.val$outputFolderString, this.val$minSize, this.val$maxSize);
                }
            }
            new Worker(outputFolderString, minSize, maxSize).execute();
        }
    }

    private class RemovePartitionsAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -6117043639589381428L;

        private RemovePartitionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SampleSideBar.this.files.size() == 0) {
                SampleSideBar.this.global.showError("Please provide atleast one file to remove partition markup from.");
                return;
            }
            class Worker
            extends SwingWorker<Boolean, Object> {
                Worker() {
                }

                @Override
                public Boolean doInBackground() {
                    return SampleSideBar.this.removePartitionsMarkup(SampleSideBar.this.files);
                }
            }
            new Worker().execute();
        }
    }

    private class UsePartitionedFilesAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 8546064595699132554L;

        private UsePartitionedFilesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SampleSideBar.this.files.size() == 0) {
                SampleSideBar.this.global.showError("Please provide atleast one file to use for sample.");
                return;
            }
            class Worker
            extends SwingWorker<Boolean, Object> {
                Worker() {
                }

                @Override
                public Boolean doInBackground() {
                    return SampleSideBar.this.usePartitionedFiles(SampleSideBar.this.files);
                }
            }
            new Worker().execute();
        }
    }
}

