/*
 * Decompiled with CFR 0.152.
 */
package gui.sidebar;

import gui.MainScreen;
import gui.NoAction;
import gui.TBJButton;
import gui.TBJToggleButton;
import gui.sidebar.ClearListAction;
import gui.sidebar.RemoveSelectedFromListAction;
import gui.sidebar.SideBarPanel;
import gui.sidebar.TextPrompt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.TransferHandler;
import model.ConfidenceWeights;
import model.Globals;
import model.Setup;
import model.lookup.LookUpDictionary;

public class BatchScreenSideBar
extends SideBarPanel {
    private static final long serialVersionUID = -3733938112889329199L;
    private final HashMap<String, Action> actions;
    private final JList fileList;
    private final TreeSet<File> files;
    private final JTextField outputFolderTF;
    private final JFileChooser fc;
    private final JSpinner thresholdSpinner;
    private final JToggleButton searchSubFoldersTB;
    private final JCheckBox xmlCheckBox;
    private final JCheckBox plainCheckBox;
    private final JCheckBox useCacheCheckBox;
    private final Globals global;
    private final ConfidenceWeights confidenceWeights;
    private final LookUpDictionary lud;
    private Setup setup;
    private final JFrame owner;

    public BatchScreenSideBar(JFrame owner, ConfidenceWeights confidenceWeights, LookUpDictionary lud, Setup setup) {
        this.owner = owner;
        this.confidenceWeights = confidenceWeights;
        this.lud = lud;
        this.setup = setup;
        this.global = Globals.getInstance();
        this.files = new TreeSet();
        this.fileList = new JList<Object>(this.files.toArray());
        this.fileList.setVisibleRowCount(15);
        this.fileList.setTransferHandler(new AddTransferHandler());
        JScrollPane fileListSP = new JScrollPane(this.fileList, 22, 32);
        this.actions = new HashMap();
        this.actions.put("Add Files", MainScreen.fixAction(new AddFilesAction(), "Add File(s)", "page_white_add", "Add file(s).", -1, null));
        this.actions.put("Add Folders", MainScreen.fixAction(new AddFoldersAction(), "Add Folder(s)", "folder_add", "Add folder(s).", -1, null));
        this.actions.put("Remove Files", MainScreen.fixAction(new RemoveSelectedFromListAction(this.fileList, this.files), "Remove File(s)", "table_row_delete", "Remove selected file(s).", -1, null));
        this.actions.put("Clear List", MainScreen.fixAction(new ClearListAction(this.fileList, this.files), "Clear List", "table_delete", "Clear list.", -1, null));
        this.actions.put("Process List", MainScreen.fixAction(new ProcessListAction(), "Process list", null, "Process all files.", -1, null));
        this.actions.put("Output Browse", MainScreen.fixAction(new OutputBrowseAction(), "Browse", "folder_explore", "Browse for output folder.", -1, null));
        this.actions.put("Search Subfolders", MainScreen.fixAction(new NoAction(), "Search subfolders", "folder_find", "Search subfolders?", -1, null));
        JToolBar inputButtonsToolBar = new JToolBar(1);
        inputButtonsToolBar.setFloatable(false);
        inputButtonsToolBar.add(new TBJButton(this.actions.get("Add Files")));
        inputButtonsToolBar.add(new TBJButton(this.actions.get("Add Folders")));
        inputButtonsToolBar.add(new TBJButton(this.actions.get("Remove Files")));
        inputButtonsToolBar.add(new TBJButton(this.actions.get("Clear List")));
        this.searchSubFoldersTB = new TBJToggleButton(this.actions.get("Search Subfolders"));
        inputButtonsToolBar.add(this.searchSubFoldersTB);
        JPanel inputPanel = new JPanel(new BorderLayout());
        inputPanel.setBorder(BorderFactory.createTitledBorder("Files"));
        inputPanel.add((Component)fileListSP, "Center");
        inputPanel.add((Component)inputButtonsToolBar, "East");
        JPanel thresholdPanel = new JPanel(new GridBagLayout());
        JLabel thresholdLabel = new JLabel("Threshold (%):", 11);
        thresholdPanel.add(thresholdLabel);
        this.thresholdSpinner = new JSpinner(new SpinnerNumberModel(50, 0, 99, 5));
        thresholdLabel.setLabelFor(this.thresholdSpinner);
        thresholdPanel.add(this.thresholdSpinner);
        JPanel controlPanel = new JPanel(new BorderLayout());
        controlPanel.setBorder(BorderFactory.createTitledBorder("Normalisation Control"));
        controlPanel.add((Component)thresholdPanel, "West");
        controlPanel.add(Box.createGlue(), "Center");
        this.useCacheCheckBox = new JCheckBox("Use normalisation cache");
        this.useCacheCheckBox.setSelected(true);
        controlPanel.add((Component)this.useCacheCheckBox, "South");
        JPanel outputTypePanel = new JPanel(new GridLayout(2, 1));
        this.plainCheckBox = new JCheckBox("Changes Unmarked");
        this.xmlCheckBox = new JCheckBox("Changes Tagged");
        this.xmlCheckBox.setSelected(true);
        outputTypePanel.add(this.plainCheckBox);
        outputTypePanel.add(this.xmlCheckBox);
        JPanel outputFilePanel = new JPanel(new BorderLayout());
        this.outputFolderTF = new JTextField(15);
        TextPrompt tp = new TextPrompt("Output folder", this.outputFolderTF);
        tp.setShow(TextPrompt.Show.FOCUS_LOST);
        tp.changeAlpha(0.5f);
        this.outputFolderTF.setTransferHandler(new FolderTransferHandler());
        outputFilePanel.add((Component)this.outputFolderTF, "Center");
        outputFilePanel.add((Component)new TBJButton(this.actions.get("Output Browse")), "East");
        JPanel outputPanel = new JPanel(new BorderLayout());
        outputPanel.setBorder(BorderFactory.createTitledBorder("Output"));
        outputPanel.add((Component)outputTypePanel, "North");
        outputPanel.add((Component)outputFilePanel, "South");
        this.fc = new JFileChooser();
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)controlPanel, "North");
        bottomPanel.add((Component)outputPanel, "Center");
        bottomPanel.add((Component)new JButton(this.actions.get("Process List")), "South");
        this.setLayout(new BorderLayout());
        this.add((Component)inputPanel, "Center");
        this.add((Component)bottomPanel, "South");
    }

    private String getCommonFolderString() {
        String latest = this.files.first().getAbsolutePath();
        latest = latest.substring(0, latest.lastIndexOf(File.separator));
        for (File file : this.files) {
            String currentFileString = file.getAbsolutePath();
            while (!currentFileString.startsWith(latest)) {
                latest = latest.substring(0, latest.lastIndexOf(File.separator));
            }
        }
        return latest;
    }

    @Override
    public void changeSetup(Setup setup) {
        this.setup = setup;
    }

    @Override
    public void setEnabled(boolean e) {
        for (Action a : this.actions.values()) {
            a.setEnabled(e);
        }
        this.fileList.setEnabled(e);
        this.useCacheCheckBox.setEnabled(e);
        this.thresholdSpinner.setEnabled(e);
        this.outputFolderTF.setEditable(e);
        this.xmlCheckBox.setEnabled(e);
        this.plainCheckBox.setEnabled(e);
    }

    private static void walkFolder(TreeSet<File> toAddTo, File folder) {
        File[] filesFromFolder;
        File[] fileArray = filesFromFolder = folder.listFiles();
        int n = filesFromFolder.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory()) {
                if (!file.isHidden() && !toAddTo.contains(file)) {
                    toAddTo.add(file);
                }
            } else {
                BatchScreenSideBar.walkFolder(toAddTo, file);
            }
            ++n2;
        }
    }

    static /* synthetic */ JSpinner access$8(BatchScreenSideBar batchScreenSideBar) {
        return batchScreenSideBar.thresholdSpinner;
    }

    static /* synthetic */ ConfidenceWeights access$9(BatchScreenSideBar batchScreenSideBar) {
        return batchScreenSideBar.confidenceWeights;
    }

    static /* synthetic */ String access$10(BatchScreenSideBar batchScreenSideBar) {
        return batchScreenSideBar.getCommonFolderString();
    }

    static /* synthetic */ LookUpDictionary access$11(BatchScreenSideBar batchScreenSideBar) {
        return batchScreenSideBar.lud;
    }

    static /* synthetic */ JCheckBox access$12(BatchScreenSideBar batchScreenSideBar) {
        return batchScreenSideBar.useCacheCheckBox;
    }

    static /* synthetic */ Setup access$13(BatchScreenSideBar batchScreenSideBar) {
        return batchScreenSideBar.setup;
    }

    static /* synthetic */ JCheckBox access$14(BatchScreenSideBar batchScreenSideBar) {
        return batchScreenSideBar.plainCheckBox;
    }

    static /* synthetic */ JCheckBox access$15(BatchScreenSideBar batchScreenSideBar) {
        return batchScreenSideBar.xmlCheckBox;
    }

    private class AddFilesAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 4326016666260935844L;

        private AddFilesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            BatchScreenSideBar.this.fc.setFileSelectionMode(0);
            BatchScreenSideBar.this.fc.setMultiSelectionEnabled(true);
            int returnVal = BatchScreenSideBar.this.fc.showOpenDialog(BatchScreenSideBar.this.owner);
            if (returnVal == 0) {
                new Thread(){

                    @Override
                    public void run() {
                        File[] filesSelected = BatchScreenSideBar.this.fc.getSelectedFiles();
                        BatchScreenSideBar.this.global.startProgress(filesSelected.length);
                        BatchScreenSideBar.this.global.writeProgressMessage("Adding files...");
                        int count = 0;
                        File[] fileArray = filesSelected;
                        int n = filesSelected.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            BatchScreenSideBar.this.files.add(file);
                            BatchScreenSideBar.this.global.setProgressCurrent(++count);
                            ++n2;
                        }
                        BatchScreenSideBar.this.fileList.setListData(BatchScreenSideBar.this.files.toArray());
                        BatchScreenSideBar.this.global.finishProgress();
                    }
                }.start();
            }
        }
    }

    private class AddFoldersAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -7212828610752565633L;

        private AddFoldersAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BatchScreenSideBar.this.fc.setFileSelectionMode(1);
            BatchScreenSideBar.this.fc.setMultiSelectionEnabled(true);
            int returnVal2 = BatchScreenSideBar.this.fc.showOpenDialog(BatchScreenSideBar.this.owner);
            if (returnVal2 == 0) {
                new Thread(){

                    @Override
                    public void run() {
                        BatchScreenSideBar.this.global.startIndeterminateProgress();
                        File[] foldersSelected = BatchScreenSideBar.this.fc.getSelectedFiles();
                        int totalFolders = foldersSelected.length;
                        int folderCount = 0;
                        File[] fileArray = foldersSelected;
                        int n = foldersSelected.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File folder = fileArray[n2];
                            if (BatchScreenSideBar.this.searchSubFoldersTB.isSelected()) {
                                BatchScreenSideBar.walkFolder(BatchScreenSideBar.this.files, folder);
                            } else {
                                File[] filesFromFolder = folder.listFiles();
                                BatchScreenSideBar.this.global.startProgress(filesFromFolder.length);
                                BatchScreenSideBar.this.global.writeProgressMessage("Adding files from " + folder.getName() + "(" + ++folderCount + "/" + totalFolders + ")...");
                                int fileCount = 0;
                                File[] fileArray2 = filesFromFolder;
                                int n3 = filesFromFolder.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    File file = fileArray2[n4];
                                    if (!(file.isDirectory() || file.isHidden() || BatchScreenSideBar.this.files.contains(file))) {
                                        BatchScreenSideBar.this.files.add(file);
                                    }
                                    BatchScreenSideBar.this.global.setProgressCurrent(++fileCount);
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                        BatchScreenSideBar.this.fileList.setListData(BatchScreenSideBar.this.files.toArray());
                        BatchScreenSideBar.this.global.finishProgress();
                    }
                }.start();
            }
        }
    }

    private class AddTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -3375927171804520959L;

        private AddTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            List filesAdded;
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                filesAdded = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            if (filesAdded.isEmpty()) {
                return false;
            }
            new Thread(){

                @Override
                public void run() {
                    BatchScreenSideBar.this.global.startProgress(filesAdded.size());
                    BatchScreenSideBar.this.global.writeProgressMessage("Adding files...");
                    int count = 0;
                    for (File file : filesAdded) {
                        if (file.isDirectory()) {
                            if (BatchScreenSideBar.this.searchSubFoldersTB.isSelected()) {
                                BatchScreenSideBar.walkFolder(BatchScreenSideBar.this.files, file);
                            } else {
                                File[] filesFromFolder = file.listFiles();
                                BatchScreenSideBar.this.global.startProgress(filesFromFolder.length);
                                BatchScreenSideBar.this.global.writeProgressMessage("Adding files from " + file.getName());
                                int fileCount = 0;
                                File[] fileArray = filesFromFolder;
                                int n = filesFromFolder.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    File f = fileArray[n2];
                                    if (!(f.isDirectory() || f.isHidden() || BatchScreenSideBar.this.files.contains(f))) {
                                        BatchScreenSideBar.this.files.add(f);
                                    }
                                    BatchScreenSideBar.this.global.setProgressCurrent(++fileCount);
                                    ++n2;
                                }
                            }
                        } else {
                            BatchScreenSideBar.this.files.add(file);
                        }
                        BatchScreenSideBar.this.global.setProgressCurrent(++count);
                    }
                    BatchScreenSideBar.this.fileList.setListData(BatchScreenSideBar.this.files.toArray());
                    BatchScreenSideBar.this.global.finishProgress();
                }
            }.start();
            return true;
        }
    }

    private class FolderTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -260318740428503951L;

        private FolderTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            List files;
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            if (files.isEmpty()) {
                return false;
            }
            File folder = (File)files.get(0);
            if (!folder.isDirectory()) {
                folder = folder.getParentFile();
            }
            BatchScreenSideBar.this.outputFolderTF.setText(folder.getAbsolutePath());
            return true;
        }
    }

    private class OutputBrowseAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -4484055645720417160L;

        private OutputBrowseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BatchScreenSideBar.this.fc.setFileSelectionMode(1);
            BatchScreenSideBar.this.fc.setMultiSelectionEnabled(false);
            int saveReturnVal = BatchScreenSideBar.this.fc.showSaveDialog(BatchScreenSideBar.this.owner);
            if (saveReturnVal == 0) {
                String ofs = BatchScreenSideBar.this.fc.getSelectedFile().getPath();
                BatchScreenSideBar.this.outputFolderTF.setText(ofs);
            }
        }
    }

    private class ProcessListAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 216582840693631371L;

        private ProcessListAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String outputFolderString = BatchScreenSideBar.this.outputFolderTF.getText();
            if (BatchScreenSideBar.this.files.size() == 0) {
                BatchScreenSideBar.this.global.showError("Please provide atleast one file to process.");
                return;
            }
            if (outputFolderString.equals("")) {
                BatchScreenSideBar.this.global.showError("Please provide an output folder.");
                return;
            }
            File outputFolder = new File(outputFolderString);
            outputFolder.mkdirs();
            new Thread(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            }.start();
        }

        static /* synthetic */ BatchScreenSideBar access$1(ProcessListAction processListAction) {
            return processListAction.BatchScreenSideBar.this;
        }
    }
}

