/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.AddOwnVariantDialog;
import gui.QuestionAsker;
import gui.ThreadedProcessEditHolder;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.text.BadLocationException;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import model.ConfidenceWeights;
import model.Globals;
import model.MethodScores;
import model.MethodScoresUpdate;
import model.SuggestedReplacement;
import model.doc.DocumentModel;
import model.doc.Instance;
import model.doc.InvalidInstanceChangeException;
import model.doc.NormaliseAllVariantInstancesEdit;
import model.doc.NormaliseVariantInstanceEdit;
import model.doc.ThreadableEdit;
import model.doc.VariantInstance;
import model.doc.WordHolder;
import model.lookup.LookUpDictionary;
import model.lookup.Word;

public class NormaliseToAction<F extends VariantInstance>
extends AbstractAction {
    private static final long serialVersionUID = 6659037788557951900L;
    private F fi;
    private int fromType;
    private WordHolder wh;
    private boolean isInstance;
    private final DocumentModel docModel;
    private final LookUpDictionary lud;
    private final ConfidenceWeights confidenceWeights;
    private final UndoableEditSupport undoSupport;
    private final QuestionAsker questionAsker;

    public NormaliseToAction(F fi, DocumentModel docModel, LookUpDictionary lud, ConfidenceWeights confidenceWeights, UndoableEditSupport undoSupport, QuestionAsker questionAsker) {
        this.docModel = docModel;
        this.lud = lud;
        this.confidenceWeights = confidenceWeights;
        this.undoSupport = undoSupport;
        this.questionAsker = questionAsker;
        this.isInstance = true;
        this.fi = fi;
        this.fromType = ((VariantInstance)fi).getType();
        this.wh = ((Instance)fi).getHolder();
        this.putValue("Name", "Normalise to...");
    }

    public NormaliseToAction(WordHolder wh, int fromType, DocumentModel docModel, LookUpDictionary lud, ConfidenceWeights confidenceWeights, UndoableEditSupport undoSupport, QuestionAsker questionAsker) {
        this.docModel = docModel;
        this.lud = lud;
        this.confidenceWeights = confidenceWeights;
        this.undoSupport = undoSupport;
        this.questionAsker = questionAsker;
        this.isInstance = false;
        this.wh = wh;
        this.fromType = fromType;
        this.putValue("Name", "Normalise to...");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        QuestionAsker.Answer answer;
        String variantString = this.isInstance ? ((Instance)this.fi).getDisplayString() : this.wh.getWord();
        AddOwnVariantDialog.UserInput userInput = AddOwnVariantDialog.showDialog(this.questionAsker, variantString, this.isInstance);
        if (userInput == null) {
            return;
        }
        String replacement = userInput.getReplacement();
        Word word = this.lud.checkWords(replacement);
        boolean newWord = false;
        if (word == null) {
            word = new Word(replacement, null, true, 1);
            newWord = true;
        }
        SuggestedReplacement rep = null;
        List<SuggestedReplacement> reps = this.lud.findReplacements(variantString, 0, this.confidenceWeights);
        for (SuggestedReplacement r : reps) {
            if (!r.getReplacementStringWithoutChangingCapitalisation().equalsIgnoreCase(word.getWord())) continue;
            rep = r;
            rep.setReplacementString(replacement);
            break;
        }
        if (rep == null) {
            rep = new SuggestedReplacement(variantString, replacement, word.getFreq(), word.isUserAdded());
            if (reps.size() != 0) {
                SuggestedReplacement first = (SuggestedReplacement)reps.iterator().next();
                for (Map.Entry<String, MethodScoresUpdate> msu : first.getMethodScoresUpdates().entrySet()) {
                    MethodScores origUpdate = msu.getValue().getUpdate();
                    MethodScores newUpdate = new MethodScores(0.0, origUpdate.fp() + origUpdate.tp());
                    rep.setScoreUpdate(msu.getKey(), new MethodScoresUpdate(msu.getValue().getToUpdate(), newUpdate));
                }
            } else {
                Set<Map.Entry<String, MethodScores>> cwMSs = this.confidenceWeights.getScores().entrySet();
                for (Map.Entry<String, MethodScores> ms : cwMSs) {
                    rep.setScoreUpdate(ms.getKey(), new MethodScoresUpdate(ms.getValue(), new MethodScores(0.0, 0.0)));
                }
            }
            rep.reCalculateScore(this.confidenceWeights);
        }
        if (newWord && (answer = this.questionAsker.askYesNoQuestion("Add normalisation to dictionary?", "Would you like to add this replacement word to the dictionary?")) == QuestionAsker.Answer.Yes) {
            DocumentModel.AddWordToDictionaryEdit addEdit = this.docModel.getAddWordToDictionaryEdit(this.wh, word.toString());
            addEdit.execute();
            this.undoSupport.postEdit(addEdit);
        }
        try {
            AbstractUndoableEdit edit;
            if (userInput.isReplaceAllInstancesOfWord()) {
                edit = new NormaliseAllVariantInstancesEdit(this.wh, this.fromType, rep, this.docModel, this.docModel, this.lud, false, true, false);
                ThreadedProcessEditHolder tEdit = new ThreadedProcessEditHolder((ThreadableEdit)((Object)edit));
                tEdit.execute();
                this.undoSupport.postEdit(tEdit);
            } else {
                edit = new NormaliseVariantInstanceEdit((VariantInstance)this.fi, rep, this.docModel, this.docModel, this.lud, false, true, false);
                edit.execute();
                this.undoSupport.postEdit(edit);
            }
        }
        catch (BadLocationException ex) {
            Globals.getInstance().showException("Error occurred replacing word", ex);
        }
        catch (InvalidInstanceChangeException ex) {
            Globals.getInstance().showException("Error occurred replacing word", ex);
        }
    }
}

