/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.text.Position;
import model.IgnoreCaseComparator;
import model.Setup;
import model.SuggestedReplacement;
import model.doc.CorrectInstance;
import model.doc.HolderChangeListener;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.ReplacedInstance;
import model.doc.VariantInstance;
import model.lookup.Word;

public class WordHolder
implements Comparable<WordHolder> {
    public static final int VARIANT = 101;
    public static final int REPLACED = 102;
    public static final int CORRECT = 103;
    public static final int[] types = new int[]{101, 102, 103};
    private final String word;
    private final InstanceHolder<VariantInstance> asVariant;
    private final InstanceHolder<CorrectInstance> asCorrect;
    private final TreeMap<String, InstanceHolder<ReplacedInstance>> asReplaced;
    private boolean inDictionary;
    private boolean isLowFreq;
    private Word dictionaryRef;
    private List<SuggestedReplacement> replacements;
    private boolean areReplacementsSet;
    private final HolderChangeListener holderChangeListener;

    public WordHolder(String word, HolderChangeListener holderChangeListener) {
        this.word = word;
        this.asVariant = new InstanceHolder(word, this, holderChangeListener);
        this.asReplaced = new TreeMap(new IgnoreCaseComparator());
        this.asCorrect = new InstanceHolder(word, this, holderChangeListener);
        this.holderChangeListener = holderChangeListener;
        this.replacements = new Vector<SuggestedReplacement>();
    }

    static String getTypeString(int type) {
        switch (type) {
            case 101: {
                return "Variant";
            }
            case 102: {
                return "Replaced";
            }
            case 103: {
                return "Not variant";
            }
        }
        return "Type unrecognized";
    }

    @Override
    public int compareTo(WordHolder wh) {
        return this.word.compareToIgnoreCase(wh.word);
    }

    public boolean equals(WordHolder wh) {
        return this.compareTo(wh) == 0;
    }

    public VariantInstance addVariant(Position start, Position end, String actual, String display, Map<String, String> entitiesContainedWithin) {
        VariantInstance newInstance = new VariantInstance(start, end, actual, display, entitiesContainedWithin, this, this.asVariant, false);
        if (!this.asVariant.addInstance(newInstance)) {
            return this.asVariant.getInstanceAtPos(start.getOffset());
        }
        return newInstance;
    }

    public VariantInstance addVariant(Position start, Position end, String actual, String display, Map<String, String> entitiesContainedWithin, LinkedHashMap<String, String> attributes, Setup setup) {
        VariantInstance newInstance = new VariantInstance(start, end, actual, display, entitiesContainedWithin, attributes, setup, this, this.asVariant);
        if (!this.asVariant.addInstance(newInstance)) {
            return this.asVariant.getInstanceAtPos(start.getOffset());
        }
        return newInstance;
    }

    public CorrectInstance addCorrect(Position start, Position end, String actual, String display, Map<String, String> entitiesContainedWithin) {
        CorrectInstance newInstance = new CorrectInstance(start, end, actual, display, entitiesContainedWithin, this, this.asCorrect, false);
        if (!this.asCorrect.addInstance(newInstance)) {
            return this.asCorrect.getInstanceAtPos(start.getOffset());
        }
        return newInstance;
    }

    public CorrectInstance addCorrect(Position start, Position end, String actual, String display, Map<String, String> entitiesContainedWithin, LinkedHashMap<String, String> attributes, Setup setup) {
        CorrectInstance newInstance = new CorrectInstance(start, end, actual, display, entitiesContainedWithin, attributes, setup, this, this.asCorrect);
        if (!this.asCorrect.addInstance(newInstance)) {
            return this.asCorrect.getInstanceAtPos(start.getOffset());
        }
        return newInstance;
    }

    public ReplacedInstance addReplaced(Position start, Position end, String replacementTextOriginal, String replacementTextDisplay, Map<String, String> entitiesContainedWithin, String originalDisplayText, Map<String, String> originalTextEntitiesContainedWithin, LinkedHashMap<String, String> attributes, Setup setup, SuggestedReplacement replacement) {
        InstanceHolder<ReplacedInstance> ih = this.asReplaced.get(replacementTextDisplay);
        if (ih == null) {
            ih = new InstanceHolder(this.word, this, this.holderChangeListener);
        }
        this.asReplaced.put(replacementTextDisplay, ih);
        ReplacedInstance newInstance = new ReplacedInstance(start, end, replacementTextOriginal, replacementTextDisplay, entitiesContainedWithin, originalDisplayText, originalTextEntitiesContainedWithin, attributes, setup, replacement, this, ih);
        if (!ih.addInstance(newInstance)) {
            return ih.getInstanceAtPos(start.getOffset());
        }
        return newInstance;
    }

    public void addVariant(VariantInstance vi) {
        this.asVariant.addInstance(vi);
    }

    public void addCorrect(CorrectInstance ci) {
        this.asCorrect.addInstance(ci);
    }

    public void addReplaced(ReplacedInstance ri) {
        InstanceHolder<ReplacedInstance> ih = this.getAsReplaced(ri.getReplacement().getReplacementStringWithoutChangingCapitalisation());
        if (ih == null) {
            ih = new InstanceHolder(this.word, this, this.holderChangeListener);
            this.addAsReplaced(ri.getReplacement().getReplacementStringWithoutChangingCapitalisation(), ih);
        }
        ih.addInstance(ri);
    }

    public boolean removeVariant(VariantInstance vi) {
        return this.asVariant.removeInstance(vi);
    }

    public boolean removeCorrect(CorrectInstance ci) {
        return this.asCorrect.removeInstance(ci);
    }

    public boolean removeReplaced(ReplacedInstance ri) {
        InstanceHolder<ReplacedInstance> ih = this.getAsReplaced(ri.getReplacement().getReplacementStringWithoutChangingCapitalisation());
        if (ih != null) {
            boolean removed = ih.removeInstance(ri);
            if (ih.size() == 0) {
                this.removeAsReplaced(ri.getReplacement().getReplacementStringWithoutChangingCapitalisation());
            }
            return removed;
        }
        return false;
    }

    public Instance getInstanceAt(int caretPos) {
        Instance toReturn = this.asVariant.getInstanceAtPos(caretPos);
        if (toReturn != null) {
            return toReturn;
        }
        toReturn = this.asCorrect.getInstanceAtPos(caretPos);
        if (toReturn != null) {
            return toReturn;
        }
        for (InstanceHolder<ReplacedInstance> ih : this.asReplaced.values()) {
            toReturn = ih.getInstanceAtPos(caretPos);
            if (toReturn == null) continue;
            return toReturn;
        }
        return null;
    }

    public boolean isInDictionary() {
        return this.inDictionary;
    }

    public Word getDictionaryRef() {
        return this.dictionaryRef;
    }

    public boolean isLowFreq() {
        return this.isLowFreq;
    }

    public void setDictionaryRef(Word dictionaryRef) {
        this.dictionaryRef = dictionaryRef;
        this.inDictionary = dictionaryRef != null;
        this.isLowFreq = this.inDictionary ? dictionaryRef.isLowFreq() : false;
    }

    public String getWord() {
        return this.word;
    }

    public boolean areReplacementsSet() {
        return this.areReplacementsSet;
    }

    public List<SuggestedReplacement> getReplacements() {
        return this.replacements;
    }

    public void setReplacements(List<SuggestedReplacement> replacements) {
        this.replacements = replacements;
        this.areReplacementsSet = true;
    }

    public SuggestedReplacement getTopReplacement() {
        if (this.replacements.size() > 0) {
            return this.replacements.iterator().next();
        }
        return null;
    }

    public TreeSet<Instance> getInstances() {
        TreeSet<Instance> toReturn = new TreeSet<Instance>();
        toReturn.addAll(this.asVariant.getInstances());
        toReturn.addAll(this.asCorrect.getInstances());
        for (InstanceHolder<ReplacedInstance> ih : this.asReplaced.values()) {
            toReturn.addAll(ih.getInstances());
        }
        return toReturn;
    }

    public boolean isAtleastOneInstanceAVariant() {
        return !this.asVariant.isEmpty();
    }

    public boolean isAtleastOneInstanceAReplaced() {
        return !this.asReplaced.isEmpty();
    }

    public boolean isAtleastOneInstanceACorrect() {
        return !this.asCorrect.isEmpty();
    }

    public int getVariantsSize() {
        return this.asVariant.getInstancesSize();
    }

    public int getReplacedSize() {
        int toReturn = 0;
        for (InstanceHolder<ReplacedInstance> ih : this.asReplaced.values()) {
            toReturn += ih.getInstancesSize();
        }
        return toReturn;
    }

    public int getCorrectSize() {
        return this.asCorrect.getInstancesSize();
    }

    public InstanceHolder<VariantInstance> getAsVariant() {
        return this.asVariant;
    }

    public InstanceHolder<ReplacedInstance> getAsReplaced(String replacementString) {
        return this.asReplaced.get(replacementString);
    }

    public void addAsReplaced(String replacementString, InstanceHolder<ReplacedInstance> ih) {
        this.asReplaced.put(replacementString, ih);
    }

    public void removeAsReplaced(String replacementString) {
        this.asReplaced.remove(replacementString);
    }

    public InstanceHolder<CorrectInstance> getAsCorrect() {
        return this.asCorrect;
    }

    public static String getTypeName(int type) {
        switch (type) {
            case 101: {
                return "Variants";
            }
            case 102: {
                return "Normalised";
            }
            case 103: {
                return "Not variants";
            }
        }
        return "Unknown";
    }
}

