/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.HashMap;
import java.util.TreeMap;
import javax.swing.text.BadLocationException;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import model.Globals;
import model.SuggestedReplacement;
import model.doc.CannotExecuteException;
import model.doc.HolderChangeListener;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.InvalidInstanceChangeException;
import model.doc.ReplacedInstance;
import model.doc.TextReplacementHandler;
import model.doc.ThreadableEdit;
import model.doc.VariantInstance;
import model.doc.WordHolder;
import model.lookup.LookUpDictionary;
import model.lookup.ReplacementWord;
import model.lookup.VariantReplacement;

public class NormaliseAllVariantInstancesEdit
extends AbstractUndoableEdit
implements ThreadableEdit {
    private static final long serialVersionUID = 1L;
    private final TreeMap<ReplacedInstance, VariantInstance> instances;
    private final WordHolder wh;
    private final InstanceHolder<VariantInstance> from;
    private InstanceHolder<ReplacedInstance> to;
    private final Globals global = Globals.getInstance();
    private String progressMessage;
    private final SuggestedReplacement rep;
    private final LookUpDictionary lud;
    private final TextReplacementHandler textReplacementHandler;
    private boolean addToKVL;
    private boolean toIsNew = true;
    private boolean executed = false;
    private boolean undone = false;

    public NormaliseAllVariantInstancesEdit(WordHolder wh, int fromType, SuggestedReplacement rep, TextReplacementHandler textReplacementHandler, HolderChangeListener holderChangeListener, LookUpDictionary lud, boolean auto, boolean addToKVL, boolean changeCapitalisation) throws InvalidInstanceChangeException {
        this.wh = wh;
        this.textReplacementHandler = textReplacementHandler;
        this.lud = lud;
        this.addToKVL = addToKVL;
        this.rep = rep;
        this.from = wh.getAsVariant();
        this.to = wh.getAsReplaced(rep.getReplacementStringWithoutChangingCapitalisation());
        if (this.to == null) {
            this.to = new InstanceHolder(wh.getWord(), wh, holderChangeListener);
            this.toIsNew = true;
        }
        this.instances = new TreeMap();
        for (VariantInstance vi : this.from.getInstances()) {
            String replacementOriginal = changeCapitalisation ? rep.getReplacementString(vi.getCapitalisation()) : rep.getReplacementStringWithoutChangingCapitalisation();
            HashMap<String, String> entitiesContainedWithin = new HashMap<String, String>();
            String replacementDisplayString = textReplacementHandler.getTextWithReplacedEntities(replacementOriginal, entitiesContainedWithin);
            ReplacedInstance ri = null;
            Instance p = vi;
            while ((p = p.getPreviousInstance()) != null && p != vi) {
                if (p.getType() != 102 || !((ReplacedInstance)p).getReplacement().equals(rep)) continue;
                ri = (ReplacedInstance)p;
                break;
            }
            if (ri == null) {
                ri = new ReplacedInstance(vi, replacementOriginal, replacementDisplayString, entitiesContainedWithin, this.to, auto, rep);
            }
            this.instances.put(ri, vi);
        }
        this.progressMessage = "Normalise all: " + this.instances.firstKey().toString();
    }

    @Override
    public void execute() throws CannotExecuteException {
        if (!this.executed) {
            ReplacementWord newRW;
            VariantReplacement newVR;
            block13: {
                this.global.startProgress(this.instances.size());
                this.global.writeProgressMessage("Executing: " + this.progressMessage);
                int count = 0;
                this.from.emptyInstances();
                this.to.addInstances(this.instances.keySet());
                try {
                    try {
                        for (ReplacedInstance ri : this.instances.keySet()) {
                            ri.setupInText(this.textReplacementHandler);
                            this.instances.get(ri).setPreviousInstance(ri);
                            this.global.setProgressCurrent(++count);
                        }
                        break block13;
                    }
                    catch (BadLocationException e) {
                        try {
                            for (ReplacedInstance ri : this.instances.keySet()) {
                                if (!ri.isSetup()) continue;
                                ri.revertInText(this.textReplacementHandler);
                                this.global.setProgressCurrent(--count);
                            }
                        }
                        catch (BadLocationException ex) {
                            this.global.showException("Reversing " + this.progressMessage + " failed.", ex);
                        }
                    }
                    this.global.showException(String.valueOf(this.progressMessage) + " failed.", e);
                    throw new CannotExecuteException(String.valueOf(this.progressMessage) + " failed.");
                }
                finally {
                    this.global.finishProgress();
                }
            }
            this.global.startIndeterminateProgress();
            this.global.writeProgressMessage("Executing: " + this.progressMessage);
            if (this.toIsNew) {
                this.wh.addAsReplaced(this.rep.getReplacementStringWithoutChangingCapitalisation(), this.to);
            }
            if (this.addToKVL && (newVR = this.lud.addUserVariant(this.rep.getOriginal(), this.rep.getReplacementStringWithoutChangingCapitalisation())) != null && (newRW = newVR.getReplacement()) != null) {
                this.rep.setReplacementWord("KV", newVR.getReplacement());
            }
        } else {
            throw new CannotExecuteException("Cannot execute twice.");
        }
        this.executed = true;
        this.global.finishProgress();
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.executed) {
            block12: {
                this.global.startProgress(this.instances.size());
                this.global.writeProgressMessage("Undoing: " + this.progressMessage);
                int count = 0;
                try {
                    try {
                        for (ReplacedInstance ri : this.instances.keySet()) {
                            ri.revertInText(this.textReplacementHandler);
                            this.global.setProgressCurrent(++count);
                        }
                        break block12;
                    }
                    catch (BadLocationException e) {
                        try {
                            for (ReplacedInstance ri : this.instances.keySet()) {
                                if (!ri.isReverted()) continue;
                                ri.setupInText(this.textReplacementHandler);
                                this.global.setProgressCurrent(--count);
                            }
                        }
                        catch (BadLocationException ex) {
                            this.global.showException("Reversing undo " + this.progressMessage + " failed.", ex);
                        }
                    }
                    this.global.showException("Undoing " + this.progressMessage + " failed.", e);
                    throw new CannotUndoException();
                }
                finally {
                    this.global.finishProgress();
                }
            }
            this.global.startIndeterminateProgress();
            this.global.writeProgressMessage("Undoing: " + this.progressMessage);
            this.to.removeInstances(this.instances.keySet());
            this.from.addInstances(this.instances.values());
            if (this.toIsNew) {
                this.wh.removeAsReplaced(this.rep.getReplacementStringWithoutChangingCapitalisation());
            }
        } else {
            throw new CannotUndoException();
        }
        this.undone = true;
        this.global.finishProgress();
    }

    @Override
    public void redo() throws CannotRedoException {
        if (this.undone) {
            ReplacementWord newRW;
            VariantReplacement newVR;
            block13: {
                this.global.startProgress(this.instances.size());
                this.global.writeProgressMessage("Redoing: " + this.progressMessage);
                int count = 0;
                this.from.emptyInstances();
                this.to.addInstances(this.instances.keySet());
                try {
                    try {
                        for (ReplacedInstance ri : this.instances.keySet()) {
                            ri.setupInText(this.textReplacementHandler);
                            this.global.setProgressCurrent(++count);
                        }
                        break block13;
                    }
                    catch (BadLocationException e) {
                        try {
                            for (ReplacedInstance ri : this.instances.keySet()) {
                                if (!ri.isSetup()) continue;
                                ri.revertInText(this.textReplacementHandler);
                                this.global.setProgressCurrent(--count);
                            }
                        }
                        catch (BadLocationException ex) {
                            this.global.showException("Reversing redo " + this.progressMessage + " failed.", ex);
                        }
                    }
                    this.global.showException("Redoing " + this.progressMessage + " failed.", e);
                    throw new CannotRedoException();
                }
                finally {
                    this.global.finishProgress();
                }
            }
            this.global.startIndeterminateProgress();
            this.global.writeProgressMessage("Redoing: " + this.progressMessage);
            if (this.toIsNew) {
                this.wh.addAsReplaced(this.rep.getReplacementStringWithoutChangingCapitalisation(), this.to);
            }
            if (this.addToKVL && (newVR = this.lud.addUserVariant(this.rep.getOriginal(), this.rep.getReplacementStringWithoutChangingCapitalisation())) != null && (newRW = newVR.getReplacement()) != null) {
                this.rep.setReplacementWord("KV", newVR.getReplacement());
            }
        } else {
            throw new CannotRedoException();
        }
        this.undone = false;
        this.global.finishProgress();
    }

    @Override
    public boolean canUndo() {
        return this.executed;
    }

    @Override
    public boolean canRedo() {
        return this.undone;
    }

    @Override
    public String getPresentationName() {
        return this.progressMessage;
    }

    public String getActionName() {
        return "Normalise all";
    }
}

