/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.Collection;
import java.util.LinkedHashMap;
import javax.swing.text.Position;
import model.Setup;
import model.doc.DocumentXMLElement;
import model.doc.Instance;
import model.doc.JoinInstance;

public class ForeignText
extends DocumentXMLElement {
    private String language;
    private Collection<Instance> instancesHidden;
    private Collection<JoinInstance> joinInstancesHidden;

    public ForeignText(Position start, Position end, String language) {
        super(start, end, "[text not included]", true);
        this.language = language;
        this.instancesHidden = null;
        this.joinInstancesHidden = null;
    }

    public ForeignText(Position start, Position end, LinkedHashMap<String, String> attributes, Setup setup) {
        super(start, end, "[text not included]", attributes, setup);
        this.language = this.getAttributeValue(setup.getForeignLanguageAttribute());
        this.instancesHidden = null;
        this.joinInstancesHidden = null;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public String toString() {
        return "Foreign text: " + this.language + " - " + super.toString();
    }

    @Override
    public boolean areRequiredAttributesPresent(Setup setup) {
        return this.isAttributePresent(setup.getForeignLanguageAttribute());
    }

    public void setHiddenInstances(Collection<Instance> instances, Collection<JoinInstance> joinInstances) {
        this.instancesHidden = instances;
        this.joinInstancesHidden = joinInstances;
    }

    public Collection<Instance> getInstancesHidden() {
        return this.instancesHidden;
    }

    public Collection<JoinInstance> getJoinInstancesHidden() {
        return this.joinInstancesHidden;
    }

    @Override
    protected void updateAttributes(Setup setup) {
        super.updateAttributes(setup);
        this.setAttribute(setup.getForeignLanguageAttribute(), this.language);
    }

    @Override
    protected String getTag(Setup setup) {
        return setup.getForeignTag();
    }
}

