/*
 * Decompiled with CFR 0.152.
 */
package clui;

import clui.CommandLineProgressAndErrorHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import model.Globals;
import vardwrapper.NormalisationStats;
import vardwrapper.VARD;
import vardwrapper.VARDException;

public class StartAndWaitForStdIn {
    private static int threshold = 0;
    private static boolean useCache = false;
    private static boolean writeStats = false;
    private static PrintWriter statsWriter;

    public static void main(String[] args) {
        boolean xml;
        if (args.length != 6) {
            System.out.println("ERROR: There should be FIVE arguments: the setup folder, the threshold (a whole number between 0 and 100), the f-score weight(a fraction or whole number), whether or not to use the normalisation cache (true or false), and the file to print normalisation stats to (can be \"null\" if you don't want stats), the string \"XML\" or \"Plain\" to indicate the output type");
            System.exit(1);
            return;
        }
        String setupFolderString = StartAndWaitForStdIn.fixTildeInPath(args[0]);
        File setupFolder = new File(setupFolderString);
        setupFolder.mkdirs();
        if (!setupFolder.isDirectory()) {
            System.out.println("ERROR: First argument, the setup folder, must be a path to a folder.");
            System.exit(1);
            return;
        }
        try {
            threshold = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            System.out.println("ERROR: Second argument, the threshold, should be an integer value");
            System.exit(1);
            return;
        }
        if (threshold < 0 || threshold > 100) {
            System.out.println("ERROR: Second argument, the threshold, should be between 0 and 100");
            System.exit(1);
            return;
        }
        String fweight = args[2];
        Pattern fwPattern = Pattern.compile("([1-9]{1})[/]?([1-9]?)");
        Matcher fwMatcher = fwPattern.matcher(fweight);
        double fWeight = 1.0;
        if (fwMatcher.find()) {
            int top = Integer.parseInt(fwMatcher.group(1));
            fWeight = top;
            String denString = fwMatcher.group(2);
            if (denString != null && !denString.isEmpty()) {
                fWeight /= (double)Integer.parseInt(denString);
            }
        } else {
            System.out.println();
            System.out.println("Third argument, the f-score weight, should either be a fraction with a numerator and denominator between 1 and 9 (inclusive) or a whole number between 1 and 9 (inclusive). 1 represents equal weighting between precision and recall, 1/2 represents precision weighted twice as much as recall, 2 represents recall weighted twice as much as precision.");
            System.exit(1);
            return;
        }
        useCache = Boolean.parseBoolean(args[3]);
        if (args[4].equals("null")) {
            writeStats = false;
        } else {
            writeStats = true;
            File statsFile = new File(StartAndWaitForStdIn.fixTildeInPath(args[4]));
            try {
                if (statsFile.isDirectory()) {
                    System.out.println("ERROR: Fourth argument, the stats file, must not be a directory");
                    System.exit(1);
                }
                statsFile.getParentFile().mkdirs();
                statsFile.createNewFile();
                statsWriter = new PrintWriter(new FileWriter(statsFile));
                statsWriter.println("Threshold: " + threshold + "%");
                statsWriter.println(NormalisationStats.headerString());
            }
            catch (IOException ex) {
                System.out.println("ERROR: Error occurred creating stats file");
                System.exit(1);
                return;
            }
        }
        if (args[5].equalsIgnoreCase("xml")) {
            xml = true;
        } else if (args[5].equalsIgnoreCase("plain")) {
            xml = false;
        } else {
            System.err.println();
            System.err.println("Sixth argument, the output type, must be XML or Plain.");
            System.exit(1);
            return;
        }
        try {
            VARD vard = new VARD(setupFolder, (double)threshold, fWeight, useCache);
            CommandLineProgressAndErrorHandler handler = new CommandLineProgressAndErrorHandler();
            Globals global = Globals.getInstance();
            global.setErrorHandler(handler);
            BufferedReader inReader = new BufferedReader(new InputStreamReader(System.in));
            boolean keepWaiting = true;
            System.out.println("READY");
            while (keepWaiting) {
                String line = inReader.readLine();
                if (line == null) continue;
                if (line.equalsIgnoreCase("EXIT")) {
                    keepWaiting = false;
                    continue;
                }
                String[] files = line.split(" > ");
                if (files.length != 2) {
                    System.out.println("ERROR: should be [infile] > [outfile]");
                    continue;
                }
                File inFile = new File(StartAndWaitForStdIn.fixTildeInPath(files[0]));
                if (inFile.exists() && inFile.isFile()) {
                    File outFile = new File(StartAndWaitForStdIn.fixTildeInPath(files[1]));
                    outFile.createNewFile();
                    NormalisationStats stats = xml ? vard.normaliseFile(inFile, outFile, null) : vard.normaliseFile(inFile, null, outFile);
                    if (writeStats) {
                        statsWriter.println(stats.toString());
                    }
                    System.out.println("FILECOMPLETE");
                    continue;
                }
                System.out.println("ERROR: In file not a file / doesn't exist.");
            }
        }
        catch (VARDException e) {
            System.out.println("ERROR: VARDException");
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("ERROR: IOException");
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static String fixTildeInPath(String path) {
        if (path.startsWith("~" + File.separator)) {
            return String.valueOf(System.getProperty("user.home")) + path.substring(1);
        }
        return path;
    }
}

