/*
 * Decompiled with CFR 0.152.
 */
package model.lookup;

import model.Globals;
import model.lookup.LookUpDictionary;
import model.lookup.ReplacementWord;
import model.lookup.VariantHolder;
import model.lookup.Word;

public class VariantReplacement
implements ReplacementWord.PickListener,
Comparable<VariantReplacement> {
    private boolean userAdded;
    private VariantHolder vh;
    private Word replacementWord;
    private int picked;
    private LookUpDictionary lud;

    public VariantReplacement(VariantHolder vh, Word a, int picked, boolean userAdded, LookUpDictionary lud) {
        this.userAdded = userAdded;
        this.picked = picked;
        this.replacementWord = a;
        this.vh = vh;
        this.lud = lud;
    }

    public String toString() {
        return String.valueOf(this.vh.getVariantString()) + " -> " + this.replacementWord;
    }

    public boolean equals(VariantReplacement v) {
        if (this.vh.equals(v.vh)) {
            return this.replacementWord.equals(v.replacementWord);
        }
        return false;
    }

    public boolean isUserAdded() {
        return this.userAdded;
    }

    public void setUserAdded(boolean userAdded) {
        this.userAdded = userAdded;
    }

    public ReplacementWord getReplacement() {
        if (this.vh.getSeen() < 1 || this.picked < 1) {
            return null;
        }
        return new ReplacementWord(this.replacementWord, (double)this.picked / (double)this.vh.getSeen(), this);
    }

    public String getVariantString() {
        return this.vh.getVariantString();
    }

    public String getWordString() {
        return this.replacementWord.toString();
    }

    @Override
    public void picked() {
        this.vh.incrementSeen();
        ++this.picked;
        if (this.picked == 1) {
            this.lud.setVariantsChanged(true, String.valueOf(Globals.NEW_LINE) + "added: " + this.getVariantString() + " -> " + this.getWordString());
        } else {
            this.lud.setVariantsChanged(true);
        }
    }

    @Override
    public void unpicked() {
        --this.picked;
        if (this.picked == 0) {
            this.lud.setVariantsChanged(true, String.valueOf(Globals.NEW_LINE) + "removed: " + this.getVariantString() + " -> " + this.getWordString());
        } else {
            this.lud.setVariantsChanged(true);
        }
        if (this.picked < 0) {
            this.picked = 0;
        } else {
            this.vh.decrementSeen();
        }
    }

    public int getPicked() {
        return this.picked;
    }

    @Override
    public int compareTo(VariantReplacement vr) {
        return this.replacementWord.compareTo(vr.replacementWord);
    }
}

