/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.text.Position;
import model.doc.DocumentElementList;
import model.doc.Instance;

public class InstanceList
extends DocumentElementList<Instance> {
    private final TreeMap<Integer, TreeSet<Instance>> typeInstances = new TreeMap();

    public InstanceList() {
        this.typeInstances.put(101, new TreeSet());
        this.typeInstances.put(102, new TreeSet());
        this.typeInstances.put(103, new TreeSet());
    }

    @Override
    public void clear() {
        super.clear();
        for (TreeSet<Instance> is : this.typeInstances.values()) {
            is.clear();
        }
    }

    @Override
    public Instance put(Position pos, Instance instance) {
        Instance removed = super.put(pos, instance);
        if (removed != null) {
            this.typeInstances.get(removed.getType()).remove(removed);
        }
        this.typeInstances.get(instance.getType()).add(instance);
        return removed;
    }

    @Override
    public Instance remove(Position pos) {
        Instance removed = (Instance)super.remove(pos);
        if (removed != null) {
            this.typeInstances.get(removed.getType()).remove(removed);
        }
        return removed;
    }

    public TreeSet<Instance> getInstances(int type) {
        return this.typeInstances.get(type);
    }

    public Instance getFirstInstance(int type) {
        TreeSet<Instance> ti = this.typeInstances.get(type);
        if (ti.isEmpty()) {
            return null;
        }
        return ti.first();
    }

    public Instance getLastInstance(int type) {
        TreeSet<Instance> ti = this.typeInstances.get(type);
        if (ti.isEmpty()) {
            return null;
        }
        return ti.last();
    }

    public Instance getNextInstance(int type, Instance current) {
        TreeSet<Instance> ti = this.typeInstances.get(type);
        if (ti.isEmpty()) {
            return null;
        }
        if (current == null) {
            return ti.first();
        }
        Instance nextInstance = ti.higher(current);
        if (nextInstance == null) {
            nextInstance = ti.first();
        }
        return nextInstance;
    }

    public Instance getPreviousInstance(int type, Instance current) {
        TreeSet<Instance> ti = this.typeInstances.get(type);
        if (ti.isEmpty()) {
            return null;
        }
        if (current == null) {
            return ti.last();
        }
        Instance prevInstance = ti.lower(current);
        if (prevInstance == null) {
            prevInstance = ti.last();
        }
        return prevInstance;
    }

    public int getPosition(Instance instance) {
        if (instance == null) {
            return 0;
        }
        return this.typeInstances.get(instance.getType()).headSet(instance).size() + 1;
    }

    public int getTokenCount(int type) {
        return this.typeInstances.get(type).size();
    }
}

