/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.TreeMap;
import model.Capitalisation;
import model.ConfidenceWeights;
import model.MethodScoresUpdate;
import model.lookup.ReplacementWord;

public class SuggestedReplacement
implements Comparable<SuggestedReplacement> {
    private String original;
    private String replacement;
    private int freq;
    private boolean isUserAdded;
    private Capitalisation.CapType defaultCapitalisation;
    private TreeMap<String, MethodScoresUpdate> msus;
    private TreeMap<String, ReplacementWord> rws;
    private double score;
    private boolean customScore = false;

    public SuggestedReplacement() {
    }

    public SuggestedReplacement(String original, String replacement, int freq, boolean isUserAdded) {
        this.original = original;
        this.replacement = replacement;
        this.freq = freq;
        this.isUserAdded = isUserAdded;
        this.msus = new TreeMap();
        this.rws = new TreeMap();
        this.defaultCapitalisation = Capitalisation.getCapitalisation(original);
    }

    public SuggestedReplacement(String original, String replacement, int freq, boolean isUserAdded, double score) {
        this(original, replacement, freq, isUserAdded);
        this.customScore = true;
        this.score = score;
    }

    @Override
    public int compareTo(SuggestedReplacement sr) {
        int r = Double.valueOf(sr.getScore()).compareTo(this.getScore());
        if (r == 0) {
            return new Integer(sr.freq).compareTo(this.freq);
        }
        return r;
    }

    public boolean equals(SuggestedReplacement sr) {
        if (this.replacement.equalsIgnoreCase(sr.replacement)) {
            return this.original.equalsIgnoreCase(sr.original);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof SuggestedReplacement) {
            return this.equals((SuggestedReplacement)object);
        }
        return false;
    }

    public String getOriginal() {
        return this.original;
    }

    public boolean isReplacementUserAdded() {
        return this.isUserAdded;
    }

    public double getScoreWithoutUpdating() {
        return this.score;
    }

    public double getScore() {
        return this.score;
    }

    public void reCalculateScore(ConfidenceWeights confidenceWeights) {
        if (!this.customScore) {
            this.score = confidenceWeights.calculateScoreOfReplacement(this);
        }
    }

    public String toString() {
        return this.toMenuString(this.defaultCapitalisation);
    }

    public String toMenuString(Capitalisation.CapType capitalisation) {
        String scoreString = Double.toString(this.getScore());
        if (scoreString.endsWith(".0")) {
            scoreString = scoreString.substring(0, scoreString.length() - 2);
        }
        return String.valueOf(this.getReplacementString(capitalisation)) + " (" + scoreString + "%)";
    }

    public String getReplacementString(Capitalisation.CapType capitalisation) {
        return Capitalisation.changeWordToMatch(this.replacement, capitalisation);
    }

    public String getReplacementStringWithoutChangingCapitalisation() {
        return this.replacement;
    }

    public void picked() {
        for (MethodScoresUpdate msu : this.msus.values()) {
            msu.update();
        }
        for (ReplacementWord rw : this.rws.values()) {
            rw.picked();
        }
    }

    public void unpicked() {
        for (MethodScoresUpdate msu : this.msus.values()) {
            msu.reverse();
        }
        for (ReplacementWord rw : this.rws.values()) {
            rw.unpicked();
        }
    }

    public MethodScoresUpdate getMethodScoresUpdate(String key) {
        return this.msus.get(key);
    }

    public TreeMap<String, MethodScoresUpdate> getMethodScoresUpdates() {
        return this.msus;
    }

    public MethodScoresUpdate getScoreUpdate(String method) {
        return this.msus.get(method);
    }

    public void setScoreUpdate(String method, MethodScoresUpdate msu) {
        this.msus.put(method, msu);
    }

    public void setReplacementWord(String method, ReplacementWord rw) {
        this.rws.put(method, rw);
    }

    public TreeMap<String, MethodScoresUpdate> getScoreUpdates() {
        return this.msus;
    }

    public int getFreq() {
        return this.freq;
    }

    public void setReplacementString(String replacementString) {
        this.replacement = replacementString;
    }
}

