/*
 * Decompiled with CFR 0.152.
 */
package gui.sidebar;

import gui.MainScreen;
import gui.TBJButton;
import gui.sidebar.SideBarPanel;
import gui.sidebar.TextPrompt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import model.Globals;
import model.Setup;
import model.lookup.LookUpDictionary;
import model.lookup.Rule;

public class RulesSideBar
extends SideBarPanel
implements LookUpDictionary.DataChangeListener {
    private static final long serialVersionUID = -453439287906782849L;
    private final HashMap<String, Action> actions;
    private LookUpDictionary lud;
    private final JTextField origTF;
    private final JTextField repTF;
    private final JComboBox posCB;
    private final JList rulesList;

    public RulesSideBar(LookUpDictionary lud) {
        this.lud = lud;
        this.lud.addDataChangeListener(this);
        this.actions = new HashMap();
        this.rulesList = new JList();
        this.rulesList.setListData(lud.getRules().toArray());
        this.rulesList.setVisibleRowCount(10);
        JScrollPane rulesListSP = new JScrollPane(this.rulesList, 20, 30);
        this.origTF = new JTextField(7);
        TextPrompt oTP = new TextPrompt("Original", this.origTF);
        oTP.setShow(TextPrompt.Show.FOCUS_LOST);
        oTP.changeAlpha(0.5f);
        this.origTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RulesSideBar.this.repTF.requestFocus();
            }
        });
        this.repTF = new JTextField(7);
        TextPrompt rTP = new TextPrompt("Replacment", this.repTF);
        rTP.setShow(TextPrompt.Show.FOCUS_LOST);
        rTP.changeAlpha(0.5f);
        this.repTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RulesSideBar.this.posCB.requestFocus();
            }
        });
        this.posCB = new JComboBox<Rule.Position>(Rule.Position.values());
        this.posCB.setSelectedItem((Object)Rule.Position.Anywhere);
        this.actions.put("add", MainScreen.fixAction(new AddRuleAction(), "Add new rule", "brick_add", "Add new rule", -1, null));
        this.actions.put("edit", MainScreen.fixAction(new EditRuleAction(), "Edit selected rule", "brick_edit", "Edit selected rule", -1, null));
        this.actions.put("remove", MainScreen.fixAction(new RemoveRulesAction(), "Remove selected rule(s)", "brick_delete", "Remove selected rule(s)", -1, null));
        this.actions.put("revert", MainScreen.fixAction(new RevertRulesListAction(), "Revert rules", "table_refresh", "Revert to saved rules list", -1, null));
        this.actions.put("save", MainScreen.fixAction(new SaveRulesAction(), "Save rules list", null, "Save rules list to file.", -1, null));
        JToolBar rulesTB = new JToolBar(1);
        rulesTB.setFloatable(false);
        rulesTB.add(new TBJButton(this.actions.get("edit")));
        rulesTB.add(new TBJButton(this.actions.get("remove")));
        rulesTB.add(new TBJButton(this.actions.get("revert")));
        JPanel ruleListPanel = new JPanel(new BorderLayout());
        ruleListPanel.setBorder(BorderFactory.createTitledBorder("Rule list"));
        ruleListPanel.add((Component)rulesListSP, "Center");
        ruleListPanel.add((Component)rulesTB, "East");
        JPanel newRulePanel = new JPanel(new GridBagLayout());
        GridBagConstraints f = new GridBagConstraints();
        f.gridy = 0;
        f.weightx = 1.0;
        f.fill = 2;
        GridBagConstraints nf = new GridBagConstraints();
        nf.gridy = 0;
        nf.weightx = 0.0;
        nf.fill = 0;
        GridBagConstraints p = new GridBagConstraints();
        p.gridy = 1;
        p.gridx = 0;
        p.gridwidth = 3;
        p.fill = 2;
        newRulePanel.add((Component)this.origTF, f);
        newRulePanel.add((Component)new JLabel(" \u2192 "), nf);
        newRulePanel.add((Component)this.repTF, f);
        newRulePanel.add((Component)this.posCB, p);
        JPanel addRulePanel = new JPanel(new BorderLayout());
        addRulePanel.setBorder(BorderFactory.createTitledBorder("Add rule"));
        addRulePanel.add((Component)newRulePanel, "Center");
        addRulePanel.add((Component)new TBJButton(this.actions.get("add")), "East");
        GridBagConstraints fv = new GridBagConstraints();
        fv.gridx = 0;
        fv.weighty = 1.0;
        fv.weightx = 1.0;
        fv.fill = 1;
        GridBagConstraints nfv = new GridBagConstraints();
        nfv.gridx = 0;
        nfv.weighty = 0.0;
        nfv.weightx = 1.0;
        nfv.fill = 2;
        this.setLayout(new GridBagLayout());
        this.add((Component)ruleListPanel, fv);
        this.add((Component)addRulePanel, nfv);
        this.add((Component)new JButton(this.actions.get("save")), nfv);
    }

    @Override
    public void changeSetup(Setup setup) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (Action action : this.actions.values()) {
            action.setEnabled(enabled);
        }
        this.actions.get("save").setEnabled(this.lud.isRulesChanged());
        this.actions.get("revert").setEnabled(this.lud.isRulesChanged());
        this.rulesList.setEnabled(enabled);
        this.origTF.setEnabled(enabled);
        this.repTF.setEnabled(enabled);
        this.posCB.setEnabled(enabled);
    }

    @Override
    public void wordsChanged(boolean changed) {
    }

    @Override
    public void variantsChanged(boolean changed) {
    }

    @Override
    public void rulesChanged(boolean changed) {
        this.rulesList.setListData(this.lud.getRules().toArray());
        this.actions.get("save").setEnabled(changed);
        this.actions.get("revert").setEnabled(changed);
    }

    private class AddRuleAction
    extends AbstractAction {
        private static final long serialVersionUID = -939227709148242161L;

        private AddRuleAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (RulesSideBar.this.origTF.getText().equals("") && RulesSideBar.this.repTF.getText().equals("")) {
                Globals.getInstance().showError("Original and Replacement fields can't both be empty.");
            } else {
                Rule.Position pos = (Rule.Position)((Object)RulesSideBar.this.posCB.getSelectedItem());
                RulesSideBar.this.lud.addRule(new Rule(RulesSideBar.this.origTF.getText(), RulesSideBar.this.repTF.getText(), pos, true));
                RulesSideBar.this.origTF.setText("");
                RulesSideBar.this.repTF.setText("");
                RulesSideBar.this.posCB.setSelectedItem((Object)Rule.Position.Anywhere);
            }
        }
    }

    private class EditRuleAction
    extends AbstractAction {
        private static final long serialVersionUID = -7612649002413787897L;

        private EditRuleAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Rule rule = (Rule)RulesSideBar.this.rulesList.getSelectedValue();
            if (rule != null) {
                RulesSideBar.this.origTF.setText(rule.getOriginal());
                RulesSideBar.this.repTF.setText(rule.getReplacement());
                RulesSideBar.this.posCB.setSelectedItem((Object)rule.getWhereToApply());
                RulesSideBar.this.lud.removeRule(rule);
            }
        }
    }

    private class RemoveRulesAction
    extends AbstractAction {
        private static final long serialVersionUID = -7547022017056022428L;

        private RemoveRulesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object[] selectedRules;
            Object[] objectArray = selectedRules = RulesSideBar.this.rulesList.getSelectedValues();
            int n = selectedRules.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                RulesSideBar.this.lud.removeRule((Rule)item);
                ++n2;
            }
        }
    }

    private class RevertRulesListAction
    extends AbstractAction {
        private static final long serialVersionUID = 3451099013918928810L;

        private RevertRulesListAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        RulesSideBar.this.lud.readInRules();
                    }
                    catch (IOException ex) {
                        Globals.getInstance().showException("An error occurred re-reading the rules list, please report.", ex);
                    }
                }
            });
        }
    }

    private class SaveRulesAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 7397383512576562239L;

        private SaveRulesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        RulesSideBar.this.lud.writeRulesToFile();
                    }
                    catch (IOException ex) {
                        Globals.getInstance().showException("Error writing rules.txt.", ex);
                    }
                }
            });
        }
    }
}

