/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MainScreen;
import gui.MarkAllFInstancesAsTAction;
import gui.MarkFInstanceAsTAction;
import gui.NormaliseAllInstancesOfVariantAction;
import gui.NormaliseToAction;
import gui.NormaliseVariantInstanceAction;
import gui.QuestionAsker;
import gui.RevertAllAction;
import gui.RevertInstanceAction;
import gui.SwingWorkerAction;
import gui.TBJButton;
import gui.TBJToggleButton;
import gui.ThreadedProcessEditHolder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Highlighter;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.UndoableEditSupport;
import model.Capitalisation;
import model.ConfidenceWeights;
import model.Globals;
import model.SuggestedReplacement;
import model.doc.CorrectInstance;
import model.doc.DocumentModel;
import model.doc.ForeignText;
import model.doc.ForeignTextListener;
import model.doc.HolderChangeListener;
import model.doc.IgnorableText;
import model.doc.IgnorableTextListener;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.InvalidInstanceChangeException;
import model.doc.ReplacedInstance;
import model.doc.VariantInstance;
import model.doc.WordHolder;
import model.lookup.LookUpDictionary;

public class DocumentView
extends JPanel
implements HolderChangeListener,
IgnorableTextListener,
ForeignTextListener,
CaretListener,
MouseListener,
DocumentModel.DocumentChangeListener {
    private static final long serialVersionUID = 6486898205332289840L;
    public static final Color SELECTION_COLOUR = new Color(120, 220, 120);
    private boolean isEnabled = false;
    private boolean ignoreUpdates = false;
    private boolean textSelection = false;
    private final JTextPane textPane;
    private final JScrollPane textPaneSP;
    private final JLabel currentFileLabel;
    private Style currentViewAttributes;
    private Style ignored;
    private Style foreign;
    private Style blank;
    private Highlighter.HighlightPainter mainHighlighter;
    private Highlighter.HighlightPainter selectedHighlighter;
    private Highlighter.HighlightPainter instanceHighlighter;
    private Highlighter highlighter;
    private final JToggleButton boldToggle;
    private final JToggleButton italicToggle;
    private final JToggleButton underlineToggle;
    private final JComboBox fontComboBox;
    private final JComboBox sizeComboBox;
    private final String[] systemFonts;
    private static final Integer[] fontSizes = new Integer[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48};
    private HashMap<String, Action> actions;
    private final DocumentModel docModel;
    private final ConfidenceWeights confidenceWeights;
    private final LookUpDictionary lud;
    private final HolderChangeListener holderChangeListener;
    private Globals global;
    private InstanceHolder<? extends Instance> selectedHolder;
    private Instance selectedInstance;
    private int listSelected = WordHolder.types[0];
    private final UndoableEditSupport undoSupport;
    private final QuestionAsker questionAsker;
    private List<DocumentViewChangeListener> changeListeners;

    public DocumentView(DocumentModel docModel, ConfidenceWeights confidenceWeights, LookUpDictionary lud, UndoableEditSupport undoSupport, QuestionAsker questionAsker) {
        super(new BorderLayout());
        this.docModel = docModel;
        docModel.addDocumentChangeListener(this);
        this.holderChangeListener = docModel;
        this.confidenceWeights = confidenceWeights;
        this.lud = lud;
        this.undoSupport = undoSupport;
        this.questionAsker = questionAsker;
        this.changeListeners = new ArrayList<DocumentViewChangeListener>();
        this.global = Globals.getInstance();
        this.textPane = new JTextPane();
        this.textPane.setSelectedTextColor(Color.RED);
        this.currentViewAttributes = this.textPane.addStyle("Current View", null);
        this.mainHighlighter = new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW);
        this.selectedHighlighter = new DefaultHighlighter.DefaultHighlightPainter(SELECTION_COLOUR);
        this.instanceHighlighter = new DefaultHighlighter.DefaultHighlightPainter(new Color(240, 160, 160));
        this.highlighter = this.textPane.getHighlighter();
        this.ignored = this.textPane.addStyle("Ignored", null);
        StyleConstants.setForeground(this.ignored, Color.LIGHT_GRAY);
        this.foreign = this.textPane.addStyle("Foreign Text", null);
        StyleConstants.setForeground(this.foreign, new Color(140, 180, 220));
        this.blank = this.textPane.addStyle("Blank", null);
        StyleConstants.setForeground(this.blank, Color.BLACK);
        this.actions = new HashMap();
        this.actions.put("Copy", MainScreen.fixAction(new CopyAction(), "Copy", "page_copy", "Copy selected text to clipboard", 67, KeyStroke.getKeyStroke(67, 2)));
        this.actions.put("Paste", MainScreen.fixAction(new PasteAction(), "Paste", "paste_plain", "Paste text from clipboard into document", 80, KeyStroke.getKeyStroke(86, 2)));
        this.actions.put("Bold", MainScreen.fixAction(new StyledEditorKit.BoldAction(), "Bold", "text_bold", "Toggle Bold on selected text", 66, KeyStroke.getKeyStroke(66, 2)));
        this.actions.put("Italic", MainScreen.fixAction(new StyledEditorKit.ItalicAction(), "Italic", "text_italic", "Toggle Italic on selected text", 73, KeyStroke.getKeyStroke(73, 2)));
        this.actions.put("Underline", MainScreen.fixAction(new StyledEditorKit.UnderlineAction(), "Underline", "text_underline", "Toggle Underline on selected text", 85, KeyStroke.getKeyStroke(85, 2)));
        this.actions.put("Select All", MainScreen.fixAction(new SelectAllAction(), "Select All", "arrow_out", "Select All Text In Document", 65, KeyStroke.getKeyStroke(65, 2)));
        this.actions.put("Join", MainScreen.fixAction(new JoinAction(), "Join", "arrow_join", "Join two or more words.", -1, null));
        this.actions.put("Foreign", MainScreen.fixAction(new ForeignAction(), "Mark as language", "page_world", "Mark selected span as a language.", -1, null));
        this.actions.put("FontComboBox", new FontComboBoxAction());
        this.actions.put("SizeComboBox", new SizeComboBoxAction());
        this.systemFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.fontComboBox = this.createCombo(this.systemFonts);
        this.fontComboBox.setEditable(false);
        this.fontComboBox.setPrototypeDisplayValue("Lucida Grande ");
        this.fontComboBox.setAction(this.actions.get("FontComboBox"));
        this.sizeComboBox = this.createCombo(fontSizes);
        this.sizeComboBox.setEditable(false);
        this.sizeComboBox.setAction(this.actions.get("SizeComboBox"));
        JToolBar textToolBar = new JToolBar("Text");
        textToolBar.setFloatable(false);
        TBJButton foreignButton = new TBJButton(this.getActionByName("Foreign"));
        textToolBar.add(new TBJButton(this.getActionByName("Join")));
        textToolBar.add(foreignButton);
        textToolBar.addSeparator();
        textToolBar.add(new TBJButton(this.getActionByName("Copy")));
        textToolBar.add(new TBJButton(this.getActionByName("Paste")));
        textToolBar.add(new TBJButton(this.getActionByName("Select All")));
        textToolBar.addSeparator();
        textToolBar.add(this.fontComboBox);
        textToolBar.add(this.sizeComboBox);
        this.boldToggle = new TBJToggleButton(this.getActionByName("Bold"));
        textToolBar.add(this.boldToggle);
        this.italicToggle = new TBJToggleButton(this.getActionByName("Italic"));
        textToolBar.add(this.italicToggle);
        this.underlineToggle = new TBJToggleButton(this.getActionByName("Underline"));
        textToolBar.add(this.underlineToggle);
        this.textPane.setEditable(false);
        this.textPaneSP = new JScrollPane(this.textPane, 22, 31);
        this.textPane.addCaretListener(this);
        this.textPane.addMouseListener(this);
        this.currentFileLabel = new JLabel("  > " + docModel.toString());
        this.add((Component)textToolBar, "North");
        this.add((Component)this.textPaneSP, "Center");
        this.add((Component)this.currentFileLabel, "South");
        docModel.addChangeListener(this);
        docModel.addForeignTextListener(this);
        docModel.addIgnorableTextListener(this);
        this.reset();
        this.clearText();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        this.textPane.setEnabled(enabled);
        if (enabled) {
            this.getActionByName("Copy").setEnabled(this.textSelection);
            this.getActionByName("Join").setEnabled(this.textSelection);
            this.getActionByName("Foreign").setEnabled(this.textSelection);
        }
    }

    private Action getActionByName(String name) {
        return this.actions.get(name);
    }

    public Map<String, Action> getActions() {
        return this.actions;
    }

    private void reset() {
        this.getActionByName("Copy").setEnabled(false);
        this.getActionByName("Join").setEnabled(false);
        this.getActionByName("Foreign").setEnabled(false);
        this.selectedHolder = null;
        this.changeSelectedInstance(null);
        for (DocumentViewChangeListener l : this.changeListeners) {
            l.textCleared();
        }
        this.textSelectionChanged(this.docModel.getStartOfDoc(), this.docModel.getEndOfDoc());
        this.showText();
    }

    @Override
    public void setTransferHandler(TransferHandler handler) {
        this.textPane.setTransferHandler(handler);
    }

    private void clearText() {
        this.textPane.setDocument(new DefaultStyledDocument());
    }

    public void showText() {
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Displaying Text");
        this.textPane.setDocument(this.docModel.getDoc());
        if (this.docModel.isSamplePartition()) {
            this.scrollToCaretRange(this.docModel.getCurrentPartition().getStartOffset(), this.docModel.getCurrentPartition().getEndOffset());
        }
        this.global.finishProgress();
    }

    void removeAllHighlights() {
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Removing highlights...");
        this.highlighter.removeAllHighlights();
        this.global.finishProgress();
    }

    void giveAllHighlightsOfType(int type) {
        TreeSet<InstanceHolder<? extends Instance>> hl = this.docModel.getHolderList(type);
        this.global.startProgress(hl.size());
        this.global.writeProgressMessage("Renewing highlights...");
        int count = 0;
        for (InstanceHolder instanceHolder : hl) {
            if (this.selectedHolder != null && this.selectedHolder.equals(instanceHolder)) {
                this.doHighlights(instanceHolder, this.selectedHighlighter);
            } else {
                this.doHighlights(instanceHolder, this.mainHighlighter);
            }
            this.global.setProgressCurrent(++count);
        }
        this.global.finishProgress();
    }

    private void doHighlight(Instance instance, Highlighter.HighlightPainter painter) {
        try {
            instance.changeHighlight(this.highlighter, painter);
        }
        catch (BadLocationException ex) {
            this.global.showException("Error occurred applying highlight.", ex);
        }
    }

    private void removeHighlight(Instance instance) {
        instance.removeHighlight(this.highlighter);
    }

    private void doHighlights(InstanceHolder<? extends Instance> ih, Highlighter.HighlightPainter painter) {
        try {
            ih.changeHighlights(this.highlighter, painter);
        }
        catch (BadLocationException ex) {
            this.global.showException("Error occurred applying highlights.", ex);
        }
    }

    private void removeHighlights(InstanceHolder<? extends Instance> ih) {
        ih.removeHighlights(this.highlighter);
    }

    private void updateAttributesViewWithAttributesOfRange(int start, int end) throws BadLocationException {
        String font = "";
        int size = 0;
        boolean boldDisagree = false;
        boolean italicDisagree = false;
        boolean underlineDisagree = false;
        boolean sizeDisagree = false;
        boolean fontDisagree = false;
        while (!this.docModel.isCharAtPosLetter(start) && start < end - 1) {
            ++start;
        }
        AttributeSet cas = this.docModel.getAttributesAtPos(start);
        boolean bold = StyleConstants.isBold(cas);
        boolean italic = StyleConstants.isItalic(cas);
        boolean underline = StyleConstants.isUnderline(cas);
        font = StyleConstants.getFontFamily(cas);
        size = StyleConstants.getFontSize(cas);
        int i = start + 1;
        while (i < end) {
            if (this.docModel.isCharAtPosLetter(i)) {
                cas = this.docModel.getAttributesAtPos(i);
                if (!boldDisagree && StyleConstants.isBold(cas) != bold) {
                    bold = false;
                    boldDisagree = true;
                }
                if (!italicDisagree && StyleConstants.isItalic(cas) != italic) {
                    italic = false;
                    italicDisagree = true;
                }
                if (!underlineDisagree && StyleConstants.isUnderline(cas) != underline) {
                    underline = false;
                    underlineDisagree = true;
                }
                if (!fontDisagree && !StyleConstants.getFontFamily(cas).equals(font)) {
                    font = "";
                    fontDisagree = true;
                }
                if (!sizeDisagree && StyleConstants.getFontSize(cas) != size) {
                    size = 0;
                    sizeDisagree = true;
                }
            }
            ++i;
        }
        this.fontComboBox.setActionCommand("skip");
        this.fontComboBox.setSelectedItem(font);
        this.fontComboBox.setActionCommand("do it");
        this.sizeComboBox.setActionCommand("skip");
        if (size == 0) {
            this.sizeComboBox.setSelectedItem("");
        } else {
            this.sizeComboBox.setSelectedItem(size);
        }
        this.sizeComboBox.setActionCommand("do it");
        this.boldToggle.getModel().setSelected(bold);
        this.italicToggle.getModel().setSelected(italic);
        this.underlineToggle.getModel().setSelected(underline);
    }

    private JMenu getReplacementPopupMenu(SuggestedReplacement replacement, WordHolder wh, VariantInstance instance, int type, Capitalisation.CapType capitalisation) {
        double weight = this.confidenceWeights.getFWeight();
        JMenu toReturn = new JMenu(replacement.toMenuString(capitalisation));
        Set<String> methods = this.confidenceWeights.getScores().keySet();
        Vector<JMenuItem> mis = new Vector<JMenuItem>(1 + methods.size());
        for (String method : methods) {
            mis.add(new JMenuItem(String.valueOf(method) + ": " + replacement.getScoreUpdate(method).getUpdate().toMenuString(weight)));
        }
        mis.add(new JMenuItem("Frequency is " + replacement.getFreq()));
        if (instance.getType() == 101) {
            toReturn.add(new NormaliseVariantInstanceAction<VariantInstance>(instance, replacement, this.docModel, this.lud, this.undoSupport));
        }
        if (type == 101) {
            toReturn.add(new NormaliseAllInstancesOfVariantAction(wh, 101, replacement, this.docModel, this.lud, this.undoSupport));
        }
        toReturn.addSeparator();
        for (JMenuItem m : mis) {
            m.setEnabled(false);
            toReturn.add(m);
        }
        return toReturn;
    }

    public void insertText(String text) {
        try {
            class Worker
            extends SwingWorkerAction {
                private final /* synthetic */ String val$text;

                Worker(String string) {
                    this.val$text = string;
                }

                @Override
                public void action() {
                    try {
                        try {
                            DocumentView.this.global.startIndeterminateProgress();
                            DocumentView.this.global.writeProgressMessage("Inserting text...");
                            DocumentView.this.global.lockFinishProgress();
                            DocumentView.this.holderChangeListener.suppressChanges();
                            DocumentView.this.docModel.processNewText(this.val$text, DocumentView.this.currentViewAttributes);
                        }
                        catch (InvalidInstanceChangeException e) {
                            DocumentView.this.global.showException("Error occurred reading xml tag.", e);
                            DocumentView.this.holderChangeListener.unSuppressChanges();
                            DocumentView.this.global.unlockFinishProgress();
                            DocumentView.this.global.finishProgress();
                        }
                        catch (BadLocationException e) {
                            DocumentView.this.global.showException("Error occurred parsing words.", e);
                            DocumentView.this.holderChangeListener.unSuppressChanges();
                            DocumentView.this.global.unlockFinishProgress();
                            DocumentView.this.global.finishProgress();
                        }
                    }
                    finally {
                        DocumentView.this.holderChangeListener.unSuppressChanges();
                        DocumentView.this.global.unlockFinishProgress();
                        DocumentView.this.global.finishProgress();
                    }
                }
            }
            new Worker(text).runAction();
        }
        catch (InterruptedException e) {
            this.global.showException("Error occurred inserting text.", e);
        }
        catch (ExecutionException e) {
            this.global.showException("Error occurred inserting text.", e);
        }
    }

    public MarkAsForeignAction getMarkAsForeignAction(String lang) {
        return new MarkAsForeignAction(lang);
    }

    public void addChangeListener(DocumentViewChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(DocumentViewChangeListener l) {
        this.changeListeners.remove(l);
    }

    public void changeSelectedInstance(Instance instance) {
        if (this.selectedInstance != null) {
            if (this.selectedHolder != null && this.selectedHolder.contains(this.selectedInstance)) {
                this.doHighlight(this.selectedInstance, this.selectedHighlighter);
            } else if (this.selectedInstance != null && this.selectedInstance.getType() == this.listSelected) {
                this.doHighlight(this.selectedInstance, this.mainHighlighter);
            } else {
                this.removeHighlight(this.selectedInstance);
            }
        }
        this.selectedInstance = instance;
        if (this.selectedInstance != null) {
            this.doHighlight(this.selectedInstance, this.instanceHighlighter);
            this.scrollToCaretPosition(this.selectedInstance.getStartOffset());
        }
        for (DocumentViewChangeListener l : this.changeListeners) {
            l.selectedInstanceChanged(instance);
        }
    }

    private void scrollToCaretPosition(int offset) {
        this.textPane.setCaretPosition(offset);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Rectangle r = DocumentView.this.textPane.modelToView(DocumentView.this.textPane.getCaretPosition());
                    if (r != null) {
                        JViewport viewport = DocumentView.this.textPaneSP.getViewport();
                        int extentHeight = viewport.getExtentSize().height;
                        int viewHeight = viewport.getViewSize().height;
                        int y = Math.max(0, r.y - extentHeight / 2);
                        y = Math.min(y, viewHeight - extentHeight);
                        viewport.setViewPosition(new Point(0, y));
                    }
                }
                catch (BadLocationException ex) {
                    DocumentView.this.global.showException("Error occurred scrolling to location.", ex);
                }
            }
        });
    }

    private void scrollToCaretRange(final int startOffset, int endOffset) {
        this.textPane.setCaretPosition((startOffset + endOffset) / 2);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Rectangle r = DocumentView.this.textPane.modelToView(DocumentView.this.textPane.getCaretPosition());
                    if (r != null) {
                        JViewport viewport = DocumentView.this.textPaneSP.getViewport();
                        int extentHeight = viewport.getExtentSize().height;
                        int viewHeight = viewport.getViewSize().height;
                        int y = Math.max(0, r.y - extentHeight / 2);
                        y = Math.min(y, viewHeight - extentHeight);
                        viewport.setViewPosition(new Point(0, y));
                        int zeroOffset = DocumentView.this.textPane.viewToModel(viewport.getViewPosition());
                        if (startOffset < zeroOffset) {
                            DocumentView.this.textPane.setCaretPosition(startOffset);
                            Rectangle startR = DocumentView.this.textPane.modelToView(DocumentView.this.textPane.getCaretPosition());
                            if (startR != null) {
                                viewport.setViewPosition(new Point(0, startR.y));
                            }
                        }
                    }
                }
                catch (BadLocationException ex) {
                    DocumentView.this.global.showException("Error occurred scrolling to location.", ex);
                }
            }
        });
    }

    public void changeSelectedType(InstanceHolder<? extends Instance> newSelection) {
        InstanceHolder<? extends Instance> oldSelection = this.selectedHolder;
        if (this.selectedHolder != newSelection) {
            this.selectedHolder = newSelection;
            if (oldSelection != null) {
                if (oldSelection.getType() == this.listSelected) {
                    this.doHighlights(oldSelection, this.mainHighlighter);
                } else {
                    this.removeHighlights(oldSelection);
                }
            }
            if (this.selectedHolder != null) {
                this.doHighlights(this.selectedHolder, this.selectedHighlighter);
                if (this.selectedInstance != null) {
                    this.doHighlight(this.selectedInstance, this.instanceHighlighter);
                }
            }
            for (DocumentViewChangeListener l : this.changeListeners) {
                l.selectedTypeChanged(newSelection);
            }
        }
    }

    public void textSelectionChanged(int start, int end) {
        AttributeSet cas = this.docModel.getAttributesAtPos(start);
        StyleConstants.setBold(this.currentViewAttributes, StyleConstants.isBold(cas));
        StyleConstants.setItalic(this.currentViewAttributes, StyleConstants.isItalic(cas));
        StyleConstants.setUnderline(this.currentViewAttributes, StyleConstants.isUnderline(cas));
        try {
            this.updateAttributesViewWithAttributesOfRange(start, end);
        }
        catch (BadLocationException ex) {
            this.global.showException("Error occurred collecting formatting information for text.", ex);
        }
    }

    public void changeList(final int whichList) {
        this.global.lockFinishProgress();
        this.clearText();
        this.changeSelectedType(null);
        final int oldSelected = this.listSelected;
        this.listSelected = whichList;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (oldSelected != -1) {
                    DocumentView.this.removeAllHighlights();
                }
                DocumentView.this.giveAllHighlightsOfType(whichList);
                if (DocumentView.this.selectedInstance != null) {
                    DocumentView.this.doHighlight(DocumentView.this.selectedInstance, DocumentView.this.instanceHighlighter);
                }
            }
        });
        this.showText();
        for (DocumentViewChangeListener l : this.changeListeners) {
            l.currentListChanged(whichList);
        }
        this.global.unlockFinishProgress();
        this.global.finishProgress();
    }

    public Instance getSelectedInstance() {
        return this.selectedInstance;
    }

    public InstanceHolder<? extends Instance> getSelectedHolder() {
        return this.selectedHolder;
    }

    public int getListSelected() {
        return this.listSelected;
    }

    public void changeFont(String f) {
        Style style = this.textPane.addStyle("Font " + f, null);
        StyleConstants.setFontFamily(style, f);
        StyleConstants.setFontFamily(this.currentViewAttributes, f);
        this.textPane.setCharacterAttributes(style, false);
        this.textPane.requestFocus();
    }

    public void changeFontSize(int s) {
        Style style = this.textPane.addStyle("Size " + s, null);
        StyleConstants.setFontSize(style, s);
        StyleConstants.setFontSize(this.currentViewAttributes, s);
        this.textPane.setCharacterAttributes(style, false);
        this.textPane.requestFocus();
    }

    private JComboBox createCombo(Object[] objects) {
        return new JComboBox(objects){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
    }

    private MouseListener getChangeSelectionMouseListener(final ForeignText foreign, final Instance instance) {
        return new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                DocumentView.this.textPane.setSelectionStart(foreign.getStartOffset());
                DocumentView.this.textPane.setSelectionEnd(foreign.getEndOffset());
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                DocumentView.this.textPane.setSelectionStart(instance.getStartOffset());
                DocumentView.this.textPane.setSelectionEnd(instance.getEndOffset());
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        };
    }

    @Override
    public void listChanged(InstanceHolder<? extends Instance> holder, int type) {
    }

    @Override
    public void instanceAboutToChange(Instance instance, int type) {
        if (!this.ignoreUpdates) {
            this.removeHighlight(instance);
        }
    }

    @Override
    public void instanceChanged(Instance instance, int type) {
        if (!this.ignoreUpdates) {
            if (this.selectedHolder != null && this.selectedHolder.contains(instance)) {
                this.doHighlight(instance, this.selectedHighlighter);
            } else if (this.listSelected == type) {
                this.doHighlight(instance, this.mainHighlighter);
            } else {
                this.removeHighlight(instance);
            }
        }
    }

    @Override
    public void holderEmptied(InstanceHolder<? extends Instance> holder, Instance lastRemoved, int type) {
    }

    @Override
    public void holderFilled(InstanceHolder<? extends Instance> holder, Instance lastAdded, int type) {
    }

    @Override
    public void suppressChanges() {
        this.ignoreUpdates = true;
        this.clearText();
    }

    @Override
    public void unSuppressChanges() {
        this.ignoreUpdates = false;
        this.showText();
    }

    @Override
    public void showAsForeign(ForeignText ft) {
        ft.changeStyleAttributes(this.docModel.getDoc(), this.foreign);
    }

    @Override
    public void ignoreThatForeign(ForeignText ft) {
        ft.changeStyleAttributes(this.docModel.getDoc(), this.blank);
    }

    @Override
    public void ignore(IgnorableText it) {
        it.changeStyleAttributes(this.docModel.getDoc(), this.ignored);
    }

    @Override
    public void unIgnore(IgnorableText it) {
        it.changeStyleAttributes(this.docModel.getDoc(), this.blank);
    }

    @Override
    public void caretUpdate(CaretEvent evt) {
        if (this.isEnabled) {
            int end;
            int start = evt.getMark();
            boolean bl = this.textSelection = start != (end = evt.getDot());
            if (!this.textSelection) {
                end = start = this.docModel.getStartOfDoc();
            }
            this.setEnabled(this.isEnabled);
            if (start > end) {
                start = evt.getDot();
                end = evt.getMark();
            }
            this.textSelectionChanged(start, end);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isEnabled && e.getButton() == 3) {
            Point point = e.getPoint();
            int caretPos = this.textPane.viewToModel(point);
            this.textPane.setCaretPosition(caretPos);
            try {
                Instance instance = this.docModel.getInstanceAt(caretPos);
                ForeignText foreign = this.docModel.getForeignAt(caretPos);
                if (instance == null && foreign == null) {
                    return;
                }
                int showX = point.x;
                int showY = point.y;
                JPopupMenu popup = new JPopupMenu();
                if (instance != null) {
                    WordHolder wh = instance.getHolder();
                    Rectangle wordRect = this.textPane.modelToView(instance.getEndOffset());
                    switch (instance.getType()) {
                        case 101: {
                            JMenuItem wait = new JMenuItem("Please Wait...");
                            wait.setEnabled(false);
                            popup.add(wait);
                            popup.show(this.textPane, wordRect.x + wordRect.width, wordRect.y + wordRect.height);
                            JMenu more = new JMenu("More Suggestions...");
                            int added = 0;
                            this.docModel.findReplacementsForWord(wh, 25);
                            List<SuggestedReplacement> reps = wh.getReplacements();
                            for (SuggestedReplacement replacement : reps) {
                                JMenu repPopup = this.getReplacementPopupMenu(replacement, wh, (VariantInstance)instance, 101, instance.getCapitalisation());
                                if (added < 5) {
                                    popup.add(repPopup);
                                    ++added;
                                    continue;
                                }
                                more.add(repPopup);
                                ++added;
                            }
                            if (added == 0) {
                                JMenuItem noneFound = new JMenuItem("No Replacements found");
                                noneFound.setEnabled(false);
                                popup.add(noneFound);
                            }
                            if (added > 5) {
                                popup.add(more);
                            }
                            popup.addSeparator();
                            popup.add(new NormaliseToAction<VariantInstance>((VariantInstance)instance, this.docModel, this.lud, this.confidenceWeights, this.undoSupport, this.questionAsker));
                            popup.add(new MarkFInstanceAsTAction((VariantInstance)instance, 103, this.undoSupport));
                            popup.addSeparator();
                            popup.add(new FindWordInListAction(instance));
                            popup.add(new MarkAllFInstancesAsTAction(wh, 101, 103, this.docModel, this.undoSupport, this.questionAsker));
                            popup.setVisible(false);
                            popup.remove(wait);
                            break;
                        }
                        case 103: {
                            popup.add(new MarkFInstanceAsTAction((CorrectInstance)instance, 101, this.undoSupport));
                            popup.addSeparator();
                            popup.add(new FindWordInListAction(instance));
                            popup.add(new MarkAllFInstancesAsTAction(wh, 103, 101, this.docModel, this.undoSupport, this.questionAsker));
                            break;
                        }
                        case 102: {
                            popup.add(new RevertInstanceAction((ReplacedInstance)instance, this.docModel, this.undoSupport));
                            popup.addSeparator();
                            popup.add(new FindWordInListAction(instance));
                            popup.add(new RevertAllAction(wh, ((ReplacedInstance)instance).getReplacement(), this.docModel, this.undoSupport));
                        }
                    }
                    showX = wordRect.x + wordRect.width;
                    showY = wordRect.y + wordRect.height;
                }
                if (foreign != null) {
                    if (instance != null) {
                        popup.addSeparator();
                    } else {
                        this.textPane.setSelectionStart(foreign.getStartOffset());
                        this.textPane.setSelectionEnd(foreign.getEndOffset());
                    }
                    JMenuItem info = new JMenuItem("Text marked as " + foreign.getLanguage());
                    info.setEnabled(false);
                    if (instance != null) {
                        info.addMouseListener(this.getChangeSelectionMouseListener(foreign, instance));
                    }
                    popup.add(info);
                    JMenu changeLang = new JMenu("Change language to...");
                    if (instance != null) {
                        changeLang.addMouseListener(this.getChangeSelectionMouseListener(foreign, instance));
                    }
                    SortedSet<String> langs = this.docModel.getForeignLanguages();
                    for (String lang : langs) {
                        JMenuItem langMenuItem = new JMenuItem(MainScreen.fixAction(new ChangeForeignLanguageAction(lang, foreign), lang, null, "Change selected span to " + lang, -1, null));
                        if (instance != null) {
                            langMenuItem.addMouseListener(this.getChangeSelectionMouseListener(foreign, instance));
                        }
                        changeLang.add(langMenuItem);
                    }
                    popup.add(changeLang);
                    JMenuItem removeMenuItem = new JMenuItem(MainScreen.fixAction(new RemoveForeignLanguageAction(foreign), "Remove language markup", null, "Remove langauge markup from span", -1, null));
                    if (instance != null) {
                        removeMenuItem.addMouseListener(this.getChangeSelectionMouseListener(foreign, instance));
                    }
                    popup.add(removeMenuItem);
                }
                popup.show(this.textPane, showX, showY);
            }
            catch (BadLocationException ex) {
                this.global.showException("Error occurred finding word.", ex);
                return;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void documentChangedFromSaved(boolean changed) {
    }

    @Override
    public void fileChanged() {
        this.currentFileLabel.setText("  > " + this.docModel.toString());
        this.reset();
    }

    @Override
    public void cleared() {
        this.clearText();
    }

    private class ChangeForeignLanguageAction
    extends AbstractAction {
        private static final long serialVersionUID = -5324066518544222055L;
        private String lang;
        private ForeignText foreignText;

        private ChangeForeignLanguageAction(String lang, ForeignText foreignText) {
            this.lang = lang;
            this.foreignText = foreignText;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            DocumentModel.ChangeForeignTextLanguageEdit edit = DocumentView.this.docModel.getChangeForeignTextLanguageEdit(this.foreignText, this.lang);
            if (edit.isValid()) {
                ThreadedProcessEditHolder tEdit = new ThreadedProcessEditHolder(edit);
                tEdit.execute();
                DocumentView.this.undoSupport.postEdit(tEdit);
            } else {
                DocumentView.this.global.showError(edit.getWhyInvalid());
            }
        }
    }

    private class CopyAction
    extends AbstractAction {
        private static final long serialVersionUID = -562300188506750751L;

        private CopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.ClipboardTextTransfer ctt = new MainScreen.ClipboardTextTransfer();
            ctt.setClipboardContents(DocumentView.this.textPane.getSelectedText());
        }
    }

    public static interface DocumentViewChangeListener {
        public void selectedInstanceChanged(Instance var1);

        public void selectedTypeChanged(InstanceHolder<? extends Instance> var1);

        public void currentListChanged(int var1);

        public void textCleared();
    }

    private class FindWordInListAction
    extends AbstractAction {
        private static final long serialVersionUID = 7144807205585186906L;
        Instance instance;

        private FindWordInListAction(Instance instance) {
            this.putValue("Name", "Select type");
            this.instance = instance;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int type = this.instance.getType();
            if (DocumentView.this.listSelected != type) {
                DocumentView.this.changeList(type);
            }
            DocumentView.this.changeSelectedType(this.instance.getInstanceHolder());
            DocumentView.this.changeSelectedInstance(this.instance);
        }
    }

    private class FontComboBoxAction
    extends AbstractAction {
        private static final long serialVersionUID = -4749472273813725546L;
        private boolean shownOnce = false;

        private FontComboBoxAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getActionCommand().equals("skip")) {
                return;
            }
            String f = (String)DocumentView.this.fontComboBox.getSelectedItem();
            if (Arrays.binarySearch(DocumentView.this.systemFonts, f) < 0) {
                if (!this.shownOnce) {
                    this.shownOnce = true;
                    QuestionAsker.Answer answer = DocumentView.this.questionAsker.askYesNoQuestion("' " + f + "' not found", "The font '" + f + "' is not available on this system, do you still wish to use it?");
                    if (answer == QuestionAsker.Answer.No) {
                        return;
                    }
                } else {
                    this.shownOnce = false;
                    return;
                }
            }
            DocumentView.this.changeFont(f);
        }
    }

    private class ForeignAction
    extends AbstractAction {
        private static final long serialVersionUID = -6650352543345466972L;

        private ForeignAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupMenu popup = new JPopupMenu();
            SortedSet<String> langs = DocumentView.this.docModel.getForeignLanguages();
            if (langs.size() > 0) {
                for (String lang : langs) {
                    popup.add(new JMenuItem(MainScreen.fixAction(DocumentView.this.getMarkAsForeignAction(lang), "Mark as " + lang, null, "Mark selected span as " + lang, -1, null)));
                }
                JComponent source = (JComponent)e.getSource();
                popup.show(source, source.getX(), source.getY());
            }
        }
    }

    private class JoinAction
    extends AbstractAction {
        private static final long serialVersionUID = 5061994287539564528L;

        private JoinAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int start = DocumentView.this.textPane.getSelectionStart();
            int end = DocumentView.this.textPane.getSelectionEnd();
            if (end - start > 0) {
                try {
                    DocumentModel.JoinEdit je = DocumentView.this.docModel.getJoinEdit(start, end);
                    if (je.isValid()) {
                        je.execute();
                        DocumentView.this.undoSupport.postEdit(je);
                    } else {
                        DocumentView.this.global.showError(je.getWhyInvalid());
                    }
                }
                catch (BadLocationException ex) {
                    DocumentView.this.global.showException("Join Failed.", ex);
                }
                catch (InvalidInstanceChangeException ex) {
                    DocumentView.this.global.showException("Join Failed.", ex);
                }
            }
        }
    }

    private class MarkAsForeignAction
    extends AbstractAction {
        private static final long serialVersionUID = 7833484066230877407L;
        private String lang;

        protected MarkAsForeignAction(String lang) {
            this.lang = lang;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int start = DocumentView.this.textPane.getSelectionStart();
            int end = DocumentView.this.textPane.getSelectionEnd();
            if (end - start > 0) {
                try {
                    DocumentModel.MarkSpanAsForeignEdit edit = DocumentView.this.docModel.getMarkAsForeignEdit(start, end, this.lang);
                    if (edit.isValid()) {
                        ThreadedProcessEditHolder tEdit = new ThreadedProcessEditHolder(edit);
                        tEdit.execute();
                        DocumentView.this.undoSupport.postEdit(tEdit);
                    } else {
                        DocumentView.this.global.showError(edit.getWhyInvalid());
                    }
                }
                catch (BadLocationException ex) {
                    DocumentView.this.global.showException("Mark span as language failed.", ex);
                }
            }
        }
    }

    private class PasteAction
    extends AbstractAction {
        private static final long serialVersionUID = -4304408041448008546L;
        private String cbText;

        private PasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.cbText = "";
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable cbContents = cb.getContents(null);
            if (cbContents != null && cbContents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    this.cbText = (String)cbContents.getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException ex) {
                    DocumentView.this.global.showException("Error occurred pasting from the clipboard.", ex);
                    DocumentView.this.global.unlockFinishProgress();
                    DocumentView.this.global.finishProgress();
                    return;
                }
                catch (IOException ex) {
                    DocumentView.this.global.showException("Error occurred pasting from the clipboard.", ex);
                    DocumentView.this.global.unlockFinishProgress();
                    DocumentView.this.global.finishProgress();
                    return;
                }
            } else {
                DocumentView.this.global.showError("Pasted text not supported");
                return;
            }
            if (this.cbText == null || this.cbText.equals("")) {
                return;
            }
            DocumentView.this.insertText(this.cbText);
        }
    }

    private class RemoveForeignLanguageAction
    extends AbstractAction {
        private static final long serialVersionUID = 3706137750673058845L;
        private ForeignText foreignText;

        private RemoveForeignLanguageAction(ForeignText foreignText) {
            this.foreignText = foreignText;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            DocumentModel.RemoveForeignEdit edit = DocumentView.this.docModel.getRemoveForeignEdit(this.foreignText);
            ThreadedProcessEditHolder tEdit = new ThreadedProcessEditHolder(edit);
            tEdit.execute();
            DocumentView.this.undoSupport.postEdit(tEdit);
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -8085670128620720543L;

        private SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DocumentView.this.textPane.setSelectionStart(DocumentView.this.docModel.getStartOfDoc());
            DocumentView.this.textPane.setSelectionEnd(DocumentView.this.docModel.getEndOfDoc());
        }
    }

    private class SizeComboBoxAction
    extends AbstractAction {
        private static final long serialVersionUID = -5262798822044239592L;
        private boolean shownOnce = false;

        private SizeComboBoxAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getActionCommand().equals("skip")) {
                return;
            }
            if (!(DocumentView.this.sizeComboBox.getSelectedItem() instanceof Integer)) {
                if (!this.shownOnce) {
                    DocumentView.this.global.showError("Not a valid font size");
                    this.shownOnce = true;
                } else {
                    this.shownOnce = false;
                }
                return;
            }
            Integer s = (Integer)DocumentView.this.sizeComboBox.getSelectedItem();
            DocumentView.this.changeFontSize(s);
        }
    }
}

