/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.text.DecimalFormat;

public class DisplayUtilities {
    private static final DecimalFormat formatter = new DecimalFormat("#,###");

    public static String getFormattedNumber(int number) {
        return formatter.format(number);
    }

    public static String getPercent(double count, double total) {
        String percentString = Double.toString(DisplayUtilities.round(count / total * 100.0, 2));
        if (percentString.endsWith(".0")) {
            percentString = percentString.substring(0, percentString.length() - 2);
        }
        return String.valueOf(percentString) + "%";
    }

    private static double round(double value, int places) {
        String r = "1";
        int i = 0;
        while (i < places) {
            r = String.valueOf(r) + "0";
            ++i;
        }
        r = String.valueOf(r) + ".0";
        Double p = Double.parseDouble(r);
        return Math.rint(value * p) / p;
    }
}

