/*
 * Decompiled with CFR 0.152.
 */
package model.sample;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import model.CharsetToolkit;
import model.Setup;
import model.doc.XMLUtilities;
import model.sample.Partition;

public class SampleUtilities {
    public static List<Partition> findPartitionsInFile(String fileID, File file, Setup setup) throws IOException {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        Pattern tagPattern = Pattern.compile("<" + setup.getPartitionTag() + "([^>]*)>");
        Charset charset = setup.getEncoding().equals("detect") ? CharsetToolkit.guessEncoding(file, 4096) : Charset.forName(setup.getEncoding());
        LineNumberReader in = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                Matcher tagMatcher = tagPattern.matcher(line);
                while (tagMatcher.find()) {
                    String attributesString = tagMatcher.group(1);
                    LinkedHashMap<String, String> attributes = XMLUtilities.getAttributes(attributesString);
                    if (!attributes.keySet().containsAll(setup.getPartitionAttributes())) continue;
                    int seq = Integer.parseInt(attributes.get(setup.getPartitionSequenceAttribute()));
                    int words = Integer.parseInt(attributes.get(setup.getPartitionCountAttribute()));
                    Partition.State state = Partition.State.valueOf(attributes.get(setup.getPartitionStateAttribute()));
                    partitions.add(new Partition(seq, words, state, fileID, file));
                }
            }
        }
        finally {
            in.close();
        }
        return partitions;
    }
}

