/*
 * Decompiled with CFR 0.152.
 */
package model.sample;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import model.sample.Partition;
import model.sample.RandomAccessQueue;

public class SampleModel {
    private final List<Partition> done;
    private final List<Partition> started;
    private final RandomAccessQueue<Partition> queued;
    private int doneWords = 0;
    private int startedWords = 0;
    private int queuedWords = 0;
    private Partition currentPartition = null;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public SampleModel() {
        this.done = new ArrayList<Partition>();
        this.started = new ArrayList<Partition>();
        this.queued = new RandomAccessQueue();
    }

    public void clear() {
        this.done.clear();
        this.doneWords = 0;
        this.started.clear();
        this.startedWords = 0;
        this.queued.clear();
        this.queuedWords = 0;
        this.setCurrentPartition(null);
        this.firePartitionDistributionChanged();
    }

    public void addPartitions(Collection<Partition> partitions) {
        for (Partition partition : partitions) {
            this.addPartition(partition);
        }
        this.firePartitionDistributionChanged();
    }

    private void addPartition(Partition partition) {
        switch (partition.getState()) {
            case done: {
                this.doneWords += partition.getWords();
                this.done.add(partition);
                break;
            }
            case queued: {
                this.queuedWords += partition.getWords();
                this.queued.add(partition);
                break;
            }
            case started: {
                this.startedWords += partition.getWords();
                this.started.add(partition);
                break;
            }
        }
    }

    private void nextPartition() {
        if (this.started.isEmpty()) {
            this.nextQueuedPartition();
        } else {
            this.processStartedPartion(this.started.get(0));
        }
    }

    public void nextQueuedPartition() {
        if (this.queued.isEmpty()) {
            this.setCurrentPartition(null);
        } else {
            Partition next = this.queued.remove();
            this.queuedWords -= next.getWords();
            this.startedWords += next.getWords();
            this.started.add(next);
            next.setState(Partition.State.started);
            this.firePartitionDistributionChanged();
            this.setCurrentPartition(next);
        }
    }

    public void markCurrentPartitionAsDone() {
        if (this.currentPartition != null) {
            if (this.started.remove(this.currentPartition)) {
                this.startedWords -= this.currentPartition.getWords();
                this.doneWords += this.currentPartition.getWords();
                this.done.add(this.currentPartition);
                this.currentPartition.setState(Partition.State.done);
                this.firePartitionDistributionChanged();
            }
            this.nextPartition();
        }
    }

    public void processStartedPartion(Partition partition) {
        if (partition.getState() == Partition.State.started) {
            this.setCurrentPartition(partition);
        }
    }

    public void processDonePartition(Partition partition) {
        if (partition.getState() == Partition.State.done && this.done.remove(partition)) {
            this.doneWords -= partition.getWords();
            partition.setState(Partition.State.started);
            this.startedWords += partition.getWords();
            this.started.add(partition);
            this.firePartitionDistributionChanged();
            this.setCurrentPartition(partition);
        }
    }

    public int getDoneWords() {
        return this.doneWords;
    }

    public int getStartedWords() {
        return this.startedWords;
    }

    public int getQueuedWords() {
        return this.queuedWords;
    }

    public int getTotalWords() {
        return this.doneWords + this.startedWords + this.queuedWords;
    }

    public List<Partition> getStartedPartitions() {
        return this.started;
    }

    public List<Partition> getDonePartitions() {
        return this.done;
    }

    public int getStartedPartitionsSize() {
        return this.started.size();
    }

    public int getDonePartitionsSize() {
        return this.done.size();
    }

    public int getQueuedPartitionsSize() {
        return this.queued.size();
    }

    public Partition getCurrentPartition() {
        return this.currentPartition;
    }

    private void firePartitionDistributionChanged() {
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.partitionDistributionChanged();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void setCurrentPartition(Partition partition) {
        this.currentPartition = partition;
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.currentPartitionChanged(partition);
        }
    }

    public static interface ChangeListener {
        public void currentPartitionChanged(Partition var1);

        public void partitionDistributionChanged();
    }
}

