/*
 * Decompiled with CFR 0.152.
 */
package model.lookup;

import java.util.Collection;
import java.util.Vector;
import model.lookup.Rule;

class FlaggedString
implements Cloneable {
    private String string;
    private boolean[] dirty;
    private int stringLength;
    private int rulesApplied;
    private Collection<Rule> listofrules;

    public FlaggedString() {
    }

    public FlaggedString(String s) {
        this.string = s;
        this.stringLength = this.string.length();
        this.dirty = new boolean[this.stringLength];
        this.rulesApplied = 0;
        this.listofrules = new Vector<Rule>();
    }

    public FlaggedString(FlaggedString original) {
        this.string = new String(original.toString());
        this.stringLength = this.string.length();
        this.dirty = new boolean[this.stringLength];
        int i = 0;
        while (i < this.stringLength) {
            if (original.isDirty(i)) {
                this.dirty[i] = true;
            }
            ++i;
        }
        this.rulesApplied = original.getRulesApplied();
        this.listofrules = original.listofrules;
    }

    private void setRulesApplied(Collection<Rule> rules) {
        this.rulesApplied = rules.size();
        this.listofrules = new Vector<Rule>();
        this.listofrules.addAll(rules);
    }

    private void addRuleApplied(Rule rule) {
        ++this.rulesApplied;
        this.listofrules.add(rule);
    }

    public int getRulesApplied() {
        return this.rulesApplied;
    }

    public Collection<Rule> getRules() {
        return this.listofrules;
    }

    public String toString() {
        return this.string;
    }

    private int length() {
        return this.stringLength;
    }

    private void setCharDirty(int i, boolean d) throws IndexOutOfBoundsException {
        if (i < 0 || i > this.stringLength - 1) {
            throw new IndexOutOfBoundsException();
        }
        this.dirty[i] = d;
    }

    private void dirtyRange(int start, int end) throws IndexOutOfBoundsException {
        if (end < start || start < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            if (start == this.stringLength) {
                this.dirty[start - 1] = true;
            } else {
                this.dirty[start] = true;
            }
        } else {
            int s = Math.max(0, start);
            int e = Math.min(this.stringLength, end);
            int i = s;
            while (i < e) {
                this.dirty[i] = true;
                ++i;
            }
        }
    }

    private boolean isDirty(int start, int end) throws IndexOutOfBoundsException {
        if (end < start || start < 0 || end > this.stringLength) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            if (start == this.stringLength) {
                return this.dirty[start - 1];
            }
            return this.dirty[start];
        }
        int i = start;
        while (i < end) {
            if (this.dirty[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isDirty(int i) throws IndexOutOfBoundsException {
        if (i < 0 || i > this.stringLength - 1) {
            throw new IndexOutOfBoundsException();
        }
        return this.dirty[i];
    }

    private boolean startsWith(String prefix) {
        int prefixLength = prefix.length();
        if (prefixLength > this.stringLength) {
            return false;
        }
        if (this.isDirty(0, prefixLength)) {
            return false;
        }
        return this.string.startsWith(prefix);
    }

    private boolean endsWith(String suffix) {
        int suffixLength = suffix.length();
        if (suffixLength > this.stringLength) {
            return false;
        }
        if (this.isDirty(this.stringLength - suffixLength, this.stringLength)) {
            return false;
        }
        return this.string.endsWith(suffix);
    }

    private boolean secondIs(String search) {
        int searchLength = search.length();
        if (searchLength > this.stringLength - 1) {
            return false;
        }
        if (this.string.substring(1 + searchLength).length() < 2) {
            return false;
        }
        if (this.isDirty(1, searchLength + 1)) {
            return false;
        }
        return this.string.substring(1).startsWith(search);
    }

    private boolean penultimateIs(String search) {
        int searchLength = search.length();
        if (searchLength > this.stringLength - 1) {
            return false;
        }
        if (this.string.substring(0, this.stringLength - 1 - searchLength).length() < 2) {
            return false;
        }
        if (this.isDirty(this.stringLength - 1 - searchLength, this.stringLength - 1)) {
            return false;
        }
        return this.string.substring(0, this.stringLength - 1).endsWith(search);
    }

    private int indexOf(String toCheck, int start) {
        int currentStart = start;
        int toCheckLength = toCheck.length();
        if (toCheckLength > this.stringLength) {
            return -1;
        }
        int result = -1;
        for (int currentEnd = currentStart + toCheckLength; currentEnd < this.stringLength + 1; ++currentEnd) {
            result = this.string.indexOf(toCheck, currentStart);
            if (result == -1) {
                return -1;
            }
            currentStart = result;
            currentEnd = currentStart + toCheckLength;
            if (this.isDirty(currentStart, currentEnd)) {
                ++currentStart;
                continue;
            }
            return currentStart;
        }
        return -1;
    }

    public Vector<FlaggedString> applyRule(Rule rule) {
        Rule.Position where = rule.getWhereToApply();
        String original = rule.getOriginal();
        String replacement = rule.getReplacement();
        Vector<FlaggedString> toReturn = new Vector<FlaggedString>(10, 5);
        if (this.stringLength < 2) {
            return toReturn;
        }
        if (this.rulesApplied > 1) {
            return toReturn;
        }
        switch (where) {
            case Start: {
                if (this.startsWith(original)) {
                    toReturn.add(this.replace(original, replacement, 0, rule));
                }
                return toReturn;
            }
            case End: {
                if (this.endsWith(original)) {
                    toReturn.add(this.replace(original, replacement, this.stringLength - original.length(), rule));
                }
                return toReturn;
            }
            case Second: {
                if (this.secondIs(original)) {
                    toReturn.add(this.replace(original, replacement, 1, rule));
                }
                return toReturn;
            }
            case Penultimate: {
                if (this.penultimateIs(original)) {
                    toReturn.add(this.replace(original, replacement, this.stringLength - 1 - original.length(), rule));
                }
                return toReturn;
            }
            case Middle: {
                if (this.stringLength - 2 == original.length()) {
                    if (original.equals(this.string.substring(1, this.stringLength - 1))) {
                        toReturn.add(this.replace(original, replacement, 1, rule));
                    }
                } else {
                    int start = this.indexOf(original, 2);
                    if (start > -1 && start < this.stringLength - 2) {
                        Vector<FlaggedString> toCheck = new Vector<FlaggedString>(20, 5);
                        toCheck.add(new FlaggedString(this));
                        while (!toCheck.isEmpty() && toCheck.size() < 5000) {
                            FlaggedString current = (FlaggedString)toCheck.firstElement();
                            start = current.indexOf(original, 2);
                            if (current.rulesApplied > 1 || start == -1 || start >= this.stringLength - 2) {
                                toCheck.remove(0);
                                continue;
                            }
                            FlaggedString toAdd = current.replace(original, replacement, start, rule);
                            toCheck.add(toAdd);
                            toReturn.add(toAdd);
                            current.dirtyRange(start, start + original.length());
                        }
                    }
                }
                return toReturn;
            }
            case Anywhere: {
                int start = this.indexOf(original, 0);
                if (start > -1) {
                    Vector<FlaggedString> toCheck = new Vector<FlaggedString>(20, 5);
                    toCheck.add(new FlaggedString(this));
                    while (!toCheck.isEmpty() && toCheck.size() < 5000) {
                        FlaggedString current = (FlaggedString)toCheck.firstElement();
                        start = current.indexOf(original, 0);
                        if (start == -1) {
                            toCheck.remove(0);
                            continue;
                        }
                        FlaggedString toAdd = current.replace(original, replacement, start, rule);
                        toCheck.add(toAdd);
                        toReturn.add(toAdd);
                        current.dirtyRange(start, start + original.length());
                    }
                }
                return toReturn;
            }
        }
        return toReturn;
    }

    private FlaggedString substring(int start, int end) {
        FlaggedString toReturn = new FlaggedString(this.string.substring(start, end));
        int trPlace = 0;
        int i = start;
        while (i < end) {
            toReturn.setCharDirty(trPlace, this.dirty[i]);
            ++trPlace;
            ++i;
        }
        return toReturn;
    }

    private FlaggedString concat(FlaggedString newFS) {
        FlaggedString toReturn = new FlaggedString(String.valueOf(this.string) + newFS.toString());
        int i = 0;
        while (i < this.stringLength) {
            toReturn.setCharDirty(i, this.dirty[i]);
            ++i;
        }
        int toReturnLength = toReturn.length();
        int nfsPlace = 0;
        int i2 = this.stringLength;
        while (i2 < toReturnLength) {
            toReturn.setCharDirty(i2, newFS.isDirty(nfsPlace));
            ++nfsPlace;
            ++i2;
        }
        return toReturn;
    }

    private FlaggedString concat(String newS) {
        FlaggedString toReturn = new FlaggedString(String.valueOf(this.string) + newS);
        int i = 0;
        while (i < this.stringLength) {
            toReturn.setCharDirty(i, this.dirty[i]);
            ++i;
        }
        return toReturn;
    }

    private FlaggedString replace(String original, String replacement, int start, Rule rule) {
        FlaggedString before = this.substring(0, start);
        FlaggedString after = this.substring(start + original.length(), this.stringLength);
        FlaggedString toReturn = before.concat(replacement);
        toReturn = toReturn.concat(after);
        toReturn.dirtyRange(start, start + replacement.length());
        toReturn.setRulesApplied(this.listofrules);
        toReturn.addRuleApplied(rule);
        return toReturn;
    }

    public boolean[] getDirty() {
        return this.dirty;
    }

    public void setDirty(boolean[] dirty) {
        this.dirty = dirty;
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
    }

    public int getStringLength() {
        return this.stringLength;
    }

    public void setStringLength(int stringLength) {
        this.stringLength = stringLength;
    }
}

