/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import javax.swing.text.BadLocationException;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import model.doc.InstanceHolder;
import model.doc.InvalidInstanceChangeException;
import model.doc.ReplacedInstance;
import model.doc.TextReplacementHandler;
import model.doc.VariantInstance;
import model.doc.WordHolder;

public class RevertReplacedInstanceEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private VariantInstance vi;
    private ReplacedInstance ri;
    private InstanceHolder<ReplacedInstance> from = null;
    private final boolean isAlone;
    private WordHolder wh;
    private final TextReplacementHandler textReplacementHandler;
    private boolean executed = false;
    private boolean undone = false;

    public RevertReplacedInstanceEdit(ReplacedInstance ri, TextReplacementHandler textReplacementHandler) throws InvalidInstanceChangeException {
        this.textReplacementHandler = textReplacementHandler;
        this.ri = ri;
        this.wh = ri.holder;
        this.vi = (VariantInstance)ri.getPreviousInstance();
        if (this.vi == null) {
            this.vi = new VariantInstance(ri);
        }
        this.from = this.wh.getAsReplaced(ri.getReplacement().getReplacementStringWithoutChangingCapitalisation());
        if (this.from == null) {
            throw new InvalidInstanceChangeException("Replacement not found.");
        }
        this.isAlone = this.from.size() == 1;
    }

    public void execute() throws InvalidInstanceChangeException, BadLocationException {
        if (!this.executed) {
            this.ri.setPreviousInstance(this.vi);
            this.ri.revertInText(this.textReplacementHandler);
            if (this.from.removeInstance(this.ri)) {
                if (!this.wh.getAsVariant().addInstance(this.vi)) {
                    this.from.addInstance(this.ri);
                    this.ri.setupInText(this.textReplacementHandler);
                    throw new InvalidInstanceChangeException(this.ri + " could not be reverted.");
                }
                if (this.isAlone) {
                    this.wh.removeAsReplaced(this.ri.getReplacement().getReplacementStringWithoutChangingCapitalisation());
                }
                this.executed = true;
                return;
            }
            throw new InvalidInstanceChangeException(this.ri + " could not be reverted.");
        }
        throw new InvalidInstanceChangeException("Can only execute once. Revert " + this.ri);
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.executed) {
            try {
                if (this.wh.getAsVariant().removeInstance(this.vi)) {
                    if (!this.from.addInstance(this.ri)) {
                        this.wh.getAsVariant().addInstance(this.vi);
                        this.ri.revertInText(this.textReplacementHandler);
                        throw new CannotUndoException();
                    }
                } else {
                    throw new CannotUndoException();
                }
                this.ri.setupInText(this.textReplacementHandler);
            }
            catch (BadLocationException ex) {
                throw new CannotUndoException();
            }
            if (this.isAlone) {
                this.wh.addAsReplaced(this.ri.getReplacement().getReplacementStringWithoutChangingCapitalisation(), this.from);
            }
            this.undone = true;
            return;
        }
        throw new CannotUndoException();
    }

    @Override
    public void redo() throws CannotRedoException {
        if (this.undone) {
            try {
                this.ri.revertInText(this.textReplacementHandler);
                if (this.from.removeInstance(this.ri)) {
                    if (!this.wh.getAsVariant().addInstance(this.vi)) {
                        this.from.addInstance(this.ri);
                        this.ri.setupInText(this.textReplacementHandler);
                        throw new CannotRedoException();
                    }
                    if (this.isAlone) {
                        this.wh.removeAsReplaced(this.ri.getReplacement().getReplacementStringWithoutChangingCapitalisation());
                    }
                    this.undone = false;
                    return;
                }
                throw new CannotRedoException();
            }
            catch (BadLocationException ex) {
                throw new CannotRedoException();
            }
        }
        throw new CannotRedoException();
    }

    @Override
    public boolean canUndo() {
        return this.executed;
    }

    @Override
    public boolean canRedo() {
        return this.undone;
    }

    @Override
    public String getPresentationName() {
        return "Revert (" + this.ri.revertString() + ")";
    }

    public String getActionName() {
        return "Revert to " + WordHolder.getTypeString(101);
    }
}

