/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import model.Setup;
import model.SuggestedReplacement;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.TextReplacementHandler;
import model.doc.VariantInstance;
import model.doc.WordHolder;

public class ReplacedInstance
extends Instance {
    private final SuggestedReplacement replacement;
    private final String originalDisplayText;
    private final String originalXMLText;
    private final Map<String, String> originalTextEntitiesContainedWithin;
    private final boolean auto;
    private boolean isSetup;
    private boolean isReverted;

    public ReplacedInstance(Position start, Position end, String replacedTextOriginal, String replacedTextDisplay, Map<String, String> entitiesContainedWithin, String originalDisplayText, Map<String, String> originalTextEntitiesContainedWithin, LinkedHashMap<String, String> attributes, Setup setup, SuggestedReplacement replacement, WordHolder holder, InstanceHolder<ReplacedInstance> instanceHolder) {
        super(start, end, replacedTextOriginal, replacedTextDisplay, entitiesContainedWithin, attributes, setup, holder, instanceHolder);
        this.originalDisplayText = originalDisplayText;
        this.originalTextEntitiesContainedWithin = originalTextEntitiesContainedWithin;
        this.originalXMLText = this.getAttributeValue(setup.getNormalisedOriginalAttribute());
        this.auto = this.isAttributePresent(setup.getNormalisedAutoAttribute()) ? Boolean.parseBoolean(this.getAttributeValue(setup.getNormalisedAutoAttribute())) : false;
        this.replacement = replacement;
        this.isSetup = true;
        this.isReverted = false;
    }

    public ReplacedInstance(VariantInstance previousInstance, String replacedTextOriginal, String replacedTextDisplay, Map<String, String> entitiesContainedWithin, InstanceHolder<ReplacedInstance> replacedInstanceHolder, boolean auto, SuggestedReplacement replacement) {
        super(previousInstance, replacedInstanceHolder, ReplacedInstance.getReplacedTextWithVariantEntitiesReverted(replacedTextOriginal, previousInstance.entitiesContainedWithin), replacedTextDisplay, entitiesContainedWithin);
        this.auto = auto;
        this.replacement = replacement;
        this.originalDisplayText = previousInstance.getDisplayString();
        this.originalTextEntitiesContainedWithin = previousInstance.entitiesContainedWithin;
        this.originalXMLText = previousInstance.getText();
        this.isSetup = false;
        this.isReverted = false;
    }

    private static String getReplacedTextWithVariantEntitiesReverted(String replacement, Map<String, String> entities) {
        String revertedText = replacement;
        for (Map.Entry<String, String> entity : entities.entrySet()) {
            revertedText = revertedText.replace(entity.getKey(), entity.getValue());
        }
        return revertedText;
    }

    @Override
    public int getType() {
        return 102;
    }

    @Override
    public boolean areRequiredAttributesPresent(Setup setup) {
        return this.isAttributePresent(setup.getNormalisedOriginalAttribute());
    }

    public String getOriginalDisplayText() {
        return this.originalDisplayText;
    }

    public String getOriginalXMLText() {
        return this.originalXMLText;
    }

    public SuggestedReplacement getReplacement() {
        return this.replacement;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public void setupInText(TextReplacementHandler textReplacementHandler) throws BadLocationException {
        textReplacementHandler.replaceText(this.getStart(), this.getEnd(), this.getText(), true);
        this.isSetup = true;
    }

    public void revertInText(TextReplacementHandler textReplacementHandler) throws BadLocationException {
        textReplacementHandler.replaceText(this.getStart(), this.getEnd(), this.originalXMLText, true);
        this.isSetup = false;
        this.isReverted = true;
    }

    public boolean isSetup() {
        return this.isSetup;
    }

    public boolean isReverted() {
        return this.isReverted;
    }

    @Override
    public String analysisString() {
        return String.valueOf(this.getType()) + ": " + this.getOriginalDisplayText() + " -> " + this.getDisplayString() + " (" + this.getStartOffset() + " - " + this.getEndOffset() + ")";
    }

    public String revertString() {
        return String.valueOf(this.getOriginalDisplayText()) + " <- " + this.getDisplayString();
    }

    @Override
    public boolean removeSelfFromHolder() {
        return this.holder.removeReplaced(this);
    }

    @Override
    public void addSelfToHolder() {
        this.holder.addReplaced(this);
    }

    @Override
    protected void updateAttributes(Setup setup) {
        super.updateAttributes(setup);
        this.setAttribute(setup.getNormalisedOriginalAttribute(), this.originalXMLText);
        if (setup.isNormalisedAutoAttributeSet()) {
            this.setAttribute(setup.getNormalisedAutoAttribute(), Boolean.toString(this.auto));
        }
    }

    @Override
    protected String getTag(Setup setup) {
        return setup.getNormalisedTag();
    }

    public Map<String, String> getOriginalTextEntitiesContainedWithin() {
        return this.originalTextEntitiesContainedWithin;
    }

    public int compareAlphabeticallyTo(ReplacedInstance other) {
        int c = this.getOriginalDisplayText().compareToIgnoreCase(other.getOriginalDisplayText());
        if (c == 0) {
            return super.compareAlphabeticallyTo(other);
        }
        return c;
    }
}

