/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import model.ConfidenceWeights;
import model.Globals;
import model.doc.CannotExecuteException;
import model.doc.DocumentModel;
import model.doc.HolderChangeListener;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.InvalidInstanceChangeException;
import model.doc.NormaliseAllVariantInstancesEdit;
import model.doc.ThreadableEdit;
import model.lookup.LookUpDictionary;

public class ProcessAllVariantsEdit
extends AbstractUndoableEdit
implements ThreadableEdit {
    private static final long serialVersionUID = 1L;
    private boolean executed;
    private boolean undone;
    private boolean update;
    private boolean hasChangedBefore;
    private double threshold;
    private int currentPos;
    private ArrayList<NormaliseAllVariantInstancesEdit> edits;
    private ArrayList<NormaliseAllVariantInstancesEdit> editsUndone;
    private ArrayList<NormaliseAllVariantInstancesEdit> editsRedone;
    private final DocumentModel docModel;
    private final ConfidenceWeights confidenceWeights;
    private final LookUpDictionary lud;
    private final HolderChangeListener holderChangeListener;
    private final Globals global;

    public ProcessAllVariantsEdit(double threshold, boolean updateConfidenceWeights, DocumentModel docModel, ConfidenceWeights confidenceWeights, LookUpDictionary lud) {
        this.threshold = threshold;
        this.update = updateConfidenceWeights;
        this.docModel = docModel;
        this.holderChangeListener = docModel;
        this.confidenceWeights = confidenceWeights;
        this.lud = lud;
        this.edits = new ArrayList();
        this.hasChangedBefore = confidenceWeights.hasChanged();
        this.global = Globals.getInstance();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void execute() throws CannotExecuteException {
        if (!this.executed) {
            block9: {
                this.global.lockFinishProgress();
                this.global.startIndeterminateProgress();
                this.holderChangeListener.suppressChanges();
                this.getReplacements(1);
                varIHs = new TreeSet<InstanceHolder<? extends Instance>>();
                varIHs.addAll(this.docModel.getHolderList(101));
                this.global.startProgress(varIHs.size());
                this.global.writeProgressMessage("Normalising variants...");
                this.confidenceWeights.setUpdate(this.update);
                this.currentPos = 0;
                try {
                    try {
                        for (InstanceHolder varIH : varIHs) {
                            top = varIH.getWordHolder().getTopReplacement();
                            if (top != null && top.getScoreWithoutUpdating() >= this.threshold) {
                                edit = new NormaliseAllVariantInstancesEdit(varIH.getWordHolder(), 101, top, this.docModel, this.docModel, this.lud, true, false, true);
                                edit.execute();
                                this.edits.add(edit);
                            }
                            this.global.setProgressCurrent(++this.currentPos);
                        }
                        break block9;
                    }
                    catch (InvalidInstanceChangeException ex) {
                        ** for (edit : this.edits)
                    }
lbl-1000:
                    // 1 sources

                    {
                        edit.undo();
                        continue;
                    }
lbl29:
                    // 1 sources

                    throw new CannotExecuteException(ex.getMessage());
                }
                finally {
                    this.confidenceWeights.setUpdateToDefault();
                    this.holderChangeListener.unSuppressChanges();
                    this.global.unlockFinishProgress();
                    this.global.finishProgress();
                }
            }
            this.executed = true;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void undo() throws CannotUndoException {
        block9: {
            if (this.canUndo()) {
                this.global.lockFinishProgress();
                this.global.startIndeterminateProgress();
                this.holderChangeListener.suppressChanges();
                this.editsUndone = new ArrayList<E>();
                toUse = this.edits;
                if (this.editsRedone != null && !this.editsRedone.isEmpty()) {
                    toUse = this.editsRedone;
                }
                this.confidenceWeights.setUpdate(this.update);
                this.confidenceWeights.setHasChanged(this.hasChangedBefore);
                this.global.startProgress(toUse.size());
                this.global.writeProgressMessage("Undoing normalising variants...");
                this.currentPos = 0;
                try {
                    try {
                        for (NormaliseAllVariantInstancesEdit edit : toUse) {
                            edit.undo();
                            this.editsUndone.add(edit);
                            this.global.setProgressCurrent(++this.currentPos);
                        }
                        break block9;
                    }
                    catch (CannotUndoException ex) {
                        ** for (edit : this.editsUndone)
                    }
lbl-1000:
                    // 1 sources

                    {
                        edit.redo();
                        continue;
                    }
lbl27:
                    // 1 sources

                    throw ex;
                }
                finally {
                    this.confidenceWeights.setUpdateToDefault();
                    this.holderChangeListener.unSuppressChanges();
                    this.global.unlockFinishProgress();
                    this.global.finishProgress();
                }
            }
            throw new CannotUndoException();
        }
        this.undone = true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void redo() throws CannotRedoException {
        block8: {
            if (this.canRedo()) {
                this.global.lockFinishProgress();
                this.global.startProgress(this.editsUndone.size());
                this.holderChangeListener.suppressChanges();
                this.global.writeProgressMessage("Redoing normalising variants...");
                this.editsRedone = new ArrayList<E>();
                this.confidenceWeights.setUpdate(this.update);
                this.currentPos = 0;
                try {
                    try {
                        for (NormaliseAllVariantInstancesEdit edit : this.editsUndone) {
                            edit.redo();
                            this.editsRedone.add(edit);
                            this.global.setProgressCurrent(++this.currentPos);
                        }
                        break block8;
                    }
                    catch (CannotRedoException ex) {
                        ** for (edit : this.editsRedone)
                    }
lbl-1000:
                    // 1 sources

                    {
                        edit.undo();
                        continue;
                    }
lbl22:
                    // 1 sources

                    throw ex;
                }
                finally {
                    this.confidenceWeights.setUpdateToDefault();
                    this.holderChangeListener.unSuppressChanges();
                    this.global.unlockFinishProgress();
                    this.global.finishProgress();
                }
            }
            throw new CannotRedoException();
        }
        this.undone = false;
    }

    @Override
    public boolean canUndo() {
        return this.executed;
    }

    @Override
    public boolean canRedo() {
        return this.undone;
    }

    @Override
    public String getPresentationName() {
        return "Process all variants (" + this.threshold + "%)";
    }

    private void getReplacements(int limit) {
        TreeSet<InstanceHolder<? extends Instance>> varIHs = this.docModel.getHolderList(101);
        this.global.startProgress(varIHs.size());
        this.global.writeProgressMessage("Finding replacements...");
        int currentPos = 0;
        for (InstanceHolder instanceHolder : varIHs) {
            this.docModel.findReplacementsForWord(instanceHolder.getWordHolder(), limit);
            this.global.setProgressCurrent(++currentPos);
        }
        this.global.finishProgress();
    }
}

