/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.LinkedHashMap;
import javax.swing.text.Position;
import model.Setup;
import model.doc.DocumentXMLElement;
import model.sample.Partition;

public class PartitionElement
extends DocumentXMLElement {
    private final int seq;
    private final int words;
    private Partition.State state;

    public PartitionElement(Position start, Position end, LinkedHashMap<String, String> attributes, Setup setup) {
        super(start, end, "[text not included]", attributes, setup);
        this.seq = Integer.parseInt(this.getAttributeValue(setup.getPartitionSequenceAttribute()));
        this.words = Integer.parseInt(this.getAttributeValue(setup.getPartitionCountAttribute()));
        this.state = Partition.State.valueOf(this.getAttributeValue(setup.getPartitionStateAttribute()));
    }

    public PartitionElement(Position start, Position end, int seq, int words, Partition.State state) {
        super(start, end, "[text not included]", true);
        this.seq = seq;
        this.words = words;
        this.state = state;
    }

    @Override
    public boolean areRequiredAttributesPresent(Setup setup) {
        return this.isAttributePresent(setup.getPartitionCountAttribute()) && this.isAttributePresent(setup.getPartitionSequenceAttribute()) && this.isAttributePresent(setup.getPartitionStateAttribute());
    }

    @Override
    protected void updateAttributes(Setup setup) {
        super.updateAttributes(setup);
        this.setAttribute(setup.getPartitionSequenceAttribute(), "" + this.seq);
        this.setAttribute(setup.getPartitionStateAttribute(), this.state.toString());
        this.setAttribute(setup.getPartitionCountAttribute(), "" + this.words);
    }

    @Override
    protected String getTag(Setup setup) {
        return setup.getPartitionTag();
    }

    @Override
    public String toString() {
        return "Sample partition #" + this.seq + " (" + this.words + " words)";
    }

    public int getSequence() {
        return this.seq;
    }

    public Partition.State getState() {
        return this.state;
    }

    public void setState(Partition.State state) {
        this.state = state;
    }
}

