/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.TreeSet;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import model.Globals;
import model.doc.CannotExecuteException;
import model.doc.CorrectInstance;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.InvalidInstanceChangeException;
import model.doc.ThreadableEdit;
import model.doc.VariantInstance;
import model.doc.WordHolder;

public class MarkAllFInstancesAsTEdit<F extends Instance, T extends Instance>
extends AbstractUndoableEdit
implements ThreadableEdit {
    private static final long serialVersionUID = 1L;
    private TreeSet<F> fis;
    private TreeSet<T> tis;
    private int toType;
    private InstanceHolder<F> from;
    private InstanceHolder<T> to;
    private boolean executed = false;
    private boolean undone = false;
    private String progressMessage;
    private Globals global = Globals.getInstance();

    public MarkAllFInstancesAsTEdit(WordHolder wh, int fromType, int toType) throws InvalidInstanceChangeException {
        this.toType = toType;
        switch (fromType) {
            case 101: {
                this.from = wh.getAsVariant();
                break;
            }
            case 103: {
                this.from = wh.getAsCorrect();
                break;
            }
            case 102: {
                throw new InvalidInstanceChangeException("Can't mark replaced instance as something else. Use revert back instead.");
            }
            default: {
                throw new InvalidInstanceChangeException("From instance type not recognised.");
            }
        }
        switch (toType) {
            case 101: {
                this.to = wh.getAsVariant();
                break;
            }
            case 103: {
                this.to = wh.getAsCorrect();
                break;
            }
            case 102: {
                throw new InvalidInstanceChangeException("Can't mark replaced instance as something else. Use revert back instead.");
            }
            default: {
                throw new InvalidInstanceChangeException("From instance type not recognised.");
            }
        }
        this.fis = new TreeSet();
        this.tis = new TreeSet();
        for (Instance fi : this.from.getInstances()) {
            Instance toAdd;
            this.fis.add(fi);
            switch (toType) {
                case 101: {
                    toAdd = new VariantInstance(fi, wh.getAsVariant());
                    break;
                }
                case 103: {
                    toAdd = new CorrectInstance(fi, wh.getAsCorrect());
                    break;
                }
                case 102: {
                    throw new InvalidInstanceChangeException("Can't mark replaced instance as something else. Use revert back instead.");
                }
                default: {
                    throw new InvalidInstanceChangeException("From instance type not recognised.");
                }
            }
            Instance p = fi;
            while ((p = p.getPreviousInstance()) != null && p != fi) {
                if (p.getType() != toType) continue;
                toAdd = p;
                break;
            }
            this.tis.add(toAdd);
        }
        this.progressMessage = "Mark all " + WordHolder.getTypeString(fromType) + " as " + WordHolder.getTypeString(toType) + " (" + ((Instance)this.tis.first()).getDisplayString() + ")";
    }

    @Override
    public void execute() throws CannotExecuteException {
        if (this.executed) {
            throw new CannotExecuteException("Cannot execute twice.");
        }
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Executing: " + this.progressMessage);
        this.from.emptyInstances();
        this.to.addInstances(this.tis);
        this.executed = true;
        this.global.finishProgress();
    }

    @Override
    public void undo() throws CannotUndoException {
        if (!this.executed) {
            throw new CannotUndoException();
        }
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Undoing: " + this.progressMessage);
        this.to.removeInstances(this.tis);
        this.from.addInstances(this.fis);
        this.undone = true;
        this.global.finishProgress();
    }

    @Override
    public void redo() throws CannotRedoException {
        if (!this.undone) {
            throw new CannotRedoException();
        }
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Redoing: " + this.progressMessage);
        this.from.removeInstances(this.fis);
        this.to.addInstances(this.tis);
        this.undone = false;
        this.global.finishProgress();
    }

    @Override
    public boolean canUndo() {
        return this.executed;
    }

    @Override
    public boolean canRedo() {
        return this.undone;
    }

    @Override
    public String getPresentationName() {
        return this.progressMessage;
    }

    public String getActionName() {
        return "Mark all as " + WordHolder.getTypeString(this.toType);
    }

    public int getToType() {
        return this.toType;
    }
}

