/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import model.Setup;
import model.doc.DocumentElement;

public abstract class DocumentXMLElement
extends DocumentElement {
    private final LinkedHashMap<String, String> attributes;
    private final boolean isXMLRequired;
    private final boolean fromXML;
    private int lastOpenTagLength;
    private int lastCloseTagLength;

    protected DocumentXMLElement(Position start, Position end, String original, LinkedHashMap<String, String> attributes, Setup setup) {
        super(start, end, original);
        this.isXMLRequired = true;
        this.fromXML = true;
        this.attributes = attributes;
        if (!this.areRequiredAttributesPresent(setup)) {
            throw new IllegalArgumentException("Required attributes not present: " + this.getXMLOpenTag(setup));
        }
    }

    protected DocumentXMLElement(Position start, Position end, String original, boolean isXMLRequired) {
        super(start, end, original);
        this.attributes = new LinkedHashMap();
        this.isXMLRequired = isXMLRequired;
        this.fromXML = false;
    }

    public abstract boolean areRequiredAttributesPresent(Setup var1);

    protected abstract String getTag(Setup var1);

    private String getXMLOpenTag(Setup setup) {
        String text = "<" + this.getTag(setup);
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            text = String.valueOf(text) + " " + entry.getKey() + "=\"" + entry.getValue() + "\"";
        }
        text = String.valueOf(text) + ">";
        return text;
    }

    protected void updateAttributes(Setup setup) {
        if (!this.fromXML && setup.isAnnotatorIDSet() && setup.isAnnotatorIDAttributeSet()) {
            this.setAttribute(setup.getAnnotatorIDAttribute(), setup.getAnnotatorID());
        }
    }

    private String getXMLCloseTag(Setup setup) {
        return "</" + this.getTag(setup) + ">";
    }

    protected void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    protected String getAttributeValue(String name) {
        return this.attributes.get(name);
    }

    protected boolean isAttributePresent(String name) {
        return this.attributes.containsKey(name);
    }

    protected boolean isXMLRequired() {
        return this.isXMLRequired;
    }

    public void insertXMLTags(Document doc, Setup setup) throws BadLocationException {
        if (this.isXMLRequired()) {
            this.updateAttributes(setup);
            String openTag = this.getXMLOpenTag(setup);
            String closeTag = this.getXMLCloseTag(setup);
            this.lastOpenTagLength = openTag.length();
            this.lastCloseTagLength = closeTag.length();
            doc.insertString(this.getStartOffset(), openTag, null);
            doc.insertString(this.getEndOffset(), closeTag, null);
        }
    }

    public void removeLastXMLTags(Document doc) throws BadLocationException {
        if (this.isXMLRequired()) {
            doc.remove(this.getStartOffset() - this.lastOpenTagLength, this.lastOpenTagLength);
            doc.remove(this.getEndOffset() - this.lastCloseTagLength, this.lastCloseTagLength);
        }
    }
}

