/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.swing.text.Position;
import model.doc.DocumentElement;

public class DocumentElementList<E extends DocumentElement>
implements DocumentElement.DocumentElementStartMovedListener {
    private final TreeMap<Position, E> elements = new TreeMap(new PosCompare());
    private final Collection<ListChangeListener> changeListeners = new ArrayList<ListChangeListener>();

    public void clear() {
        for (DocumentElement element : this.elements.values()) {
            element.removeStartMoveListener(this);
        }
        this.elements.clear();
        this.fireChangeEvent();
    }

    public E getFirstElement() {
        if (!this.isEmpty()) {
            return (E)((DocumentElement)this.elements.firstEntry().getValue());
        }
        return null;
    }

    public E getElementWithStart(Position start) {
        return (E)((DocumentElement)this.elements.get(start));
    }

    public E getElementAt(Position pos) {
        Position closestKey = this.elements.floorKey(pos);
        if (closestKey == null) {
            return null;
        }
        DocumentElement element = (DocumentElement)this.elements.get(closestKey);
        if (element.containsPosition(pos.getOffset())) {
            return (E)element;
        }
        return null;
    }

    public List<E> getElementsInSpan(Position start, Position end) {
        NavigableMap<Position, E> betweenElements = this.elements.subMap(start, false, end, false);
        ArrayList<Object> toReturn = new ArrayList<Object>();
        E startWord = this.getElementAt(start);
        if (startWord != null) {
            toReturn.add(startWord);
        }
        toReturn.addAll(betweenElements.values());
        return toReturn;
    }

    public E getPreviousElement(Position startPos) {
        Map.Entry<Position, E> entry = this.elements.lowerEntry(startPos);
        if (entry != null) {
            return (E)((DocumentElement)entry.getValue());
        }
        return null;
    }

    public boolean isThereAnElementAt(Position pos) {
        return this.getElementAt(pos) != null;
    }

    public boolean areThereAnyElementsBetween(Position start, Position end) {
        return !this.getElementsInSpan(start, end).isEmpty();
    }

    public E put(Position pos, E element) {
        DocumentElement removed = (DocumentElement)this.elements.put(pos, element);
        if (removed != null && removed != element) {
            removed.removeStartMoveListener(this);
        }
        if (removed == null || removed != element) {
            ((DocumentElement)element).addStartMoveListener(this);
        }
        this.fireChangeEvent();
        return (E)removed;
    }

    public E remove(Position pos) {
        DocumentElement removed = (DocumentElement)this.elements.remove(pos);
        if (removed != null) {
            removed.removeStartMoveListener(this);
        }
        this.fireChangeEvent();
        return (E)removed;
    }

    public Collection<E> values() {
        return this.elements.values();
    }

    public Collection<E> backwardsValues() {
        return this.elements.descendingMap().values();
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public void elementStartMoved(Position oldStart, Position newStart) {
        DocumentElement removed = (DocumentElement)this.elements.remove(oldStart);
        this.elements.put(newStart, removed);
        this.fireChangeEvent();
    }

    public void addChangeListener(ListChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ListChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    public void fireChangeEvent() {
        for (ListChangeListener changeListener : this.changeListeners) {
            changeListener.listChanged();
        }
    }

    public static interface ListChangeListener {
        public void listChanged();
    }

    private static class PosCompare
    implements Comparator<Position> {
        private PosCompare() {
        }

        @Override
        public int compare(Position p1, Position p2) {
            return p1.getOffset() - p2.getOffset();
        }
    }
}

