/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;

public abstract class DocumentElement
implements Comparable<DocumentElement> {
    private Position start;
    private Position end;
    private final String text;
    private Object highlightTag;
    private final Collection<DocumentElementStartMovedListener> startMoveListeners;
    private int startInt = -1;

    protected DocumentElement(Position start, Position end, String text) {
        if (start == null) {
            throw new NullPointerException("Document Element start null");
        }
        if (end == null) {
            throw new NullPointerException("Document Element end null");
        }
        if (text == null) {
            throw new NullPointerException("Document Element text null");
        }
        this.start = start;
        this.end = end;
        this.text = text;
        this.highlightTag = null;
        this.startMoveListeners = new ArrayList<DocumentElementStartMovedListener>();
    }

    public Position getStart() {
        return this.start;
    }

    public int getStartOffset() {
        return this.start.getOffset();
    }

    public Position getEnd() {
        return this.end;
    }

    public int getEndOffset() {
        return this.end.getOffset();
    }

    public boolean saveStart() {
        if (this.startInt == -1) {
            this.startInt = this.start.getOffset();
            return true;
        }
        return false;
    }

    public boolean restoreStart(StyledDocument doc, int offset) throws BadLocationException {
        if (this.startInt != -1) {
            Position newStart = doc.createPosition(this.startInt + offset);
            if (newStart.getOffset() != this.start.getOffset()) {
                this.startMoved(this.start, newStart);
                this.start = newStart;
            }
            this.startInt = -1;
            return true;
        }
        return false;
    }

    public boolean restoreStartAndEnd(StyledDocument doc, int offset) throws BadLocationException {
        if (this.startInt != -1) {
            Position newStart = doc.createPosition(this.startInt + offset);
            if (newStart.getOffset() != this.start.getOffset()) {
                this.startMoved(this.start, newStart);
                this.start = newStart;
            }
            this.end = doc.createPosition(this.getStartOffset() + this.getDisplayString().length());
            this.startInt = -1;
            return true;
        }
        return false;
    }

    public void restoreEnd(StyledDocument doc) throws BadLocationException {
        this.end = doc.createPosition(this.getStartOffset() + this.getDisplayString().length());
    }

    public String toString() {
        return String.valueOf(this.start.getOffset()) + "-" + this.end.getOffset() + ": " + this.text;
    }

    public String getDisplayString() {
        return this.text;
    }

    @Override
    public int compareTo(DocumentElement another) {
        return new Integer(this.getStartOffset()).compareTo(new Integer(another.getStartOffset()));
    }

    public boolean equals(DocumentElement another) {
        return this.compareTo(another) == 0;
    }

    public int compareAlphabeticallyTo(DocumentElement other) {
        return this.getDisplayString().compareToIgnoreCase(other.getDisplayString());
    }

    public boolean containsPosition(int caretPosition) {
        return caretPosition >= this.getStartOffset() && caretPosition < this.getEndOffset();
    }

    public void changeStyleAttributes(StyledDocument doc, AttributeSet atts) {
        doc.setCharacterAttributes(this.getStartOffset(), this.getEndOffset() - this.getStartOffset(), atts, false);
    }

    public void changeHighlight(Highlighter highlighter, Highlighter.HighlightPainter painter) throws BadLocationException {
        this.removeHighlight(highlighter);
        this.highlightTag = highlighter.addHighlight(this.getStartOffset(), this.getEndOffset(), painter);
    }

    public void removeHighlight(Highlighter highlighter) {
        if (this.highlightTag != null) {
            highlighter.removeHighlight(this.highlightTag);
            this.highlightTag = null;
        }
    }

    public String getText() {
        return this.text;
    }

    public void addStartMoveListener(DocumentElementStartMovedListener startMoveListener) {
        this.startMoveListeners.add(startMoveListener);
    }

    public void removeStartMoveListener(DocumentElementStartMovedListener startMoveListener) {
        this.startMoveListeners.remove(startMoveListener);
    }

    public void startMoved(Position oldStart, Position newStart) {
        for (DocumentElementStartMovedListener moveListener : this.startMoveListeners) {
            moveListener.elementStartMoved(oldStart, newStart);
        }
    }

    public static interface DocumentElementStartMovedListener {
        public void elementStartMoved(Position var1, Position var2);
    }
}

