/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Pattern;
import model.IgnoreCaseComparator;

public class Setup {
    public static final String DEFAULT_LINE_BREAK_MARKER = "[lb]";
    private File folder;
    private String setupName;
    private File trainingFolder;
    private Pattern wordPattern;
    private String encoding;
    private String annotatorID;
    private String annotatorIDAttribute;
    private String foreignTag;
    private String foreignLanguageAttribute;
    private String normalisedTag;
    private String normalisedOriginalAttribute;
    private String normalisedAutoAttribute;
    private String variantTag;
    private String notvariantTag;
    private String joinTag;
    private String joinOriginalAttribute;
    private String joinLineBreakMarker;
    private String partitionTag;
    private String partitionSequenceAttribute;
    private String partitionCountAttribute;
    private String partitionStateAttribute;
    private final SortedMap<String, Boolean> languages = new TreeMap<String, Boolean>(new IgnoreCaseComparator());
    private final SortedMap<String, String> entities = new TreeMap<String, String>();
    private final LinkedHashMap<String, String> alwaysApplyRules = new LinkedHashMap();
    private final List<Pattern> ignoredPatterns = new ArrayList<Pattern>();
    private final Collection<Pattern> variantOverridePatterns = new ArrayList<Pattern>();
    private final Collection<Pattern> nonvariantOverridePatterns = new ArrayList<Pattern>();
    private static LinkedHashMap<String, String> previousSetups = null;

    public Setup(File folder) {
        this.folder = folder;
    }

    public Setup() {
        this.folder = new File("default");
        if (this.folder.exists()) {
            try {
                this.setupName = Setup.getSetupNameFromFolder(this.folder);
                if (this.setupName == null) {
                    this.setupName = "default";
                }
            }
            catch (IOException ex) {
                this.setupName = "default";
            }
        } else {
            this.setupName = "default";
        }
        this.trainingFolder = new File(this.folder, "training");
        this.wordPattern = Pattern.compile("[\\p{L}\\'\\-\\^~=]+");
        this.encoding = "detect";
        this.annotatorID = "";
        this.annotatorIDAttribute = "a_id";
        this.normalisedTag = "normalised";
        this.normalisedOriginalAttribute = "orig";
        this.normalisedAutoAttribute = "auto";
        this.variantTag = "variant";
        this.notvariantTag = "notvariant";
        this.foreignTag = "foreign";
        this.foreignLanguageAttribute = "lang";
        this.joinTag = "join";
        this.joinOriginalAttribute = "original";
        this.joinLineBreakMarker = DEFAULT_LINE_BREAK_MARKER;
        this.partitionTag = "vard:partition";
        this.partitionSequenceAttribute = "seq";
        this.partitionCountAttribute = "words";
        this.partitionStateAttribute = "state";
        this.entities.put("&apos;", "'");
        this.entities.put("&quot;", "\"");
        this.entities.put("&amp;", "&");
        this.entities.put("&lt;", "<");
        this.entities.put("&gt;", ">");
        this.alwaysApplyRules.put("\u017f", "s");
        this.ignoredPatterns.add(Pattern.compile("<[^>]*>", 32));
        this.ignoredPatterns.add(Pattern.compile("\\[[^\\]]*\\]", 32));
        this.ignoredPatterns.add(Pattern.compile("\\{[^\\}]*\\}", 32));
    }

    public void writeToFiles() throws IOException {
        this.folder.mkdirs();
        this.writeOptionsFile();
        this.writeAnnotationsFile();
        this.writeLanguagesFile();
        this.writeEntitiesFile();
        this.writeAlwaysRulesFile();
        this.writePatternsListToFile("text_to_ignore.txt", this.ignoredPatterns);
        this.writePatternsListToFile("variant_overrides.txt", this.variantOverridePatterns);
        this.writePatternsListToFile("nonvariant_overrides.txt", this.nonvariantOverridePatterns);
    }

    private void writeOptionsFile() throws IOException {
        File optionsFile = new File(this.folder, "options.txt");
        optionsFile.createNewFile();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(optionsFile), "UTF-8"));
        try {
            writer.println("setup_name\t" + this.setupName);
            writer.println("training_folder\t" + this.getRelativeTrainingFolderString());
            writer.println("encoding\t" + this.encoding);
            writer.println("word_regex\t" + this.wordPattern.pattern());
            writer.println("annotator_id\t" + this.annotatorID);
        }
        finally {
            writer.close();
        }
    }

    private void writeAnnotationsFile() throws IOException {
        File annotationsFile = new File(this.folder, "annotations.txt");
        annotationsFile.createNewFile();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(annotationsFile), "UTF-8"));
        try {
            writer.println("annotator_id_attribute\t" + this.annotatorIDAttribute);
            writer.println("normalised_tag\t" + this.normalisedTag);
            writer.println("normalised_original_attribute\t" + this.normalisedOriginalAttribute);
            writer.println("normalised_auto_attribute\t" + this.normalisedAutoAttribute);
            writer.println("variant_tag\t" + this.variantTag);
            writer.println("notvariant_tag\t" + this.notvariantTag);
            writer.println("foreign_tag\t" + this.foreignTag);
            writer.println("foreign_language_attribute\t" + this.foreignLanguageAttribute);
            writer.println("join_tag\t" + this.joinTag);
            writer.println("join_original_attribute\t" + this.joinOriginalAttribute);
            writer.println("join_linebreak_marker\t" + this.joinLineBreakMarker);
            writer.println("partition_tag\t" + this.partitionTag);
            writer.println("partition_sequence_attribute\t" + this.partitionSequenceAttribute);
            writer.println("partition_count_attribute\t" + this.partitionCountAttribute);
            writer.println("partition_state_attribute\t" + this.partitionStateAttribute);
        }
        finally {
            writer.close();
        }
    }

    private void writeLanguagesFile() throws IOException {
        File languagesFile = new File(this.folder, "languages.txt");
        languagesFile.createNewFile();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(languagesFile), "UTF-8"));
        try {
            for (Map.Entry<String, Boolean> pair : this.languages.entrySet()) {
                writer.println(String.valueOf(pair.getKey()) + "\t" + (pair.getValue() != false ? "process" : "ignore"));
            }
        }
        finally {
            writer.close();
        }
    }

    private void writeEntitiesFile() throws IOException {
        File entitiesFile = new File(this.folder, "entities.txt");
        entitiesFile.createNewFile();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(entitiesFile), "UTF-8"));
        try {
            for (Map.Entry<String, String> pair : this.entities.entrySet()) {
                writer.println(String.valueOf(pair.getKey()) + "\t" + pair.getValue());
            }
        }
        finally {
            writer.close();
        }
    }

    private void writeAlwaysRulesFile() throws IOException {
        File alwaysRulesFile = new File(this.folder, "alwaysrules.txt");
        alwaysRulesFile.createNewFile();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(alwaysRulesFile), "UTF-8"));
        try {
            for (Map.Entry<String, String> pair : this.alwaysApplyRules.entrySet()) {
                writer.println(String.valueOf(pair.getKey()) + "\t" + pair.getValue());
            }
        }
        finally {
            writer.close();
        }
    }

    private void writePatternsListToFile(String filename, Collection<Pattern> patterns) throws IOException {
        File patternFile = new File(this.folder, filename);
        patternFile.createNewFile();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(patternFile), "UTF-8"));
        try {
            for (Pattern pattern : patterns) {
                writer.println(pattern.pattern());
            }
        }
        finally {
            writer.close();
        }
    }

    public void readFromFolder(File folder) throws IOException {
        this.folder = folder;
        this.trainingFolder = new File(folder, "training");
        folder.mkdirs();
        this.readOptionsFile();
        this.readAnnotationsFile();
        this.readLanguagesFile();
        this.readEntitiesFile();
        this.readAlwaysRulesFile();
        this.readPatternListFile("text_to_ignore.txt", this.ignoredPatterns);
        this.readPatternListFile("variant_overrides.txt", this.variantOverridePatterns);
        this.readPatternListFile("nonvariant_overrides.txt", this.nonvariantOverridePatterns);
        Setup.addToPreviousSetups(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readOptionsFile() throws IOException {
        boolean saveOptions;
        block12: {
            File optionsFile = new File(this.folder, "options.txt");
            saveOptions = false;
            if (optionsFile.exists()) {
                LineNumberReader optionsIn = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(optionsFile), "UTF-8"));
                try {
                    int fieldsFound = 0;
                    boolean setupNameSet = false;
                    while (true) {
                        String currentLine;
                        if ((currentLine = optionsIn.readLine()) == null) {
                            if (fieldsFound == 5) break block12;
                            saveOptions = true;
                            if (!setupNameSet) {
                                this.setupName = this.folder.getName();
                            }
                            break block12;
                        }
                        String[] currentLineArray = currentLine.split("\t");
                        if (currentLineArray.length <= 1) continue;
                        String field = currentLineArray[0].trim();
                        String value = currentLineArray[1].trim();
                        if (field.equals("setup_name")) {
                            this.setupName = value;
                            ++fieldsFound;
                            setupNameSet = true;
                            continue;
                        }
                        if (field.equals("training_folder")) {
                            this.setTrainingFolder(value);
                            ++fieldsFound;
                            continue;
                        }
                        if (field.equals("encoding")) {
                            this.encoding = value;
                            ++fieldsFound;
                            continue;
                        }
                        if (field.equals("word_regex")) {
                            this.wordPattern = Pattern.compile(value);
                            ++fieldsFound;
                            continue;
                        }
                        if (!field.equals("annotator_id")) continue;
                        this.annotatorID = value;
                        ++fieldsFound;
                    }
                }
                finally {
                    optionsIn.close();
                }
            }
            saveOptions = true;
        }
        if (saveOptions) {
            this.writeOptionsFile();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readAnnotationsFile() throws IOException {
        boolean saveAnnotations;
        block22: {
            File annotationsFile = new File(this.folder, "annotations.txt");
            saveAnnotations = false;
            if (annotationsFile.exists()) {
                LineNumberReader annotationsIn = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(annotationsFile), "UTF-8"));
                try {
                    int fieldsFound = 0;
                    while (true) {
                        String currentLine;
                        if ((currentLine = annotationsIn.readLine()) == null) {
                            if (fieldsFound != 15) {
                                saveAnnotations = true;
                            }
                            break block22;
                        }
                        String[] currentLineArray = currentLine.split("\t");
                        if (currentLineArray.length <= 1) continue;
                        String field = currentLineArray[0].trim();
                        String value = currentLineArray[1].trim();
                        if (field.equals("annotator_id_attribute")) {
                            this.annotatorIDAttribute = value;
                            ++fieldsFound;
                            continue;
                        }
                        if (field.equals("normalised_tag")) {
                            this.normalisedTag = value;
                            ++fieldsFound;
                            continue;
                        }
                        if (field.equals("normalised_original_attribute")) {
                            this.normalisedOriginalAttribute = value;
                            ++fieldsFound;
                            continue;
                        }
                        if (field.equals("normalised_auto_attribute")) {
                            this.normalisedAutoAttribute = value;
                            ++fieldsFound;
                            continue;
                        }
                        if (field.equals("variant_tag")) {
                            this.variantTag = value;
                            ++fieldsFound;
                            continue;
                        }
                        if (field.equals("notvariant_tag")) {
                            this.notvariantTag = value;
                            ++fieldsFound;
                            continue;
                        }
                        if (field.equals("foreign_tag")) {
                            this.foreignTag = value;
                            ++fieldsFound;
                            continue;
                        }
                        if (field.equals("foreign_language_attribute")) {
                            this.foreignLanguageAttribute = value;
                            ++fieldsFound;
                            continue;
                        }
                        if (field.equals("join_tag")) {
                            this.joinTag = value;
                            ++fieldsFound;
                            continue;
                        }
                        if (field.equals("join_original_attribute")) {
                            this.joinOriginalAttribute = value;
                            ++fieldsFound;
                            continue;
                        }
                        if (field.equals("join_linebreak_marker")) {
                            this.joinLineBreakMarker = value;
                            ++fieldsFound;
                            continue;
                        }
                        if (field.equals("partition_tag")) {
                            this.partitionTag = value;
                            ++fieldsFound;
                            continue;
                        }
                        if (field.equals("partition_sequence_attribute")) {
                            this.partitionSequenceAttribute = value;
                            ++fieldsFound;
                            continue;
                        }
                        if (field.equals("partition_count_attribute")) {
                            this.partitionCountAttribute = value;
                            ++fieldsFound;
                            continue;
                        }
                        if (!field.equals("partition_state_attribute")) continue;
                        this.partitionStateAttribute = value;
                        ++fieldsFound;
                    }
                }
                finally {
                    annotationsIn.close();
                }
            }
            saveAnnotations = true;
        }
        if (saveAnnotations) {
            this.writeAnnotationsFile();
        }
    }

    private void readLanguagesFile() throws IOException {
        File languagesFile = new File(this.folder, "languages.txt");
        if (languagesFile.exists()) {
            LineNumberReader languagesIn = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(languagesFile), "UTF-8"));
            try {
                String currentLine;
                this.languages.clear();
                while ((currentLine = languagesIn.readLine()) != null) {
                    String[] currentLineArray = currentLine.split("\t");
                    if (currentLineArray.length <= 1) continue;
                    this.languages.put(currentLineArray[0], currentLineArray[1].equalsIgnoreCase("process"));
                }
            }
            finally {
                languagesIn.close();
            }
        } else {
            this.writeLanguagesFile();
        }
    }

    private void readEntitiesFile() throws IOException {
        File entitiesFile = new File(this.folder, "entities.txt");
        if (entitiesFile.exists()) {
            LineNumberReader entitiesIn = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(entitiesFile), "UTF-8"));
            try {
                String currentLine;
                this.entities.clear();
                while ((currentLine = entitiesIn.readLine()) != null) {
                    String[] currentLineArray = currentLine.split("\t");
                    if (currentLineArray.length <= 1) continue;
                    this.entities.put(currentLineArray[0], currentLineArray[1]);
                }
            }
            finally {
                entitiesIn.close();
            }
        } else {
            this.writeEntitiesFile();
        }
    }

    private void readAlwaysRulesFile() throws IOException {
        File alwaysRulesFile = new File(this.folder, "alwaysrules.txt");
        if (alwaysRulesFile.exists()) {
            LineNumberReader rulesIn = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(alwaysRulesFile), "UTF-8"));
            try {
                String currentLine;
                this.alwaysApplyRules.clear();
                while ((currentLine = rulesIn.readLine()) != null) {
                    String[] currentLineArray = currentLine.split("\t");
                    if (currentLineArray.length <= 1) continue;
                    this.alwaysApplyRules.put(currentLineArray[0], currentLineArray[1]);
                }
            }
            finally {
                rulesIn.close();
            }
        } else {
            this.writeAlwaysRulesFile();
        }
    }

    private void readPatternListFile(String filename, Collection<Pattern> patterns) throws IOException {
        File patternsFile = new File(this.folder, filename);
        if (patternsFile.exists()) {
            patterns.clear();
            LineNumberReader patternsIn = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(patternsFile), "UTF-8"));
            try {
                String currentLine;
                while ((currentLine = patternsIn.readLine()) != null) {
                    patterns.add(Pattern.compile(currentLine.trim()));
                }
            }
            finally {
                patternsIn.close();
            }
        } else {
            this.writePatternsListToFile(filename, patterns);
        }
    }

    public File getFolder() {
        return this.folder;
    }

    public File getTrainingFolder() {
        return this.trainingFolder;
    }

    public String getRelativeTrainingFolderString() {
        return this.getRelativeFolderString(this.trainingFolder.getAbsolutePath());
    }

    public String getRelativeFolderString(String path) {
        String folderPath = this.folder.getAbsolutePath();
        return path.replace(folderPath, "");
    }

    public void setTrainingFolder(String pathString) {
        File combinedFile = new File(this.folder, pathString);
        this.trainingFolder = combinedFile.isDirectory() ? combinedFile : new File(pathString);
    }

    public String getSetupName() {
        return this.setupName;
    }

    public void setSetupName(String setupName) {
        this.setupName = setupName;
    }

    public Pattern getWordPattern() {
        return this.wordPattern;
    }

    public void setWordPattern(Pattern wordPattern) {
        this.wordPattern = wordPattern;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getAnnotatorID() {
        return this.annotatorID;
    }

    public void setAnnotatorID(String annotatorID) {
        this.annotatorID = annotatorID;
    }

    public boolean isAnnotatorIDSet() {
        return !this.annotatorID.isEmpty();
    }

    public Set<String> getLanguages() {
        return this.languages.keySet();
    }

    public void setLanguages(Map<String, Boolean> languages) {
        this.languages.clear();
        for (Map.Entry<String, Boolean> entry : languages.entrySet()) {
            this.languages.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean isLanguageToProcess(String lang) {
        if (lang == null) {
            return false;
        }
        Boolean process = (Boolean)this.languages.get(lang);
        if (process == null) {
            return false;
        }
        return process;
    }

    public String getAnnotatorIDAttribute() {
        return this.annotatorIDAttribute;
    }

    public boolean isAnnotatorIDAttributeSet() {
        return !this.annotatorIDAttribute.isEmpty();
    }

    public String getForeignTag() {
        return this.foreignTag;
    }

    public String getForeignLanguageAttribute() {
        return this.foreignLanguageAttribute;
    }

    public String getNormalisedTag() {
        return this.normalisedTag;
    }

    public String getNormalisedOriginalAttribute() {
        return this.normalisedOriginalAttribute;
    }

    public String getNormalisedAutoAttribute() {
        return this.normalisedAutoAttribute;
    }

    public boolean isNormalisedAutoAttributeSet() {
        return !this.normalisedAutoAttribute.isEmpty();
    }

    public String getVariantTag() {
        return this.variantTag;
    }

    public String getNotvariantTag() {
        return this.notvariantTag;
    }

    public String getJoinTag() {
        return this.joinTag;
    }

    public String getJoinOriginalAttribute() {
        return this.joinOriginalAttribute;
    }

    public String getJoinLineBreakMarker() {
        return this.joinLineBreakMarker;
    }

    public void setJoinLineBreakMarker(String joinLineBreakMarker) {
        this.joinLineBreakMarker = joinLineBreakMarker;
    }

    public SortedMap<String, String> getEntities() {
        return this.entities;
    }

    public void setEntities(SortedMap<String, String> entities) {
        this.entities.clear();
        this.entities.putAll(entities);
    }

    public LinkedHashMap<String, String> getAlwaysApplyRules() {
        return this.alwaysApplyRules;
    }

    public void setAlwaysApplyRules(LinkedHashMap<String, String> alwaysApplyRules) {
        this.alwaysApplyRules.clear();
        this.alwaysApplyRules.putAll(alwaysApplyRules);
    }

    public List<Pattern> getIgnoredPatterns() {
        return this.ignoredPatterns;
    }

    public void setIgnoredPatterns(List<Pattern> ignoredPatterns) {
        this.ignoredPatterns.clear();
        this.ignoredPatterns.addAll(ignoredPatterns);
    }

    public Collection<Pattern> getVariantOverridePatterns() {
        return this.variantOverridePatterns;
    }

    public void setVariantOverridePatterns(List<Pattern> variantOverridePatterns) {
        this.variantOverridePatterns.clear();
        this.variantOverridePatterns.addAll(variantOverridePatterns);
    }

    public Collection<Pattern> getNonvariantOverridePatterns() {
        return this.nonvariantOverridePatterns;
    }

    public void setNonvariantOverridePatterns(List<Pattern> nonvariantOverridePatterns) {
        this.nonvariantOverridePatterns.clear();
        this.nonvariantOverridePatterns.addAll(nonvariantOverridePatterns);
    }

    public boolean isVARDXMLTag(String tag) {
        if (tag.equals(this.getNormalisedTag())) {
            return true;
        }
        if (tag.equals(this.getVariantTag())) {
            return true;
        }
        if (tag.equals(this.getNotvariantTag())) {
            return true;
        }
        if (tag.equals(this.getJoinTag())) {
            return true;
        }
        if (tag.equals(this.getForeignTag())) {
            return true;
        }
        return tag.equals(this.getPartitionTag());
    }

    public static Vector<String> getPreviousSetupsList() throws IOException {
        if (previousSetups == null) {
            Setup.loadPreviousSetups();
        }
        Vector<String> setupsList = new Vector<String>();
        for (Map.Entry<String, String> entry : previousSetups.entrySet()) {
            setupsList.add(0, String.valueOf(entry.getKey()) + " : " + entry.getValue());
        }
        return setupsList;
    }

    private static void loadPreviousSetups() throws IOException {
        previousSetups = new LinkedHashMap();
        File setupsFile = new File("previous_setups.txt");
        if (setupsFile.exists()) {
            LineNumberReader setupsIn = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(setupsFile), "UTF-8"));
            try {
                String currentLine;
                while ((currentLine = setupsIn.readLine()) != null) {
                    String folderString = currentLine.trim();
                    File folder = new File(folderString);
                    if (!folder.isDirectory()) continue;
                    String name = Setup.getSetupNameFromFolder(folder);
                    previousSetups.put(folderString, name);
                }
            }
            finally {
                setupsIn.close();
            }
        }
        if (previousSetups.isEmpty()) {
            Setup defaultSetup = new Setup();
            previousSetups.put(defaultSetup.getFolder().getAbsolutePath(), defaultSetup.getSetupName());
        }
    }

    private static void addToPreviousSetups(Setup setup) throws IOException {
        if (previousSetups == null) {
            previousSetups = new LinkedHashMap();
        }
        String name = setup.getSetupName();
        String folder = setup.getFolder().getAbsolutePath();
        previousSetups.remove(folder);
        previousSetups.put(folder, name);
        Setup.savePreviousSetups();
    }

    private static void savePreviousSetups() throws IOException {
        File setupsFile = new File("previous_setups.txt");
        setupsFile.createNewFile();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(setupsFile), "UTF-8"));
        try {
            for (String folder : previousSetups.keySet()) {
                writer.println(folder);
            }
        }
        finally {
            writer.close();
        }
    }

    public static String getListStringFromFolder(File folder) throws IOException {
        String setupName = Setup.getSetupNameFromFolder(folder);
        return folder + " : " + setupName;
    }

    public String getListString() {
        return this.folder + " : " + this.setupName;
    }

    public static String getFolderFromListString(String listString) {
        String[] parts = listString.split(" : ");
        if (parts.length == 2) {
            return parts[0];
        }
        return null;
    }

    private static String getSetupNameFromFolder(File folder) throws IOException {
        File optionsFile = new File(folder, "options.txt");
        if (optionsFile.exists()) {
            LineNumberReader optionsIn = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(optionsFile), "UTF-8"));
            try {
                String currentLine;
                while ((currentLine = optionsIn.readLine()) != null) {
                    String field;
                    String[] currentLineArray = currentLine.split("\t");
                    if (currentLineArray.length <= 1 || !(field = currentLineArray[0]).equals("setup_name")) continue;
                    String string = currentLineArray[1].trim();
                    return string;
                }
            }
            finally {
                optionsIn.close();
            }
        }
        return "default";
    }

    public void setAnnotatorIDAttribute(String annotatorIDAttribute) {
        this.annotatorIDAttribute = annotatorIDAttribute;
    }

    public void setForeignTag(String foreignTag) {
        this.foreignTag = foreignTag;
    }

    public void setForeignLanguageAttribute(String foreignLanguageAttribute) {
        this.foreignLanguageAttribute = foreignLanguageAttribute;
    }

    public void setNormalisedTag(String normalisedTag) {
        this.normalisedTag = normalisedTag;
    }

    public void setNormalisedOriginalAttribute(String normalisedOriginalAttribute) {
        this.normalisedOriginalAttribute = normalisedOriginalAttribute;
    }

    public void setNormalisedAutoAttribute(String normalisedAutoAttribute) {
        this.normalisedAutoAttribute = normalisedAutoAttribute;
    }

    public void setVariantTag(String variantTag) {
        this.variantTag = variantTag;
    }

    public void setNotvariantTag(String notvariantTag) {
        this.notvariantTag = notvariantTag;
    }

    public void setJoinTag(String joinTag) {
        this.joinTag = joinTag;
    }

    public void setJoinOriginalAttribute(String joinOriginalAttribute) {
        this.joinOriginalAttribute = joinOriginalAttribute;
    }

    public String getPartitionTag() {
        return this.partitionTag;
    }

    public void setPartitionTag(String partitionTag) {
        this.partitionTag = partitionTag;
    }

    public String getPartitionSequenceAttribute() {
        return this.partitionSequenceAttribute;
    }

    public void setPartitionSequenceAttribute(String partitionSequenceAttribute) {
        this.partitionSequenceAttribute = partitionSequenceAttribute;
    }

    public String getPartitionCountAttribute() {
        return this.partitionCountAttribute;
    }

    public void setPartitionCountAttribute(String partitionCountAttribute) {
        this.partitionCountAttribute = partitionCountAttribute;
    }

    public String getPartitionStateAttribute() {
        return this.partitionStateAttribute;
    }

    public void setPartitionStateAttribute(String partitionStateAttribute) {
        this.partitionStateAttribute = partitionStateAttribute;
    }

    public Collection<String> getPartitionAttributes() {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(this.partitionCountAttribute);
        attributes.add(this.partitionStateAttribute);
        attributes.add(this.partitionSequenceAttribute);
        return attributes;
    }
}

