/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import model.ErrorMessageHandler;
import model.ProgressListener;

public class Globals
implements ProgressListener,
ErrorMessageHandler,
Thread.UncaughtExceptionHandler {
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static int PROGRESS_DELAY = 250;
    private static Globals _instance = null;
    private static int lockCount = 0;
    private static int keyCount = 0;
    private boolean stopProgressMessages = false;
    private int stopCount = 0;
    private int resumeCount = 0;
    private ProgressListener progressHandler;
    private String lastProgressMessage = "";
    private String progressMessagePrefix = "";
    private int lastProgressMax = 0;
    private boolean finishProgressLocked = false;
    private boolean inValuedProgress = false;
    private int currentProgress = 0;
    private Timer progressTimer;
    private ErrorMessageHandler errorHandler;
    private PrintStream errStream;

    protected Globals() {
        Thread.setDefaultUncaughtExceptionHandler(this);
        try {
            File errFile = new File("error_log.txt");
            errFile.createNewFile();
            this.errStream = new PrintStream(errFile);
            System.setErr(this.errStream);
        }
        catch (IOException ex) {
            this.showException("Error occurred creating ouput.txt", ex);
        }
        this.progressHandler = new ProgressListener(){

            @Override
            public void finishProgress() {
            }

            @Override
            public void setProgressCurrent(int current) {
            }

            @Override
            public void startIndeterminateProgress() {
            }

            @Override
            public void startProgress(int max) {
            }

            @Override
            public void terminateProgressDisplay() {
            }

            @Override
            public void writeProgressMessage(String message) {
            }
        };
        this.errorHandler = new ErrorMessageHandler(){

            @Override
            public void showException(String message, Throwable e) {
            }

            @Override
            public void showError(String message) {
            }
        };
        this.progressTimer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (Globals.this.inValuedProgress) {
                    Globals.this.progressHandler.setProgressCurrent(Globals.this.currentProgress);
                }
            }
        };
        this.progressTimer.schedule(task, PROGRESS_DELAY, (long)PROGRESS_DELAY);
    }

    public static Globals getInstance() {
        if (_instance == null) {
            _instance = new Globals();
        }
        return _instance;
    }

    public void setErrorHandler(ErrorMessageHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setProgressHandler(ProgressListener progressHandler) {
        ProgressListener previousPL = this.progressHandler;
        this.progressHandler = progressHandler;
        previousPL.finishProgress();
        previousPL.terminateProgressDisplay();
    }

    public void finalize() {
        this.progressTimer.cancel();
    }

    @Override
    public void finishProgress() {
        if (this.stopProgressMessages) {
            return;
        }
        this.inValuedProgress = false;
        this.lastProgressMax = 0;
        this.setProgressCurrent(0);
        this.writeProgressMessage("");
        if (!this.finishProgressLocked) {
            this.progressHandler.finishProgress();
        }
    }

    @Override
    public void setProgressCurrent(int current) {
        if (this.stopProgressMessages) {
            return;
        }
        this.currentProgress = current;
        if (current == 0) {
            this.progressHandler.setProgressCurrent(current);
        }
    }

    @Override
    public void startIndeterminateProgress() {
        if (this.stopProgressMessages) {
            return;
        }
        this.progressHandler.startIndeterminateProgress();
    }

    @Override
    public void startProgress(int max) {
        if (this.stopProgressMessages) {
            return;
        }
        this.inValuedProgress = true;
        this.setProgressCurrent(0);
        this.lastProgressMax = max;
        this.progressHandler.startProgress(max);
    }

    @Override
    public void terminateProgressDisplay() {
        this.finishProgress();
        this.progressHandler.terminateProgressDisplay();
    }

    @Override
    public void writeProgressMessage(String message) {
        if (this.stopProgressMessages) {
            return;
        }
        if (message.length() == 0) {
            this.lastProgressMessage = String.valueOf(this.lastProgressMessage) + " (cleared)";
            this.progressHandler.writeProgressMessage("");
        } else {
            this.lastProgressMessage = String.valueOf(this.progressMessagePrefix) + " " + message;
            this.progressHandler.writeProgressMessage(this.lastProgressMessage);
        }
    }

    @Override
    public void showException(String message, Throwable e) {
        System.err.println();
        System.err.println();
        System.err.println(new Date(System.currentTimeMillis()));
        System.err.println("Exception Occurred.");
        System.err.println();
        if (this.lastProgressMessage != "") {
            // empty if block
        }
        System.err.println("Last progress message: " + this.lastProgressMessage);
        if (this.lastProgressMax != 0) {
            System.err.println("Progress: " + this.currentProgress + "/" + this.lastProgressMax);
        }
        System.err.println();
        System.err.println("Exception message:");
        System.err.println(message);
        System.err.println();
        e.printStackTrace();
        this.errorHandler.showException(message, e);
    }

    @Override
    public void showError(String message) {
        this.errorHandler.showError(message);
    }

    public void setProgressMessagePrefix(String progressMessagePrefix) {
        this.progressMessagePrefix = progressMessagePrefix;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.showException("Uncaught Exception occurred in thread " + t.getName(), e);
    }

    public void stopProgressMessages() {
        this.stopProgressMessages = true;
        ++this.stopCount;
    }

    public void resumeProgressMessages() {
        ++this.resumeCount;
        if (this.resumeCount == this.stopCount) {
            this.stopProgressMessages = false;
        }
    }

    public void lockFinishProgress() {
        this.finishProgressLocked = true;
        ++lockCount;
    }

    public void unlockFinishProgress() {
        if (++keyCount == lockCount) {
            this.finishProgressLocked = false;
        }
    }
}

