/*
 * Decompiled with CFR 0.152.
 */
package gui.sidebar;

import gui.MarkAllFInstancesAsTAction;
import gui.MarkFInstanceAsTAction;
import gui.NormaliseAllInstancesOfVariantAction;
import gui.NormaliseToAction;
import gui.NormaliseVariantInstanceAction;
import gui.QuestionAsker;
import gui.sidebar.InstanceStepPanel;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.undo.UndoableEditSupport;
import model.Capitalisation;
import model.ConfidenceWeights;
import model.SuggestedReplacement;
import model.doc.DocumentModel;
import model.doc.Instance;
import model.doc.VariantInstance;
import model.lookup.LookUpDictionary;

public class VariantStepPanel
extends InstanceStepPanel
implements ActionListener {
    private static final long serialVersionUID = 3538050211560168605L;
    private JComboBox replacementsCB;
    private JButton[] buttons = new JButton[]{new JButton("Normalise instance"), new JButton("Normalise all"), new JButton("Normalise to..."), new JButton("Instance not variant"), new JButton("All not variant")};
    private boolean repPresent;
    private boolean currentEnabled = true;
    private final DocumentModel docModel;
    private final ConfidenceWeights confidenceWeights;
    private final LookUpDictionary lud;
    private final UndoableEditSupport undoSupport;
    private final QuestionAsker questionAsker;

    public VariantStepPanel(DocumentModel docModel, LookUpDictionary lud, ConfidenceWeights confidenceWeights, UndoableEditSupport undoSupport, QuestionAsker questionAsker) {
        this.docModel = docModel;
        this.confidenceWeights = confidenceWeights;
        this.lud = lud;
        this.undoSupport = undoSupport;
        this.questionAsker = questionAsker;
        this.setLayout(new GridLayout(6, 1));
        this.replacementsCB = new JComboBox();
        this.add(this.replacementsCB);
        JButton[] jButtonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            JButton button = jButtonArray[n2];
            button.addActionListener(this);
            this.add(button);
            ++n2;
        }
    }

    @Override
    public void changeInstance(Instance instance) {
        super.changeInstance(instance);
        this.replacementsCB.removeAllItems();
        this.docModel.findReplacementsForWord(this.currentWH, 25);
        List<SuggestedReplacement> reps = this.currentWH.getReplacements();
        Capitalisation.CapType capitalisation = this.currentInstance.getCapitalisation();
        this.replacementsCB.setModel(new DefaultComboBoxModel<Object>(reps.toArray()));
        this.replacementsCB.setRenderer(new SRListCellRenderer(capitalisation));
        boolean bl = this.repPresent = !reps.isEmpty();
        if (this.currentEnabled) {
            this.buttons[0].setEnabled(this.repPresent);
            this.buttons[1].setEnabled(this.repPresent);
        }
    }

    @Override
    public void emptyInstance() {
        super.emptyInstance();
        this.replacementsCB.setModel(new DefaultComboBoxModel());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.currentEnabled = enabled;
        JButton[] jButtonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            JButton button = jButtonArray[n2];
            button.setEnabled(enabled);
            ++n2;
        }
        if (enabled) {
            this.buttons[0].setEnabled(this.repPresent);
            this.buttons[1].setEnabled(this.repPresent);
        }
        this.replacementsCB.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int buttonNumber = -1;
        int i = 0;
        while (i < this.buttons.length) {
            if (e.getSource().equals(this.buttons[i])) {
                buttonNumber = i;
            }
            ++i;
        }
        switch (buttonNumber) {
            case 0: {
                new NormaliseVariantInstanceAction<VariantInstance>((VariantInstance)this.currentInstance, (SuggestedReplacement)this.replacementsCB.getSelectedItem(), this.docModel, this.lud, this.undoSupport).actionPerformed(e);
                break;
            }
            case 1: {
                new NormaliseAllInstancesOfVariantAction(this.currentWH, 101, (SuggestedReplacement)this.replacementsCB.getSelectedItem(), this.docModel, this.lud, this.undoSupport).actionPerformed(e);
                break;
            }
            case 2: {
                new NormaliseToAction<VariantInstance>((VariantInstance)this.currentInstance, this.docModel, this.lud, this.confidenceWeights, this.undoSupport, this.questionAsker).actionPerformed(e);
                break;
            }
            case 3: {
                new MarkFInstanceAsTAction((VariantInstance)this.currentInstance, 103, this.undoSupport).actionPerformed(e);
                break;
            }
            case 4: {
                new MarkAllFInstancesAsTAction(this.currentWH, 101, 103, this.docModel, this.undoSupport, this.questionAsker).actionPerformed(e);
            }
        }
    }

    private final class SRListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -6440087879734210301L;
        private Capitalisation.CapType capitalisation;

        private SRListCellRenderer(Capitalisation.CapType capitalisation) {
            this.setOpaque(true);
            this.capitalisation = capitalisation;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            if (value == null) {
                this.setText("");
            } else if (value.getClass().equals(SuggestedReplacement.class)) {
                this.setText(((SuggestedReplacement)value).toMenuString(this.capitalisation));
            } else {
                this.setText(value.toString());
            }
            return this;
        }
    }
}

