/*
 * Decompiled with CFR 0.152.
 */
package gui.sidebar;

import gui.MainScreen;
import gui.NoAction;
import gui.TBJButton;
import gui.TBJToggleButton;
import gui.sidebar.ClearListAction;
import gui.sidebar.RemoveSelectedFromListAction;
import gui.sidebar.SideBarPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import model.ConfidenceWeights;
import model.Globals;
import model.Setup;
import model.doc.DocumentModel;
import model.doc.InvalidInstanceChangeException;
import model.lookup.LookUpDictionary;

public class TrainingScreenSideBar
extends SideBarPanel {
    private static final long serialVersionUID = -4529991045828763351L;
    private final HashMap<String, Action> actions;
    private final JList fileList;
    private final TreeSet<File> files;
    private final JFileChooser fc;
    private final JCheckBox addXMLRepsToDictionaryCheckBox;
    private final JToggleButton searchSubFoldersTB;
    private final Globals global;
    private final ConfidenceWeights confidenceWeights;
    private final LookUpDictionary lud;
    private Setup setup;
    private final JFrame owner;

    public TrainingScreenSideBar(JFrame owner, ConfidenceWeights confidenceWeights, LookUpDictionary lud, Setup setup) {
        this.owner = owner;
        this.confidenceWeights = confidenceWeights;
        this.lud = lud;
        this.setup = setup;
        this.global = Globals.getInstance();
        this.files = new TreeSet();
        this.fileList = new JList<Object>(this.files.toArray());
        this.fileList.setVisibleRowCount(15);
        this.fileList.setTransferHandler(new AddTransferHandler());
        JScrollPane fileListSP = new JScrollPane(this.fileList, 22, 32);
        this.actions = new HashMap();
        this.actions.put("Add Files", MainScreen.fixAction(new AddFilesAction(), "Add File(s)", "page_white_add", "Add file(s).", -1, null));
        this.actions.put("Add Folders", MainScreen.fixAction(new AddFoldersAction(), "Add Folder(s)", "folder_add", "Add folder(s).", -1, null));
        this.actions.put("Remove Files", MainScreen.fixAction(new RemoveSelectedFromListAction(this.fileList, this.files), "Remove File(s)", "table_row_delete", "Remove selected file(s).", -1, null));
        this.actions.put("Clear List", MainScreen.fixAction(new ClearListAction(this.fileList, this.files), "Clear List", "table_delete", "Clear list.", -1, null));
        this.actions.put("Process List", MainScreen.fixAction(new ProcessListAction(), "Train from file(s)", null, null, -1, null));
        this.actions.put("Search Subfolders", MainScreen.fixAction(new NoAction(), "Search subfolders", "folder_find", "Search subfolders?", -1, null));
        JToolBar inputButtonsToolBar = new JToolBar(1);
        inputButtonsToolBar.setFloatable(false);
        inputButtonsToolBar.add(new TBJButton(this.getActionByName("Add Files")));
        inputButtonsToolBar.add(new TBJButton(this.getActionByName("Add Folders")));
        inputButtonsToolBar.add(new TBJButton(this.getActionByName("Remove Files")));
        inputButtonsToolBar.add(new TBJButton(this.getActionByName("Clear List")));
        this.searchSubFoldersTB = new TBJToggleButton(this.getActionByName("Search Subfolders"));
        inputButtonsToolBar.add(this.searchSubFoldersTB);
        JPanel inputPanel = new JPanel(new BorderLayout());
        inputPanel.setBorder(BorderFactory.createTitledBorder("Files"));
        inputPanel.add((Component)fileListSP, "Center");
        inputPanel.add((Component)inputButtonsToolBar, "East");
        JPanel setupPanel = new JPanel(new BorderLayout());
        setupPanel.setBorder(BorderFactory.createTitledBorder("Training setup"));
        this.addXMLRepsToDictionaryCheckBox = new JCheckBox();
        setupPanel.add((Component)this.addXMLRepsToDictionaryCheckBox, "West");
        setupPanel.add((Component)new JLabel("<html>Add normalisations to words list?</html>"), "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)setupPanel, "Center");
        bottomPanel.add((Component)new JButton(this.getActionByName("Process List")), "South");
        this.setLayout(new BorderLayout());
        this.add((Component)inputPanel, "Center");
        this.add((Component)bottomPanel, "South");
        this.fc = new JFileChooser();
    }

    @Override
    public void changeSetup(Setup setup) {
        this.setup = setup;
    }

    private Action getActionByName(String name) {
        return this.actions.get(name);
    }

    @Override
    public void setEnabled(boolean e) {
        for (Action a : this.actions.values()) {
            a.setEnabled(e);
        }
        this.fileList.setEnabled(e);
        this.addXMLRepsToDictionaryCheckBox.setEnabled(e);
    }

    public String getCommonFolderString() {
        String latest = this.files.first().getAbsolutePath();
        latest = latest.substring(0, latest.lastIndexOf(File.separator));
        for (File file : this.files) {
            String currentFileString = file.getAbsolutePath();
            while (!currentFileString.startsWith(latest)) {
                latest = latest.substring(0, latest.lastIndexOf(File.separator));
            }
        }
        return latest;
    }

    private static void walkFolder(TreeSet<File> toAddTo, File folder) {
        File[] filesFromFolder;
        File[] fileArray = filesFromFolder = folder.listFiles();
        int n = filesFromFolder.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory()) {
                if (!file.isHidden() && !toAddTo.contains(file)) {
                    toAddTo.add(file);
                }
            } else {
                TrainingScreenSideBar.walkFolder(toAddTo, file);
            }
            ++n2;
        }
    }

    private class AddFilesAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 4326016666260935844L;

        private AddFilesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            TrainingScreenSideBar.this.fc.setFileSelectionMode(0);
            TrainingScreenSideBar.this.fc.setMultiSelectionEnabled(true);
            int returnVal = TrainingScreenSideBar.this.fc.showOpenDialog(TrainingScreenSideBar.this.owner);
            if (returnVal == 0) {
                new Thread(){

                    @Override
                    public void run() {
                        File[] filesSelected = TrainingScreenSideBar.this.fc.getSelectedFiles();
                        TrainingScreenSideBar.this.global.startProgress(filesSelected.length);
                        TrainingScreenSideBar.this.global.writeProgressMessage("Adding files...");
                        int count = 0;
                        File[] fileArray = filesSelected;
                        int n = filesSelected.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            TrainingScreenSideBar.this.files.add(file);
                            TrainingScreenSideBar.this.global.setProgressCurrent(++count);
                            ++n2;
                        }
                        TrainingScreenSideBar.this.fileList.setListData(TrainingScreenSideBar.this.files.toArray());
                        TrainingScreenSideBar.this.global.finishProgress();
                    }
                }.start();
            }
        }
    }

    private class AddFoldersAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -7212828610752565633L;

        private AddFoldersAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TrainingScreenSideBar.this.fc.setFileSelectionMode(1);
            TrainingScreenSideBar.this.fc.setMultiSelectionEnabled(true);
            int returnVal2 = TrainingScreenSideBar.this.fc.showOpenDialog(TrainingScreenSideBar.this.owner);
            if (returnVal2 == 0) {
                new Thread(){

                    @Override
                    public void run() {
                        TrainingScreenSideBar.this.global.startIndeterminateProgress();
                        File[] foldersSelected = TrainingScreenSideBar.this.fc.getSelectedFiles();
                        int totalFolders = foldersSelected.length;
                        int folderCount = 0;
                        File[] fileArray = foldersSelected;
                        int n = foldersSelected.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File folder = fileArray[n2];
                            if (TrainingScreenSideBar.this.searchSubFoldersTB.isSelected()) {
                                TrainingScreenSideBar.walkFolder(TrainingScreenSideBar.this.files, folder);
                            } else {
                                File[] filesFromFolder = folder.listFiles();
                                TrainingScreenSideBar.this.global.startProgress(filesFromFolder.length);
                                TrainingScreenSideBar.this.global.writeProgressMessage("Adding files from " + folder.getName() + "(" + ++folderCount + "/" + totalFolders + ")...");
                                int fileCount = 0;
                                File[] fileArray2 = filesFromFolder;
                                int n3 = filesFromFolder.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    File file = fileArray2[n4];
                                    if (!(file.isDirectory() || file.isHidden() || TrainingScreenSideBar.this.files.contains(file))) {
                                        TrainingScreenSideBar.this.files.add(file);
                                    }
                                    TrainingScreenSideBar.this.global.setProgressCurrent(++fileCount);
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                        TrainingScreenSideBar.this.fileList.setListData(TrainingScreenSideBar.this.files.toArray());
                        TrainingScreenSideBar.this.global.finishProgress();
                    }
                }.start();
            }
        }
    }

    private class AddTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -3375927171804520959L;

        private AddTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            List filesAdded;
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                filesAdded = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            if (filesAdded.isEmpty()) {
                return false;
            }
            new Thread(){

                @Override
                public void run() {
                    TrainingScreenSideBar.this.global.startProgress(filesAdded.size());
                    TrainingScreenSideBar.this.global.writeProgressMessage("Adding files...");
                    int count = 0;
                    for (File file : filesAdded) {
                        if (file.isDirectory()) {
                            if (TrainingScreenSideBar.this.searchSubFoldersTB.isSelected()) {
                                TrainingScreenSideBar.walkFolder(TrainingScreenSideBar.this.files, file);
                            } else {
                                File[] filesFromFolder = file.listFiles();
                                TrainingScreenSideBar.this.global.startProgress(filesFromFolder.length);
                                TrainingScreenSideBar.this.global.writeProgressMessage("Adding files from " + file.getName());
                                int fileCount = 0;
                                File[] fileArray = filesFromFolder;
                                int n = filesFromFolder.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    File f = fileArray[n2];
                                    if (!(f.isDirectory() || f.isHidden() || TrainingScreenSideBar.this.files.contains(f))) {
                                        TrainingScreenSideBar.this.files.add(f);
                                    }
                                    TrainingScreenSideBar.this.global.setProgressCurrent(++fileCount);
                                    ++n2;
                                }
                            }
                        } else {
                            TrainingScreenSideBar.this.files.add(file);
                        }
                        TrainingScreenSideBar.this.global.setProgressCurrent(++count);
                    }
                    TrainingScreenSideBar.this.fileList.setListData(TrainingScreenSideBar.this.files.toArray());
                    TrainingScreenSideBar.this.global.finishProgress();
                }
            }.start();
            return true;
        }
    }

    private class ProcessListAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 6246240903387728062L;

        private ProcessListAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (TrainingScreenSideBar.this.files.size() == 0) {
                TrainingScreenSideBar.this.global.showError("Please provide atleast one file to process.");
                return;
            }
            new Thread(){

                @Override
                public void run() {
                    int totalFiles = TrainingScreenSideBar.this.files.size();
                    int fileCounter = 0;
                    String commonFolder = TrainingScreenSideBar.this.getCommonFolderString();
                    TrainingScreenSideBar.this.global.startProgress(totalFiles);
                    TrainingScreenSideBar.this.global.lockFinishProgress();
                    DocumentModel docModel = new DocumentModel(TrainingScreenSideBar.this.setup, TrainingScreenSideBar.this.confidenceWeights, TrainingScreenSideBar.this.lud);
                    int count = 0;
                    try {
                        try {
                            for (File file : TrainingScreenSideBar.this.files) {
                                String fileString = file.getAbsolutePath().replace(commonFolder, "");
                                String fileProgress = "Processing " + fileString + " (" + ++fileCounter + "/" + totalFiles + ")";
                                TrainingScreenSideBar.this.global.writeProgressMessage(fileProgress);
                                TrainingScreenSideBar.this.global.stopProgressMessages();
                                docModel.processNewFile(file, true, TrainingScreenSideBar.this.addXMLRepsToDictionaryCheckBox.isSelected());
                                TrainingScreenSideBar.this.global.resumeProgressMessages();
                                TrainingScreenSideBar.this.global.setProgressCurrent(++count);
                            }
                        }
                        catch (InvalidInstanceChangeException e) {
                            TrainingScreenSideBar.this.global.showException("Error occurred reading xml tag.", e);
                            TrainingScreenSideBar.this.global.unlockFinishProgress();
                            TrainingScreenSideBar.this.global.finishProgress();
                        }
                        catch (BadLocationException e) {
                            TrainingScreenSideBar.this.global.showException("Error occurred whilst processing file.", e);
                            TrainingScreenSideBar.this.global.unlockFinishProgress();
                            TrainingScreenSideBar.this.global.finishProgress();
                        }
                    }
                    finally {
                        TrainingScreenSideBar.this.global.unlockFinishProgress();
                        TrainingScreenSideBar.this.global.finishProgress();
                    }
                }
            }.start();
        }
    }
}

