/*
 * Decompiled with CFR 0.152.
 */
package gui.sidebar;

import gui.MainScreen;
import gui.TBJButton;
import gui.sidebar.AddPatternToListAction;
import gui.sidebar.AddPatternToStringToListAction;
import gui.sidebar.EditListItemAction;
import gui.sidebar.EditListStringPairItemAction;
import gui.sidebar.FourPiecePanel;
import gui.sidebar.MoveItemDownListAction;
import gui.sidebar.MoveItemUpListAction;
import gui.sidebar.Pair;
import gui.sidebar.RemoveSelectedFromListAction;
import gui.sidebar.SetupSideBarPanel;
import gui.sidebar.TextPrompt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import model.Setup;

public class TextInputSideBar
extends SetupSideBarPanel {
    private static final long serialVersionUID = 5227124331579359182L;
    private final HashMap<String, Action> actions = new HashMap();
    private final JTextField wordRegexTF;
    private final JTextField addEntityKeyTF;
    private final JTextField addEntityValueTF;
    private final JTextField addTextToIgnoreTF;
    private final JComboBox encodingComboBox;
    private final JList textToIgnoreList;
    private final JList entitiesList;
    private final LinkedHashSet<Pattern> textToIgnore;
    private final LinkedHashSet<Pair<String, String>> entities;

    public TextInputSideBar(Setup setup) {
        JPanel wordRegexPanel = new JPanel(new BorderLayout());
        wordRegexPanel.setBorder(BorderFactory.createTitledBorder("Word pattern"));
        this.wordRegexTF = new JTextField(setup.getWordPattern().toString());
        TextPrompt textPrompt = new TextPrompt("Required", this.wordRegexTF);
        textPrompt.setShow(TextPrompt.Show.FOCUS_LOST);
        textPrompt.changeAlpha(0.5f);
        wordRegexPanel.add(this.wordRegexTF);
        this.textToIgnore = new LinkedHashSet();
        this.textToIgnore.addAll(setup.getIgnoredPatterns());
        this.textToIgnoreList = new JList();
        this.textToIgnoreList.setListData(this.textToIgnore.toArray());
        this.textToIgnoreList.setVisibleRowCount(4);
        JScrollPane textToIgnoreListSP = new JScrollPane(this.textToIgnoreList, 20, 30);
        this.addTextToIgnoreTF = new JTextField(10);
        this.actions.put("tti Add", MainScreen.fixAction(new AddPatternToListAction(this.textToIgnoreList, this.textToIgnore, this.addTextToIgnoreTF), "Add to list", "table_row_insert", "Add to list", -1, null));
        this.actions.put("tti Edit", MainScreen.fixAction(new EditListItemAction(this.textToIgnoreList, this.textToIgnore, this.addTextToIgnoreTF), "Edit selected item", "table_edit", "Edit selected item", -1, null));
        this.actions.put("tti Up", MainScreen.fixAction(new MoveItemUpListAction<Pattern>(this.textToIgnoreList, this.textToIgnore), "Move up", "arrow_up", "Move up", -1, null));
        this.actions.put("tti Down", MainScreen.fixAction(new MoveItemDownListAction<Pattern>(this.textToIgnoreList, this.textToIgnore), "Move down", "arrow_down", "Move down", -1, null));
        this.actions.put("tti Remove", MainScreen.fixAction(new RemoveSelectedFromListAction(this.textToIgnoreList, this.textToIgnore), "Remove selected item(s)", "table_row_delete", "Remove selected item(s)", -1, null));
        this.addTextToIgnoreTF.setAction(this.actions.get("tti Add"));
        JToolBar textToIgnoreTB = new JToolBar(1);
        textToIgnoreTB.setFloatable(false);
        textToIgnoreTB.add(new TBJButton(this.actions.get("tti Up")));
        textToIgnoreTB.add(new TBJButton(this.actions.get("tti Down")));
        textToIgnoreTB.add(new TBJButton(this.actions.get("tti Edit")));
        textToIgnoreTB.add(new TBJButton(this.actions.get("tti Remove")));
        FourPiecePanel textToIgnorePanel = new FourPiecePanel(textToIgnoreListSP, textToIgnoreTB, this.addTextToIgnoreTF, new TBJButton(this.actions.get("tti Add")));
        textToIgnorePanel.setBorder(BorderFactory.createTitledBorder("Text to ignore"));
        JPanel encodingPanel = new JPanel(new BorderLayout());
        encodingPanel.setBorder(BorderFactory.createTitledBorder("Encoding"));
        Vector<String> charsets = new Vector<String>();
        charsets.add("detect");
        for (String string : Charset.availableCharsets().keySet()) {
            charsets.add(string);
        }
        this.encodingComboBox = new JComboBox(charsets);
        this.encodingComboBox.setSelectedItem(setup.getEncoding());
        encodingPanel.add((Component)this.encodingComboBox, "Center");
        this.entities = new LinkedHashSet();
        for (Map.Entry entry : setup.getEntities().entrySet()) {
            this.entities.add(new Pair<String, String>((String)entry.getKey(), (String)entry.getValue()));
        }
        this.entitiesList = new JList();
        this.entitiesList.setListData(this.entities.toArray());
        this.entitiesList.setVisibleRowCount(4);
        JScrollPane jScrollPane = new JScrollPane(this.entitiesList, 20, 30);
        this.addEntityKeyTF = new JTextField(7);
        this.addEntityKeyTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TextInputSideBar.this.addEntityValueTF.requestFocus();
            }
        });
        this.addEntityValueTF = new JTextField(7);
        this.actions.put("e Add", MainScreen.fixAction(new AddPatternToStringToListAction(this.entitiesList, this.entities, this.addEntityKeyTF, this.addEntityValueTF), "Add to list", "table_row_insert", "Add to list", -1, null));
        this.actions.put("e Edit", MainScreen.fixAction(new EditListStringPairItemAction(this.entitiesList, this.entities, this.addEntityKeyTF, this.addEntityValueTF), "Edit selected item", "table_edit", "Edit selected item", -1, null));
        this.actions.put("e Remove", MainScreen.fixAction(new RemoveSelectedFromListAction(this.entitiesList, this.entities), "Remove selected item(s)", "table_row_delete", "Remove selected item(s)", -1, null));
        this.addEntityValueTF.setAction(this.actions.get("e Add"));
        JToolBar entitiesTB = new JToolBar(1);
        entitiesTB.setFloatable(false);
        entitiesTB.add(new TBJButton(this.actions.get("e Edit")));
        entitiesTB.add(new TBJButton(this.actions.get("e Remove")));
        JPanel addEntityPanel = new JPanel(new GridBagLayout());
        GridBagConstraints f = new GridBagConstraints();
        f.gridy = 0;
        f.weightx = 1.0;
        f.fill = 1;
        GridBagConstraints nf = new GridBagConstraints();
        nf.gridy = 0;
        nf.weightx = 0.0;
        nf.fill = 0;
        addEntityPanel.add((Component)this.addEntityKeyTF, f);
        addEntityPanel.add((Component)new JLabel(" \u2192 "), nf);
        addEntityPanel.add((Component)this.addEntityValueTF, f);
        FourPiecePanel entitiesPanel = new FourPiecePanel(jScrollPane, entitiesTB, addEntityPanel, new TBJButton(this.actions.get("e Add")));
        entitiesPanel.setBorder(BorderFactory.createTitledBorder("Entity conversion"));
        GridBagConstraints fv = new GridBagConstraints();
        fv.gridx = 0;
        fv.weighty = 1.0;
        fv.weightx = 1.0;
        fv.fill = 1;
        GridBagConstraints nfv = new GridBagConstraints();
        nfv.gridx = 0;
        nfv.weighty = 0.0;
        nfv.weightx = 1.0;
        nfv.fill = 2;
        this.setLayout(new GridBagLayout());
        this.add((Component)wordRegexPanel, nfv);
        this.add((Component)textToIgnorePanel, fv);
        this.add((Component)encodingPanel, nfv);
        this.add((Component)entitiesPanel, fv);
    }

    @Override
    public void changeSetup(Setup setup) {
        this.encodingComboBox.setSelectedItem(setup.getEncoding());
        this.wordRegexTF.setText(setup.getWordPattern().toString());
        this.entities.clear();
        for (Map.Entry<String, String> entry : setup.getEntities().entrySet()) {
            this.entities.add(new Pair<String, String>(entry.getKey(), entry.getValue()));
        }
        this.entitiesList.setListData(this.entities.toArray());
        this.textToIgnore.clear();
        this.textToIgnore.addAll(setup.getIgnoredPatterns());
        this.textToIgnoreList.setListData(this.textToIgnore.toArray());
    }

    @Override
    public void updateSetup(Setup setup) {
        setup.setEncoding(this.encodingComboBox.getSelectedItem().toString());
        setup.setWordPattern(Pattern.compile(this.wordRegexTF.getText()));
        ArrayList<Pattern> newTextToIgnorePatterns = new ArrayList<Pattern>();
        newTextToIgnorePatterns.addAll(this.textToIgnore);
        setup.setIgnoredPatterns(newTextToIgnorePatterns);
        TreeMap<String, String> newEntities = new TreeMap<String, String>();
        for (Pair pair : this.entities) {
            newEntities.put((String)pair.getKey(), (String)pair.getValue());
        }
        setup.setEntities(newEntities);
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (Action action : this.actions.values()) {
            action.setEnabled(enabled);
        }
        this.encodingComboBox.setEnabled(enabled);
        this.wordRegexTF.setEnabled(enabled);
        this.textToIgnoreList.setEnabled(enabled);
        this.addTextToIgnoreTF.setEnabled(enabled);
        this.entitiesList.setEnabled(enabled);
        this.addEntityKeyTF.setEnabled(enabled);
        this.addEntityValueTF.setEnabled(enabled);
    }

    @Override
    public String validateForm() {
        String wordPattern = this.wordRegexTF.getText();
        if (wordPattern.isEmpty()) {
            return "Word pattern is empty";
        }
        try {
            Pattern.compile(wordPattern);
        }
        catch (PatternSyntaxException ex) {
            return "Word pattern invalid: " + ex.getDescription();
        }
        return null;
    }
}

