/*
 * Decompiled with CFR 0.152.
 */
package gui.sidebar;

import gui.MainScreen;
import gui.TBJButton;
import gui.sidebar.AddPatternToListAction;
import gui.sidebar.AddPatternToStringToListAction;
import gui.sidebar.EditListItemAction;
import gui.sidebar.EditListStringPairItemAction;
import gui.sidebar.FourPiecePanel;
import gui.sidebar.MoveItemDownListAction;
import gui.sidebar.MoveItemUpListAction;
import gui.sidebar.Pair;
import gui.sidebar.RemoveSelectedFromListAction;
import gui.sidebar.SetupSideBarPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import model.Setup;

public class OverridesSideBar
extends SetupSideBarPanel {
    private static final long serialVersionUID = -453439287906782849L;
    private final HashMap<String, Action> actions = new HashMap();
    private final JTextField addRuleKeyTF;
    private final JTextField addRuleValueTF;
    private final JTextField addVariantTF;
    private final JTextField addNotVariantTF;
    private final JList notVariantsList;
    private final JList variantsList;
    private final JList rulesList;
    private final LinkedHashSet<Pattern> notVariantOverrides;
    private final LinkedHashSet<Pattern> variantOverrides;
    private final LinkedHashSet<Pair<String, String>> rules = new LinkedHashSet();

    public OverridesSideBar(Setup setup) {
        for (Map.Entry<String, String> entry : setup.getAlwaysApplyRules().entrySet()) {
            this.rules.add(new Pair<String, String>(entry.getKey(), entry.getValue()));
        }
        this.rulesList = new JList();
        this.rulesList.setListData(this.rules.toArray());
        this.rulesList.setVisibleRowCount(4);
        JScrollPane rulesListSP = new JScrollPane(this.rulesList, 20, 30);
        this.addRuleKeyTF = new JTextField(7);
        this.addRuleKeyTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverridesSideBar.this.addRuleValueTF.requestFocus();
            }
        });
        this.addRuleValueTF = new JTextField(7);
        this.actions.put("r Add", MainScreen.fixAction(new AddPatternToStringToListAction(this.rulesList, this.rules, this.addRuleKeyTF, this.addRuleValueTF), "Add to list", "table_row_insert", "Add to list", -1, null));
        this.actions.put("r Edit", MainScreen.fixAction(new EditListStringPairItemAction(this.rulesList, this.rules, this.addRuleKeyTF, this.addRuleValueTF), "Edit selected item", "table_edit", "Edit selected item", -1, null));
        this.actions.put("r Up", MainScreen.fixAction(new MoveItemUpListAction<Pair<String, String>>(this.rulesList, this.rules), "Move up", "arrow_up", "Move up", -1, null));
        this.actions.put("r Down", MainScreen.fixAction(new MoveItemDownListAction<Pair<String, String>>(this.rulesList, this.rules), "Move down", "arrow_down", "Move down", -1, null));
        this.actions.put("r Remove", MainScreen.fixAction(new RemoveSelectedFromListAction(this.rulesList, this.rules), "Remove selected item(s)", "table_row_delete", "Remove selected item(s)", -1, null));
        this.addRuleValueTF.addActionListener(this.actions.get("r Add"));
        JToolBar rulesTB = new JToolBar(1);
        rulesTB.setFloatable(false);
        rulesTB.add(new TBJButton(this.actions.get("r Up")));
        rulesTB.add(new TBJButton(this.actions.get("r Down")));
        rulesTB.add(new TBJButton(this.actions.get("r Edit")));
        rulesTB.add(new TBJButton(this.actions.get("r Remove")));
        JPanel addRulePanel = new JPanel(new GridBagLayout());
        GridBagConstraints f = new GridBagConstraints();
        f.gridy = 0;
        f.weightx = 1.0;
        f.fill = 1;
        GridBagConstraints nf = new GridBagConstraints();
        nf.gridy = 0;
        nf.weightx = 0.0;
        nf.fill = 0;
        addRulePanel.add((Component)this.addRuleKeyTF, f);
        addRulePanel.add((Component)new JLabel(" \u2192 "), nf);
        addRulePanel.add((Component)this.addRuleValueTF, f);
        FourPiecePanel rulesPanel = new FourPiecePanel(rulesListSP, rulesTB, addRulePanel, new TBJButton(this.actions.get("r Add")));
        rulesPanel.setBorder(BorderFactory.createTitledBorder("Always apply rules"));
        this.notVariantOverrides = new LinkedHashSet();
        this.notVariantOverrides.addAll(setup.getNonvariantOverridePatterns());
        this.notVariantsList = new JList();
        this.notVariantsList.setListData(this.notVariantOverrides.toArray());
        this.notVariantsList.setVisibleRowCount(4);
        JScrollPane notVariantsListSP = new JScrollPane(this.notVariantsList, 20, 30);
        this.addNotVariantTF = new JTextField(12);
        this.actions.put("nvo Add", MainScreen.fixAction(new AddPatternToListAction(this.notVariantsList, this.notVariantOverrides, this.addNotVariantTF), "Add to list", "table_row_insert", "Add to list", -1, null));
        this.actions.put("nvo Edit", MainScreen.fixAction(new EditListItemAction(this.notVariantsList, this.notVariantOverrides, this.addNotVariantTF), "Edit selected item", "table_edit", "Edit selected item", -1, null));
        this.actions.put("nvo Remove", MainScreen.fixAction(new RemoveSelectedFromListAction(this.notVariantsList, this.notVariantOverrides), "Remove selected item(s)", "table_row_delete", "Remove selected item(s)", -1, null));
        this.addNotVariantTF.setAction(this.actions.get("nvo Add"));
        JToolBar notVariantTB = new JToolBar(1);
        notVariantTB.setFloatable(false);
        notVariantTB.add(new TBJButton(this.actions.get("nvo Edit")));
        notVariantTB.add(new TBJButton(this.actions.get("nvo Remove")));
        FourPiecePanel notVariantOverridesPanel = new FourPiecePanel(notVariantsListSP, notVariantTB, this.addNotVariantTF, new TBJButton(this.actions.get("nvo Add")));
        notVariantOverridesPanel.setBorder(BorderFactory.createTitledBorder("Override to not variant"));
        this.variantOverrides = new LinkedHashSet();
        this.variantOverrides.addAll(setup.getVariantOverridePatterns());
        this.variantsList = new JList();
        this.variantsList.setListData(this.variantOverrides.toArray());
        this.variantsList.setVisibleRowCount(4);
        JScrollPane variantsListSP = new JScrollPane(this.variantsList, 20, 30);
        this.addVariantTF = new JTextField(12);
        this.actions.put("vo Add", MainScreen.fixAction(new AddPatternToListAction(this.variantsList, this.variantOverrides, this.addVariantTF), "Add to list", "table_row_insert", "Add to list", -1, null));
        this.actions.put("vo Edit", MainScreen.fixAction(new EditListItemAction(this.variantsList, this.variantOverrides, this.addVariantTF), "Edit selected item", "table_edit", "Edit selected item", -1, null));
        this.actions.put("vo Remove", MainScreen.fixAction(new RemoveSelectedFromListAction(this.variantsList, this.variantOverrides), "Remove selected item(s)", "table_row_delete", "Remove selected item(s)", -1, null));
        this.addVariantTF.setAction(this.actions.get("vo Add"));
        JToolBar variantTB = new JToolBar(1);
        variantTB.setFloatable(false);
        variantTB.add(new TBJButton(this.actions.get("vo Edit")));
        variantTB.add(new TBJButton(this.actions.get("vo Remove")));
        JPanel addVOPanel = new JPanel(new GridBagLayout());
        addVOPanel.add(this.addVariantTF);
        addVOPanel.add(new TBJButton(this.actions.get("vo Add")));
        FourPiecePanel variantOverridesPanel = new FourPiecePanel(variantsListSP, variantTB, this.addVariantTF, new TBJButton(this.actions.get("vo Add")));
        variantOverridesPanel.setBorder(BorderFactory.createTitledBorder("Override to variant"));
        this.setLayout(new GridLayout(3, 1));
        this.add(rulesPanel);
        this.add(notVariantOverridesPanel);
        this.add(variantOverridesPanel);
    }

    @Override
    public void changeSetup(Setup setup) {
        this.notVariantOverrides.clear();
        this.notVariantOverrides.addAll(setup.getNonvariantOverridePatterns());
        this.notVariantsList.setListData(this.notVariantOverrides.toArray());
        this.variantOverrides.clear();
        this.variantOverrides.addAll(setup.getVariantOverridePatterns());
        this.variantsList.setListData(this.variantOverrides.toArray());
        this.rules.clear();
        for (Map.Entry<String, String> entry : setup.getAlwaysApplyRules().entrySet()) {
            this.rules.add(new Pair<String, String>(entry.getKey(), entry.getValue()));
        }
        this.rulesList.setListData(this.rules.toArray());
    }

    @Override
    public void updateSetup(Setup setup) {
        ArrayList<Pattern> newVariantOverridePatterns = new ArrayList<Pattern>();
        newVariantOverridePatterns.addAll(this.variantOverrides);
        setup.setVariantOverridePatterns(newVariantOverridePatterns);
        ArrayList<Pattern> newNotVariantOverridePatterns = new ArrayList<Pattern>();
        newNotVariantOverridePatterns.addAll(this.notVariantOverrides);
        setup.setNonvariantOverridePatterns(newNotVariantOverridePatterns);
        LinkedHashMap<String, String> newRules = new LinkedHashMap<String, String>();
        for (Pair pair : this.rules) {
            newRules.put((String)pair.getKey(), (String)pair.getValue());
        }
        setup.setAlwaysApplyRules(newRules);
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (Action action : this.actions.values()) {
            action.setEnabled(enabled);
        }
        this.notVariantsList.setEnabled(enabled);
        this.variantsList.setEnabled(enabled);
        this.rulesList.setEnabled(enabled);
        this.addNotVariantTF.setEnabled(enabled);
        this.addVariantTF.setEnabled(enabled);
        this.addRuleKeyTF.setEnabled(enabled);
        this.addRuleValueTF.setEnabled(enabled);
    }

    @Override
    public String validateForm() {
        return null;
    }
}

