/*
 * Decompiled with CFR 0.152.
 */
package gui.sidebar;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import model.IgnoreCaseComparator;
import model.Setup;

public class LanguageTableModel
extends AbstractTableModel
implements TableModel {
    private static final long serialVersionUID = 8100840546622441401L;
    private static final String[] columnNames = new String[]{"Language", "Process?"};
    private final TreeMap<String, Boolean> languageMap = new TreeMap(new IgnoreCaseComparator());
    private final Vector<String> langs = new Vector();
    private final Vector<Boolean> processes = new Vector();

    public LanguageTableModel(Setup setup) {
        this.changeSetup(setup);
    }

    void changeSetup(Setup setup) {
        this.languageMap.clear();
        this.langs.clear();
        this.processes.clear();
        Set<String> setupLangs = setup.getLanguages();
        for (String lang : setupLangs) {
            boolean process = setup.isLanguageToProcess(lang);
            this.languageMap.put(lang, process);
            this.langs.add(lang);
            this.processes.add(process);
        }
        this.fireTableDataChanged();
        this.fireTableStructureChanged();
    }

    void addLanguage(String language) {
        if (!this.languageMap.containsKey(language)) {
            this.languageMap.put(language, Boolean.FALSE);
            this.updateVectors();
            this.fireTableStructureChanged();
        }
    }

    Map<String, Boolean> getLanguageMap() {
        return this.languageMap;
    }

    private void updateVectors() {
        this.langs.clear();
        this.processes.clear();
        this.langs.addAll(this.languageMap.keySet());
        this.processes.addAll(this.languageMap.values());
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.langs.size();
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col == 1) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            String lang = value.toString();
            this.languageMap.remove(this.langs.get(row));
            this.languageMap.put(lang, this.processes.get(row));
            this.updateVectors();
        } else {
            this.languageMap.put(this.langs.get(row), (Boolean)value);
            this.processes.remove(row);
            this.processes.add(row, (Boolean)value);
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.langs.get(row);
        }
        if (col == 1) {
            return this.processes.get(row);
        }
        return "";
    }

    public void removeRow(int[] rows) {
        if (rows.length == 0) {
            return;
        }
        TreeSet<Integer> rowsSet = new TreeSet<Integer>();
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            rowsSet.add(row);
            ++n2;
        }
        int min = (Integer)rowsSet.first();
        int max = (Integer)rowsSet.last();
        Iterator rowIt = rowsSet.descendingIterator();
        while (rowIt.hasNext()) {
            int row = (Integer)rowIt.next();
            String lang = this.langs.remove(row);
            this.languageMap.remove(lang);
            this.processes.remove(row);
        }
        this.fireTableRowsDeleted(min, max);
    }
}

