/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoableEditSupport;
import model.Globals;
import model.SuggestedReplacement;
import model.doc.DocumentModel;
import model.doc.InvalidInstanceChangeException;
import model.doc.NormaliseVariantInstanceEdit;
import model.doc.VariantInstance;
import model.lookup.LookUpDictionary;

public class NormaliseVariantInstanceAction<F extends VariantInstance>
extends AbstractAction {
    private static final long serialVersionUID = -7964139713034760680L;
    private NormaliseVariantInstanceEdit edit;
    private UndoableEditSupport undoSupport;

    public NormaliseVariantInstanceAction(F fi, SuggestedReplacement rep, DocumentModel docModel, LookUpDictionary lud, UndoableEditSupport undoSupport) {
        this.undoSupport = undoSupport;
        try {
            this.edit = new NormaliseVariantInstanceEdit((VariantInstance)fi, rep, docModel, docModel, lud, false, true, true);
            this.putValue("Name", this.edit.getActionName());
        }
        catch (InvalidInstanceChangeException ex) {
            Globals.getInstance().showException("Error occurred in replacing instance prep.", ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            this.edit.execute();
            this.undoSupport.postEdit(this.edit);
        }
        catch (InvalidInstanceChangeException ex) {
            Globals.getInstance().showException("Error occurred replacing instance.", ex);
        }
        catch (BadLocationException ex) {
            Globals.getInstance().showException("Error occurred replacing instance in text", ex);
        }
    }
}

