/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ConfidenceWeightsTableModel;
import gui.DocumentView;
import gui.ErrorDisplay;
import gui.QuestionAsker;
import gui.StackListModel;
import gui.SwingWorkerAction;
import gui.TBJButton;
import gui.sidebar.BatchScreenSideBar;
import gui.sidebar.DocumentSideBar;
import gui.sidebar.RulesSideBar;
import gui.sidebar.SampleSideBar;
import gui.sidebar.SetupSideBar;
import gui.sidebar.SideBarPanel;
import gui.sidebar.TrainingScreenSideBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import model.ConfidenceWeights;
import model.ErrorMessageHandler;
import model.Globals;
import model.ProgressListener;
import model.Setup;
import model.doc.DocumentModel;
import model.doc.InvalidInstanceChangeException;
import model.lookup.LookUpDictionary;
import model.sample.Partition;
import model.sample.SampleModel;

public class MainScreen
implements ProgressListener,
ErrorMessageHandler,
LookUpDictionary.DataChangeListener,
ConfidenceWeights.ChangeListener,
QuestionAsker,
SetupSideBar.SetupChangeListener,
SampleModel.ChangeListener,
DocumentModel.DocumentChangeListener {
    private static final String PROGRAM_TITLE = "VARD 2.5.1";
    private boolean isEnabled = false;
    private Setup setup;
    private final DocumentModel docModel;
    private final ConfidenceWeights confidenceWeights;
    private final LookUpDictionary lud;
    private final SampleModel sampleModel;
    private final Globals global;
    private final JFileChooser fileChooser;
    private final JFrame frame;
    private final HashMap<String, Action> actions;
    private final UIUpdatingUndoManager undoManager = new UIUpdatingUndoManager();
    private final UndoableEditSupport undoSupport = new UndoableEditSupport();
    private final JComboBox setupComboBox;
    private final ChangeSetupAction changeSetupAction;
    private final JFileChooser setupFC;
    private final JToolBar sampleToolBar;
    private final JComboBox inProgressCB;
    private final JSlider fScoreSlider;
    private final DocumentView documentView;
    private final JTabbedPane tabbedPane;
    private final LinkedHashMap<String, SideBarPanel> sideBarPanels;
    private final JProgressBar progressBar;
    private final JLabel progressBarLabel;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error occurred setting look and feel.\n\n" + ex.getMessage(), "Error", 0);
        }
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        Globals global = Globals.getInstance();
        global.setErrorHandler(ErrorDisplay.getInstance());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainScreen(null);
            }
        });
    }

    private MainScreen() {
        this.global = Globals.getInstance();
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Loading user interface...");
        this.global.lockFinishProgress();
        this.sampleModel = new SampleModel();
        this.sampleModel.addChangeListener(this);
        this.actions = new HashMap();
        this.actions.put("New", MainScreen.fixAction(new NewAction(), "New", "page_white", "Create a new file", 78, KeyStroke.getKeyStroke(78, 128)));
        this.actions.put("Open", MainScreen.fixAction(new OpenAction(), "Open", "folder_page", "Open a file to analyse", 79, KeyStroke.getKeyStroke(79, 128)));
        this.actions.put("Save", MainScreen.fixAction(new SaveAction(), "Save", "disk", "Save current file", 83, KeyStroke.getKeyStroke(83, 128)));
        this.actions.put("Save As Plain", MainScreen.fixAction(new SaveWithoutTagsAction(), "Save Without XML Tags", "script_save", "Save the file in it's original format, but with variants replaced (unmarked).", 84, null));
        this.actions.put("Save As XML", MainScreen.fixAction(new SaveWithTagsAction(), "Save With XML Tags", "script_code_red", "Saves the file with variants replaced and marked. No formatting will be saved.", 88, null));
        this.actions.put("Save Dictionary", MainScreen.fixAction(new SaveDictionaryAction(), "Save Dictionary", "book_go", "Save changes to dictionary", 68, null));
        this.actions.put("Save Variant List", MainScreen.fixAction(new SaveVariantsAction(), "Save Variant List", "table_go", "Save changes to known variants list", 86, null));
        this.actions.put("Save Confidence Weights", MainScreen.fixAction(new SaveConfidenceWeightsAction(), "Save Confidence Weights", "chart_curve_go", "Save changes to replacement method confidence weights", 67, null));
        this.actions.put("Save All", MainScreen.fixAction(new SaveAllAction(), "Save All", "disk_multiple", "Save document, dictionary, variant list, rule list and confidence weights", 65, null));
        this.actions.put("Exit", MainScreen.fixAction(new ExitAction(), "Exit", "door", null, 88, null));
        this.actions.put("Undo", MainScreen.fixAction(new UndoAction(), "Undo", "arrow_undo", "Undo", 85, KeyStroke.getKeyStroke(90, 128)));
        this.actions.put("Redo", MainScreen.fixAction(new RedoAction(), "Redo", "arrow_redo", "Redo", 82, KeyStroke.getKeyStroke(89, 128)));
        this.actions.put("Setup Browse", MainScreen.fixAction(new SetupBrowseAction(), "Browse", "folder_explore", "Browse for setup folder", -1, null));
        this.actions.put("Next queued partition", MainScreen.fixAction(new NextQueuedPartitionAction(), "Next random partition", "page_go", "Process next random queued partition.", -1, null));
        this.actions.put("Mark partition done", MainScreen.fixAction(new MarkPartitionAsCompleteAction(), "Mark partition as complete and save all.", "page_save_tick", "Mark current partition as complete, save all data and move on to next available partition.", 68, KeyStroke.getKeyStroke(68, 128)));
        this.actions.put("Edit started partition", MainScreen.fixAction(new EditStartedPartitionAction(), "Process partition", "page_edit", "Process partition", -1, null));
        JPanel setupPanel = new JPanel(new BorderLayout());
        setupPanel.setBorder(new TitledBorder("Setup"));
        setupPanel.setToolTipText("Change setup folder");
        Vector<Object> previousSetups = new Vector();
        try {
            previousSetups = Setup.getPreviousSetupsList();
        }
        catch (IOException e) {
            this.global.showException("Error occurred collecting list of previous setups", e);
        }
        this.setupComboBox = this.createCombo(new DefaultComboBoxModel(previousSetups));
        this.setupComboBox.setEditable(true);
        setupPanel.setTransferHandler(new SetupFolderTransferHandler());
        final JTextField comboBoxTF = new JTextField(20);
        comboBoxTF.setTransferHandler(new SetupFolderTransferHandler());
        comboBoxTF.setEditable(false);
        this.setupComboBox.setEditor(new ComboBoxEditor(){

            @Override
            public void addActionListener(ActionListener arg0) {
                comboBoxTF.addActionListener(arg0);
            }

            @Override
            public Component getEditorComponent() {
                return comboBoxTF;
            }

            @Override
            public Object getItem() {
                return comboBoxTF.getText();
            }

            @Override
            public void removeActionListener(ActionListener arg0) {
                comboBoxTF.removeActionListener(arg0);
            }

            @Override
            public void selectAll() {
                comboBoxTF.selectAll();
            }

            @Override
            public void setItem(Object item) {
                if (item == null) {
                    comboBoxTF.setText("");
                } else {
                    comboBoxTF.setText(item.toString());
                }
            }
        });
        this.changeSetupAction = new ChangeSetupAction();
        this.setupComboBox.setAction(this.changeSetupAction);
        this.setupComboBox.setPrototypeDisplayValue("setup-eebo trained");
        setupPanel.add((Component)this.setupComboBox, "Center");
        setupPanel.add((Component)new TBJButton(this.getActionByName("Setup Browse")), "East");
        this.setupFC = new JFileChooser();
        this.setupFC.setFileSelectionMode(1);
        this.setupFC.setMultiSelectionEnabled(false);
        this.setupFC.setCurrentDirectory(new File(System.getProperty("user.dir")));
        this.setup = new Setup();
        String setupFolderString = Setup.getFolderFromListString(this.setupComboBox.getSelectedItem().toString());
        if (setupFolderString == null) {
            this.global.showError("Error occurred loading from setup folder.");
        }
        File setupFolder = new File(setupFolderString);
        try {
            this.setup.readFromFolder(setupFolder);
        }
        catch (IOException e) {
            this.global.showException("Error occurred loading from setup folder.", e);
        }
        this.lud = new LookUpDictionary(this.setup);
        this.confidenceWeights = new ConfidenceWeights(this.setup);
        this.docModel = new DocumentModel(this.setup, this.confidenceWeights, this.lud);
        this.docModel.addDocumentChangeListener(this);
        this.undoSupport.addUndoableEditListener(this.undoManager);
        this.documentView = new DocumentView(this.docModel, this.confidenceWeights, this.lud, this.undoSupport, this);
        this.documentView.setTransferHandler(new InteractiveTransferHandler());
        this.actions.putAll(this.documentView.getActions());
        JFrame.setDefaultLookAndFeelDecorated(true);
        final JPanel main = new JPanel(new BorderLayout());
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileSelectionMode(0);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(this.getActionByName("New"));
        fileMenu.add(this.getActionByName("Open"));
        fileMenu.addSeparator();
        fileMenu.add(this.getActionByName("Save"));
        fileMenu.add(this.getActionByName("Save As XML"));
        fileMenu.add(this.getActionByName("Save As Plain"));
        fileMenu.addSeparator();
        fileMenu.add(this.getActionByName("Save Dictionary"));
        fileMenu.add(this.getActionByName("Save Variant List"));
        fileMenu.add(this.getActionByName("Save Confidence Weights"));
        fileMenu.add(this.getActionByName("Save All"));
        fileMenu.addSeparator();
        fileMenu.add(this.getActionByName("Exit"));
        menuBar.add(fileMenu);
        this.getActionByName("Save Variant List").setEnabled(false);
        this.getActionByName("Save Dictionary").setEnabled(false);
        this.getActionByName("Save Confidence Weights").setEnabled(false);
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic(69);
        editMenu.add(this.getActionByName("Undo"));
        editMenu.add(this.getActionByName("Redo"));
        editMenu.addSeparator();
        editMenu.add(this.getActionByName("Join"));
        final JMenu foreignMenu = new JMenu(this.getActionByName("Foreign"));
        foreignMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent arg0) {
            }

            @Override
            public void menuDeselected(MenuEvent arg0) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                foreignMenu.removeAll();
                SortedSet<String> langs = MainScreen.this.docModel.getForeignLanguages();
                for (String lang : langs) {
                    foreignMenu.add(MainScreen.fixAction(MainScreen.this.documentView.getMarkAsForeignAction(lang), "Mark as " + lang, null, "Mark selected span as " + lang, -1, null));
                }
            }
        });
        editMenu.add(foreignMenu);
        editMenu.addSeparator();
        editMenu.add(this.getActionByName("Copy"));
        editMenu.add(this.getActionByName("Paste"));
        editMenu.addSeparator();
        editMenu.add(this.getActionByName("Select All"));
        menuBar.add(editMenu);
        JMenu styleMenu = new JMenu("Style");
        styleMenu.setMnemonic(83);
        styleMenu.add(this.getActionByName("Bold"));
        styleMenu.add(this.getActionByName("Italic"));
        styleMenu.add(this.getActionByName("Underline"));
        menuBar.add(styleMenu);
        JToolBar mainToolBar = new JToolBar("Functions");
        mainToolBar.setFloatable(false);
        mainToolBar.add(new TBJButton(this.getActionByName("New")));
        mainToolBar.add(new TBJButton(this.getActionByName("Open")));
        mainToolBar.add(new TBJButton(this.getActionByName("Save")));
        mainToolBar.add(new TBJButton(this.getActionByName("Save All")));
        mainToolBar.addSeparator();
        mainToolBar.add(new TBJButton(this.getActionByName("Undo")));
        mainToolBar.add(new TBJButton(this.getActionByName("Redo")));
        this.sampleToolBar = new JToolBar("Sample partitions");
        this.sampleToolBar.setFloatable(false);
        this.sampleToolBar.addSeparator();
        this.sampleToolBar.add(new TBJButton(this.getActionByName("Next queued partition")));
        this.sampleToolBar.add(new TBJButton(this.getActionByName("Mark partition done")));
        this.inProgressCB = new JComboBox();
        this.sampleToolBar.add(this.inProgressCB);
        this.sampleToolBar.add(new TBJButton(this.getActionByName("Edit started partition")));
        mainToolBar.add(this.sampleToolBar);
        JPanel fScorePanel = new JPanel(new BorderLayout());
        fScorePanel.setBorder(new TitledBorder("F-Score"));
        fScorePanel.setToolTipText("Change F-Score Precision/Recall weight");
        fScorePanel.add((Component)new JLabel("P"), "West");
        this.fScoreSlider = new JSlider(-4, 4, 0);
        this.fScoreSlider.setToolTipText("Change F-Score Precision/Recall weight");
        this.fScoreSlider.setMaximumSize(new Dimension(180, 50));
        this.fScoreSlider.setMajorTickSpacing(1);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(0, new JLabel("1"));
        labelTable.put(1, new JLabel("2"));
        labelTable.put(2, new JLabel("3"));
        labelTable.put(3, new JLabel("4"));
        labelTable.put(4, new JLabel("5"));
        labelTable.put(-1, new JLabel("\u00bd"));
        labelTable.put(-2, new JLabel("\u2153"));
        labelTable.put(-3, new JLabel("\u00bc"));
        labelTable.put(-4, new JLabel("\u2155"));
        this.fScoreSlider.setLabelTable(labelTable);
        this.fScoreSlider.setPaintLabels(true);
        this.fScoreSlider.setSnapToTicks(true);
        fScorePanel.add((Component)this.fScoreSlider, "Center");
        fScorePanel.add((Component)new JLabel("R"), "East");
        fScorePanel.add(Box.createGlue(), "North");
        fScorePanel.add(Box.createGlue(), "South");
        this.fScoreSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainScreen.this.confidenceWeights.setFWeight(ConfidenceWeights.calculateFWeight(MainScreen.this.fScoreSlider.getValue()));
            }
        });
        ConfidenceWeightsTableModel tableModel = new ConfidenceWeightsTableModel(this.confidenceWeights);
        JTable confidenceWeightsTable = new JTable(tableModel);
        confidenceWeightsTable.setEnabled(false);
        confidenceWeightsTable.setOpaque(false);
        confidenceWeightsTable.setShowHorizontalLines(true);
        confidenceWeightsTable.setShowVerticalLines(false);
        confidenceWeightsTable.setGridColor(Color.LIGHT_GRAY);
        FontMetrics cellMetrics = confidenceWeightsTable.getFontMetrics(confidenceWeightsTable.getFont());
        TableColumn col1 = confidenceWeightsTable.getColumnModel().getColumn(0);
        col1.setPreferredWidth(cellMetrics.stringWidth("Phonetic Matching") + 5);
        col1.setResizable(false);
        DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
        rightRenderer.setHorizontalAlignment(4);
        int i = 1;
        while (i < tableModel.getColumnCount()) {
            TableColumn col = confidenceWeightsTable.getColumnModel().getColumn(i);
            int width = cellMetrics.stringWidth("00.00%") + 10;
            col.setPreferredWidth(width);
            col.setResizable(false);
            col.setCellRenderer(rightRenderer);
            ++i;
        }
        JTableHeader confidenceWeightsTableHeader = confidenceWeightsTable.getTableHeader();
        JPanel cwPanel = new JPanel(new BorderLayout());
        cwPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        cwPanel.add((Component)confidenceWeightsTableHeader, "North");
        cwPanel.add((Component)confidenceWeightsTable, "Center");
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints tb = new GridBagConstraints();
        tb.anchor = 18;
        tb.fill = 0;
        topPanel.add((Component)mainToolBar, tb);
        GridBagConstraints s = new GridBagConstraints();
        s.gridx = 0;
        s.gridy = 1;
        s.weightx = 2.0;
        s.anchor = 16;
        s.fill = 2;
        topPanel.add((Component)setupPanel, s);
        GridBagConstraints b = new GridBagConstraints();
        b.gridheight = 2;
        b.weightx = 1.0;
        b.weighty = 1.0;
        b.fill = 1;
        topPanel.add(Box.createGlue(), b);
        GridBagConstraints f = new GridBagConstraints();
        f.gridheight = 2;
        f.weighty = 1.0;
        f.anchor = 12;
        f.fill = 3;
        topPanel.add((Component)fScorePanel, f);
        GridBagConstraints r = new GridBagConstraints();
        r.gridheight = 2;
        r.anchor = 12;
        r.fill = 0;
        topPanel.add((Component)cwPanel, r);
        main.add((Component)topPanel, "North");
        this.frame = new JFrame(PROGRAM_TITLE);
        this.sideBarPanels = new LinkedHashMap();
        this.sideBarPanels.put("Text", new DocumentSideBar(this.docModel, this.confidenceWeights, this.lud, this.undoSupport, this.documentView, this));
        this.sideBarPanels.put("Sample", new SampleSideBar(this.sampleModel, this.frame, this.confidenceWeights, this.lud, this.setup, this));
        this.sideBarPanels.put("Batch", new BatchScreenSideBar(this.frame, this.confidenceWeights, this.lud, this.setup));
        this.sideBarPanels.put("Train", new TrainingScreenSideBar(this.frame, this.confidenceWeights, this.lud, this.setup));
        this.sideBarPanels.put("Setup", new SetupSideBar(this.setup, this.frame, this, this));
        this.sideBarPanels.put("Rules", new RulesSideBar(this.lud));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabPlacement(1);
        for (Map.Entry<String, SideBarPanel> entry : this.sideBarPanels.entrySet()) {
            this.tabbedPane.addTab(entry.getKey(), entry.getValue());
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle maxWinSize = ge.getMaximumWindowBounds();
        final JSplitPane splitPane = new JSplitPane(1, this.documentView, this.tabbedPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(1.0);
        main.add((Component)splitPane, "Center");
        main.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
                Dimension dims = main.getSize();
                splitPane.setDividerLocation(dims.width - 310);
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
                this.componentResized(arg0);
            }
        });
        final JLayeredPane progressBarPane = new JLayeredPane();
        progressBarPane.setPreferredSize(new Dimension(maxWinSize.width, 20));
        this.progressBar = new JProgressBar(0, 0);
        this.progressBar.setValue(0);
        this.progressBar.setSize(new Dimension(maxWinSize.width - 10, 20));
        this.progressBar.setLocation(5, 0);
        this.progressBarLabel = new JLabel();
        this.resetProgressBarLabel();
        this.progressBarLabel.setSize(new Dimension(maxWinSize.width - 15, 20));
        this.progressBarLabel.setLocation(10, 0);
        this.progressBarLabel.setFont(new Font(this.progressBarLabel.getFont().getName(), 1, this.progressBarLabel.getFont().getSize()));
        progressBarPane.add((Component)this.progressBar, new Integer(0));
        progressBarPane.add((Component)this.progressBarLabel, new Integer(1));
        progressBarPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
                Dimension dims = progressBarPane.getSize();
                MainScreen.this.progressBarLabel.setSize(new Dimension(dims.width - 15, dims.height));
                MainScreen.this.progressBar.setSize(new Dimension(dims.width - 10, dims.height));
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
            }
        });
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainScreen.this.doExit();
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.frame.setJMenuBar(menuBar);
        this.frame.getContentPane().add((Component)main, "Center");
        this.frame.add((Component)progressBarPane, "South");
        this.frame.setMaximizedBounds(maxWinSize);
        this.frame.setBounds(maxWinSize.x, maxWinSize.y, maxWinSize.width, maxWinSize.height);
        this.global.finishProgress();
        this.global.setProgressHandler(this);
        this.global.setErrorHandler(this);
        this.show();
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Completing startup...");
        this.lud.addDataChangeListener(this);
        this.confidenceWeights.addChangeListener(this);
        this.global.unlockFinishProgress();
        this.global.finishProgress();
    }

    public static Action fixAction(Action action, String name, String icon, String description, int mnemonic, KeyStroke keyStroke) {
        URL iconURL;
        if (name != null) {
            action.putValue("Name", name);
        }
        if (icon != null && (iconURL = MainScreen.class.getResource("icons/" + icon + ".png")) != null) {
            action.putValue("SmallIcon", new ImageIcon(iconURL));
        }
        if (description != null) {
            action.putValue("ShortDescription", description);
        }
        if (mnemonic != -1) {
            action.putValue("MnemonicKey", new Integer(mnemonic));
        }
        if (keyStroke != null) {
            action.putValue("AcceleratorKey", keyStroke);
        }
        return action;
    }

    private Action getActionByName(String name) {
        return this.actions.get(name);
    }

    private void show() {
        this.frame.setVisible(true);
        this.documentView.textSelectionChanged(0, 0);
        this.documentView.requestFocus();
    }

    private void resetProgressBarLabel() {
        this.progressBarLabel.setText("");
    }

    private void setProgressBarLabelLoading(String text) {
        this.progressBarLabel.setText(text);
    }

    private void saveAll() throws BadLocationException, IOException, InvalidInstanceChangeException {
        if (this.docModel.hasDocumentChanged()) {
            this.saveToCurrentFile();
        }
        if (this.confidenceWeights.hasChanged()) {
            this.confidenceWeights.save(this.setup);
        }
        if (this.lud.isWordsChanged()) {
            this.lud.writeWordsToFile();
        }
        if (this.lud.isVariantsChanged()) {
            this.lud.writeVariantsToFile();
        }
    }

    private boolean checkSave() {
        JPanel savePanel = new JPanel(new GridLayout(0, 1));
        JCheckBox docCB = new JCheckBox("Current Document", false);
        JCheckBox cwCB = new JCheckBox("Confidence Weights", false);
        JCheckBox dCB = new JCheckBox("Dictionary", false);
        JCheckBox vCB = new JCheckBox("Variant list", false);
        JCheckBox rCB = new JCheckBox("Letter replacement rules", false);
        savePanel.add(new JLabel("Tick changes to save:"));
        boolean saveNeeded = false;
        if (this.docModel.hasDocumentChanged()) {
            docCB.setSelected(true);
            savePanel.add(docCB);
            saveNeeded = true;
        }
        if (this.confidenceWeights.hasChanged()) {
            cwCB.setSelected(true);
            savePanel.add(cwCB);
            saveNeeded = true;
        }
        if (this.lud.isWordsChanged()) {
            dCB.setSelected(true);
            savePanel.add(dCB);
            saveNeeded = true;
        }
        if (this.lud.isVariantsChanged()) {
            vCB.setSelected(true);
            savePanel.add(vCB);
            saveNeeded = true;
        }
        if (this.lud.isRulesChanged()) {
            rCB.setSelected(true);
            savePanel.add(rCB);
            saveNeeded = true;
        }
        if (!saveNeeded) {
            return true;
        }
        Object[] options = new Object[]{"Save changes", "Discard changes", "Cancel"};
        int pc = JOptionPane.showOptionDialog(this.frame, savePanel, "Save changes?", 1, 3, null, options, options[0]);
        if (pc == 0) {
            block16: {
                if (!docCB.isSelected() || this.saveToCurrentFile()) break block16;
                return false;
            }
            try {
                if (dCB.isSelected()) {
                    this.lud.writeWordsToFile();
                }
                if (vCB.isSelected()) {
                    this.lud.writeVariantsToFile();
                }
                if (rCB.isSelected()) {
                    this.lud.writeRulesToFile();
                }
                if (cwCB.isSelected()) {
                    this.confidenceWeights.save(this.setup);
                }
                return true;
            }
            catch (IOException e) {
                this.global.showException("Error writing file, please report.", e);
                return false;
            }
            catch (BadLocationException e) {
                this.global.showException("Error writing file, please report.", e);
                return false;
            }
            catch (InvalidInstanceChangeException e) {
                this.global.showException("Error writing file, please report.", e);
                return false;
            }
        }
        return pc == 1;
    }

    private void doExit() {
        try {
            class Worker
            extends SwingWorkerAction {
                Worker() {
                }

                @Override
                public void action() {
                    if (MainScreen.this.checkSave()) {
                        System.exit(0);
                    }
                }
            }
            new Worker().runAction();
        }
        catch (InterruptedException e) {
            this.global.showException("An error occurred saving.", e);
        }
        catch (ExecutionException e) {
            this.global.showException("An error occurred saving.", e);
        }
    }

    private void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        for (Action a : this.actions.values()) {
            a.setEnabled(enabled);
        }
        this.documentView.setEnabled(enabled);
        for (SideBarPanel sidebar : this.sideBarPanels.values()) {
            sidebar.setEnabled(enabled);
        }
        this.fScoreSlider.setEnabled(enabled);
        this.setupComboBox.setEnabled(enabled);
        if (enabled) {
            this.undoManager.refreshUndoRedoUI();
            this.getActionByName("Save").setEnabled(this.docModel.hasDocumentChanged());
            this.getActionByName("Save Variant List").setEnabled(this.lud.isVariantsChanged());
            this.getActionByName("Save Dictionary").setEnabled(this.lud.isWordsChanged());
            this.getActionByName("Save Confidence Weights").setEnabled(this.confidenceWeights.hasChanged());
            this.getActionByName("Save All").setEnabled(this.docModel.hasDocumentChanged() && this.docModel.isFileSavedSet() || this.lud.isVariantsChanged() || this.lud.isWordsChanged() || this.confidenceWeights.hasChanged());
            this.enableSampleRelevant(this.docModel.isSamplePartition());
        }
    }

    private boolean saveToCurrentFile() throws BadLocationException, IOException, InvalidInstanceChangeException {
        if (this.docModel.getFileSaved() != null) {
            if (this.docModel.getFileSavedType() == DocumentModel.FileType.XML) {
                return this.docModel.saveWithTags(this.docModel.getFileSaved());
            }
            return this.docModel.saveWithoutTags(this.docModel.getFileSaved());
        }
        if (this.docModel.isSamplePartition()) {
            return this.saveWithTags();
        }
        Object[] options = new Object[]{"Save with XML tags", "Save without XML tags"};
        Object o = JOptionPane.showInputDialog(this.frame, "How would you like to save the file?", "Save as?", 3, null, options, options[0]);
        if (o == null) {
            return false;
        }
        if (o.equals(options[0])) {
            return this.saveWithTags();
        }
        if (o.equals(options[1])) {
            return this.saveWithoutTags();
        }
        return false;
    }

    private boolean saveWithoutTags() throws BadLocationException, IOException {
        int returnVal = this.fileChooser.showSaveDialog(this.frame);
        if (returnVal == 0) {
            int yn;
            File fileSelected = this.fileChooser.getSelectedFile();
            if (fileSelected.exists() && (yn = JOptionPane.showConfirmDialog(this.frame, "You are overwriting an existing file, continue?", "Overwrite?", 2)) == 2) {
                return false;
            }
            return this.docModel.saveWithoutTags(fileSelected);
        }
        return false;
    }

    private boolean saveWithTags() throws BadLocationException, IOException, InvalidInstanceChangeException {
        int returnVal = this.fileChooser.showSaveDialog(this.frame);
        if (returnVal == 0) {
            int yn;
            File fileSelected = this.fileChooser.getSelectedFile();
            if (fileSelected.exists() && (yn = JOptionPane.showConfirmDialog(this.frame, "You are overwriting an existing file, continue?", "Overwrite?", 2)) == 2) {
                return false;
            }
            return this.docModel.saveWithTags(fileSelected);
        }
        return false;
    }

    @Override
    public void showException(String message, Throwable e) {
        JOptionPane.showMessageDialog(this.frame, String.valueOf(message) + "\n\n" + e.getMessage(), "Error", 0);
    }

    @Override
    public void showError(String message) {
        JOptionPane.showMessageDialog(this.frame, message, "Error", 0);
    }

    @Override
    public void writeProgressMessage(String message) {
        this.setProgressBarLabelLoading(message);
    }

    @Override
    public void rulesChanged(boolean changed) {
    }

    @Override
    public void variantsChanged(boolean changed) {
        if (this.isEnabled) {
            this.getActionByName("Save Variant List").setEnabled(changed);
            this.getActionByName("Save All").setEnabled(this.docModel.hasDocumentChanged() && this.docModel.isFileSavedSet() || this.lud.isVariantsChanged() || this.lud.isWordsChanged() || this.confidenceWeights.hasChanged());
        }
    }

    @Override
    public void wordsChanged(boolean changed) {
        if (this.isEnabled) {
            this.getActionByName("Save Dictionary").setEnabled(changed);
            this.getActionByName("Save All").setEnabled(this.docModel.hasDocumentChanged() && this.docModel.isFileSavedSet() || this.lud.isVariantsChanged() || this.lud.isWordsChanged() || this.confidenceWeights.hasChanged());
        }
    }

    @Override
    public void weightsChanged(boolean changed) {
        if (this.isEnabled) {
            this.getActionByName("Save Confidence Weights").setEnabled(changed);
            this.getActionByName("Save All").setEnabled(this.docModel.hasDocumentChanged() && this.docModel.isFileSavedSet() || this.lud.isVariantsChanged() || this.lud.isWordsChanged() || this.confidenceWeights.hasChanged());
        }
    }

    @Override
    public void setProgressCurrent(final int current) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainScreen.this.progressBar.setValue(current);
            }
        });
    }

    @Override
    public void terminateProgressDisplay() {
    }

    @Override
    public void startIndeterminateProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainScreen.this.progressBar.setIndeterminate(true);
                MainScreen.this.setEnabled(false);
            }
        });
    }

    @Override
    public void finishProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainScreen.this.resetProgressBarLabel();
                MainScreen.this.progressBar.setIndeterminate(false);
                MainScreen.this.setEnabled(true);
            }
        });
    }

    @Override
    public void startProgress(final int max) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainScreen.this.progressBar.setIndeterminate(false);
                MainScreen.this.progressBar.setMaximum(max);
                MainScreen.this.setEnabled(false);
            }
        });
    }

    private JComboBox createCombo(ComboBoxModel comboBoxModel) {
        return new JComboBox(comboBoxModel){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
    }

    @Override
    public QuestionAsker.Answer askYesNoQuestion(String title, String message) {
        int o = JOptionPane.showOptionDialog(this.frame, message, title, 0, 3, null, null, null);
        switch (o) {
            case 0: {
                return QuestionAsker.Answer.Yes;
            }
        }
        return QuestionAsker.Answer.No;
    }

    @Override
    public QuestionAsker.Answer askYesNoCancelQuestion(String title, String message) {
        int o = JOptionPane.showOptionDialog(this.frame, message, title, 1, 3, null, null, null);
        switch (o) {
            case 0: {
                return QuestionAsker.Answer.Yes;
            }
            case 1: {
                return QuestionAsker.Answer.No;
            }
        }
        return QuestionAsker.Answer.Cancel;
    }

    @Override
    public QuestionAsker.Answer askFormQuestion(JComponent component, String title) {
        int o = JOptionPane.showConfirmDialog(this.frame, component, title, 2, -1);
        switch (o) {
            case 0: {
                return QuestionAsker.Answer.OK;
            }
        }
        return QuestionAsker.Answer.Cancel;
    }

    @Override
    public QuestionAsker.Answer askOkCancelQuestion(String title, String message) {
        int o = JOptionPane.showOptionDialog(this.frame, message, title, 2, 3, null, null, null);
        switch (o) {
            case 0: {
                return QuestionAsker.Answer.OK;
            }
        }
        return QuestionAsker.Answer.Cancel;
    }

    @Override
    public boolean changeSetup(Setup setup) {
        if (this.checkSave()) {
            this.lud.changeSetup(setup);
            this.confidenceWeights.changeSetup(setup);
            try {
                this.docModel.changeSetup(setup);
            }
            catch (BadLocationException e) {
                this.global.showException("Error occurred re-loading file, please report.", e);
            }
            catch (InvalidInstanceChangeException e) {
                this.global.showException("Error occurred re-loading file, please report.", e);
            }
            catch (IOException e) {
                this.global.showException("Error occurred re-loading file, please report.", e);
            }
            for (SideBarPanel sidebar : this.sideBarPanels.values()) {
                sidebar.changeSetup(setup);
            }
            this.changeSetupAction.turnOff();
            try {
                this.setupComboBox.setModel(new DefaultComboBoxModel<String>(Setup.getPreviousSetupsList()));
            }
            catch (IOException e) {
                this.global.showException("An error occurred loading previous setup lists", e);
            }
            this.setupComboBox.setSelectedItem(setup.getListString());
            this.changeSetupAction.turnOn();
            return true;
        }
        return false;
    }

    private void enableSampleRelevant(boolean displayingSample) {
        this.inProgressCB.setEnabled(this.isEnabled && this.sampleModel.getStartedPartitionsSize() > 0);
        this.getActionByName("Edit started partition").setEnabled(this.isEnabled && this.sampleModel.getStartedPartitionsSize() > 0);
        this.getActionByName("Next queued partition").setEnabled(this.isEnabled && this.sampleModel.getQueuedPartitionsSize() > 0);
        this.getActionByName("Mark partition done").setEnabled(this.isEnabled && displayingSample);
        this.getActionByName("Save As Plain").setEnabled(this.isEnabled && !displayingSample);
    }

    @Override
    public void currentPartitionChanged(Partition partition) {
        this.inProgressCB.setSelectedItem(partition);
        if (partition != null) {
            this.enableSampleRelevant(true);
            try {
                class Worker
                extends SwingWorkerAction {
                    private final /* synthetic */ Partition val$partition;

                    Worker(Partition partition) {
                        this.val$partition = partition;
                    }

                    @Override
                    public void action() {
                        if (MainScreen.this.checkSave()) {
                            try {
                                MainScreen.this.docModel.openPartition(this.val$partition);
                            }
                            catch (BadLocationException e) {
                                MainScreen.this.global.showException("Error occurred opening partition.", e);
                            }
                            catch (InvalidInstanceChangeException e) {
                                MainScreen.this.global.showException("Error occurred opening partition.", e);
                            }
                            catch (IOException e) {
                                MainScreen.this.global.showException("Error occurred opening partition.", e);
                            }
                        }
                    }
                }
                new Worker(partition).runAction();
            }
            catch (InterruptedException e) {
                this.global.showException("An error occurred changing partition.", e);
            }
            catch (ExecutionException e) {
                this.global.showException("An error occurred changing partition.", e);
            }
        } else {
            this.enableSampleRelevant(false);
            if (this.checkSave()) {
                this.docModel.newEmptyDocument();
            }
        }
    }

    @Override
    public void partitionDistributionChanged() {
        this.inProgressCB.setModel(new DefaultComboBoxModel<Object>(this.sampleModel.getStartedPartitions().toArray()));
        this.enableSampleRelevant(this.docModel.isSamplePartition());
    }

    @Override
    public void documentChangedFromSaved(boolean changed) {
        if (this.isEnabled) {
            this.getActionByName("Save").setEnabled(changed);
            this.getActionByName("Save All").setEnabled(this.docModel.hasDocumentChanged() && this.docModel.isFileSavedSet() || this.lud.isVariantsChanged() || this.lud.isWordsChanged() || this.confidenceWeights.hasChanged());
        }
    }

    @Override
    public void fileChanged() {
        this.getActionByName("Save As Plain").setEnabled(this.isEnabled && !this.docModel.isSamplePartition());
        this.undoManager.discardAllEdits();
        this.undoManager.refreshUndoRedoUI();
    }

    @Override
    public void cleared() {
    }

    /* synthetic */ MainScreen(MainScreen mainScreen) {
        this();
    }

    private class ChangeSetupAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 7624514418560494295L;
        private boolean performAction = true;

        private void turnOff() {
            this.performAction = false;
        }

        private void turnOn() {
            this.performAction = true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.performAction) {
                try {
                    class Worker
                    extends SwingWorkerAction {
                        Worker() {
                        }

                        @Override
                        public void action() {
                            ChangeSetupAction.this.turnOff();
                            if (MainScreen.this.checkSave()) {
                                MainScreen.this.setup = new Setup();
                                String setupFolderString = Setup.getFolderFromListString(MainScreen.this.setupComboBox.getSelectedItem().toString());
                                if (setupFolderString == null) {
                                    MainScreen.this.global.showError("Error occurred loading from setup folder.");
                                    return;
                                }
                                File setupFolder = new File(setupFolderString);
                                try {
                                    MainScreen.this.setup.readFromFolder(setupFolder);
                                    MainScreen.this.setupComboBox.setModel(new DefaultComboBoxModel<String>(Setup.getPreviousSetupsList()));
                                }
                                catch (IOException ex) {
                                    MainScreen.this.global.showException("Error occurred loading from setup folder.", ex);
                                    return;
                                }
                                MainScreen.this.lud.changeSetup(MainScreen.this.setup);
                                MainScreen.this.confidenceWeights.changeSetup(MainScreen.this.setup);
                                try {
                                    MainScreen.this.docModel.changeSetup(MainScreen.this.setup);
                                }
                                catch (BadLocationException e) {
                                    MainScreen.this.global.showException("Error occurred re-loading file, please report.", e);
                                }
                                catch (InvalidInstanceChangeException e) {
                                    MainScreen.this.global.showException("Error occurred re-loading file, please report.", e);
                                }
                                catch (IOException e) {
                                    MainScreen.this.global.showException("Error occurred re-loading file, please report.", e);
                                }
                                for (SideBarPanel sidebar : MainScreen.this.sideBarPanels.values()) {
                                    sidebar.changeSetup(MainScreen.this.setup);
                                }
                            } else {
                                MainScreen.this.setupComboBox.setSelectedItem(MainScreen.this.setup.getListString());
                            }
                            ChangeSetupAction.this.turnOn();
                        }
                    }
                    new Worker().runAction();
                }
                catch (InterruptedException e1) {
                    MainScreen.this.global.showException("An error occurred changing setup.", e1);
                }
                catch (ExecutionException e1) {
                    MainScreen.this.global.showException("An error occurred changing setup.", e1);
                }
            }
        }
    }

    public static final class ClipboardTextTransfer
    implements ClipboardOwner {
        @Override
        public void lostOwnership(Clipboard aClipboard, Transferable aContents) {
        }

        public void setClipboardContents(String text) {
            try {
                StringSelection stringSelection = new StringSelection(text);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, this);
            }
            catch (IllegalStateException ex) {
                Globals.getInstance().showException("Error occurred whilst copying to clipboard.", ex);
            }
        }
    }

    private class EditStartedPartitionAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -8446586664113182319L;

        private EditStartedPartitionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Partition selectedPartition = (Partition)MainScreen.this.inProgressCB.getSelectedItem();
            if (selectedPartition != null) {
                MainScreen.this.sampleModel.processStartedPartion(selectedPartition);
            }
        }
    }

    private class ExitAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 6496262943261420464L;

        private ExitAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.this.doExit();
        }
    }

    private class InteractiveTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 6231756482449647494L;

        private InteractiveTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            if (info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return true;
            }
            return info.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List files;
                try {
                    files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                }
                catch (UnsupportedFlavorException ex) {
                    JOptionPane.showMessageDialog(null, "Error occurred selecting setup folder.\n\n" + ex.getMessage(), "Error", 0);
                    return false;
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, "Error occurred selecting setup folder.\n\n" + ex.getMessage(), "Error", 0);
                    return false;
                }
                if (files.isEmpty()) {
                    return false;
                }
                if (files.size() > 1) {
                    JOptionPane.showMessageDialog(null, "The interactive mode can only be used with one file at a time. Please use the Batch mode to process multiple texts.", "Warning", 2);
                    return false;
                }
                File file = (File)files.get(0);
                if (file.isDirectory()) {
                    JOptionPane.showMessageDialog(null, "The interactive mode can only be used with one file at a time. Please use the Batch mode to process multiple texts.", "Warning", 2);
                    return false;
                }
                try {
                    class Worker
                    extends SwingWorkerAction {
                        private final /* synthetic */ File val$file;

                        Worker(File file) {
                            this.val$file = file;
                        }

                        @Override
                        public void action() {
                            if (MainScreen.this.checkSave()) {
                                try {
                                    MainScreen.this.docModel.processNewFile(this.val$file, false, false);
                                }
                                catch (BadLocationException e) {
                                    MainScreen.this.global.showException("Error occurred opening file.", e);
                                }
                                catch (InvalidInstanceChangeException e) {
                                    MainScreen.this.global.showException("Error occurred opening file.", e);
                                }
                            }
                        }
                    }
                    new Worker(file).runAction();
                }
                catch (InterruptedException e) {
                    MainScreen.this.global.showException("An error occurred processing new file.", e);
                }
                catch (ExecutionException e) {
                    MainScreen.this.global.showException("An error occurred processing new file.", e);
                }
                return true;
            }
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String text;
                try {
                    text = (String)t.getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException ex) {
                    MainScreen.this.global.showException("Error occurred dragging and dropping text.", ex);
                    MainScreen.this.global.unlockFinishProgress();
                    MainScreen.this.global.finishProgress();
                    return false;
                }
                catch (IOException ex) {
                    MainScreen.this.global.showException("Error occurred dragging and dropping text.", ex);
                    MainScreen.this.global.unlockFinishProgress();
                    MainScreen.this.global.finishProgress();
                    return false;
                }
                if (text == null || text.equals("")) {
                    return false;
                }
                MainScreen.this.documentView.insertText(text);
                return true;
            }
            return false;
        }
    }

    private class MarkPartitionAsCompleteAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -7275830361201799128L;

        private MarkPartitionAsCompleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                class Worker
                extends SwingWorkerAction {
                    Worker() {
                    }

                    @Override
                    public void action() {
                        try {
                            MainScreen.this.docModel.markCurrentPartitionAsDone();
                            MainScreen.this.saveAll();
                            MainScreen.this.sampleModel.markCurrentPartitionAsDone();
                        }
                        catch (BadLocationException e) {
                            MainScreen.this.global.showException("Error occurred saving file, please report.", e);
                        }
                        catch (IOException e) {
                            MainScreen.this.global.showException("Error occurred saving file, please report.", e);
                        }
                        catch (InvalidInstanceChangeException e) {
                            MainScreen.this.global.showException("Error occurred saving file, please report.", e);
                        }
                    }
                }
                new Worker().runAction();
            }
            catch (InterruptedException e1) {
                MainScreen.this.global.showException("An error occurred marking partition as done.", e1);
            }
            catch (ExecutionException e1) {
                MainScreen.this.global.showException("An error occurred marking partition as done.", e1);
            }
        }
    }

    private class NewAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -6218890096674492767L;

        private NewAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.this.docModel.newEmptyDocument();
        }
    }

    private class NextQueuedPartitionAction
    extends AbstractAction {
        private static final long serialVersionUID = 127278163431158910L;

        private NextQueuedPartitionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.this.sampleModel.nextQueuedPartition();
        }
    }

    private class OpenAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -2167496422726054143L;

        private OpenAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                class Worker
                extends SwingWorkerAction {
                    Worker() {
                    }

                    @Override
                    public void action() {
                        int returnVal;
                        if (MainScreen.this.checkSave() && (returnVal = MainScreen.this.fileChooser.showOpenDialog(MainScreen.this.frame)) == 0) {
                            File fileSelected = MainScreen.this.fileChooser.getSelectedFile();
                            if (fileSelected == null) {
                                MainScreen.this.global.showError("No file selected");
                                return;
                            }
                            try {
                                MainScreen.this.docModel.processNewFile(fileSelected, false, false);
                            }
                            catch (BadLocationException e) {
                                MainScreen.this.global.showException("Error occurred opening file, please report.", e);
                            }
                            catch (InvalidInstanceChangeException e) {
                                MainScreen.this.global.showException("Error occurred opening file, please report.", e);
                            }
                        }
                    }
                }
                new Worker().runAction();
            }
            catch (InterruptedException e1) {
                MainScreen.this.global.showException("An error occurred processing new file.", e1);
            }
            catch (ExecutionException e1) {
                MainScreen.this.global.showException("An error occurred processing new file.", e1);
            }
        }
    }

    private class RedoAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -7714793221124041484L;

        private RedoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.this.undoManager.redo();
        }
    }

    private class SaveAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 1035721027447348802L;

        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                class Worker
                extends SwingWorkerAction {
                    Worker() {
                    }

                    @Override
                    public void action() {
                        try {
                            MainScreen.this.saveToCurrentFile();
                        }
                        catch (BadLocationException e) {
                            MainScreen.this.global.showException("An error occurred saving file, please report.", e);
                        }
                        catch (IOException e) {
                            MainScreen.this.global.showException("An error occurred saving file, please report.", e);
                        }
                        catch (InvalidInstanceChangeException e) {
                            MainScreen.this.global.showException("An error occurred saving file, please report.", e);
                        }
                    }
                }
                new Worker().runAction();
            }
            catch (InterruptedException e1) {
                MainScreen.this.global.showException("An error occurred saving file.", e1);
            }
            catch (ExecutionException e1) {
                MainScreen.this.global.showException("An error occurred saving file.", e1);
            }
        }
    }

    private class SaveAllAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -7275830361201799128L;

        private SaveAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                class Worker
                extends SwingWorkerAction {
                    Worker() {
                    }

                    @Override
                    public void action() {
                        try {
                            MainScreen.this.saveAll();
                        }
                        catch (BadLocationException e) {
                            MainScreen.this.global.showException("Error occurred saving file, please report.", e);
                        }
                        catch (IOException e) {
                            MainScreen.this.global.showException("Error occurred saving file, please report.", e);
                        }
                        catch (InvalidInstanceChangeException e) {
                            MainScreen.this.global.showException("Error occurred saving file, please report.", e);
                        }
                    }
                }
                new Worker().runAction();
            }
            catch (InterruptedException e1) {
                MainScreen.this.global.showException("An error occurred saving data.", e1);
            }
            catch (ExecutionException e1) {
                MainScreen.this.global.showException("An error occurred saving data.", e1);
            }
        }
    }

    private class SaveConfidenceWeightsAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -7275830361201799128L;

        private SaveConfidenceWeightsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                class Worker
                extends SwingWorkerAction {
                    Worker() {
                    }

                    @Override
                    public void action() {
                        try {
                            MainScreen.this.confidenceWeights.save(MainScreen.this.setup);
                        }
                        catch (IOException ex) {
                            MainScreen.this.global.showException("Error writing confidence weights.", ex);
                        }
                    }
                }
                new Worker().runAction();
            }
            catch (InterruptedException e1) {
                MainScreen.this.global.showException("An error occurred saving confidence weights.", e1);
            }
            catch (ExecutionException e1) {
                MainScreen.this.global.showException("An error occurred saving confidence weights.", e1);
            }
        }
    }

    private class SaveDictionaryAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 7397383512576562239L;

        private SaveDictionaryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                class Worker
                extends SwingWorkerAction {
                    Worker() {
                    }

                    @Override
                    public void action() {
                        try {
                            MainScreen.this.lud.writeWordsToFile();
                        }
                        catch (IOException ex) {
                            MainScreen.this.global.showException("Error writing words.txt.", ex);
                        }
                    }
                }
                new Worker().runAction();
            }
            catch (InterruptedException e1) {
                MainScreen.this.global.showException("An error occurred saving dictionary.", e1);
            }
            catch (ExecutionException e1) {
                MainScreen.this.global.showException("An error occurred saving dictionary.", e1);
            }
        }
    }

    private class SaveVariantsAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 7397383512576562239L;

        private SaveVariantsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                class Worker
                extends SwingWorkerAction {
                    Worker() {
                    }

                    @Override
                    public void action() {
                        try {
                            MainScreen.this.lud.writeVariantsToFile();
                        }
                        catch (IOException ex) {
                            MainScreen.this.global.showException("Error writing variants.txt.", ex);
                        }
                    }
                }
                new Worker().runAction();
            }
            catch (InterruptedException e1) {
                MainScreen.this.global.showException("An error occurred saving variants file.", e1);
            }
            catch (ExecutionException e1) {
                MainScreen.this.global.showException("An error occurred saving variants file.", e1);
            }
        }
    }

    private class SaveWithTagsAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 2998037746672741986L;

        private SaveWithTagsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                class Worker
                extends SwingWorkerAction {
                    Worker() {
                    }

                    @Override
                    public void action() {
                        try {
                            MainScreen.this.saveWithTags();
                        }
                        catch (BadLocationException e) {
                            MainScreen.this.global.showException("An error occurred saving file, please report.", e);
                        }
                        catch (IOException e) {
                            MainScreen.this.global.showException("An error occurred saving file, please report.", e);
                        }
                        catch (InvalidInstanceChangeException e) {
                            MainScreen.this.global.showException("An error occurred saving file, please report.", e);
                        }
                    }
                }
                new Worker().runAction();
            }
            catch (InterruptedException e) {
                MainScreen.this.global.showException("An error occurred saving file.", e);
            }
            catch (ExecutionException e) {
                MainScreen.this.global.showException("An error occurred saving file.", e);
            }
        }
    }

    private class SaveWithoutTagsAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 3551298055490692028L;

        private SaveWithoutTagsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                class Worker
                extends SwingWorkerAction {
                    Worker() {
                    }

                    @Override
                    public void action() {
                        try {
                            MainScreen.this.saveWithoutTags();
                        }
                        catch (BadLocationException e) {
                            MainScreen.this.global.showException("An error occurred saving file, please report.", e);
                        }
                        catch (IOException e) {
                            MainScreen.this.global.showException("An error occurred saving file, please report.", e);
                        }
                    }
                }
                new Worker().runAction();
            }
            catch (InterruptedException e1) {
                MainScreen.this.global.showException("An error occurred saving file.", e1);
            }
            catch (ExecutionException e1) {
                MainScreen.this.global.showException("An error occurred saving file.", e1);
            }
        }
    }

    private class SetupBrowseAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 29075498098392224L;

        private SetupBrowseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int setupReturnVal = MainScreen.this.setupFC.showSaveDialog(MainScreen.this.frame);
            if (setupReturnVal == 0) {
                File folder = MainScreen.this.setupFC.getSelectedFile();
                try {
                    MainScreen.this.setupComboBox.setSelectedItem(Setup.getListStringFromFolder(folder));
                }
                catch (IOException ex) {
                    MainScreen.this.global.showError("Error occurred selecting setup folder.");
                }
            }
        }
    }

    private class SetupFolderTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -260318740428503951L;

        private SetupFolderTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            List files;
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                MainScreen.this.global.showException("Error occurred selecting setup folder.", ex);
                return false;
            }
            catch (IOException ex) {
                MainScreen.this.global.showException("Error occurred selecting setup folder.", ex);
                return false;
            }
            if (files.isEmpty()) {
                return false;
            }
            File folder = (File)files.get(0);
            if (!folder.isDirectory()) {
                folder = folder.getParentFile();
            }
            try {
                MainScreen.this.setupComboBox.setSelectedItem(Setup.getListStringFromFolder(folder));
            }
            catch (IOException ex) {
                MainScreen.this.global.showException("Error occurred selecting setup folder.", ex);
                return false;
            }
            return true;
        }
    }

    private class UIUpdatingUndoManager
    extends UndoManager {
        private static final long serialVersionUID = -4525959504955190941L;
        private StackListModel<String> undoList;
        private StackListModel<String> redoList;

        private UIUpdatingUndoManager() {
            this.setLimit(1000);
            this.undoList = new StackListModel();
            this.redoList = new StackListModel();
        }

        @Override
        public void discardAllEdits() {
            this.undoList.clear();
            this.redoList.clear();
            super.discardAllEdits();
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.canUndo()) {
                super.undo();
                this.undoList.remove();
                this.redoList.add(this.getRedoPresentationName());
                this.refreshUndoRedoUI();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.canRedo()) {
                super.redo();
                this.redoList.remove();
                this.undoList.add(this.getUndoPresentationName());
                this.refreshUndoRedoUI();
            }
        }

        @Override
        public boolean addEdit(UndoableEdit edit) {
            boolean toReturn = super.addEdit(edit);
            this.refreshUndoRedoUI();
            this.undoList.add(this.getUndoPresentationName());
            this.redoList.clear();
            return toReturn;
        }

        private void refreshUndoRedoUI() {
            Action undoAction = MainScreen.this.getActionByName("Undo");
            undoAction.setEnabled(this.canUndo());
            if (this.canUndo()) {
                undoAction.putValue("ShortDescription", this.getUndoPresentationName());
            } else {
                undoAction.putValue("ShortDescription", "Nothing to undo");
            }
            Action redoAction = MainScreen.this.getActionByName("Redo");
            redoAction.setEnabled(this.canRedo());
            if (this.canRedo()) {
                redoAction.putValue("ShortDescription", this.getRedoPresentationName());
            } else {
                redoAction.putValue("ShortDescription", "Nothing to redo");
            }
        }
    }

    private class UndoAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -4167460240567150171L;

        private UndoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.this.undoManager.undo();
        }
    }
}

