/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.sidebar.TextPrompt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import model.ErrorMessageHandler;
import model.Globals;
import model.ProgressListener;
import model.Setup;

public class BatchScreen
implements ActionListener,
ProgressListener,
ErrorMessageHandler {
    static final Dimension SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
    private JButton[] buttons = new JButton[]{new JButton("Add file(s)"), new JButton("Add folder(s)"), new JButton("Remove selected file(s)"), new JButton("Clear list"), new JButton("Process listed file(s)"), new JButton("Exit"), new JButton("Browse"), new JButton("Browse")};
    private JList fileList;
    private TreeSet<File> files = new TreeSet();
    private JScrollPane fileListSP;
    private JTextField outputFolderTF;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private JFileChooser fc;
    private JFileChooser setupFC;
    private JFrame frame;
    private JSpinner thresholdSpinner;
    private JSlider fScoreSlider;
    private JComboBox setupComboBox;
    private JCheckBox searchSubFoldersCheckBox;
    private JCheckBox xmlCheckBox;
    private JCheckBox plainCheckBox;
    private JCheckBox useCacheCheckBox;
    private static Globals global;

    public static void run() {
        global = Globals.getInstance();
        new Thread(){

            @Override
            public void run() {
                global.startIndeterminateProgress();
                global.writeProgressMessage("Loading user interface...");
                BatchScreen ui = new BatchScreen(null);
                global.finishProgress();
                global.setProgressHandler(ui);
                global.setErrorHandler(ui);
            }
        }.start();
    }

    private BatchScreen() {
        this.fileList = new JList<Object>(this.files.toArray());
        this.fileList.setVisibleRowCount(10);
        this.fileList.setTransferHandler(new AddTransferHandler());
        this.fileListSP = new JScrollPane(this.fileList, 22, 32);
        this.fileListSP.setAlignmentX(0.0f);
        JButton[] jButtonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            JButton button = jButtonArray[n2];
            button.addActionListener(this);
            ++n2;
        }
        JPanel inputButtonsPanel = new JPanel(new GridLayout(7, 1));
        int i = 0;
        while (i < 4) {
            inputButtonsPanel.add(this.buttons[i]);
            ++i;
        }
        this.searchSubFoldersCheckBox = new JCheckBox("Search subfolders?");
        inputButtonsPanel.add(this.searchSubFoldersCheckBox);
        inputButtonsPanel.add(Box.createVerticalGlue());
        inputButtonsPanel.add(Box.createVerticalGlue());
        JPanel inputPanel = new JPanel(new BorderLayout());
        inputPanel.setBorder(BorderFactory.createTitledBorder("Input"));
        inputPanel.add((Component)this.fileListSP, "Center");
        inputPanel.add((Component)inputButtonsPanel, "East");
        JPanel setupPanel = new JPanel(new BorderLayout());
        setupPanel.setBorder(BorderFactory.createTitledBorder("Setup"));
        Vector<Object> previousSetups = new Vector();
        try {
            previousSetups = Setup.getPreviousSetupsList();
        }
        catch (IOException e) {
            global.showException("Error occurred collecting list of previous setups", e);
            return;
        }
        this.setupComboBox = new JComboBox(previousSetups);
        this.setupComboBox.setEditable(true);
        setupPanel.setTransferHandler(new SetupFolderTransferHandler());
        final JTextField comboBoxTF = new JTextField(20);
        comboBoxTF.setTransferHandler(new SetupFolderTransferHandler());
        comboBoxTF.setEditable(false);
        this.setupComboBox.setEditor(new ComboBoxEditor(){

            @Override
            public void addActionListener(ActionListener arg0) {
                comboBoxTF.addActionListener(arg0);
            }

            @Override
            public Component getEditorComponent() {
                return comboBoxTF;
            }

            @Override
            public Object getItem() {
                return comboBoxTF.getText();
            }

            @Override
            public void removeActionListener(ActionListener arg0) {
                comboBoxTF.removeActionListener(arg0);
            }

            @Override
            public void selectAll() {
                comboBoxTF.selectAll();
            }

            @Override
            public void setItem(Object arg0) {
                comboBoxTF.setText(arg0.toString());
            }
        });
        setupPanel.add((Component)this.setupComboBox, "Center");
        setupPanel.add((Component)this.buttons[6], "East");
        this.setupFC = new JFileChooser();
        this.setupFC.setFileSelectionMode(1);
        this.setupFC.setMultiSelectionEnabled(false);
        this.setupFC.setCurrentDirectory(new File(System.getProperty("user.dir")));
        JPanel fScorePanel = new JPanel(new BorderLayout());
        fScorePanel.add((Component)new JLabel("F-Score Weight", 0), "North");
        fScorePanel.add((Component)new JLabel("Precision"), "West");
        fScorePanel.add((Component)new JLabel("Recall"), "East");
        this.fScoreSlider = new JSlider(-4, 4, 0);
        this.fScoreSlider.setToolTipText("Change F-Score Precision/Recall weight");
        this.fScoreSlider.setMaximumSize(new Dimension(180, 50));
        this.fScoreSlider.setMajorTickSpacing(1);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(0, new JLabel("1"));
        labelTable.put(1, new JLabel("2"));
        labelTable.put(2, new JLabel("3"));
        labelTable.put(3, new JLabel("4"));
        labelTable.put(4, new JLabel("5"));
        labelTable.put(-1, new JLabel("\u00bd"));
        labelTable.put(-2, new JLabel("\u2153"));
        labelTable.put(-3, new JLabel("\u00bc"));
        labelTable.put(-4, new JLabel("\u2155"));
        this.fScoreSlider.setLabelTable(labelTable);
        this.fScoreSlider.setPaintLabels(true);
        this.fScoreSlider.setSnapToTicks(true);
        fScorePanel.add((Component)this.fScoreSlider, "Center");
        JPanel thresholdPanel = new JPanel(new GridBagLayout());
        JLabel thresholdLabel = new JLabel("Threshold (/100%):", 11);
        thresholdPanel.add(new JSeparator(1));
        thresholdPanel.add(thresholdLabel);
        this.thresholdSpinner = new JSpinner(new SpinnerNumberModel(50, 0, 100, 5));
        thresholdLabel.setLabelFor(this.thresholdSpinner);
        thresholdPanel.add(this.thresholdSpinner);
        this.useCacheCheckBox = new JCheckBox("Use normalisation cache");
        JPanel thresholdAndCachePanel = new JPanel(new BorderLayout());
        thresholdAndCachePanel.add((Component)thresholdPanel, "Center");
        thresholdAndCachePanel.add((Component)this.useCacheCheckBox, "South");
        JPanel controlPanel = new JPanel();
        controlPanel.setBorder(BorderFactory.createTitledBorder("Normalisation Control"));
        controlPanel.add(fScorePanel);
        controlPanel.add(thresholdAndCachePanel);
        JPanel outputTypePanel = new JPanel(new GridLayout(2, 1));
        this.plainCheckBox = new JCheckBox("Original Format (Changes Unmarked)");
        this.xmlCheckBox = new JCheckBox("XML Format (Changes Tagged)");
        outputTypePanel.add(this.plainCheckBox);
        outputTypePanel.add(this.xmlCheckBox);
        JPanel outputFilePanel = new JPanel(new BorderLayout());
        this.outputFolderTF = new JTextField(20);
        TextPrompt tp = new TextPrompt("Output folder", this.outputFolderTF);
        tp.setShow(TextPrompt.Show.FOCUS_LOST);
        tp.changeAlpha(0.5f);
        this.outputFolderTF.setTransferHandler(new FolderTransferHandler());
        outputFilePanel.add((Component)this.outputFolderTF, "Center");
        outputFilePanel.add((Component)this.buttons[7], "East");
        JPanel outputPanel = new JPanel(new BorderLayout());
        outputPanel.setBorder(BorderFactory.createTitledBorder("Output"));
        outputPanel.add((Component)outputTypePanel, "Center");
        outputPanel.add((Component)outputFilePanel, "South");
        JPanel bottomButtons = new JPanel(new GridLayout(1, 2));
        bottomButtons.add(this.buttons[4]);
        bottomButtons.add(this.buttons[5]);
        this.progressLabel = new JLabel("");
        this.progressBar = new JProgressBar(0);
        JPanel progressPanel = new JPanel(new GridLayout(2, 1));
        progressPanel.setBorder(BorderFactory.createTitledBorder("Progress"));
        progressPanel.add(this.progressLabel);
        progressPanel.add(this.progressBar);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)inputPanel, "North");
        topPanel.add((Component)setupPanel, "Center");
        topPanel.add((Component)controlPanel, "South");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)progressPanel, "Center");
        bottomPanel.add((Component)bottomButtons, "South");
        this.fc = new JFileChooser();
        this.frame = new JFrame("VARD 2 Batch Process");
        this.frame.getContentPane().add((Component)topPanel, "North");
        this.frame.getContentPane().add((Component)outputPanel, "Center");
        this.frame.getContentPane().add((Component)bottomPanel, "South");
        this.frame.setDefaultCloseOperation(3);
        this.frame.pack();
        this.frame.setLocation(BatchScreen.SCREEN_SIZE.width / 2 - this.frame.getWidth() / 2, BatchScreen.SCREEN_SIZE.height / 2 - this.frame.getHeight() / 2);
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent a) {
        int buttonNumber = -1;
        int i = 0;
        while (i < this.buttons.length) {
            if (a.getSource().equals(this.buttons[i])) {
                buttonNumber = i;
            }
            ++i;
        }
        switch (buttonNumber) {
            case 0: {
                this.fc.setFileSelectionMode(0);
                this.fc.setMultiSelectionEnabled(true);
                int returnVal = this.fc.showOpenDialog(this.frame);
                if (returnVal != 0) break;
                new Thread(){

                    @Override
                    public void run() {
                        File[] filesSelected = BatchScreen.this.fc.getSelectedFiles();
                        global.startProgress(filesSelected.length);
                        global.writeProgressMessage("Adding files...");
                        int count = 0;
                        File[] fileArray = filesSelected;
                        int n = filesSelected.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            BatchScreen.this.files.add(file);
                            global.setProgressCurrent(++count);
                            ++n2;
                        }
                        BatchScreen.this.fileList.setListData(BatchScreen.this.files.toArray());
                        global.finishProgress();
                    }
                }.start();
                break;
            }
            case 1: {
                this.fc.setFileSelectionMode(1);
                this.fc.setMultiSelectionEnabled(true);
                int returnVal2 = this.fc.showOpenDialog(this.frame);
                if (returnVal2 != 0) break;
                new Thread(){

                    @Override
                    public void run() {
                        global.startIndeterminateProgress();
                        File[] foldersSelected = BatchScreen.this.fc.getSelectedFiles();
                        int totalFolders = foldersSelected.length;
                        int folderCount = 0;
                        File[] fileArray = foldersSelected;
                        int n = foldersSelected.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File folder = fileArray[n2];
                            if (BatchScreen.this.searchSubFoldersCheckBox.isSelected()) {
                                BatchScreen.walkFolder(BatchScreen.this.files, folder);
                            } else {
                                File[] filesFromFolder = folder.listFiles();
                                global.startProgress(filesFromFolder.length);
                                global.writeProgressMessage("Adding files from " + folder.getName() + "(" + ++folderCount + "/" + totalFolders + ")...");
                                int fileCount = 0;
                                File[] fileArray2 = filesFromFolder;
                                int n3 = filesFromFolder.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    File file = fileArray2[n4];
                                    if (!(file.isDirectory() || file.isHidden() || BatchScreen.this.files.contains(file))) {
                                        BatchScreen.this.files.add(file);
                                    }
                                    global.setProgressCurrent(++fileCount);
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                        BatchScreen.this.fileList.setListData(BatchScreen.this.files.toArray());
                        global.finishProgress();
                    }
                }.start();
                break;
            }
            case 2: {
                Object[] objectArray = this.fileList.getSelectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object file = objectArray[n2];
                    this.files.remove(file);
                    ++n2;
                }
                this.fileList.setListData(this.files.toArray());
                break;
            }
            case 3: {
                this.files.clear();
                this.fileList.setListData(this.files.toArray());
                break;
            }
            case 4: {
                String outputFolderString = this.outputFolderTF.getText();
                if (this.files.size() == 0) {
                    global.showError("Please provide atleast one file to process.");
                    return;
                }
                if (outputFolderString.equals("")) {
                    global.showError("Please provide an output folder.");
                    return;
                }
                File outputFolder = new File(outputFolderString);
                if (!outputFolder.isDirectory()) {
                    this.showError("Output folder must not be a file.");
                    return;
                }
                if (this.setupComboBox.getSelectedItem().toString().isEmpty()) {
                    this.showError("Please select a setup folder.");
                    return;
                }
                String setupFolderString = Setup.getFolderFromListString(this.setupComboBox.getSelectedItem().toString());
                if (setupFolderString == null) {
                    global.showError("Please select a setup folder.");
                    return;
                }
                File setupFolder = new File(setupFolderString);
                if (!setupFolder.isDirectory()) {
                    global.showError("Please ensure that setup folder is a folder and not a file.");
                    return;
                }
                final Setup setup = new Setup();
                try {
                    setup.readFromFolder(setupFolder);
                }
                catch (IOException e) {
                    global.showException("Error occurred loading from setup folder.", e);
                    return;
                }
                new Thread(){

                    /*
                     * Exception decompiling
                     */
                    @Override
                    public void run() {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                }.start();
                break;
            }
            case 5: {
                System.exit(0);
                break;
            }
            case 6: {
                int setupReturnVal = this.setupFC.showSaveDialog(this.frame);
                if (setupReturnVal != 0) break;
                File folder = this.setupFC.getSelectedFile();
                try {
                    this.setupComboBox.setSelectedItem(Setup.getListStringFromFolder(folder));
                }
                catch (IOException ex) {
                    global.showError("Error occurred selecting setup folder.");
                }
                break;
            }
            case 7: {
                this.fc.setFileSelectionMode(1);
                this.fc.setMultiSelectionEnabled(false);
                int saveReturnVal = this.fc.showSaveDialog(this.frame);
                if (saveReturnVal != 0) break;
                String ofs = this.fc.getSelectedFile().getPath();
                this.outputFolderTF.setText(ofs);
            }
        }
    }

    private void setButtonsEnabled(boolean e) {
        this.buttons[0].setEnabled(e);
        this.buttons[1].setEnabled(e);
        this.buttons[2].setEnabled(e);
        this.buttons[3].setEnabled(e);
        this.buttons[4].setEnabled(e);
        this.buttons[6].setEnabled(e);
        this.buttons[7].setEnabled(e);
        this.setupComboBox.setEnabled(e);
        this.searchSubFoldersCheckBox.setEnabled(e);
        this.useCacheCheckBox.setEnabled(e);
        this.thresholdSpinner.setEnabled(e);
        this.outputFolderTF.setEditable(e);
        this.xmlCheckBox.setEnabled(e);
        this.plainCheckBox.setEnabled(e);
    }

    @Override
    public void writeProgressMessage(String message) {
        this.progressLabel.setText(message);
    }

    @Override
    public void showException(String message, Throwable e) {
        JOptionPane.showMessageDialog(this.frame, String.valueOf(message) + "\n\n" + e.getMessage(), "Error", 0);
    }

    @Override
    public void showError(String message) {
        JOptionPane.showMessageDialog(this.frame, message, "Error", 0);
    }

    public String getCommonFolderString() {
        String latest = this.files.first().getAbsolutePath();
        latest = latest.substring(0, latest.lastIndexOf(File.separator));
        for (File file : this.files) {
            String currentFileString = file.getAbsolutePath();
            while (!currentFileString.startsWith(latest)) {
                latest = latest.substring(0, latest.lastIndexOf(File.separator));
            }
        }
        return latest;
    }

    @Override
    public void finishProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BatchScreen.this.progressBar.setIndeterminate(false);
                BatchScreen.this.setButtonsEnabled(true);
            }
        });
    }

    @Override
    public void setProgressCurrent(final int current) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BatchScreen.this.progressBar.setValue(current);
            }
        });
    }

    @Override
    public void terminateProgressDisplay() {
    }

    @Override
    public void startIndeterminateProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BatchScreen.this.progressBar.setIndeterminate(true);
                BatchScreen.this.setButtonsEnabled(false);
            }
        });
    }

    @Override
    public void startProgress(final int max) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BatchScreen.this.progressBar.setIndeterminate(false);
                BatchScreen.this.progressBar.setMaximum(max);
                BatchScreen.this.setButtonsEnabled(false);
            }
        });
    }

    private static void walkFolder(TreeSet<File> toAddTo, File folder) {
        File[] filesFromFolder;
        File[] fileArray = filesFromFolder = folder.listFiles();
        int n = filesFromFolder.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory()) {
                if (!file.isHidden() && !toAddTo.contains(file)) {
                    toAddTo.add(file);
                }
            } else {
                BatchScreen.walkFolder(toAddTo, file);
            }
            ++n2;
        }
    }

    /* synthetic */ BatchScreen(BatchScreen batchScreen) {
        this();
    }

    static /* synthetic */ JCheckBox access$9(BatchScreen batchScreen) {
        return batchScreen.useCacheCheckBox;
    }

    static /* synthetic */ JSpinner access$10(BatchScreen batchScreen) {
        return batchScreen.thresholdSpinner;
    }

    static /* synthetic */ JSlider access$11(BatchScreen batchScreen) {
        return batchScreen.fScoreSlider;
    }

    static /* synthetic */ JCheckBox access$12(BatchScreen batchScreen) {
        return batchScreen.plainCheckBox;
    }

    static /* synthetic */ JCheckBox access$13(BatchScreen batchScreen) {
        return batchScreen.xmlCheckBox;
    }

    private class AddTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -3375927171804520959L;

        private AddTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            List filesAdded;
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                filesAdded = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            if (filesAdded.isEmpty()) {
                return false;
            }
            new Thread(){

                @Override
                public void run() {
                    global.startProgress(filesAdded.size());
                    global.writeProgressMessage("Adding files...");
                    int count = 0;
                    for (File file : filesAdded) {
                        if (file.isDirectory()) {
                            if (BatchScreen.this.searchSubFoldersCheckBox.isSelected()) {
                                BatchScreen.walkFolder(BatchScreen.this.files, file);
                            } else {
                                File[] filesFromFolder = file.listFiles();
                                global.startProgress(filesFromFolder.length);
                                global.writeProgressMessage("Adding files from " + file.getName());
                                int fileCount = 0;
                                File[] fileArray = filesFromFolder;
                                int n = filesFromFolder.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    File f = fileArray[n2];
                                    if (!(f.isDirectory() || f.isHidden() || BatchScreen.this.files.contains(f))) {
                                        BatchScreen.this.files.add(f);
                                    }
                                    global.setProgressCurrent(++fileCount);
                                    ++n2;
                                }
                            }
                        } else {
                            BatchScreen.this.files.add(file);
                        }
                        global.setProgressCurrent(++count);
                    }
                    BatchScreen.this.fileList.setListData(BatchScreen.this.files.toArray());
                    global.finishProgress();
                }
            }.start();
            return true;
        }
    }

    private class FolderTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -260318740428503951L;

        private FolderTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            List files;
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            if (files.isEmpty()) {
                return false;
            }
            File folder = (File)files.get(0);
            if (!folder.isDirectory()) {
                folder = folder.getParentFile();
            }
            BatchScreen.this.outputFolderTF.setText(folder.getAbsolutePath());
            return true;
        }
    }

    private class SetupFolderTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -260318740428503951L;

        private SetupFolderTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            List files;
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                global.showException("Error occurred selecting setup folder.", ex);
                return false;
            }
            catch (IOException ex) {
                global.showException("Error occurred selecting setup folder.", ex);
                return false;
            }
            if (files.isEmpty()) {
                return false;
            }
            File folder = (File)files.get(0);
            if (!folder.isDirectory()) {
                folder = folder.getParentFile();
            }
            try {
                BatchScreen.this.setupComboBox.setSelectedItem(Setup.getListStringFromFolder(folder));
            }
            catch (IOException ex) {
                global.showException("Error occurred selecting setup folder.", ex);
                return false;
            }
            return true;
        }
    }
}

