/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.QuestionAsker;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import model.Globals;

public class AddOwnVariantDialog {
    public static UserInput showDialog(QuestionAsker questionAsker, String variant, boolean isInstance) {
        JLabel variantLabel = new JLabel("Normalise " + variant + " with:");
        final JTextField replacementTF = new JTextField(15);
        replacementTF.setText(variant);
        replacementTF.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent e) {
                replacementTF.requestFocusInWindow();
                replacementTF.selectAll();
                replacementTF.removeAncestorListener(this);
            }

            @Override
            public void ancestorMoved(AncestorEvent arg0) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent arg0) {
            }
        });
        JCheckBox replaceAllInstancesOfWordCB = new JCheckBox("Normalise all instances of variant", false);
        if (!isInstance) {
            replaceAllInstancesOfWordCB.setSelected(true);
            replaceAllInstancesOfWordCB.setEnabled(false);
        }
        JPanel main = new JPanel(new GridLayout(3, 1));
        main.add(variantLabel);
        main.add(replacementTF);
        main.add(replaceAllInstancesOfWordCB);
        QuestionAsker.Answer answer = questionAsker.askFormQuestion(main, "Normalise " + variant);
        if (answer == QuestionAsker.Answer.OK) {
            if (!replacementTF.getText().equals("")) {
                return new UserInput(variant, replacementTF.getText(), replaceAllInstancesOfWordCB.isSelected());
            }
            Globals.getInstance().showError("Please enter a normalisation");
            return AddOwnVariantDialog.showDialog(questionAsker, variant, isInstance);
        }
        return null;
    }

    public static class UserInput {
        private String variant;
        private String replacement;
        private boolean replaceAllInstancesOfWord;

        private UserInput(String variant, String replacement, boolean replaceAllInstancesOfWord) {
            this.variant = variant;
            this.replacement = replacement;
            this.replaceAllInstancesOfWord = replaceAllInstancesOfWord;
        }

        public String getVariant() {
            return this.variant;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public boolean isReplaceAllInstancesOfWord() {
            return this.replaceAllInstancesOfWord;
        }
    }
}

