/*
 * Decompiled with CFR 0.152.
 */
package model.lookup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import model.lookup.Node;

public class Word
extends Node
implements Comparable<Word> {
    private static final long serialVersionUID = -8257792226836584638L;
    private static final int LOW_FREQ = 10;
    private String word;
    private int freq;
    boolean userAdded;
    boolean lowFreq;

    public Word(String w, Node node, boolean userAdded, int freq) {
        super(Character.valueOf(w.charAt(w.length() - 1)));
        if (node != null) {
            this.next = node.next;
        }
        this.word = w.toLowerCase().trim();
        this.userAdded = userAdded;
        this.freq = freq;
        this.lowFreq = freq < 10;
    }

    public void writeToFile(PrintWriter writer) {
        writer.println(String.valueOf(this.word) + "\t" + this.freq + (this.userAdded ? "\t#" : ""));
    }

    public String toString() {
        return this.word;
    }

    @Override
    public boolean isWord() {
        return true;
    }

    @Override
    public int compareTo(Word w) {
        return this.toString().compareToIgnoreCase(w.toString());
    }

    public boolean equals(Word w) {
        return this.toString().equalsIgnoreCase(w.toString());
    }

    public boolean equals(String s) {
        return this.toString().equalsIgnoreCase(s);
    }

    public boolean isUserAdded() {
        return this.userAdded;
    }

    public String getWord() {
        return this.word;
    }

    public void setUserAdded(boolean userAdded) {
        this.userAdded = userAdded;
    }

    public int getFreq() {
        return this.freq;
    }

    public boolean isLowFreq() {
        return this.lowFreq;
    }

    public void setFreq(int freq) {
        this.freq = freq;
        this.lowFreq = freq < 10;
    }

    static void readFile(File file, WordAction todo) throws IOException {
        LineNumberReader textIn = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        String currentLine = "file not ready";
        while ((currentLine = textIn.readLine()) != null) {
            String[] currentLineArray = currentLine.split("\t");
            todo.process(currentLineArray[0], Integer.parseInt(currentLineArray[1]), currentLineArray.length > 2 && currentLineArray[2].equals("#"));
        }
        textIn.close();
    }

    static interface WordAction {
        public void process(String var1, int var2, boolean var3);
    }
}

