/*
 * Decompiled with CFR 0.152.
 */
package model.lookup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public class Rule
implements Comparable<Rule> {
    private static final long serialVersionUID = 6117641007894822767L;
    private String original;
    private String replacement;
    private Position pos;
    private boolean userAdded;

    public Rule() {
    }

    public Rule(String original, String replacement, Position pos, boolean userAdded) {
        this.original = original;
        this.replacement = replacement;
        this.original = this.original.replaceAll("_", " ");
        this.replacement = this.replacement.replaceAll("_", " ");
        this.pos = pos;
        this.userAdded = userAdded;
        if (original == null || replacement == null) {
            throw new NullPointerException("Original and replacement must not be null");
        }
        if (original.equals("") && replacement.equals("")) {
            throw new IllegalArgumentException("Original and replacement must not both be empty");
        }
    }

    public void writeToFile(PrintWriter fileWriter) {
        fileWriter.println(String.valueOf(this.original) + "\t" + this.replacement + "\t" + (Object)((Object)this.pos) + "\t" + (this.userAdded ? "#" : ""));
    }

    Position getWhereToApply() {
        return this.pos;
    }

    public String getOriginal() {
        return this.original;
    }

    public String getReplacement() {
        return this.replacement;
    }

    private String getRuleString() {
        if (this.original.equals("")) {
            return "Insert " + this.replacement;
        }
        if (this.replacement.equals("")) {
            return "Delete " + this.original;
        }
        return "Substitute " + this.original + " > " + this.replacement;
    }

    public String toString() {
        return String.valueOf(this.getRuleString()) + " -- " + (Object)((Object)this.pos);
    }

    public boolean equals(Rule r) {
        return this.compareTo(r) == 0;
    }

    @Override
    public int compareTo(Rule r) {
        return this.toString().compareToIgnoreCase(r.toString());
    }

    public boolean isUserAdded() {
        return this.userAdded;
    }

    static void readFile(File file, RuleAction todo) throws IOException {
        LineNumberReader textIn = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        String currentLine = "file not ready";
        while ((currentLine = textIn.readLine()) != null) {
            String[] currentLineArray = currentLine.split("\t");
            todo.process(currentLineArray[0].trim(), currentLineArray[1].trim(), Position.valueOf(currentLineArray[2].trim()), currentLineArray.length > 3 && currentLineArray[3].equals("#"));
        }
    }

    public static enum Position {
        Start,
        Second,
        Middle,
        Penultimate,
        End,
        Anywhere;

    }

    static interface RuleAction {
        public void process(String var1, String var2, Position var3, boolean var4);
    }
}

