/*
 * Decompiled with CFR 0.152.
 */
package model.lookup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import model.ConfidenceWeights;
import model.Globals;
import model.MethodScores;
import model.MethodScoresUpdate;
import model.SuggestedReplacement;
import model.lookup.FlaggedString;
import model.lookup.Node;
import model.lookup.ReplacementWord;
import model.lookup.Rule;
import model.lookup.SoundexHolder;
import model.lookup.VariantHolder;
import model.lookup.VariantReplacement;
import model.lookup.VariantSoundexHolder;
import model.lookup.Word;
import model.lookup.WordUtilities;

public class LookUpDictionary {
    private static final long serialVersionUID = 5689122285204299967L;
    private TreeMap<Character, Node> words;
    private TreeMap<Character, Node> variants;
    private TreeSet<Rule> rules;
    private TreeMap<Character, Node> soundex;
    private TreeMap<Character, Node> soundexKVL;
    private InputStream realListIS;
    private InputStream ruleListIS;
    private InputStream variantListIS;
    private static Globals global;
    private static boolean wordsChanged;
    private static boolean variantsChanged;
    private static boolean rulesChanged;
    private static String wordsLog;
    private static String variantsLog;
    private static String rulesLog;
    private static LookUpDictionary _instance;
    private static Vector<DataChangeListener> dataChangeListeners;
    private final ConfidenceWeights cw;

    static {
        wordsLog = "";
        variantsLog = "";
        rulesLog = "";
        _instance = null;
        dataChangeListeners = new Vector();
    }

    protected LookUpDictionary() {
        block11: {
            this.words = new TreeMap();
            this.variants = new TreeMap();
            this.rules = new TreeSet();
            this.soundex = new TreeMap();
            this.soundexKVL = new TreeMap();
            this.cw = ConfidenceWeights.getInstance();
            global = Globals.getInstance();
            this.words = new TreeMap();
            this.soundex = new TreeMap();
            global.startIndeterminateProgress();
            global.writeProgressMessage("Initializing...");
            global.lockFinishProgress();
            try {
                try {
                    File wordsSource = new File(Globals.getSetupFolder(), "words.txt");
                    File variantsSource = new File(Globals.getSetupFolder(), "variants.txt");
                    File rulesSource = new File(Globals.getSetupFolder(), "rules.txt");
                    wordsSource.getParentFile().mkdirs();
                    boolean writeWordsFile = false;
                    if (wordsSource.exists()) {
                        global.writeProgressMessage("Loading words.txt...");
                        Word.readFile(wordsSource, new Word.WordAction(){

                            @Override
                            public void process(String word, int freq, boolean userAdded) {
                                LookUpDictionary.this.addWord(word, freq, userAdded);
                            }
                        });
                    } else {
                        this.readInRealWordList();
                        this.readInScowlWordList();
                        writeWordsFile = true;
                    }
                    if (variantsSource.exists()) {
                        this.readVariantsList(variantsSource);
                    } else {
                        this.readOrigVariantList();
                        this.writeVariantsToFile();
                        writeWordsFile = true;
                    }
                    if (writeWordsFile) {
                        this.writeWordsToFile();
                    }
                    if (rulesSource.exists()) {
                        global.writeProgressMessage("Loading rules.txt...");
                        Rule.readFile(rulesSource, new Rule.RuleAction(){

                            @Override
                            public void process(String original, String replacement, Rule.Position position, boolean userAdded) {
                                LookUpDictionary.this.rules.add(new Rule(original, replacement, position, userAdded));
                            }
                        });
                        break block11;
                    }
                    this.readInRules();
                    this.writeRulesToFile();
                }
                catch (IOException e) {
                    global.showException("Error occurred during initializing, if problem persists, re-install.", e);
                    global.unlockFinishProgress();
                    global.finishProgress();
                }
            }
            finally {
                global.unlockFinishProgress();
                global.finishProgress();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readVariantsList(File variantsSource) throws IOException {
        global.writeProgressMessage("Loading variants.txt...");
        LineNumberReader textIn = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(variantsSource), "UTF-8"));
        String currentLine = "file not ready";
        try {
            String variant = null;
            while ((currentLine = textIn.readLine()) != null) {
                String[] cla = currentLine.split("\t");
                switch (cla.length) {
                    case 1: {
                        variant = cla[0];
                        break;
                    }
                    case 3: 
                    case 4: {
                        if (variant == null) {
                            this.readOldVariantsList(variantsSource);
                            return;
                        }
                        if (cla[2].matches("[0-9]+")) {
                            Word word = this.findWord(cla[1]);
                            if (word == null) {
                                word = new Word(cla[1], null, false, 1);
                            }
                            this.addVariant(variant, word, Integer.parseInt(cla[2]), cla.length == 4 && cla[3].equals("#"));
                            break;
                        }
                        this.readOldVariantsList(variantsSource);
                        return;
                    }
                    default: {
                        this.readOldVariantsList(variantsSource);
                        return;
                    }
                }
            }
            return;
        }
        finally {
            textIn.close();
        }
    }

    private void readOldVariantsList(File variantsSource) throws IOException {
        LineNumberReader textIn = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(variantsSource), "UTF-8"));
        String currentLine = "file not ready";
        try {
            while ((currentLine = textIn.readLine()) != null) {
                String[] currentLineArray = currentLine.split("\t");
                switch (currentLineArray.length) {
                    case 2: 
                    case 3: 
                    case 6: {
                        Word word = this.findWord(currentLineArray[1]);
                        if (word == null) {
                            word = new Word(currentLineArray[1], null, false, 1);
                        }
                        this.addVariant(currentLineArray[0], word, 1, currentLineArray.length > 2 && currentLineArray[2].equals("#"));
                        break;
                    }
                    default: {
                        throw new IOException("New variant file load failed, old variant file lines must contain 2, 3 or 6 columns. Please consult userguide for correct formatting. Also ensure file is UTF-8");
                    }
                }
            }
        }
        finally {
            textIn.close();
        }
    }

    public static LookUpDictionary getInstance() {
        if (_instance == null) {
            _instance = new LookUpDictionary();
        }
        return _instance;
    }

    public void addDataChangeListener(DataChangeListener listener) {
        dataChangeListeners.add(listener);
    }

    public void removeDataChangeListener(DataChangeListener listener) {
        dataChangeListeners.remove(listener);
    }

    private void readOrigVariantList() throws IOException {
        global.startIndeterminateProgress();
        global.writeProgressMessage("Reading variant list...");
        this.variants = new TreeMap();
        this.variantListIS = LookUpDictionary.class.getResourceAsStream("predef/variantlist.txt");
        if (this.variantListIS == null) {
            global.showException("Error occurred reading default variant list", new FileNotFoundException("Default variant list not found"));
            global.finishProgress();
            return;
        }
        LineNumberReader textIn = new LineNumberReader(new InputStreamReader(this.variantListIS));
        String currentLine = "file not ready";
        String[] currentLineArray = new String[3];
        boolean invalidWord = false;
        try {
            try {
                while (!currentLine.equals("end")) {
                    if (!textIn.ready() || (currentLine = textIn.readLine()).equals("end")) continue;
                    currentLineArray = currentLine.split("\t");
                    String currentVariant = currentLineArray[1].trim();
                    String currentWord = currentLineArray[2].trim();
                    invalidWord = false;
                    if (!WordUtilities.isValidWord(currentWord) || currentWord.endsWith("'") || currentWord.startsWith("'")) {
                        invalidWord = true;
                    }
                    if (!WordUtilities.isValidWord(currentVariant)) {
                        invalidWord = true;
                    }
                    if (invalidWord) continue;
                    Word word = this.findWord(currentWord);
                    if (word == null) {
                        word = new Word(currentWord, null, false, 1);
                    }
                    this.addVariant(currentVariant, word, 1, false);
                }
                this.setVariantsChanged(true, String.valueOf(Globals.NEW_LINE) + "Variants list (re)initialized");
            }
            catch (IOException e) {
                global.showException("Error occurred reading default variant list", e);
                global.finishProgress();
                textIn.close();
            }
        }
        finally {
            global.finishProgress();
            textIn.close();
        }
    }

    private void readInScowlWordList() throws IOException {
        int wordCount = 0;
        File scowlFolder = new File("scowl/");
        File[] files = scowlFolder.listFiles();
        if (files == null || files.length < 1) {
            global.showException("Error occurred reading SCOWL word list, please reinstall.", new FileNotFoundException("SCOWL word lists not found"));
            global.finishProgress();
            return;
        }
        global.startProgress(files.length);
        global.writeProgressMessage("Reading SCOWL word lists...");
        int count = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                File file = fileArray[n2];
                if (file.getName().matches("[^\\.]+\\.[0-9]{2}")) {
                    LineNumberReader textIn = new LineNumberReader(new FileReader(file));
                    try {
                        String currentLine = "file not ready";
                        int freq = 100 - Integer.parseInt(file.getName().substring(file.getName().lastIndexOf(46) + 1));
                        int notReadyCount = 0;
                        while (!textIn.ready() && notReadyCount < 1000) {
                            ++count;
                            System.out.println(String.valueOf(file.getName()) + " not ready.");
                        }
                        while ((currentLine = textIn.readLine()) != null) {
                            String currentWord;
                            if (currentLine.equals("") || !WordUtilities.isValidWord(currentWord = currentLine.trim()) || currentWord.endsWith("'") || currentWord.startsWith("'")) continue;
                            if (!this.addWord(currentWord, freq, false)) {
                                Word exists = this.findWord(currentWord);
                                exists.setFreq(Math.max(exists.getFreq(), freq));
                                continue;
                            }
                            ++wordCount;
                        }
                    }
                    catch (FileNotFoundException e) {
                        global.showException("Error occurred reading SCOWL word lists", e);
                        global.finishProgress();
                        textIn.close();
                        break block13;
                    }
                    catch (IOException e) {
                        try {
                            global.showException("Error occurred reading SCOWL word lists", e);
                            global.finishProgress();
                            break block13;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            textIn.close();
                        }
                    }
                    textIn.close();
                }
            }
            global.setProgressCurrent(++count);
            ++n2;
        }
        global.finishProgress();
    }

    private void readInRealWordList() throws IOException {
        global.startIndeterminateProgress();
        global.writeProgressMessage("Reading BNC Word List...");
        this.realListIS = LookUpDictionary.class.getResourceAsStream("predef/realwordlist.txt");
        if (this.realListIS == null) {
            global.showException("Error occurred reading BNC Word List", new FileNotFoundException("BNC Word list not found"));
            global.finishProgress();
            return;
        }
        LineNumberReader textIn = new LineNumberReader(new InputStreamReader(this.realListIS));
        String currentLine = "file not ready";
        String[] currentLineArray = new String[7];
        int currentRange = 0;
        int currentFreq = 0;
        try {
            try {
                while (!currentLine.equals("end")) {
                    String currentWord;
                    if (!textIn.ready() || (currentLine = textIn.readLine()).equals("end")) continue;
                    currentLineArray = currentLine.split("\t");
                    if (currentLineArray[3].equals(":")) {
                        currentWord = currentLineArray[1].trim();
                        currentFreq = Integer.parseInt(currentLineArray[4]);
                        currentRange = Integer.parseInt(currentLineArray[5]);
                    } else if (currentLineArray[1].equals("@")) {
                        currentWord = currentLineArray[3].trim();
                        currentFreq = Integer.parseInt(currentLineArray[4]);
                    } else {
                        currentFreq = Integer.parseInt(currentLineArray[4]);
                        currentRange = Integer.parseInt(currentLineArray[5]);
                        continue;
                    }
                    if (!WordUtilities.isValidWord(currentWord) || currentWord.endsWith("'") || currentWord.startsWith("'") || currentRange < 50 || currentFreq < 1 || this.addWord(currentWord, currentFreq, false)) continue;
                    Word exists = this.findWord(currentWord);
                    exists.setFreq(exists.getFreq() + currentFreq);
                }
                this.addWord("I", 8875, false);
                this.addWord("a", 21626, false);
                this.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "Words list (re)initialized");
            }
            catch (IOException e) {
                global.showException("Error occurred reading BNC word list", e);
                global.finishProgress();
                textIn.close();
            }
        }
        finally {
            global.finishProgress();
            textIn.close();
        }
    }

    private void readInRules() throws IOException {
        global.startIndeterminateProgress();
        global.writeProgressMessage("Reading default rules list...");
        this.rules = new TreeSet();
        this.ruleListIS = LookUpDictionary.class.getResourceAsStream("predef/rulelist.txt");
        if (this.ruleListIS == null) {
            global.showException("Error occurred reading default rule list", new FileNotFoundException("Default rule list not found"));
            global.finishProgress();
            return;
        }
        LineNumberReader textIn = new LineNumberReader(new InputStreamReader(this.ruleListIS));
        String currentLine = "file not ready";
        Rule.Position currentPos = Rule.Position.Anywhere;
        try {
            try {
                while (!currentLine.equals("end")) {
                    if (!textIn.ready() || (currentLine = textIn.readLine()).equals("end") || currentLine.charAt(0) == '#') continue;
                    String[] currentLineArray = currentLine.split("\t");
                    if (currentLineArray[0].startsWith("^")) {
                        currentPos = Rule.Position.Start;
                        currentLineArray[0] = currentLineArray[0].substring(1);
                    } else if (currentLineArray[0].endsWith("$")) {
                        currentPos = Rule.Position.End;
                        currentLineArray[0] = currentLineArray[0].substring(0, currentLineArray[0].length() - 1);
                    } else {
                        currentPos = Rule.Position.Anywhere;
                    }
                    if (currentLineArray[1].equals(" ")) {
                        currentLineArray[1] = "";
                    }
                    Rule r = new Rule(currentLineArray[0], currentLineArray[1], currentPos, false);
                    this.rules.add(r);
                }
                this.setRulesChanged(true, String.valueOf(Globals.NEW_LINE) + "Rules list (re)initialized");
            }
            catch (IOException e) {
                global.showException("Error occurred reading default rule list", e);
                global.finishProgress();
                textIn.close();
            }
        }
        finally {
            global.finishProgress();
            textIn.close();
        }
    }

    public void postOrder(Node node, NodeProcessor processor) {
        for (Node n : node.next.values()) {
            this.postOrder(n, processor);
        }
        processor.processNode(node);
    }

    public void writeRulesToFile() throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(Globals.getSetupFolder(), "rules.txt")), "UTF-8"));
        File lFile = new File(Globals.getSetupFolder(), "logs" + File.separator + "rules_change_log.txt");
        lFile.getParentFile().mkdirs();
        PrintWriter logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(lFile, true), "UTF-8"));
        global.startProgress(this.rules.size());
        global.writeProgressMessage("Saving rules list");
        try {
            for (Rule r : this.rules) {
                r.writeToFile(writer);
            }
            if (rulesChanged) {
                logWriter.println(rulesLog);
                this.setRulesChanged(false, null);
            }
        }
        finally {
            global.finishProgress();
            writer.close();
            logWriter.close();
        }
    }

    public void writeVariantsToFile() throws IOException {
        final PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(Globals.getSetupFolder(), "variants.txt")), "UTF-8"));
        File lFile = new File(Globals.getSetupFolder(), "logs" + File.separator + "variants_change_log.txt");
        lFile.getParentFile().mkdirs();
        PrintWriter logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(lFile, true), "UTF-8"));
        global.startIndeterminateProgress();
        global.writeProgressMessage("Saving variants list");
        try {
            Node variantsRoot = new Node(Character.valueOf('@'));
            variantsRoot.next = this.variants;
            this.postOrder(variantsRoot, new NodeProcessor(){

                @Override
                public void processNode(Node node) {
                    if (node.isWord()) {
                        VariantHolder vh = (VariantHolder)node;
                        writer.println(vh.getVariantString());
                        for (VariantReplacement vr : vh.getVariantReplacements()) {
                            if (vr.getPicked() <= 0) continue;
                            writer.println("*\t" + vr.getWordString() + "\t" + vr.getPicked() + "\t" + (vr.isUserAdded() ? "#" : ""));
                        }
                    }
                }
            });
            if (variantsChanged) {
                logWriter.println(variantsLog);
                this.setVariantsChanged(false, null);
            }
        }
        finally {
            global.finishProgress();
            writer.close();
            logWriter.close();
        }
    }

    public void writeWordsToFile() throws IOException {
        final PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(Globals.getSetupFolder(), "words.txt")), "UTF-8"));
        File lFile = new File(Globals.getSetupFolder(), "logs" + File.separator + "words_change_log.txt");
        lFile.getParentFile().mkdirs();
        PrintWriter logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(lFile, true), "UTF-8"));
        global.startIndeterminateProgress();
        global.writeProgressMessage("Saving dictionary");
        try {
            Node wordsRoot = new Node(Character.valueOf('@'));
            wordsRoot.next = this.words;
            this.postOrder(wordsRoot, new NodeProcessor(){

                @Override
                public void processNode(Node node) {
                    if (node.isWord()) {
                        ((Word)node).writeToFile(writer);
                    }
                }
            });
            if (wordsChanged) {
                logWriter.println(wordsLog);
                this.setWordsChanged(false, null);
            }
        }
        finally {
            global.finishProgress();
            writer.close();
            logWriter.close();
        }
    }

    private Word findWord(String w) {
        String word = w.toLowerCase();
        char[] letters = word.toCharArray();
        if (letters.length == 0) {
            return null;
        }
        TreeMap<Character, Node> current = this.words;
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            return null;
        }
        int i = 1;
        while (i < letters.length) {
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                return null;
            }
            ++i;
        }
        if (currentNode.isWord()) {
            return (Word)currentNode;
        }
        return null;
    }

    public Word addUserWord(String w) {
        Word toReturn = this.findWord(w);
        if (toReturn != null) {
            return toReturn;
        }
        TreeMap<Character, Node> current = this.words;
        String word = w.toLowerCase();
        char[] letters = word.toCharArray();
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            currentNode = new Node(Character.valueOf(letters[0]));
            current.put(Character.valueOf(letters[0]), currentNode);
        }
        int i = 1;
        while (i < letters.length) {
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                currentNode = new Node(Character.valueOf(letters[i]));
                current.put(Character.valueOf(letters[i]), currentNode);
            }
            ++i;
        }
        if (currentNode.isWord()) {
            return (Word)currentNode;
        }
        char lastletter = letters[letters.length - 1];
        current.remove(Character.valueOf(lastletter));
        toReturn = new Word(word, currentNode, true, 1);
        current.put(Character.valueOf(lastletter), toReturn);
        this.addSoundex(toReturn);
        return toReturn;
    }

    private boolean removeSoundex(Word w) {
        Vector<Node> nodePath = new Vector<Node>();
        TreeMap<Character, Node> current = this.soundex;
        String soundexCode = WordUtilities.getSoundexCode(w.toString());
        char[] letters = soundexCode.toCharArray();
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            return false;
        }
        int i = 1;
        while (i < letters.length) {
            nodePath.add(0, currentNode);
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                return false;
            }
            ++i;
        }
        if (!currentNode.isWord()) {
            return false;
        }
        SoundexHolder foundSoundex = (SoundexHolder)currentNode;
        if (foundSoundex.removeWord(w)) {
            if (!foundSoundex.getWords().isEmpty()) {
                return true;
            }
        } else {
            return false;
        }
        ((Node)nodePath.firstElement()).next.put(foundSoundex.key, new Node(foundSoundex));
        Node child = ((Node)nodePath.firstElement()).next.get(foundSoundex.key);
        if (child.next.isEmpty()) {
            for (Node node : nodePath) {
                node.next.remove(child.key);
                if (node.next.isEmpty()) {
                    child = node;
                    continue;
                }
                return true;
            }
        }
        return true;
    }

    public boolean removeWord(String w) {
        Vector<Node> nodePath = new Vector<Node>();
        TreeMap<Character, Node> current = this.words;
        String word = w.toLowerCase();
        char[] letters = word.toCharArray();
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            return false;
        }
        int i = 1;
        while (i < letters.length) {
            nodePath.add(0, currentNode);
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                return false;
            }
            ++i;
        }
        if (!currentNode.isWord()) {
            return false;
        }
        Word foundWord = (Word)currentNode;
        this.removeSoundex(foundWord);
        if (nodePath.isEmpty()) {
            this.words.put(foundWord.key, new Node(foundWord));
            return true;
        }
        ((Node)nodePath.firstElement()).next.put(foundWord.key, new Node(foundWord));
        Node child = ((Node)nodePath.firstElement()).next.get(foundWord.key);
        if (child.next.isEmpty()) {
            for (Node node : nodePath) {
                node.next.remove(child.key);
                if (node.next.isEmpty()) {
                    child = node;
                    continue;
                }
                return true;
            }
        }
        return true;
    }

    public void recalculateSoundex() {
        global.startIndeterminateProgress();
        global.writeProgressMessage("Recalculating Soundex codes");
        try {
            this.soundex.clear();
            Node wordsRoot = new Node(Character.valueOf('@'));
            wordsRoot.next = this.words;
            this.postOrder(wordsRoot, new NodeProcessor(){

                @Override
                public void processNode(Node node) {
                    if (node.isWord()) {
                        LookUpDictionary.this.addSoundex((Word)node);
                    }
                }
            });
            this.soundexKVL.clear();
            wordsRoot = new Node(Character.valueOf('@'));
            wordsRoot.next = this.variants;
            this.postOrder(wordsRoot, new NodeProcessor(){

                @Override
                public void processNode(Node node) {
                    if (node.isWord()) {
                        LookUpDictionary.this.addSoundex((VariantHolder)node);
                    }
                }
            });
        }
        finally {
            global.finishProgress();
        }
    }

    private boolean addWord(String w, int freq, boolean userAdded) {
        TreeMap<Character, Node> current = this.words;
        String word = w.toLowerCase();
        char[] letters = word.toCharArray();
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            currentNode = new Node(Character.valueOf(letters[0]));
            current.put(Character.valueOf(letters[0]), currentNode);
        }
        int i = 1;
        while (i < letters.length) {
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                currentNode = new Node(Character.valueOf(letters[i]));
                current.put(Character.valueOf(letters[i]), currentNode);
            }
            ++i;
        }
        if (currentNode.isWord()) {
            return false;
        }
        char lastletter = letters[letters.length - 1];
        current.remove(Character.valueOf(lastletter));
        Word newWord = new Word(word, currentNode, userAdded, freq);
        current.put(Character.valueOf(lastletter), newWord);
        this.addSoundex(newWord);
        return true;
    }

    public TreeSet<ReplacementWord> findKVMatches(String w) {
        String word = w.toLowerCase();
        char[] letters = word.toCharArray();
        TreeSet<ReplacementWord> words = new TreeSet<ReplacementWord>();
        if (letters.length == 0) {
            return words;
        }
        TreeMap<Character, Node> current = this.variants;
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            return words;
        }
        int i = 1;
        while (i < letters.length) {
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                return words;
            }
            ++i;
        }
        if (currentNode.isWord()) {
            for (VariantReplacement v : ((VariantHolder)currentNode).getVariantReplacements()) {
                ReplacementWord rw;
                if (!WordUtilities.isLikelyReplacement(v.getVariantString(), v.getWordString()) || (rw = v.getReplacement()) == null) continue;
                words.add(rw);
            }
        }
        return words;
    }

    private boolean addSoundex(VariantHolder vh) {
        String variantsoundex = WordUtilities.getSoundexCode(vh.getVariantString());
        char[] letters = variantsoundex.toCharArray();
        if (letters.length == 0) {
            System.out.println("Variant is empty, can't calculate soundex: " + vh);
            return false;
        }
        TreeMap<Character, Node> current = this.soundexKVL;
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            currentNode = new Node(Character.valueOf(letters[0]));
            current.put(Character.valueOf(letters[0]), currentNode);
        }
        int i = 1;
        while (i < letters.length) {
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                currentNode = new Node(Character.valueOf(letters[i]));
                current.put(Character.valueOf(letters[i]), currentNode);
            }
            ++i;
        }
        if (currentNode.isWord()) {
            return ((VariantSoundexHolder)currentNode).addVariant(vh);
        }
        char lastletter = letters[letters.length - 1];
        current.remove(Character.valueOf(lastletter));
        VariantSoundexHolder sh = new VariantSoundexHolder(variantsoundex, currentNode);
        current.put(Character.valueOf(lastletter), sh);
        return sh.addVariant(vh);
    }

    private boolean addSoundex(Word w) {
        String wordsoundex = WordUtilities.getSoundexCode(w.toString());
        char[] letters = wordsoundex.toCharArray();
        if (letters.length == 0) {
            return false;
        }
        TreeMap<Character, Node> current = this.soundex;
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            currentNode = new Node(Character.valueOf(letters[0]));
            current.put(Character.valueOf(letters[0]), currentNode);
        }
        int i = 1;
        while (i < letters.length) {
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                currentNode = new Node(Character.valueOf(letters[i]));
                current.put(Character.valueOf(letters[i]), currentNode);
            }
            ++i;
        }
        if (currentNode.isWord()) {
            return ((SoundexHolder)currentNode).addWord(w);
        }
        char lastletter = letters[letters.length - 1];
        current.remove(Character.valueOf(lastletter));
        SoundexHolder sh = new SoundexHolder(wordsoundex, currentNode);
        current.put(Character.valueOf(lastletter), sh);
        return sh.addWord(w);
    }

    public TreeSet<ReplacementWord> findWordWithSoundex(String wtf, String s) {
        char[] letters = s.toCharArray();
        if (letters.length == 0) {
            return new TreeSet<ReplacementWord>();
        }
        TreeMap<Character, Node> current = this.soundex;
        TreeSet<ReplacementWord> toReturn = new TreeSet<ReplacementWord>();
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode != null) {
            boolean found = true;
            int i = 1;
            while (i < letters.length) {
                current = currentNode.next;
                currentNode = current.get(Character.valueOf(letters[i]));
                if (currentNode == null) {
                    found = false;
                    break;
                }
                ++i;
            }
            if (found && currentNode.isWord()) {
                TreeSet<Word> words = ((SoundexHolder)currentNode).getWords();
                for (Word w : words) {
                    if (!WordUtilities.isLikelyReplacement(wtf, w.getWord())) continue;
                    toReturn.add(new ReplacementWord(w, 1.0, null));
                }
            }
        }
        if ((currentNode = (current = this.soundexKVL).get(Character.valueOf(letters[0]))) == null) {
            return toReturn;
        }
        int i = 1;
        while (i < letters.length) {
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                return toReturn;
            }
            ++i;
        }
        if (currentNode.isWord()) {
            TreeSet<VariantHolder> vhs = ((VariantSoundexHolder)currentNode).getVariants();
            for (VariantHolder vh : vhs) {
                for (VariantReplacement vr : vh.getVariantReplacements()) {
                    ReplacementWord rw;
                    if (!WordUtilities.isLikelyReplacement(wtf, vr.getWordString()) || (rw = vr.getReplacement()) == null) continue;
                    toReturn.add(new ReplacementWord(rw.getWord(), rw.getScore() * 0.8, null));
                }
            }
        }
        return toReturn;
    }

    private VariantReplacement addVariant(String v, Word rep, int picked, boolean userAdded) {
        String variant = v.toLowerCase();
        char[] letters = variant.toCharArray();
        if (letters.length == 0) {
            return null;
        }
        TreeMap<Character, Node> current = this.variants;
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            currentNode = new Node(Character.valueOf(letters[0]));
            current.put(Character.valueOf(letters[0]), currentNode);
        }
        int i = 1;
        while (i < letters.length) {
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                currentNode = new Node(Character.valueOf(letters[i]));
                current.put(Character.valueOf(letters[i]), currentNode);
            }
            ++i;
        }
        if (currentNode.isWord()) {
            VariantReplacement newVR = new VariantReplacement((VariantHolder)currentNode, rep, picked, userAdded);
            if (((VariantHolder)currentNode).addVariant(newVR)) {
                return newVR;
            }
            return null;
        }
        char lastletter = letters[letters.length - 1];
        current.remove(Character.valueOf(lastletter));
        VariantHolder vh = new VariantHolder(variant, currentNode);
        current.put(Character.valueOf(lastletter), vh);
        this.addSoundex(vh);
        VariantReplacement newVR = new VariantReplacement(vh, rep, picked, userAdded);
        if (vh.addVariant(newVR)) {
            return newVR;
        }
        return null;
    }

    public VariantReplacement addUserVariant(String v, Word rep) {
        VariantReplacement newVR = this.addVariant(v, rep, 1, true);
        if (newVR != null) {
            LookUpDictionary.getInstance().setVariantsChanged(true, String.valueOf(Globals.NEW_LINE) + "added: " + v + " -> " + rep);
        }
        return newVR;
    }

    public Word checkWords(String w) {
        Word word = this.findWord(w);
        if (word != null) {
            return word;
        }
        String[] split = w.split("[-\\s]{1}");
        if (split.length > 1) {
            boolean useradded = false;
            String[] stringArray = split;
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.length() < 2) {
                    return null;
                }
                word = this.findWord(s);
                if (word == null) {
                    return null;
                }
                if (word.isUserAdded()) {
                    useradded = true;
                }
                ++n2;
            }
            return new Word(w, null, useradded, 0);
        }
        return null;
    }

    public List<SuggestedReplacement> findReplacements(String wtf, String soundex, int limit) {
        SuggestedReplacement sr;
        double dist;
        Word word;
        TreeSet<ReplacementWord> kvReps = this.findKVMatches(wtf);
        TreeSet<ReplacementWord> lrReps = this.checkLetterReplacements(wtf);
        TreeSet<ReplacementWord> seReps = this.findWordWithSoundex(wtf, soundex);
        TreeSet<ReplacementWord> edReps = new TreeSet<ReplacementWord>();
        double kvTotal = 0.0;
        double lrTotal = 0.0;
        double seTotal = 0.0;
        double edTotal = 0.0;
        for (ReplacementWord rw : kvReps) {
            kvTotal += rw.getScore();
            word = rw.getWord();
            dist = WordUtilities.normalisedEditDistance(wtf, word.toString());
            if (!edReps.add(new ReplacementWord(rw.getWord(), dist, null))) continue;
            edTotal += dist;
        }
        for (ReplacementWord rw : lrReps) {
            lrTotal += rw.getScore();
            word = rw.getWord();
            dist = WordUtilities.normalisedEditDistance(wtf, word.toString());
            if (!edReps.add(new ReplacementWord(rw.getWord(), dist, null))) continue;
            edTotal += dist;
        }
        for (ReplacementWord rw : seReps) {
            seTotal += rw.getScore();
            word = rw.getWord();
            dist = WordUtilities.normalisedEditDistance(wtf, word.toString());
            if (!edReps.add(new ReplacementWord(rw.getWord(), dist, null))) continue;
            edTotal += dist;
        }
        TreeMap<ReplacementWord, SuggestedReplacement> seen = new TreeMap<ReplacementWord, SuggestedReplacement>();
        MethodScores cwKV = this.cw.getKV();
        MethodScores cwLR = this.cw.getLR();
        MethodScores cwSE = this.cw.getSE();
        MethodScores cwED = this.cw.getED();
        MethodScores kvNo = new MethodScores(0.0, kvTotal);
        MethodScores lrNo = new MethodScores(0.0, lrTotal);
        MethodScores seNo = new MethodScores(0.0, seTotal);
        for (ReplacementWord rw : kvReps) {
            sr = new SuggestedReplacement(rw.getWord(), wtf, true);
            seen.put(rw, sr);
            MethodScores kvYes = new MethodScores(rw.getScore(), kvTotal - rw.getScore());
            sr.setScoreUpdate("KV", new MethodScoresUpdate(cwKV, kvYes));
            sr.setScoreUpdate("LR", new MethodScoresUpdate(cwLR, lrNo));
            sr.setScoreUpdate("PM", new MethodScoresUpdate(cwSE, seNo));
            sr.setReplacementWord("KV", rw);
        }
        for (ReplacementWord rw : lrReps) {
            sr = (SuggestedReplacement)seen.get(rw);
            if (sr == null) {
                sr = new SuggestedReplacement(rw.getWord(), wtf, false);
                seen.put(rw, sr);
                sr.setScoreUpdate("KV", new MethodScoresUpdate(cwKV, kvNo));
                sr.setScoreUpdate("PM", new MethodScoresUpdate(cwSE, seNo));
            }
            MethodScores lrYes = new MethodScores(rw.getScore(), lrTotal - rw.getScore());
            sr.setScoreUpdate("LR", new MethodScoresUpdate(cwLR, lrYes));
            sr.setReplacementWord("LR", rw);
        }
        for (ReplacementWord rw : seReps) {
            sr = (SuggestedReplacement)seen.get(rw);
            if (sr == null) {
                sr = new SuggestedReplacement(rw.getWord(), wtf, false);
                seen.put(rw, sr);
                sr.setScoreUpdate("KV", new MethodScoresUpdate(cwKV, kvNo));
                sr.setScoreUpdate("LR", new MethodScoresUpdate(cwLR, lrNo));
            }
            MethodScores seYes = new MethodScores(rw.getScore(), seTotal - rw.getScore());
            sr.setScoreUpdate("PM", new MethodScoresUpdate(cwSE, seYes));
            sr.setReplacementWord("PM", rw);
        }
        for (ReplacementWord rw : edReps) {
            sr = (SuggestedReplacement)seen.get(rw);
            MethodScores edMS = new MethodScores(rw.getScore(), edTotal - rw.getScore());
            sr.setScoreUpdate("ED", new MethodScoresUpdate(cwED, edMS));
            sr.setReplacementWord("ED", rw);
        }
        Vector<SuggestedReplacement> results = new Vector<SuggestedReplacement>();
        for (SuggestedReplacement sr2 : seen.values()) {
            sr2.reCalculateScore();
            results.add(sr2);
        }
        Collections.sort(results);
        if (limit == 0 || limit > results.size()) {
            return results;
        }
        return results.subList(0, limit);
    }

    public TreeSet<ReplacementWord> checkLetterReplacements(String wtf) {
        Vector<FlaggedString> toCheck = new Vector<FlaggedString>(300, 50);
        Vector found = new Vector(300, 50);
        Vector<Object> foundVariants = new Vector(200, 50);
        toCheck.add(new FlaggedString(wtf.toLowerCase()));
        while (!toCheck.isEmpty()) {
            FlaggedString current = (FlaggedString)toCheck.firstElement();
            for (Rule rule : this.rules) {
                foundVariants = current.applyRule(rule);
                if (toCheck.size() >= 5000) continue;
                found.addAll(foundVariants);
                toCheck.addAll(foundVariants);
            }
            toCheck.remove(current);
        }
        TreeSet<ReplacementWord> filtered = new TreeSet<ReplacementWord>();
        for (FlaggedString fs : found) {
            String potential = fs.toString().toLowerCase();
            if (!WordUtilities.isLikelyReplacement(wtf, potential)) continue;
            double score = 1.0;
            int i = 1;
            while (i < fs.getRulesApplied()) {
                score -= 0.1;
                ++i;
            }
            Word w = this.checkWords(potential);
            if (w != null) {
                filtered.add(new ReplacementWord(w, score, null));
            }
            TreeSet<ReplacementWord> kvWords = this.findKVMatches(potential);
            for (ReplacementWord rw : kvWords) {
                filtered.add(new ReplacementWord(rw.getWord(), rw.getScore() * (score - 0.2), null));
            }
        }
        return filtered;
    }

    public TreeSet<Rule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<Rule> newRules) {
        this.rules = new TreeSet();
        this.rules.addAll(newRules);
    }

    public static boolean isRulesChanged() {
        return rulesChanged;
    }

    public static boolean isVariantsChanged() {
        return variantsChanged;
    }

    public static boolean isWordsChanged() {
        return wordsChanged;
    }

    public void setRulesChanged(boolean rc, String log) {
        rulesChanged = rc;
        rulesLog = rulesChanged ? String.valueOf(rulesLog) + log : "";
        for (DataChangeListener l : dataChangeListeners) {
            l.rulesChanged(rulesChanged);
        }
    }

    public static void setVariantsChanged(boolean vc) {
        variantsChanged = vc;
        for (DataChangeListener l : dataChangeListeners) {
            l.variantsChanged(variantsChanged);
        }
    }

    public void setVariantsChanged(boolean vc, String log) {
        variantsChanged = vc;
        variantsLog = variantsChanged ? String.valueOf(variantsLog) + log : "";
        for (DataChangeListener l : dataChangeListeners) {
            l.variantsChanged(variantsChanged);
        }
    }

    public void setWordsChanged(boolean wc, String log) {
        wordsChanged = wc;
        wordsLog = wordsChanged ? String.valueOf(wordsLog) + log : "";
        for (DataChangeListener l : dataChangeListeners) {
            l.wordsChanged(wordsChanged);
        }
    }

    public String getRulesLog() {
        return rulesLog;
    }

    public String getVariantsLog() {
        return variantsLog;
    }

    public String getWordsLog() {
        return wordsLog;
    }

    public void setRulesLog(String rulesLog) {
        LookUpDictionary.rulesLog = rulesLog;
    }

    public void setVariantsLog(String variantsLog) {
        LookUpDictionary.variantsLog = variantsLog;
    }

    public void setWordsLog(String wordsLog) {
        LookUpDictionary.wordsLog = wordsLog;
    }

    public TreeMap<Character, Node> getWordsRoot() {
        return this.words;
    }

    public double getSEScore(String v, String r) {
        TreeSet<ReplacementWord> matches = this.findWordWithSoundex(v, WordUtilities.getSoundexCode(v));
        for (ReplacementWord rw : matches) {
            if (!rw.getWord().equals(r)) continue;
            return rw.getScore();
        }
        return 0.0;
    }

    public static interface DataChangeListener {
        public void wordsChanged(boolean var1);

        public void variantsChanged(boolean var1);

        public void rulesChanged(boolean var1);
    }

    public static interface NodeProcessor {
        public void processNode(Node var1);
    }
}

