/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import model.ConfidenceWeights;
import model.Globals;
import model.SuggestedReplacement;
import model.doc.CannotExecuteException;
import model.doc.DocumentModel;
import model.doc.InstanceHolder;
import model.doc.InvalidInstanceChangeException;
import model.doc.ReplacedInstance;
import model.doc.ThreadableEdit;
import model.doc.VariantInstance;
import model.doc.WordHolder;

public class RevertAllReplacedEdit
extends AbstractUndoableEdit
implements ThreadableEdit {
    private static final long serialVersionUID = 1L;
    private TreeSet<ReplacedInstance> ris;
    private TreeSet<VariantInstance> vis;
    private WordHolder wh;
    private InstanceHolder<ReplacedInstance> from;
    private StyledDocument doc;
    private Globals global = Globals.getInstance();
    private boolean rsHasChangedBefore = ConfidenceWeights.hasChanged();
    private boolean isAlone;
    private boolean executed = false;
    private boolean undone = false;
    private String progressMessage;

    public RevertAllReplacedEdit(WordHolder wh, SuggestedReplacement rep, StyledDocument doc) throws InvalidInstanceChangeException {
        this.wh = wh;
        this.doc = doc;
        for (InstanceHolder<ReplacedInstance> ih : wh.getAsReplaced()) {
            if (ih.isEmpty() || !ih.getInstances().first().getReplacement().equals(rep)) continue;
            this.from = ih;
            if (ih.getInstances().size() != 1) break;
            this.isAlone = true;
            break;
        }
        if (this.from == null) {
            throw new InvalidInstanceChangeException("Replacement not found.");
        }
        this.ris = new TreeSet();
        this.vis = new TreeSet();
        for (ReplacedInstance ri : this.from.getInstances()) {
            this.ris.add(ri);
            VariantInstance vi = ri.getPreviousInstance();
            if (vi.getType() == 101) {
                this.vis.add(vi);
                continue;
            }
            throw new InvalidInstanceChangeException("Replaced previous is not variant/RWE.");
        }
        this.progressMessage = "Revert all " + this.ris.first().toString();
    }

    @Override
    public void execute() throws CannotExecuteException {
        if (!this.executed) {
            block12: {
                this.global.startProgress(this.ris.size());
                this.global.writeProgressMessage("Executing: " + this.progressMessage);
                int count = 0;
                try {
                    try {
                        for (ReplacedInstance ri : this.ris) {
                            ri.revertInText(this.doc);
                            this.global.setProgressCurrent(++count);
                        }
                        break block12;
                    }
                    catch (BadLocationException e) {
                        try {
                            for (ReplacedInstance ri : this.ris) {
                                if (!ri.isReverted()) continue;
                                ri.setupInText(this.doc);
                                this.global.setProgressCurrent(--count);
                            }
                        }
                        catch (BadLocationException ex) {
                            this.global.showException("Reversing " + this.progressMessage + " failed.", ex);
                        }
                    }
                    this.global.showException(String.valueOf(this.progressMessage) + " failed.", e);
                    throw new CannotExecuteException(String.valueOf(this.progressMessage) + " failed.");
                }
                finally {
                    this.global.finishProgress();
                }
            }
            this.global.startIndeterminateProgress();
            this.global.writeProgressMessage("Executing: " + this.progressMessage);
            this.from.emptyInstances();
            this.wh.getAsVariant().addInstances(this.vis);
            if (this.isAlone) {
                this.wh.getAsReplaced().remove(this.from);
            }
        } else {
            throw new CannotExecuteException("Cannot execute twice.");
        }
        this.executed = true;
        this.global.finishProgress();
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.executed) {
            block12: {
                this.global.startProgress(this.ris.size());
                this.global.writeProgressMessage("Undoing: " + this.progressMessage);
                int count = 0;
                try {
                    try {
                        for (ReplacedInstance ri : this.ris) {
                            ri.setupInText(this.doc);
                            this.global.setProgressCurrent(++count);
                        }
                        break block12;
                    }
                    catch (BadLocationException e) {
                        try {
                            for (ReplacedInstance ri : this.ris) {
                                if (!ri.isSetup()) continue;
                                ri.revertInText(this.doc);
                                this.global.setProgressCurrent(--count);
                            }
                        }
                        catch (BadLocationException ex) {
                            this.global.showException("Reversing undo " + this.progressMessage + " failed.", ex);
                        }
                    }
                    this.global.showException("Undoing " + this.progressMessage + " failed.", e);
                    throw new CannotUndoException();
                }
                finally {
                    this.global.finishProgress();
                }
            }
            this.global.startIndeterminateProgress();
            this.global.writeProgressMessage("Undoing: " + this.progressMessage);
            this.wh.getAsVariant().removeInstances(this.vis);
            this.from.addInstances(this.ris);
            if (this.isAlone) {
                this.wh.getAsReplaced().add(this.from);
            }
        } else {
            throw new CannotUndoException();
        }
        DocumentModel.confidenceWeights.setHasChanged(this.rsHasChangedBefore);
        this.undone = true;
        this.global.finishProgress();
    }

    @Override
    public void redo() throws CannotRedoException {
        if (this.undone) {
            block12: {
                this.global.startProgress(this.ris.size());
                this.global.writeProgressMessage("Redoing: " + this.progressMessage);
                int count = 0;
                try {
                    try {
                        for (ReplacedInstance ri : this.ris) {
                            ri.revertInText(this.doc);
                            this.global.setProgressCurrent(++count);
                        }
                        break block12;
                    }
                    catch (BadLocationException e) {
                        try {
                            for (ReplacedInstance ri : this.ris) {
                                if (!ri.isReverted()) continue;
                                ri.setupInText(this.doc);
                                this.global.setProgressCurrent(--count);
                            }
                        }
                        catch (BadLocationException ex) {
                            this.global.showException("Reversing redo " + this.progressMessage + " failed.", ex);
                        }
                    }
                    this.global.showException("Redoing " + this.progressMessage + " failed.", e);
                    throw new CannotRedoException();
                }
                finally {
                    this.global.finishProgress();
                }
            }
            this.global.startIndeterminateProgress();
            this.global.writeProgressMessage("Redoing: " + this.progressMessage);
            this.from.removeInstances(this.ris);
            this.wh.getAsVariant().addInstances(this.vis);
            if (this.isAlone) {
                this.wh.getAsReplaced().remove(this.from);
            }
        } else {
            throw new CannotRedoException();
        }
        this.undone = false;
        this.global.finishProgress();
    }

    @Override
    public boolean canUndo() {
        return this.executed;
    }

    @Override
    public boolean canRedo() {
        return this.undone;
    }

    @Override
    public String getPresentationName() {
        return this.progressMessage;
    }

    public String getActionName() {
        return "Revert all";
    }
}

