/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import model.ConfidenceWeights;
import model.SuggestedReplacement;
import model.doc.DocumentModel;
import model.doc.InstanceHolder;
import model.doc.InvalidInstanceChangeException;
import model.doc.ReplacedInstance;
import model.doc.VariantInstance;
import model.doc.WordHolder;
import model.lookup.LookUpDictionary;
import model.lookup.ReplacementWord;
import model.lookup.VariantReplacement;

public class ReplaceFInstanceEdit<F extends VariantInstance>
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private F fi;
    private ReplacedInstance ri;
    private boolean replaceText;
    private boolean addToKVL;
    private int fromType;
    private InstanceHolder<F> from;
    private InstanceHolder<ReplacedInstance> to;
    private boolean toIsNew = true;
    private WordHolder wh;
    private StyledDocument doc;
    private static LookUpDictionary lud = LookUpDictionary.getInstance();
    private SuggestedReplacement rep;
    private boolean rsHasChangedBefore = ConfidenceWeights.hasChanged();
    private boolean executed = false;
    private boolean undone = false;
    private boolean addedToKV = false;

    public ReplaceFInstanceEdit(F fi, SuggestedReplacement rep, StyledDocument doc, boolean replaceText, boolean auto, boolean addToKVL) throws InvalidInstanceChangeException {
        this.fi = fi;
        this.doc = doc;
        this.replaceText = replaceText;
        this.rep = rep;
        this.addToKVL = addToKVL;
        this.wh = ((VariantInstance)fi).holder;
        this.fromType = ((VariantInstance)fi).getType();
        switch (this.fromType) {
            case 101: {
                this.from = this.wh.getAsVariant();
                break;
            }
            default: {
                throw new InvalidInstanceChangeException("From instance type not recognised.");
            }
        }
        this.to = new InstanceHolder(this.wh.getWord(), this.wh);
        this.toIsNew = true;
        for (InstanceHolder<ReplacedInstance> ih : this.wh.getAsReplaced()) {
            if (ih.isEmpty() || !ih.getInstances().first().getReplacement().equals(rep)) continue;
            this.to = ih;
            this.toIsNew = false;
            break;
        }
        this.ri = new ReplacedInstance((VariantInstance)fi, this.to, rep, auto);
    }

    public ReplacedInstance getReplacedInstance() {
        return this.ri;
    }

    public void execute() throws InvalidInstanceChangeException, BadLocationException {
        if (!this.executed) {
            if (this.replaceText) {
                this.ri.setupInText(this.doc);
            }
            if (this.from.removeInstance(this.fi)) {
                VariantReplacement newVR;
                if (!this.to.addInstance(this.ri)) {
                    this.from.addInstance(this.fi);
                    throw new InvalidInstanceChangeException(this.fi + " could not be replaced");
                }
                if (this.toIsNew) {
                    this.wh.getAsReplaced().add(this.to);
                }
                if (this.addToKVL && !this.rep.isKV() && (newVR = lud.addUserVariant(this.rep.getOldWord(), this.rep.getReplacement())) != null) {
                    this.addedToKV = true;
                    ReplacementWord newRW = newVR.getReplacement();
                    if (newRW != null) {
                        this.rep.setReplacementWord("KV", newVR.getReplacement());
                    }
                }
                this.executed = true;
                return;
            }
            throw new InvalidInstanceChangeException(this.fi + " could not be replaced");
        }
        throw new InvalidInstanceChangeException("Can only execute once. Replace " + this.fi + " with " + this.ri.getReplacementString());
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.executed) {
            try {
                this.ri.revertInText(this.doc);
            }
            catch (BadLocationException ex) {
                throw new CannotUndoException();
            }
            if (this.to.removeInstance(this.ri)) {
                if (!this.from.addInstance(this.fi)) {
                    this.to.addInstance(this.ri);
                    throw new CannotUndoException();
                }
                if (this.toIsNew) {
                    this.wh.getAsReplaced().remove(this.to);
                }
                DocumentModel.confidenceWeights.setHasChanged(this.rsHasChangedBefore);
                this.undone = true;
                return;
            }
        }
        throw new CannotUndoException();
    }

    @Override
    public void redo() throws CannotRedoException {
        if (this.undone) {
            try {
                if (this.replaceText) {
                    this.ri.setupInText(this.doc);
                }
            }
            catch (BadLocationException ex) {
                throw new CannotRedoException();
            }
            if (this.from.removeInstance(this.fi)) {
                VariantReplacement newVR;
                if (!this.to.addInstance(this.ri)) {
                    this.from.addInstance(this.fi);
                    throw new CannotRedoException();
                }
                if (this.toIsNew) {
                    this.wh.getAsReplaced().add(this.to);
                }
                if (this.addToKVL && !this.rep.isKV() && (newVR = lud.addUserVariant(this.rep.getOldWord(), this.rep.getReplacement())) != null) {
                    this.addedToKV = true;
                    ReplacementWord newRW = newVR.getReplacement();
                    if (newRW != null) {
                        this.rep.setReplacementWord("KV", newVR.getReplacement());
                    }
                }
                this.undone = false;
                return;
            }
            System.out.println("Error in undo/redo replace, please report this bug.");
        }
        throw new CannotRedoException();
    }

    @Override
    public boolean canUndo() {
        return this.executed;
    }

    @Override
    public boolean canRedo() {
        return this.undone;
    }

    @Override
    public String getPresentationName() {
        return "Normalise (" + this.ri + ")";
    }

    public String getActionName() {
        return "Normalise instance";
    }

    public WordHolder getWordHolder() {
        return this.wh;
    }
}

