/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import model.ConfidenceWeights;
import model.Globals;
import model.SuggestedReplacement;
import model.doc.CannotExecuteException;
import model.doc.DocumentModel;
import model.doc.InstanceHolder;
import model.doc.InvalidInstanceChangeException;
import model.doc.ReplacedInstance;
import model.doc.ThreadableEdit;
import model.doc.VariantInstance;
import model.doc.WordHolder;
import model.lookup.LookUpDictionary;
import model.lookup.ReplacementWord;
import model.lookup.VariantReplacement;

public class ReplaceAllFInstancesEdit<F extends VariantInstance>
extends AbstractUndoableEdit
implements ThreadableEdit {
    private static final long serialVersionUID = 1L;
    private TreeSet<F> fis;
    private TreeSet<ReplacedInstance> ris;
    private WordHolder wh;
    private int fromType;
    private InstanceHolder<F> from;
    private InstanceHolder<ReplacedInstance> to;
    private StyledDocument doc;
    private Globals global = Globals.getInstance();
    private String progressMessage;
    private SuggestedReplacement rep;
    private static LookUpDictionary lud = LookUpDictionary.getInstance();
    private boolean replaceInText;
    private boolean addToKVL;
    private boolean toIsNew = true;
    private boolean rsHasChangedBefore = ConfidenceWeights.hasChanged();
    private boolean executed = false;
    private boolean undone = false;
    private boolean addedToKV = false;

    public ReplaceAllFInstancesEdit(WordHolder wh, F tempFrom, SuggestedReplacement rep, StyledDocument doc, boolean replaceInText, boolean auto, boolean addToKVL) throws InvalidInstanceChangeException {
        this.wh = wh;
        this.fromType = ((VariantInstance)tempFrom).getType();
        this.replaceInText = replaceInText;
        this.doc = doc;
        this.addToKVL = addToKVL;
        this.rep = rep;
        switch (this.fromType) {
            case 101: {
                this.from = wh.getAsVariant();
                break;
            }
            default: {
                throw new InvalidInstanceChangeException("From instance type not recognised.");
            }
        }
        this.to = new InstanceHolder(wh.getWord(), wh);
        for (InstanceHolder<ReplacedInstance> ih : wh.getAsReplaced()) {
            if (ih.isEmpty() || !ih.getInstances().first().getReplacement().equals(rep)) continue;
            this.to = ih;
            this.toIsNew = false;
            break;
        }
        this.fis = new TreeSet();
        this.ris = new TreeSet();
        for (VariantInstance fi : this.from.getInstances()) {
            this.fis.add(fi);
            this.ris.add(new ReplacedInstance(fi, this.to, rep, auto));
        }
        this.progressMessage = "Normalise all: " + this.ris.first().toString();
    }

    @Override
    public void execute() throws CannotExecuteException {
        if (!this.executed) {
            VariantReplacement newVR;
            block15: {
                if (this.replaceInText) {
                    this.global.startProgress(this.ris.size());
                    this.global.writeProgressMessage("Executing: " + this.progressMessage);
                    int count = 0;
                    try {
                        try {
                            for (ReplacedInstance ri : this.ris) {
                                ri.setupInText(this.doc);
                                this.global.setProgressCurrent(++count);
                            }
                            break block15;
                        }
                        catch (BadLocationException e) {
                            try {
                                for (ReplacedInstance ri : this.ris) {
                                    if (!ri.isSetup()) continue;
                                    ri.revertInText(this.doc);
                                    this.global.setProgressCurrent(--count);
                                }
                            }
                            catch (BadLocationException ex) {
                                this.global.showException("Reversing " + this.progressMessage + " failed.", ex);
                            }
                        }
                        this.global.showException(String.valueOf(this.progressMessage) + " failed.", e);
                        throw new CannotExecuteException(String.valueOf(this.progressMessage) + " failed.");
                    }
                    finally {
                        this.global.finishProgress();
                    }
                }
            }
            this.global.startIndeterminateProgress();
            this.global.writeProgressMessage("Executing: " + this.progressMessage);
            this.from.emptyInstances();
            this.to.addInstances(this.ris);
            if (this.toIsNew) {
                this.wh.getAsReplaced().add(this.to);
            }
            if (this.addToKVL && !this.rep.isKV() && (newVR = lud.addUserVariant(this.rep.getOldWord(), this.rep.getReplacement())) != null) {
                this.addedToKV = true;
                ReplacementWord newRW = newVR.getReplacement();
                if (newRW != null) {
                    this.rep.setReplacementWord("KV", newVR.getReplacement());
                }
            }
        } else {
            throw new CannotExecuteException("Cannot execute twice.");
        }
        this.executed = true;
        this.global.finishProgress();
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.executed) {
            block13: {
                if (this.replaceInText) {
                    this.global.startProgress(this.ris.size());
                    this.global.writeProgressMessage("Undoing: " + this.progressMessage);
                    int count = 0;
                    try {
                        try {
                            for (ReplacedInstance ri : this.ris) {
                                ri.revertInText(this.doc);
                                this.global.setProgressCurrent(++count);
                            }
                            break block13;
                        }
                        catch (BadLocationException e) {
                            try {
                                for (ReplacedInstance ri : this.ris) {
                                    if (!ri.isReverted()) continue;
                                    ri.setupInText(this.doc);
                                    this.global.setProgressCurrent(--count);
                                }
                            }
                            catch (BadLocationException ex) {
                                this.global.showException("Reversing undo " + this.progressMessage + " failed.", ex);
                            }
                        }
                        this.global.showException("Undoing " + this.progressMessage + " failed.", e);
                        throw new CannotUndoException();
                    }
                    finally {
                        this.global.finishProgress();
                    }
                }
            }
            this.global.startIndeterminateProgress();
            this.global.writeProgressMessage("Undoing: " + this.progressMessage);
            this.to.removeInstances(this.ris);
            this.from.addInstances(this.fis);
            if (this.toIsNew) {
                this.wh.getAsReplaced().remove(this.to);
            }
        } else {
            throw new CannotUndoException();
        }
        DocumentModel.confidenceWeights.setHasChanged(this.rsHasChangedBefore);
        this.undone = true;
        this.global.finishProgress();
    }

    @Override
    public void redo() throws CannotRedoException {
        if (this.undone) {
            VariantReplacement newVR;
            block15: {
                if (this.replaceInText) {
                    this.global.startProgress(this.ris.size());
                    this.global.writeProgressMessage("Redoing: " + this.progressMessage);
                    int count = 0;
                    try {
                        try {
                            for (ReplacedInstance ri : this.ris) {
                                ri.setupInText(this.doc);
                                this.global.setProgressCurrent(++count);
                            }
                            break block15;
                        }
                        catch (BadLocationException e) {
                            try {
                                for (ReplacedInstance ri : this.ris) {
                                    if (!ri.isSetup()) continue;
                                    ri.revertInText(this.doc);
                                    this.global.setProgressCurrent(--count);
                                }
                            }
                            catch (BadLocationException ex) {
                                this.global.showException("Reversing redo " + this.progressMessage + " failed.", ex);
                            }
                        }
                        this.global.showException("Redoing " + this.progressMessage + " failed.", e);
                        throw new CannotRedoException();
                    }
                    finally {
                        this.global.finishProgress();
                    }
                }
            }
            this.global.startIndeterminateProgress();
            this.global.writeProgressMessage("Redoing: " + this.progressMessage);
            this.from.removeInstances(this.fis);
            this.to.addInstances(this.ris);
            if (this.toIsNew) {
                this.wh.getAsReplaced().add(this.to);
            }
            if (this.addToKVL && !this.rep.isKV() && (newVR = lud.addUserVariant(this.rep.getOldWord(), this.rep.getReplacement())) != null) {
                this.addedToKV = true;
                ReplacementWord newRW = newVR.getReplacement();
                if (newRW != null) {
                    this.rep.setReplacementWord("KV", newVR.getReplacement());
                }
            }
        } else {
            throw new CannotRedoException();
        }
        this.undone = false;
        this.global.finishProgress();
    }

    @Override
    public boolean canUndo() {
        return this.executed;
    }

    @Override
    public boolean canRedo() {
        return this.undone;
    }

    @Override
    public String getPresentationName() {
        return this.progressMessage;
    }

    public String getActionName() {
        return "Normalise all";
    }
}

