/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.TreeMap;
import model.ConfidenceWeights;
import model.MethodScoresUpdate;
import model.lookup.ReplacementWord;
import model.lookup.Word;
import model.lookup.WordUtilities;

public class SuggestedReplacement
implements Comparable<SuggestedReplacement> {
    private static final long serialVersionUID = -1487581641966172547L;
    private Word replacement;
    private String oldWord;
    private String replacementString;
    private int capitalization;
    private TreeMap<String, MethodScoresUpdate> msus;
    private TreeMap<String, ReplacementWord> rws;
    private double score;
    private boolean isKV;

    public SuggestedReplacement() {
    }

    public SuggestedReplacement(Word replacement, String oldWord, boolean isKV) {
        this.replacement = replacement;
        this.oldWord = oldWord;
        this.isKV = isKV;
        this.msus = new TreeMap();
        this.rws = new TreeMap();
        this.setCapitalization(WordUtilities.getCapitalization(oldWord));
    }

    @Override
    public int compareTo(SuggestedReplacement sr) {
        int r = Double.valueOf(sr.getScore()).compareTo(this.getScore());
        if (r == 0) {
            return new Integer(sr.getReplacement().getFreq()).compareTo(this.replacement.getFreq());
        }
        return r;
    }

    public boolean equals(SuggestedReplacement sr) {
        if (this.replacementString.equalsIgnoreCase(sr.getReplacementString())) {
            return this.oldWord.equalsIgnoreCase(sr.getOldWord());
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof SuggestedReplacement) {
            return this.equals((SuggestedReplacement)object);
        }
        return false;
    }

    public Word getReplacement() {
        return this.replacement;
    }

    public String getOldWord() {
        return this.oldWord;
    }

    public boolean isReplacementUserAdded() {
        return this.replacement.isUserAdded();
    }

    public double getScoreWithoutUpdating() {
        return this.score;
    }

    public double getScore() {
        return this.score;
    }

    public void reCalculateScore() {
        this.score = ConfidenceWeights.getInstance().calculateScoreOfReplacement(this);
    }

    public String toString() {
        return this.toMenuString(this.capitalization);
    }

    public String toMenuString(int capitalization) {
        String scoreString = Double.toString(this.getScore());
        if (scoreString.endsWith(".0")) {
            scoreString = scoreString.substring(0, scoreString.length() - 2);
        }
        this.setCapitalization(capitalization);
        return String.valueOf(this.replacementString) + " (" + scoreString + "%)";
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public void setCapitalization(int c) {
        this.capitalization = c;
        this.replacementString = WordUtilities.capitalize(this.replacement.toString(), this.capitalization);
    }

    public int getCapitalization() {
        return this.capitalization;
    }

    public void setOldWord(String oldWord) {
        this.oldWord = oldWord;
    }

    public void setReplacement(Word replacement) {
        this.replacement = replacement;
    }

    public void setReplacementString(String replacementString) {
        this.replacementString = replacementString;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public void picked() {
        for (MethodScoresUpdate msu : this.msus.values()) {
            msu.update();
        }
        for (ReplacementWord rw : this.rws.values()) {
            rw.picked();
        }
    }

    public void unpicked() {
        for (MethodScoresUpdate msu : this.msus.values()) {
            msu.reverse();
        }
        for (ReplacementWord rw : this.rws.values()) {
            rw.unpicked();
        }
    }

    public MethodScoresUpdate getMethodScoresUpdate(String key) {
        return this.msus.get(key);
    }

    public TreeMap<String, MethodScoresUpdate> getMethodScoresUpdates() {
        return this.msus;
    }

    public MethodScoresUpdate getScoreUpdate(String method) {
        return this.msus.get(method);
    }

    public void setScoreUpdate(String method, MethodScoresUpdate msu) {
        this.msus.put(method, msu);
    }

    public void setReplacementWord(String method, ReplacementWord rw) {
        this.rws.put(method, rw);
    }

    public TreeMap<String, MethodScoresUpdate> getScoreUpdates() {
        return this.msus;
    }

    public boolean isKV() {
        return this.isKV;
    }
}

